/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;

public class LinkSet
extends DesignObjectSet {
    private static final Object[] PROTO_TYPE = new Link[0];

    public LinkSet(DesignPart designPart) {
        super(designPart);
    }

    public Link createLink(String string) {
        Link link = new Link(this.getDesignPart());
        link.setObjectID(string);
        link.setDesign(this.getDesign());
        link.setParent(this);
        this.getDesign().addDesignObject(link);
        this.add(link);
        return link;
    }

    public Link createLink(String string, RollupLink rollupLink) {
        Link link = new Link(this.getDesignPart());
        link.setObjectID(string);
        link.setDesign(this.getDesign());
        link.setParent(this);
        link.setRollupLink(rollupLink);
        this.getDesign().addDesignObject(link);
        this.add(link);
        return link;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_TYPE;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return "Link";
    }

    public Collection getLinksToSource(AbstractMDObject abstractMDObject) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            if (link.getSourceMDObject() != abstractMDObject) continue;
            arrayList.add(link);
        }
        return arrayList;
    }

    public Collection getLinksToTarget(AbstractMDObject abstractMDObject) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            if (link.getTargetMDObject() != abstractMDObject) continue;
            arrayList.add(link);
        }
        return arrayList;
    }

    public Collection getLinksTo(AbstractMDObject abstractMDObject) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            if (link.getSourceMDObject() != abstractMDObject && link.getTargetMDObject() != abstractMDObject) continue;
            arrayList.add(link);
        }
        return arrayList;
    }
}

