/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.editor.multidimensional.LevelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class Level
extends AbstractMDObject
implements EditableFonts {
    public static final String PARENT_IS_BLANK_SELF_OR_MISSING = "ParentIsBlankSelfOrMissing";
    public static final String PARENT_IS_SELF = "ParentIsSelf";
    public static final String PARENT_IS_MISSING = "ParentIsMissing";
    public static final String PARENT_IS_BLANK = "ParentIsBlank";
    public static final String PARENT_HAS_VALUE = "ParentHasValue";
    public static final String[] ROOT_IDENTS = new String[]{"ParentIsBlankSelfOrMissing", "ParentIsSelf", "ParentIsMissing", "ParentIsBlank", "ParentHasValue"};
    private ContainerObject levelEntity;
    private final List levelKey = new ArrayList();
    private final List slowChangingAttributes = new ArrayList();
    private String selectionCriteria = "";
    private String selectionCriteriaDescription = "";
    private boolean valueBasedHierarchy;
    private final List parentKey = new ArrayList();
    private String rootIdentification = ROOT_IDENTS[0];
    private String identificationValue = "";
    private int calcAttrID = 1;
    private final List calcAttributes = new ArrayList();
    private DesignObject defaultAttribute;
    private String oraDimension = "";
    private final List raggedHLinks = new ArrayList();
    private final List inputRaggedHLinks = new ArrayList();
    private final OraAWAttributes oraAWAttributes = new OraAWAttributes(this);
    private ContainedObject nameColumn;
    private ContainedObject valueColumn;
    private List editableFonts;
    public static final String TYPE_NAME = "Level";

    public Level(DesignPart designPart) {
        super(designPart);
        this.initEditableFonts();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            LevelPropertiesDialogEx levelPropertiesDialogEx = new LevelPropertiesDialogEx(this.getDesign().getAppView(), this);
            levelPropertiesDialogEx.initProperties(this);
            levelPropertiesDialogEx.show();
        }
    }

    public String getIdentificationValue() {
        return this.identificationValue;
    }

    public void setIdentificationValue(String string) {
        this.identificationValue = string;
    }

    public ContainerObject getLevelEntity() {
        return this.levelEntity;
    }

    public void setLevelEntity(ContainerObject containerObject) {
        this.levelEntity = containerObject;
        if (containerObject != null && containerObject instanceof Entity) {
            ((Entity)containerObject).setTypeID(this.getDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_DIMENSION).getTypeID());
        }
    }

    public String getRootIdentification() {
        return this.rootIdentification;
    }

    public void setRootIdentification(String string) {
        this.rootIdentification = string;
    }

    public String getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public void setSelectionCriteria(String string) {
        this.selectionCriteria = string;
    }

    public String getSelectionCriteriaDescription() {
        return this.selectionCriteriaDescription;
    }

    public void setSelectionCriteriaDescription(String string) {
        this.selectionCriteriaDescription = string;
    }

    public boolean isValueBasedHierarchy() {
        return this.valueBasedHierarchy;
    }

    public void setValueBasedHierarchy(boolean bl) {
        this.valueBasedHierarchy = bl;
    }

    public List getDescriptiveAttributes() {
        ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
        for (SlowChangingAttribute slowChangingAttribute : this.slowChangingAttributes) {
            arrayList.add(slowChangingAttribute.getAttribute());
        }
        return arrayList;
    }

    public SlowChangingAttribute getSlowChangingAttribute(ContainedObject containedObject, String string) {
        for (SlowChangingAttribute slowChangingAttribute : this.slowChangingAttributes) {
            if (slowChangingAttribute.getAttribute() != containedObject || !slowChangingAttribute.getName().equals(string)) continue;
            return slowChangingAttribute;
        }
        return null;
    }

    public SlowChangingAttribute getSlowChangingAttribute(String string, String string2) {
        for (SlowChangingAttribute slowChangingAttribute : this.slowChangingAttributes) {
            if (!slowChangingAttribute.getAttribute().getObjectID().equalsIgnoreCase(string) || !slowChangingAttribute.getName().equalsIgnoreCase(string2)) continue;
            return slowChangingAttribute;
        }
        return null;
    }

    public List getSlowChangingAttributes() {
        return this.slowChangingAttributes;
    }

    public List getAllAttributes() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getLevelKey());
        arrayList.addAll(this.getDescriptiveAttributes());
        arrayList.addAll(this.getCalculatedAttributes());
        List list = this.getOutgoingLinks();
        for (Link link : list) {
            arrayList.addAll(link.getRollupLink().getChildToParentAttributes());
        }
        return arrayList;
    }

    public List getJoinAttributes() {
        ArrayList arrayList = new ArrayList();
        List list = this.getOutgoingLinks();
        for (Link link : list) {
            arrayList.addAll(link.getRollupLink().getChildToParentAttributes());
        }
        return arrayList;
    }

    public void addDescriptiveAttribute(SlowChangingAttribute slowChangingAttribute) {
        this.slowChangingAttributes.add(slowChangingAttribute);
    }

    public void removeDescriptiveAttribute(SlowChangingAttribute slowChangingAttribute) {
        this.slowChangingAttributes.remove(slowChangingAttribute);
    }

    public SlowChangingAttribute createDescriptiveAttribute() {
        return new SlowChangingAttribute(this, "New_Descr_Attr");
    }

    public SlowChangingAttribute getDescriptiveAttrByID(String string) {
        for (SlowChangingAttribute slowChangingAttribute : this.slowChangingAttributes) {
            if (!slowChangingAttribute.getObjectID().equals(string)) continue;
            return slowChangingAttribute;
        }
        return null;
    }

    public List getLevelKey() {
        return this.levelKey;
    }

    public void addToLevelKey(ContainedObject containedObject) {
        this.levelKey.add(containedObject);
    }

    public void removeFromLevelKey(ContainedObject containedObject) {
        this.levelKey.remove(containedObject);
    }

    public List getParentKey() {
        return this.parentKey;
    }

    public void addToParentKey(ContainedObject containedObject) {
        this.parentKey.add(containedObject);
    }

    public void removeFromParentKey(ContainedObject containedObject) {
        this.parentKey.remove(containedObject);
    }

    public List getCalculatedAttributes() {
        return this.calcAttributes;
    }

    public boolean hasCalculatedAttribute(String string, String string2) {
        for (CalculatedAttribute calculatedAttribute : this.calcAttributes) {
            if (!string.trim().equals(calculatedAttribute.getName().trim()) || !string2.trim().equals(calculatedAttribute.getFunction())) continue;
            return true;
        }
        return false;
    }

    public void addCalculatedAttribute(CalculatedAttribute calculatedAttribute) {
        this.calcAttributes.add(calculatedAttribute);
        String string = calculatedAttribute.getObjectID();
        int n = 0;
        try {
            n = Integer.valueOf(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n > this.calcAttrID) {
            this.calcAttrID = n;
        }
    }

    public CalculatedAttribute addCalculatedAttribute(String string, String string2) {
        CalculatedAttribute calculatedAttribute = this.createCalculatedAttribute(string, string2);
        this.calcAttributes.add(calculatedAttribute);
        return calculatedAttribute;
    }

    public CalculatedAttribute createCalculatedAttribute() {
        String string = CalculatedAttribute.NAMEPREFIX + Integer.toString(this.calcAttrID);
        return this.createCalculatedAttribute(string);
    }

    public void ramoveCalculatedAttribute(CalculatedAttribute calculatedAttribute) {
        this.calcAttributes.remove(calculatedAttribute);
    }

    public CalculatedAttribute createCalculatedAttribute(String string) {
        CalculatedAttribute calculatedAttribute = new CalculatedAttribute(this.getDesignPart());
        calculatedAttribute.setName(string);
        String string2 = new GUID().toString();
        ++this.calcAttrID;
        calculatedAttribute.setObjectID(string2);
        calculatedAttribute.setLevel(this);
        return calculatedAttribute;
    }

    public CalculatedAttribute createCalculatedAttribute(String string, String string2) {
        CalculatedAttribute calculatedAttribute = this.createCalculatedAttribute(string);
        calculatedAttribute.setObjectID(string2);
        return calculatedAttribute;
    }

    public DesignObject getAttributeById(String string) {
        for (DesignObject designObject : this.getAllAttributes()) {
            if (!designObject.getObjectID().equalsIgnoreCase(string)) continue;
            return designObject;
        }
        return null;
    }

    public DesignObject getDefaultAttribute() {
        return this.defaultAttribute;
    }

    public void setDefaultAttribute(DesignObject designObject) {
        this.defaultAttribute = designObject;
    }

    public List getDefaultAttributeCandidates() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getLevelKey());
        arrayList.addAll(this.getDescriptiveAttributes());
        arrayList.addAll(this.getCalculatedAttributes());
        return arrayList;
    }

    public String getOraDimension() {
        return this.oraDimension;
    }

    public void setOraDimension(String string) {
        this.oraDimension = string;
    }

    public List getRaggedHLinks() {
        return this.raggedHLinks;
    }

    @Override
    public void remove() {
        TVRaggedHLink tVRaggedHLink;
        RaggedHLink raggedHLink;
        int n;
        Object[] objectArray = this.raggedHLinks.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            raggedHLink = (RaggedHLink)objectArray[n];
            tVRaggedHLink = (TVRaggedHLink)raggedHLink.getTopView();
            if (tVRaggedHLink == null) continue;
            tVRaggedHLink.remove();
        }
        objectArray = this.inputRaggedHLinks.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            raggedHLink = (RaggedHLink)objectArray[n];
            tVRaggedHLink = (TVRaggedHLink)raggedHLink.getTopView();
            if (tVRaggedHLink == null) continue;
            tVRaggedHLink.remove();
        }
        super.remove();
    }

    public List getInputRaggedHLinks() {
        return this.inputRaggedHLinks;
    }

    public RaggedHLink getFirstRaggedHLinkTo(Level level) {
        for (RaggedHLink raggedHLink : this.raggedHLinks) {
            if (raggedHLink.getParentLevel() != level) continue;
            return raggedHLink;
        }
        return null;
    }

    public OraAWAttributes getOraAWAttributes() {
        return this.oraAWAttributes;
    }

    public void validateAWAttributes(OraAWAttributes oraAWAttributes, boolean bl) {
        DesignObject designObject;
        if (oraAWAttributes.shortDesc != null && (designObject = this.getAttributeById(oraAWAttributes.shortDesc.getObjectID())) == null) {
            oraAWAttributes.shortDesc = null;
        }
        if (oraAWAttributes.longDesc != null && (designObject = this.getAttributeById(oraAWAttributes.longDesc.getObjectID())) == null) {
            oraAWAttributes.longDesc = null;
        }
        if (bl) {
            if (oraAWAttributes.timeEnd != null && (designObject = this.getAttributeById(oraAWAttributes.timeEnd.getObjectID())) == null) {
                oraAWAttributes.timeEnd = null;
            }
            if (oraAWAttributes.timeSpan != null && (designObject = this.getAttributeById(oraAWAttributes.timeSpan.getObjectID())) == null) {
                oraAWAttributes.timeSpan = null;
            }
        }
    }

    public void attributeIsDeleted(Attribute attribute) {
        Object object;
        int n;
        if (this.getDefaultAttribute() == attribute) {
            this.setDefaultAttribute(null);
        }
        Object[] objectArray = this.getLevelKey().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n];
            if (object != attribute) continue;
            this.getLevelKey().remove(object);
        }
        objectArray = this.getSlowChangingAttributes().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            object = (SlowChangingAttribute)objectArray[n];
            if (((SlowChangingAttribute)object).getAttribute() != attribute) continue;
            this.getSlowChangingAttributes().remove(object);
        }
        if (this.oraAWAttributes.shortDesc == attribute) {
            this.oraAWAttributes.shortDesc = null;
        }
        if (this.oraAWAttributes.longDesc != null) {
            this.oraAWAttributes.longDesc = null;
        }
        if (this.oraAWAttributes.timeEnd != null) {
            this.oraAWAttributes.timeEnd = null;
        }
        if (this.oraAWAttributes.timeSpan != null) {
            this.oraAWAttributes.timeSpan = null;
        }
    }

    public void entityIsDeleted(ContainerObject containerObject) {
        if (this.getLevelEntity() == containerObject) {
            this.setLevelEntity(null);
            this.setDefaultAttribute(null);
            this.getLevelKey().clear();
            this.getSlowChangingAttributes().clear();
            this.getCalculatedAttributes().clear();
            this.oraAWAttributes.shortDesc = null;
            this.oraAWAttributes.longDesc = null;
            this.oraAWAttributes.timeEnd = null;
            this.oraAWAttributes.timeSpan = null;
            for (AbstractMDObject abstractMDObject : this.getOutgoingLinks()) {
                RollupLink rollupLink = ((Link)abstractMDObject).getRollupLink();
                if (rollupLink == null) continue;
                rollupLink.getChildToParentAttributes().clear();
            }
            for (AbstractMDObject abstractMDObject : this.getRaggedHLinks()) {
                ((RaggedHLink)abstractMDObject).getChildToParentAttributes().clear();
            }
        }
    }

    @Override
    public boolean setName(String string) {
        if (!this.name.equals(string)) {
            this.name = string;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
        return true;
    }

    @Override
    public String toString() {
        String string = "";
        if (this.getLevelEntity() != null) {
            string = this.getLevelEntity().getName() + ".";
        }
        string = string + this.getName();
        return string;
    }

    public ContainedObject getNameColumn() {
        return this.nameColumn;
    }

    public void setNameColumn(ContainedObject containedObject) {
        this.nameColumn = containedObject;
    }

    public ContainedObject getValueColumn() {
        return this.valueColumn;
    }

    public void setValueColumn(ContainedObject containedObject) {
        this.valueColumn = containedObject;
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
            this.setUseDefaultColor(bl);
        } else if (DefaultFontAndColor.isModified(TYPE_NAME)) {
            DefaultFontAndColor defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME);
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
            this.setUseDefaultColor(bl);
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "level/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public class OraAWAttributes
    implements ID_ObjectPropertyTranslator {
        public Attribute shortDesc;
        public Attribute longDesc;
        public Attribute timeSpan;
        public Attribute timeEnd;
        public Level level;

        public OraAWAttributes(Level level2) {
            this.level = level2;
        }

        public Attribute getShortDesc() {
            return this.shortDesc;
        }

        public void setShortDesc(Attribute attribute) {
            this.shortDesc = attribute;
        }

        public Attribute getLongDesc() {
            return this.longDesc;
        }

        public void setLongDesc(Attribute attribute) {
            this.longDesc = attribute;
        }

        public Attribute getTimeSpan() {
            return this.timeSpan;
        }

        public void setTimeSpan(Attribute attribute) {
            this.timeSpan = attribute;
        }

        public Attribute getTimeEnd() {
            return this.timeEnd;
        }

        public void setTimeEnd(Attribute attribute) {
            this.timeEnd = attribute;
        }

        @Override
        public Object translateIdToObject(String string, String string2) {
            return this.level.translateIdToObject(string, string2);
        }

        @Override
        public String translateObjectToID(String string, Object object) {
            return this.level.translateObjectToID(string, object);
        }
    }
}

