/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.editor.multidimensional.HierarchyPropertiesDialogEx;

public class Hierarchy
extends AbstractMDObject {
    private List levels = new ArrayList();
    private List links = new ArrayList();
    private Dimension dimension;
    private Link linkToDimension;
    private boolean defaultHierarchy;
    public static final String TYPE_NAME = "Hierarchy";

    public Hierarchy(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            HierarchyPropertiesDialogEx hierarchyPropertiesDialogEx = new HierarchyPropertiesDialogEx(this.getDesign().getAppView(), this);
            hierarchyPropertiesDialogEx.initProperties(this);
            hierarchyPropertiesDialogEx.show();
        }
    }

    public boolean isValueBasedHierarchy() {
        if (this.getLevels().size() == 1) {
            Level level = (Level)this.getLevels().get(0);
            return level.isValueBasedHierarchy();
        }
        return false;
    }

    public List getLevels() {
        return this.levels;
    }

    public void addLevel(Level level) {
        this.levels.add(level);
        this.setDirty(true);
    }

    public void removeLevel(Level level) {
        this.levels.remove(level);
        this.setDirty(true);
    }

    public List getLinks() {
        return this.links;
    }

    public void addLink(RollupLink rollupLink) {
        this.setDirty(true);
        this.links.add(rollupLink);
    }

    public void removeLink(RollupLink rollupLink) {
        this.links.remove(rollupLink);
        this.setDirty(true);
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public Link getLinkToDimension() {
        return this.linkToDimension;
    }

    public void setLinkToDimension(Link link) {
        this.linkToDimension = link;
    }

    public void applyLinkToDimension(Link link) {
        Dimension dimension;
        this.setLinkToDimension(link);
        if (link != null && (dimension = (Dimension)link.getSourceMDObject()) != null) {
            dimension.addHierarchy(this);
        }
    }

    @Override
    public void remove() {
        this.levels.clear();
        this.links.clear();
        this.linkToDimension = null;
        super.remove();
    }

    public boolean contains(Level level) {
        return this.levels.contains(level);
    }

    public boolean isLast(Level level) {
        return this.levels.indexOf(level) == this.levels.size() - 1;
    }

    public Hierarchy clonePartial(Level level) {
        if (this.contains(level)) {
            Hierarchy hierarchy = ((MultidimensionalDesign)this.getDesignPart()).createHierarchy();
            hierarchy.setDimension(this.getDimension());
            hierarchy.setLinkToDimension(this.getLinkToDimension());
            int n = this.levels.indexOf(level);
            if (n > -1) {
                for (int i = 0; i <= n; ++i) {
                    hierarchy.addLevel((Level)this.levels.get(i));
                    if (i >= n) continue;
                    hierarchy.addLink((RollupLink)this.links.get(i));
                }
            }
            this.getDimension().addHierarchy(hierarchy);
            return hierarchy;
        }
        return null;
    }

    public boolean contains(RollupLink rollupLink) {
        return this.links.contains(rollupLink);
    }

    public void removePartFromLink(Link link) {
        RollupLink rollupLink = link.getRollupLink();
        if (this.links.contains(rollupLink)) {
            int n;
            int n2 = this.links.indexOf(rollupLink);
            int n3 = this.links.size();
            for (n = n3 - 1; n >= n2; --n) {
                this.links.remove(n);
            }
            n3 = this.levels.size();
            for (n = n3 - 1; n > n2; --n) {
                this.levels.remove(n);
            }
        }
    }

    public List getPathTo(Level level) {
        ArrayList<Level> arrayList = new ArrayList<Level>();
        if (this.levels.contains(level)) {
            for (int i = 0; i < this.levels.size(); ++i) {
                Level level2 = (Level)this.levels.get(i);
                if (level2 == level) {
                    return arrayList;
                }
                arrayList.add(level2);
            }
        }
        return arrayList;
    }

    public boolean hasDifferentPathToLevel(Level level, List list) {
        List list2 = this.getPathTo(level);
        if (list.size() == 0) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            Hierarchy hierarchy = (Hierarchy)list.get(i);
            if (hierarchy == this || !this.differentPaths(list2, hierarchy.getPathTo(level))) continue;
            return true;
        }
        return false;
    }

    private boolean differentPaths(List list, List list2) {
        if (list.size() == list2.size()) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == list2.get(i)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isEqualToLevelList(List list) {
        return !this.differentPaths(this.getLevels(), list);
    }

    public boolean isRaggedHierarchy() {
        for (Level level : this.getLevels()) {
            if (level.getRaggedHLinks().size() <= 0) continue;
            for (RaggedHLink raggedHLink : level.getRaggedHLinks()) {
                if (!this.levels.contains(raggedHLink.getParentLevel())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDefaultHierarchy() {
        if (this.getDimension().getHierarchies().size() == 1) {
            return true;
        }
        return this.defaultHierarchy;
    }

    public void setDefaultHierarchy(boolean bl) {
        this.defaultHierarchy = bl;
        if (bl && this.getDimension() != null) {
            Iterator iterator = this.getDimension().getHierarchies().iterator();
            while (iterator.hasNext()) {
                Hierarchy hierarchy = (Hierarchy)iterator.next();
                if (hierarchy == this) continue;
                hierarchy.setDefaultHierarchy(false);
            }
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "hierarchy/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

