/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.swingui.editor.multidimensional.CubePropertiesDialogEx;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class Cube
extends AbstractMDObject
implements EditableFonts {
    private ContainerObject factEntity;
    private final List measures = new ArrayList();
    private boolean virtual = true;
    private boolean partitioned = true;
    private String partitioningDescription = "";
    private Slice fullCubeMaterialization;
    private final List precalculatedSlices = new ArrayList();
    private final List factEntities = new ArrayList();
    private final List joins = new ArrayList();
    private Dimension partDimension;
    private Hierarchy partHierarchy;
    private Level partLevel;
    private final List dimensionsOrderList = new ArrayList();
    private boolean useGlobalComposites;
    private boolean compressedComposites;
    private String hierarchyID;
    private final List sqlDefinitions = new ArrayList();
    private List editableFonts;
    public static final String TYPE_NAME = "Cube";

    public Cube(DesignPart designPart) {
        super(designPart);
        this.initEditableFonts();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            CubePropertiesDialogEx cubePropertiesDialogEx = new CubePropertiesDialogEx(this.getDesign().getAppView(), this);
            cubePropertiesDialogEx.initProperties(this);
            cubePropertiesDialogEx.show();
        }
    }

    public ContainerObject getFactEntity() {
        if (this.factEntity != null && this.factEntities.contains(this.factEntity)) {
            return this.factEntity;
        }
        if (this.factEntities.size() > 0) {
            return (ContainerObject)this.factEntities.get(0);
        }
        return null;
    }

    public void setFactEntity(ContainerObject containerObject) {
        this.factEntity = containerObject;
        if (containerObject != null) {
            if (containerObject instanceof Entity) {
                ((Entity)containerObject).setTypeID(containerObject.getDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_FACT).getTypeID());
            }
            containerObject.setDirty(true);
            if (!this.factEntities.contains(containerObject)) {
                this.factEntities.add(containerObject);
            }
        }
    }

    public Slice getFullCubeMaterialization() {
        return this.fullCubeMaterialization;
    }

    public void setFullCubeMaterialization(Slice slice) {
        this.fullCubeMaterialization = slice;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(boolean bl) {
        this.partitioned = bl;
    }

    public String getPartitioningDescription() {
        return this.partitioningDescription;
    }

    public void setPartitioningDescription(String string) {
        this.partitioningDescription = string;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean bl) {
        this.virtual = bl;
    }

    public List getDimensions() {
        Object object;
        if (this.dimensionsOrderList.size() > 0) {
            for (int i = 0; i < this.dimensionsOrderList.size(); ++i) {
                object = (Dimension)this.dimensionsOrderList.get(i);
                this.moveToIndex((Dimension)object, i);
            }
            this.dimensionsOrderList.clear();
        }
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        object = this.getAllLinks();
        for (int i = 0; i < ((Link.Connection[])object).length; ++i) {
            Dimension dimension;
            Link.Connection connection = object[i];
            if (!(connection.getLink().getTargetMDObject() instanceof Dimension) || arrayList.indexOf(dimension = (Dimension)connection.getLink().getTargetMDObject()) != -1) continue;
            arrayList.add(dimension);
        }
        return arrayList;
    }

    public void addDimension(Dimension dimension) {
        this.dimensionsOrderList.add(dimension);
    }

    public void removeDimension(Dimension dimension) {
        this.dimensionsOrderList.remove(dimension);
    }

    public void moveDimensionToIndex(Dimension dimension, int n) {
        if (this.dimensionsOrderList.contains(dimension) && this.dimensionsOrderList.size() > n && n >= 0) {
            this.dimensionsOrderList.remove(dimension);
            this.dimensionsOrderList.add(n, dimension);
        }
    }

    public RollupLink getRollUpLink(Dimension dimension) {
        Link.Connection[] connectionArray = this.getAllLinks();
        for (int i = 0; i < connectionArray.length; ++i) {
            Link.Connection connection = connectionArray[i];
            if (!(connection.getLink().getTargetMDObject() instanceof Dimension) || connection.getLink().getTargetMDObject() != dimension) continue;
            return connection.getLink().getRollupLink();
        }
        return null;
    }

    public void moveToIndex(Dimension dimension, int n) {
        Link.Connection[] connectionArray = this.getAllLinks();
        for (int i = 0; i < connectionArray.length; ++i) {
            Link.Connection connection = connectionArray[i];
            if (!(connection.getLink().getTargetMDObject() instanceof Dimension) || connection.getLink().getTargetMDObject() != dimension) continue;
            if (n < connectionArray.length) {
                this.moveToIndex(connection, n);
                continue;
            }
            this.moveToIndex(connection, connectionArray.length - 1);
        }
    }

    public List getMeasures() {
        return this.measures;
    }

    public Measure getMeasureByName(String string) {
        for (Measure measure : this.measures) {
            if (!measure.getName().equalsIgnoreCase(string)) continue;
            return measure;
        }
        return null;
    }

    public void addMeasure(Measure measure) {
        this.measures.add(measure);
        measure.setCube(this);
    }

    public void removeMeasure(Measure measure) {
        this.measures.remove(measure);
        measure.setCube(null);
        measure.remove();
    }

    public List getPrecalculatedSlices() {
        return this.precalculatedSlices;
    }

    public void addPrecalculatedSlice(Slice slice) {
        slice.setCube(this);
        this.precalculatedSlices.add(slice);
    }

    public void removePrecalculatedSlice(Slice slice) {
        this.precalculatedSlices.remove(slice);
        slice.remove();
    }

    public List getAllJoinAttributes() {
        ArrayList arrayList = new ArrayList();
        List list = this.getOutgoingLinks();
        for (Link link : list) {
            arrayList.addAll(link.getRollupLink().getChildToParentAttributes());
        }
        return arrayList;
    }

    public Measure getMeasureForAttribute(ContainedObject containedObject) {
        for (Measure measure : this.getMeasures()) {
            if (measure.getMeasureFact() != containedObject) continue;
            return measure;
        }
        return null;
    }

    public List getFactEntities() {
        return this.factEntities;
    }

    public void addFactEntity(ContainerObject containerObject) {
        if (!this.factEntities.contains(containerObject) && containerObject != null) {
            this.factEntities.add(containerObject);
            if (containerObject instanceof Entity) {
                ((Entity)containerObject).setTypeID(containerObject.getDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_FACT).getTypeID());
            }
        }
    }

    public List getJoins() {
        return this.joins;
    }

    public void addFactEntitiesJoin(FactEntitiesJoin factEntitiesJoin) {
        if (factEntitiesJoin != null) {
            factEntitiesJoin.setCube(this);
            this.joins.add(factEntitiesJoin);
        }
    }

    public Dimension getPartDimension() {
        return this.partDimension;
    }

    public void setPartDimension(Dimension dimension) {
        this.partDimension = dimension;
    }

    public Hierarchy getPartHierarchy() {
        if (this.partHierarchy == null && this.hierarchyID != null) {
            this.partHierarchy = (Hierarchy)((MultidimensionalDesign)this.getDesignPart()).getHierarchySet().getObjectByID(this.hierarchyID);
        }
        return this.partHierarchy;
    }

    public void setPartHierarchy(Hierarchy hierarchy) {
        this.partHierarchy = hierarchy;
    }

    public Level getPartLevel() {
        return this.partLevel;
    }

    public void setPartLevel(Level level) {
        this.partLevel = level;
    }

    public List getDimensionsOrderList() {
        return this.dimensionsOrderList;
    }

    public boolean isUseGlobalComposites() {
        return this.useGlobalComposites;
    }

    public void setUseGlobalComposites(boolean bl) {
        this.useGlobalComposites = bl;
    }

    public boolean isCompressedComposites() {
        return this.compressedComposites;
    }

    public void setCompressedComposites(boolean bl) {
        this.compressedComposites = bl;
    }

    public void setPartHierarchyID(String string) {
        this.hierarchyID = string;
    }

    public boolean hasRolePlayingDimensions() {
        for (Dimension dimension : this.getDimensions()) {
            if (this.getAllRollupLinksToTarget(dimension).size() <= 1) continue;
            return true;
        }
        return false;
    }

    public List getSQLDefinitions() {
        return this.sqlDefinitions;
    }

    public void attributeIsDeleted(ContainedObject containedObject) {
        Object object;
        for (DesignObject designObject : this.getOutgoingLinks()) {
            object = ((Link)designObject).getRollupLink();
            if (object == null) continue;
            ((RollupLink)object).getChildToParentAttributes().remove(containedObject);
        }
        for (DesignObject designObject : this.getMeasures()) {
            if (((Measure)designObject).isFormula() || ((Measure)designObject).getMeasureFact() != containedObject) continue;
            ((Measure)designObject).setMeasureFact(null);
        }
        for (DesignObject designObject : this.getJoins()) {
            Object object2;
            int n;
            object = ((FactEntitiesJoin)designObject).getRightAttributes();
            for (n = 0; n < object.size(); ++n) {
                object2 = (Object[])object.get(n);
                if (object2 != containedObject) continue;
                object.remove(n);
                object.add(n, null);
            }
            object = ((FactEntitiesJoin)designObject).getLeftAttributes();
            for (n = 0; n < object.size(); ++n) {
                object2 = (ContainedObject)object.get(n);
                if (object2 != containedObject) continue;
                object.remove(n);
                object.add(n, null);
            }
            Object[] objectArray = ((FactEntitiesJoin)designObject).getLeftAttributes().toArray();
            object2 = ((FactEntitiesJoin)designObject).getRightAttributes().toArray();
            ((FactEntitiesJoin)designObject).getLeftAttributes().clear();
            ((FactEntitiesJoin)designObject).getRightAttributes().clear();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null || object2[i] == null) continue;
                ((FactEntitiesJoin)designObject).getLeftAttributes().add(objectArray[i]);
                ((FactEntitiesJoin)designObject).getRightAttributes().add(object2[i]);
            }
        }
    }

    public void entityIsDeleted(ContainerObject containerObject) {
        if (this.getFactEntity() == containerObject) {
            this.setFactEntity(null);
        }
        this.getFactEntities().remove(containerObject);
        Object[] objectArray = this.getJoins().toArray();
        this.getJoins().clear();
        for (int i = 0; i < objectArray.length; ++i) {
            FactEntitiesJoin factEntitiesJoin = (FactEntitiesJoin)objectArray[i];
            if (factEntitiesJoin.getLeftEntity() != containerObject && factEntitiesJoin.getRightEntity() != containerObject) {
                this.getJoins().add(factEntitiesJoin);
                continue;
            }
            factEntitiesJoin.remove();
        }
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
            this.setUseDefaultColor(bl);
        } else if (DefaultFontAndColor.isModified(TYPE_NAME)) {
            DefaultFontAndColor defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME);
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
            this.setUseDefaultColor(bl);
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "cube/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Measure createAndAddMeasure() {
        Measure measure = ((MultidimensionalDesign)this.getDesignPart()).createMeasure();
        measure.setCube(this);
        this.addMeasure(measure);
        return measure;
    }

    public Slice createAndAddSlice() {
        Slice slice = ((MultidimensionalDesign)this.getDesignPart()).createSlice();
        this.addPrecalculatedSlice(slice);
        return slice;
    }

    public FactEntitiesJoin createAndAddFactEntitiesJoin() {
        FactEntitiesJoin factEntitiesJoin = ((MultidimensionalDesign)this.getDesignPart()).createFactEntitiesJoin();
        this.addFactEntitiesJoin(factEntitiesJoin);
        return factEntitiesJoin;
    }
}

