/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;

public class RestoreMappings {
    private Design design;
    private RelationalDesign[] rd_array;
    private ExtendedMap xmap;

    public RestoreMappings(Design design) {
        this.design = design;
        this.rd_array = (RelationalDesign[])design.getRelationalDesigns().toArray();
        this.xmap = design.getExtendedMap();
    }

    public void restore() {
        Object object;
        Object object2;
        Object object3;
        LogicalDesign logicalDesign = this.design.getLogicalDesign();
        Iterator iterator = logicalDesign.getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            this.processEntity(entity);
            object3 = entity.getElements();
            for (int i = 0; i < ((Object)object3).length; ++i) {
                Attribute attribute = (Attribute)object3[i];
                this.processAttribute(attribute);
            }
            object2 = entity.getKeys();
            for (int i = 0; i < ((KeyObject[])object2).length; ++i) {
                object = (CandidateKey)object2[i];
                this.processCandidateKey((CandidateKey)object);
            }
        }
        for (int i = 0; i < this.rd_array.length; ++i) {
            object3 = this.rd_array[i];
            iterator = ((RelationalDesign)object3).getFKIndexAssociationSet().iterator();
            while (iterator.hasNext()) {
                object2 = (FKIndexAssociation)iterator.next();
                Relation relation = ((FKIndexAssociation)object2).getEngRelation();
                if (relation == null || (object = this.xmap.getMappingsForDesignPart((DesignObject)object2, logicalDesign.getObjectID())).size() != 0) continue;
                this.xmap.createMapping(relation, (DesignObject)object2);
            }
        }
        iterator = logicalDesign.getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            EntityView entityView = (EntityView)iterator.next();
            this.processEntityView(entityView);
        }
        this.restoreSubviews();
    }

    private void restoreSubviews() {
        Iterator iterator = this.design.getLogicalDesign().getLogicalDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
            for (int i = 0; i < this.rd_array.length; ++i) {
                RelationalDesign relationalDesign = this.rd_array[i];
                DesignPartView designPartView2 = relationalDesign.getSubViewGeneratedByDPV(designPartView.getDPVId());
                if (designPartView2 == null && designPartView.getGeneratorId() != null && !"".equalsIgnoreCase(designPartView.getGeneratorId())) {
                    designPartView2 = relationalDesign.getSubViewByID(designPartView.getGeneratorId());
                }
                if (designPartView2 == null) continue;
                this.xmap.createMapping(designPartView.getPlaceHolder(), designPartView2.getPlaceHolder());
            }
        }
    }

    private void processEntity(Entity entity) {
        for (int i = 0; i < this.rd_array.length; ++i) {
            Table table = entity.getEngTable(this.rd_array[i]);
            this.restoreMapping(entity, table);
        }
    }

    private void processAttribute(Attribute attribute) {
        for (int i = 0; i < this.rd_array.length; ++i) {
            Column column = attribute.getEngColumn(this.rd_array[i]);
            this.restoreMapping(attribute, column);
        }
    }

    private void processCandidateKey(CandidateKey candidateKey) {
        for (int i = 0; i < this.rd_array.length; ++i) {
            Index index = candidateKey.getEngIndex(this.rd_array[i]);
            this.restoreMapping(candidateKey, index);
        }
    }

    private void processEntityView(EntityView entityView) {
        for (int i = 0; i < this.rd_array.length; ++i) {
            TableView tableView = entityView.getEngTableView(this.rd_array[i]);
            this.restoreMapping(entityView, tableView);
        }
    }

    private XtdMapping restoreMapping(DesignObject designObject, DesignObject designObject2) {
        RelationalDesign relationalDesign;
        List list;
        if (designObject != null && designObject2 != null && (list = this.xmap.getMappingsForDesignPart(designObject, (relationalDesign = (RelationalDesign)designObject2.getDesignPart()).getObjectID())).size() == 0) {
            return this.xmap.createMapping(designObject, designObject2);
        }
        return null;
    }
}

