/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.TypeSubstitutionSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.MeasurementSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.ArcSet;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeSet;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.AttributeViewSet;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.EntityViewSet;
import oracle.dbtools.crest.model.design.logical.GlobalCandidateKeySet;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.InheritanceRelationSet;
import oracle.dbtools.crest.model.design.logical.LogTypeSubstitutionSet;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.logical.RelationSet;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.editor.logical.LogicalModelDialogEx;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.glossary.GlossaryDialog;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.logical.TVInheritanceRelation;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class LogicalDesign
extends DesignPart
implements ModelObjectSetListener {
    public static final String OBJECT_TYPE_NAME = "LogicalDesign";
    public static final String ENTITY_SET_NAME = Messages.getString("LogicalDesign.Entities");
    public static final String ATTRIBUTE_SET_NAME = Messages.getString("LogicalDesign.Attributes");
    public static final String RELATION_SET_NAME = Messages.getString("LogicalDesign.Relations");
    public static final String INHERITANCE_RELATION_SET_NAME = Messages.getString("LogicalDesign.Inheritances");
    public static final String ARC_SET_NAME = Messages.getString("LogicalDesign.Arcs");
    public static final String NOTE_SET_NAME = Messages.getString("LogicalDesign.Notes");
    public static final String MEASUREMENT_SET_NAME = Messages.getString("LogicalDesign.Measurement");
    public static final String ATTRIBUTE_VIEW_SET_NAME = Messages.getString("LogicalDesign.AttributeViews");
    public static final String VIEW_SET_NAME = Messages.getString("LogicalDesign.Views");
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    private EntitySet entitySet;
    private AttributeSet attributeSet;
    private RelationSet relationSet;
    private RelationSet inheritanceRelationSet;
    private ArcSet arcSet;
    private LogicalDatatypeSet logicalTypeSet;
    private NoteSet noteSet;
    private MeasurementSet measurementSet;
    private TypeSubstitutionSet typeSubstitutionSet;
    private AttributeViewSet attributeViewSet;
    private EntityViewSet viewSet;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    public static int MANY_TO_MANY = 0;
    public static int ONE_TO_MANY = 1;
    public static int ONE_TO_MANY_IDENTIFYING = 2;
    public static int ONE_TO_ONE = 3;
    public static int ONE_TO_ONE_IDENTIFYING = 4;
    private List overlappingEntities = new ArrayList();
    private List namingOptionsHolderList;
    private boolean subviewToNewDesign = false;
    private static final Logger LOGGER = new Logger(LogicalDesign.class);

    @Override
    public String getName() {
        return this.getConfiguration("nameLogDesign");
    }

    @Override
    public String toString() {
        return Messages.getString("Design.LogicalModel");
    }

    public LogicalDatatypeSet getLogicalTypeSet() {
        if (this.logicalTypeSet == null) {
            this.logicalTypeSet = new LogicalDatatypeSet(this);
            this.logicalTypeSet.addSetListener(this);
            this.logicalTypeSet.createUnknownType();
        }
        return this.logicalTypeSet;
    }

    public EntitySet getEntitySet() {
        if (this.entitySet == null) {
            this.entitySet = new EntitySet(this);
            this.entitySet.setDesign(this.getDesign());
            this.entitySet.setName(ENTITY_SET_NAME);
            this.entitySet.setParent(this);
            this.entitySet.addSetListener(this);
            this.entitySet.getGlobalCandidateKeySet().setDesign(this.getDesign());
            this.entitySet.getGlobalCandidateKeySet().setParent(this);
        }
        return this.entitySet;
    }

    public AttributeSet getAttributeSet() {
        if (this.attributeSet == null) {
            this.attributeSet = new AttributeSet(this);
            this.attributeSet.setDesign(this.getDesign());
            this.attributeSet.setName(ATTRIBUTE_SET_NAME);
            this.attributeSet.setParent(this);
            this.attributeSet.addSetListener(this);
        }
        return this.attributeSet;
    }

    public RelationSet getRelationSet() {
        if (this.relationSet == null) {
            this.relationSet = new RelationSet(this);
            this.relationSet.setDesign(this.getDesign());
            this.relationSet.setName(RELATION_SET_NAME);
            this.relationSet.setParent(this);
            this.relationSet.addSetListener(this);
        }
        return this.relationSet;
    }

    public RelationSet getInheritanceRelationSet() {
        if (this.inheritanceRelationSet == null) {
            this.inheritanceRelationSet = new InheritanceRelationSet(this);
            this.inheritanceRelationSet.setDesign(this.getDesign());
            this.inheritanceRelationSet.setParent(this);
            this.inheritanceRelationSet.setName(INHERITANCE_RELATION_SET_NAME);
            this.inheritanceRelationSet.addSetListener(this);
        }
        return this.inheritanceRelationSet;
    }

    public GlobalCandidateKeySet getGlobalCandidateKeySet() {
        return this.getEntitySet().getGlobalCandidateKeySet();
    }

    public ArcSet getArcSet() {
        if (this.arcSet == null) {
            this.arcSet = new ArcSet(this);
            this.arcSet.setDesign(this.getDesign());
            this.arcSet.setName(ARC_SET_NAME);
            this.arcSet.setParent(this);
            this.arcSet.addSetListener(this);
        }
        return this.arcSet;
    }

    @Override
    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(NOTE_SET_NAME);
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public MeasurementSet getMeasurementSet() {
        if (this.measurementSet == null) {
            this.measurementSet = new MeasurementSet(this);
            this.measurementSet.setDesign(this.getDesign());
            this.measurementSet.setName(MEASUREMENT_SET_NAME);
            this.measurementSet.setParent(this);
            this.measurementSet.addSetListener(this);
        }
        return this.measurementSet;
    }

    public AttributeViewSet getAttributeViewSet() {
        if (this.attributeViewSet == null) {
            this.attributeViewSet = new AttributeViewSet(this);
            this.attributeViewSet.setDesign(this.getDesign());
            this.attributeViewSet.setName(ATTRIBUTE_VIEW_SET_NAME);
            this.attributeViewSet.setParent(this);
            this.attributeViewSet.addSetListener(this);
        }
        return this.attributeViewSet;
    }

    public EntityViewSet getEntityViewSet() {
        if (this.viewSet == null) {
            this.viewSet = new EntityViewSet(this);
            this.viewSet.setDesign(this.getDesign());
            this.viewSet.setParent(this);
            this.viewSet.addSetListener(this);
            this.viewSet.setName(VIEW_SET_NAME);
        }
        return this.viewSet;
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (setEvent == SetEvent.OBJECT_ADDED) {
            this.fireAdded(setEvent.getAffected());
        } else if (setEvent == SetEvent.OBJECT_REMOVED) {
            this.fireRemoved(setEvent.getAffected());
        }
    }

    public Entity createEntity() {
        return this.getEntitySet().createEntity(null);
    }

    public EntityView createEntityView() {
        return this.getEntityViewSet().createEntityView(null);
    }

    public Entity createEntity(String string) {
        Entity entity = this.getEntitySet().createEntity(null);
        entity.setName(string);
        return entity;
    }

    public EntityView createEntityView(String string) {
        EntityView entityView = this.getEntityViewSet().createEntityView(null);
        entityView.setName(string);
        return entityView;
    }

    public Arc createArc() {
        return this.getArcSet().createArc(null);
    }

    public Arc createArc(String string) {
        Arc arc = this.getArcSet().createArc(null);
        arc.setName(string);
        return arc;
    }

    public Arc recreateArc(String string) {
        return this.getArcSet().createArc(string);
    }

    public Entity recreateEntity(String string) {
        return this.getEntitySet().createEntity(string);
    }

    public EntityView recreateEntityView(String string) {
        return this.getEntityViewSet().createEntityView(string);
    }

    public Relation createRelation() {
        Relation relation = this.getRelationSet().createRelation(null);
        relation.setOptionalSource(this.getAppView().getSettings().isSourceOptional());
        relation.setOptionalTarget(this.getAppView().getSettings().isTargetOptional());
        return relation;
    }

    public Relation createRelation(int n) {
        Relation relation = this.getRelationSet().createRelation(null);
        relation.setOptionalSource(this.getAppView().getSettings().isSourceOptional());
        relation.setOptionalTarget(this.getAppView().getSettings().isTargetOptional());
        if (n == MANY_TO_MANY) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[0]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
        } else if (n == ONE_TO_MANY) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
        } else if (n == ONE_TO_MANY_IDENTIFYING) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
            relation.setIdentifying(true);
        } else if (n == ONE_TO_ONE) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[1]);
        } else if (n == ONE_TO_ONE_IDENTIFYING) {
            relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[1]);
            relation.setIdentifying(true);
        }
        return relation;
    }

    public InheritanceRelation createInheritanceRelation() {
        InheritanceRelation inheritanceRelation = (InheritanceRelation)this.getInheritanceRelationSet().createRelation(null);
        inheritanceRelation.setOptionalSource(this.getAppView().getSettings().isSourceOptional());
        inheritanceRelation.setOptionalTarget(this.getAppView().getSettings().isTargetOptional());
        return inheritanceRelation;
    }

    public InheritanceRelation createNewInheritanceRelation() {
        InheritanceRelation inheritanceRelation = ((InheritanceRelationSet)this.getInheritanceRelationSet()).createInheritanceRelation();
        return inheritanceRelation;
    }

    public Relation createRelation(String string) {
        Relation relation = this.getRelationSet().createRelation(null);
        relation.setName(string);
        relation.setOptionalSource(this.getAppView().getSettings().isSourceOptional());
        relation.setOptionalTarget(this.getAppView().getSettings().isTargetOptional());
        return relation;
    }

    @Override
    public Note createNote() {
        Note note = this.getNoteSet().createNote(null);
        return note;
    }

    @Override
    public Note recreateNote(String string) {
        return this.getNoteSet().createNote(string);
    }

    public Relation recreateRelation(String string) {
        return this.getRelationSet().createRelation(string);
    }

    public InheritanceRelation recreateInheritanceRelation(String string) {
        return (InheritanceRelation)this.getInheritanceRelationSet().createRelation(string);
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList arrayList = new ArrayList();
        this.getEntitySet().addAllElementsTo(arrayList);
        this.getEntityViewSet().addAllElementsTo(arrayList);
        this.getRelationSet().addAllElementsTo(arrayList);
        this.getInheritanceRelationSet().addAllElementsTo(arrayList);
        this.getArcSet().addAllElementsTo(arrayList);
        this.getNoteSet().addAllElementsTo(arrayList);
        this.getDiagramViewSet().addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    public void clearAll() {
        this.getTypeSubstitutionSet().removeAll();
        this.getEntityViewSet().removeAll();
        this.getAttributeSet().removeAll();
        this.getRelationSet().removeAll();
        this.getInheritanceRelationSet().removeAll();
        this.getEntitySet().removeAll();
        this.getAttributeViewSet().removeAll();
        this.getArcSet().removeAll();
        this.getNoteSet().removeAll();
        this.getDiagramViewSet().removeAll();
        this.clearDocuments();
        this.clearResponsibleParties();
        this.setComment("");
        this.setNotes("");
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
        this.dpvPlaceHolder = null;
        this.setCheckedOut(false);
        this.setCheckedOutByMe(false);
        this.setCheckedOutBy("");
    }

    @Override
    public void sortCollections() {
        this.getAttributeSet().sort();
        this.getRelationSet().sort();
        this.getInheritanceRelationSet().sort();
        this.getEntitySet().sort();
        this.getAttributeViewSet().sort();
        this.getEntityViewSet().sort();
        this.getGlobalCandidateKeySet().sortByLongName();
        this.getLogicalDesignSubviews().sort();
        Iterator iterator = this.getLogicalDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
            designPartView.sortCollections();
        }
    }

    @Override
    public int getNumberOfChildren() {
        if (this.getMainView().canCreateDisplays()) {
            return 6;
        }
        return 5;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.getEntitySet();
            }
            case 1: {
                return this.getRelationSet();
            }
            case 2: {
                return this.getInheritanceRelationSet();
            }
            case 3: {
                return this.getEntityViewSet();
            }
            case 4: {
                return this.subViews;
            }
            case 5: {
                return this.getMainView().getDisplays();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.getEntitySet()) {
            return 0;
        }
        if (modelObject == this.getRelationSet()) {
            return 1;
        }
        if (modelObject == this.getInheritanceRelationSet()) {
            return 2;
        }
        if (modelObject == this.getEntityViewSet()) {
            return 3;
        }
        if (modelObject == this.subViews) {
            return 4;
        }
        if (modelObject == this.getMainView().getDisplays()) {
            return 5;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Object getParent() {
        return this.getDesign();
    }

    @Override
    protected DesignPartView createDesignPartSubView(String string) {
        DPVLogicalSubView dPVLogicalSubView = new DPVLogicalSubView(this.getAppView(), this);
        string = this.getNameVersion(this.subViews, string);
        dPVLogicalSubView.setName(string);
        DesignPartViewPlaceHolder designPartViewPlaceHolder = new DesignPartViewPlaceHolder((DesignPart)this, dPVLogicalSubView);
        designPartViewPlaceHolder.setParent(this.subViews);
        this.subViews.add(designPartViewPlaceHolder);
        return dPVLogicalSubView;
    }

    public SubViewObjectSet getLogicalDesignSubviews() {
        return this.subViews;
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVLogical(this.getAppView(), this);
            this.mainView.setDPVId(this.getAppView().getIDGenerator().createNewID());
        }
        return this.mainView;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "LogDes";
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> arrayList = new ArrayList<DesignObjectSet>();
        arrayList.add(this.getEntitySet());
        arrayList.add(this.getEntityViewSet());
        arrayList.add(this.getRelationSet());
        arrayList.add(this.getInheritanceRelationSet());
        arrayList.add(this.getArcSet());
        arrayList.add(this.getNoteSet());
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        if (this.getEntitySet().size() != 0) {
            return false;
        }
        if (this.getEntityViewSet().size() != 0) {
            return false;
        }
        if (this.getAttributeSet().size() != 0) {
            return false;
        }
        if (this.getAttributeViewSet().size() != 0) {
            return false;
        }
        if (this.getRelationSet().size() != 0) {
            return false;
        }
        if (this.getInheritanceRelationSet().size() != 0) {
            return false;
        }
        if (this.getNoteSet().size() != 0) {
            return false;
        }
        return this.getDiagramViewSet().size() == 0;
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.getAffected() instanceof DesignObject) {
            if (modelObjectSetEvent.isAdded()) {
                this.fireAdded((DesignObject)modelObjectSetEvent.getAffected());
            } else if (modelObjectSetEvent.isRemoved()) {
                this.fireRemoved((DesignObject)modelObjectSetEvent.getAffected());
            }
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            LogicalModelDialogEx logicalModelDialogEx = new LogicalModelDialogEx(this.getAppView(), this);
            logicalModelDialogEx.initProperties(this);
            logicalModelDialogEx.show();
        }
    }

    public TypeSubstitutionSet getTypeSubstitutionSet() {
        if (this.typeSubstitutionSet == null) {
            this.typeSubstitutionSet = new LogTypeSubstitutionSet(this);
            this.typeSubstitutionSet.setDesign(this.getDesign());
            this.typeSubstitutionSet.setName(Messages.getString("LogicalDesign.TypeSubstitutions"));
            this.typeSubstitutionSet.setParent(this);
            this.typeSubstitutionSet.addSetListener(this);
        }
        return this.typeSubstitutionSet;
    }

    public TypeSubstitution createTypeSubstitution() {
        return this.getTypeSubstitutionSet().createTypeSubstitution(null);
    }

    public TypeSubstitution createTypeSubstitution(String string) {
        return this.getTypeSubstitutionSet().createTypeSubstitution(string);
    }

    public void rearrangeEntities() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        EntitySet entitySet = this.getEntitySet();
        if (entitySet.size() > 0) {
            Iterator iterator = entitySet.iterator();
            float f = (float)Math.sqrt(entitySet.size());
            long l = (int)f;
            if (Math.sqrt(f * f) != (double)f) {
                ++l;
            }
            ++l;
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                TopView topView = entity.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dimension = this.getEntitySize(entity);
                this.width = dimension.width;
                this.height = Math.max(dimension.height, this.height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
                } else {
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != l) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
                this.height = 25;
            }
        }
    }

    private Dimension getEntitySize(Entity entity) {
        int n;
        int n2 = 35;
        int n3 = 25;
        int n4 = 0;
        StructuredType structuredType = null;
        if (entity.isBST() && entity.getTypeSubstitution() != null) {
            structuredType = entity.getBasedOnStructuredType();
            if (structuredType != null) {
                n4 = structuredType.getElements().length;
            }
        } else {
            n4 = entity.getElements().length;
        }
        n3 += n4 * 14;
        if (entity.getKeys().length > 0 && !this.allKeysAreFK(entity.getKeys())) {
            n3 += 4;
            for (n = 0; n < entity.getKeys().length; ++n) {
                if (entity.getKeys()[n].isFK()) continue;
                n3 += 14;
            }
        }
        n = entity.getName().length() * 6;
        int n5 = 1;
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7;
            DesignObject designObject;
            if (structuredType != null) {
                designObject = structuredType.getElements()[i];
                n7 = designObject.getName().length() * 7;
                n6 = ((TypeElement)designObject).getDataType().length() * 7;
                n = Math.max(n7, n);
                n5 = Math.max(n6, n5);
                continue;
            }
            designObject = (ContainedObjectWithDomain)entity.getElement(i);
            n7 = ((ContainedObject)designObject).getName().length() * 7;
            n6 = ((ContainedObjectWithDomain)designObject).getDataType().toString().length() * 7 + 20;
            n = Math.max(n7, n);
            n5 = Math.max(n6, n5);
        }
        if (n == 1) {
            n = entity.getName().length() * 7;
        }
        return new Dimension(n2 + n + n5, n3);
    }

    private boolean allKeysAreFK(KeyObject[] keyObjectArray) {
        boolean bl = true;
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (keyObjectArray[i].isFK()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void rearrangeViews() {
        if (this.left > 20) {
            this.left = 20;
            this.top = this.top + this.height + 50;
        }
        this.width = 35;
        this.height = 25;
        EntityViewSet entityViewSet = this.getEntityViewSet();
        if (entityViewSet.size() > 0) {
            Iterator iterator = entityViewSet.iterator();
            float f = (float)Math.sqrt(entityViewSet.size());
            long l = (int)f;
            if (Math.sqrt(f * f) != (double)f) {
                ++l;
            }
            while (iterator.hasNext()) {
                EntityView entityView = (EntityView)iterator.next();
                TopView topView = entityView.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dimension = this.getEntityViewSize(entityView);
                this.width = dimension.width;
                this.height = Math.max(dimension.height, this.height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
                } else {
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != l) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
            }
        }
    }

    private Dimension getEntityViewSize(EntityView entityView) {
        int n = 25;
        int n2 = 25;
        int n3 = 0;
        StructuredType structuredType = null;
        if (entityView.isBST() && entityView.getTypeSubstitution() != null) {
            structuredType = entityView.getBasedOnStructuredType();
            if (structuredType != null) {
                n3 = structuredType.getElements().length;
            }
        } else {
            n3 = entityView.getElements().length;
        }
        n2 += n3 * 14;
        int n4 = entityView.getName().length() * 6;
        int n5 = 1;
        for (int i = 0; i < n3; ++i) {
            int n6;
            if (structuredType != null) {
                TypeElement typeElement = structuredType.getElements()[i];
                int n7 = typeElement.getName().length() * 7;
                n6 = typeElement.getDataType().length() * 7;
                n4 = Math.max(n7, n4);
                n5 = Math.max(n6, n5);
                continue;
            }
            if (entityView.getElements()[i] instanceof AttributeView) {
                AttributeView attributeView = (AttributeView)entityView.getElements()[i];
                String string = attributeView.getAlias();
                if ("".equalsIgnoreCase(string)) {
                    string = attributeView.getName();
                }
                n6 = string.length() * 7;
                int n8 = attributeView.getDataType().length() * 7 + 10;
                n4 = Math.max(n6, n4);
                n5 = Math.max(n8, n5);
                continue;
            }
            int n9 = entityView.getElements()[i].getName().length() * 7;
            n4 = Math.max(n9, n4);
        }
        if (n4 > 250) {
            n4 = 250;
        }
        return new Dimension(n + n4 + n5, n2);
    }

    @Override
    public boolean canCreateDPSubview() {
        return true;
    }

    public void updateRelationViews() {
        Iterator iterator = this.getRelationSet().iterator();
        while (iterator.hasNext()) {
            Relation relation = (Relation)iterator.next();
            for (TVRelation tVRelation : relation.getAllTVRelations()) {
                tVRelation.resetEdgeParams(false);
            }
        }
    }

    public void updateRelationViews(DesignPartView designPartView) {
        Iterator iterator = this.getRelationSet().iterator();
        while (iterator.hasNext()) {
            Relation relation = (Relation)iterator.next();
            TVRelation tVRelation = (TVRelation)relation.getViewFor(designPartView);
            if (tVRelation == null) continue;
            tVRelation.resetEdgeParams(false);
        }
    }

    public void updateInheritances(boolean bl) {
        Iterator iterator = this.getInheritanceRelationSet().iterator();
        while (iterator.hasNext()) {
            InheritanceRelation inheritanceRelation = (InheritanceRelation)iterator.next();
            for (TVInheritanceRelation tVInheritanceRelation : inheritanceRelation.getAllTVRelations()) {
                if (bl) {
                    tVInheritanceRelation.removeConnection();
                    tVInheritanceRelation.updateParents();
                    continue;
                }
                tVInheritanceRelation.addConnection();
            }
        }
    }

    public boolean canCreateArc(Object[] objectArray) {
        Entity entity;
        List list;
        List list2 = this.getSelectedEntities(objectArray);
        if (list2.size() == 1 && (list = this.getSelectedRelations(objectArray, entity = (Entity)list2.get(0))).size() > 1) {
            for (Relation relation : list) {
                if (!entity.inArc(relation)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canRemoveFromArc(Object[] objectArray) {
        List list = this.getSelectedArcs(objectArray);
        if (list.size() == 1) {
            Arc arc = (Arc)list.get(0);
            List list2 = this.getSelectedRelations(objectArray, arc.getEntity());
            for (Relation relation : list2) {
                if (!arc.containsRelation(relation)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canAddToArc(Object[] objectArray) {
        List list = this.getSelectedArcs(objectArray);
        if (list.size() == 1) {
            Arc arc = (Arc)list.get(0);
            List list2 = this.getSelectedRelations(objectArray, arc.getEntity());
            for (Relation relation : list2) {
                if (arc.getEntity().inArc(relation)) continue;
                return true;
            }
        }
        return false;
    }

    private List getSelectedEntities(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof Entity)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    private List getSelectedRelations(Object[] objectArray, Entity entity) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        for (int i = 0; i < objectArray.length; ++i) {
            Relation relation;
            Object object = objectArray[i];
            if (!(object instanceof Relation) || (relation = (Relation)object).getSourceEntity() != entity && relation.getTargetEntity() != entity) continue;
            arrayList.add(relation);
        }
        return arrayList;
    }

    private List getSelectedArcs(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof Arc)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public Arc createArc(Object[] objectArray) {
        ApplicationView.log(Messages.getString("LogicalDesign.CreateArc"));
        List list = this.getSelectedEntities(objectArray);
        if (list.size() == 1) {
            Entity entity = (Entity)list.get(0);
            List list2 = this.getSelectedRelations(objectArray, entity);
            Arc arc = this.createArc();
            entity.addArc(arc);
            for (Relation relation : list2) {
                arc.addRelation(relation);
            }
            return arc;
        }
        return null;
    }

    public void addToArc(Object[] objectArray) {
        List list = this.getSelectedArcs(objectArray);
        if (list.size() == 1) {
            Arc arc = (Arc)list.get(0);
            List list2 = this.getSelectedRelations(objectArray, arc.getEntity());
            for (Relation relation : list2) {
                if (arc.getEntity().inArc(relation)) continue;
                arc.addRelation(relation);
            }
            arc.setDirty(true);
            this.getMainView().getWorkSpace().updateUI();
        }
    }

    public void removeFromArc(Object[] objectArray) {
        List list = this.getSelectedArcs(objectArray);
        if (list.size() == 1) {
            Arc arc = (Arc)list.get(0);
            List list2 = this.getSelectedRelations(objectArray, arc.getEntity());
            for (Relation relation : list2) {
                if (!arc.containsRelation(relation)) continue;
                arc.removeRelation(relation);
            }
            arc.setDirty(true);
            if (arc.getRelations().size() <= 1) {
                arc.remove();
            }
            this.getMainView().getWorkSpace().updateUI();
        }
    }

    public EntHolder getOverlappingKeys_EntHolder(Entity entity) {
        ArrayList arrayList = new ArrayList();
        List list = this.getRelationSet().getRelationsTo(entity);
        if (list.size() > 1) {
            for (int i = 0; i < list.size() - 1; ++i) {
                Relation relation = (Relation)list.get(i);
                Entity entity2 = relation.getOtherEntity(entity);
                if (entity2 == entity) continue;
                for (int j = i + 1; j < list.size(); ++j) {
                    Relation relation2 = (Relation)list.get(j);
                    Entity entity3 = relation2.getOtherEntity(entity);
                    if (entity3 == entity) continue;
                    this.checkOverlappingKeys(entity, relation, relation2, arrayList);
                }
            }
        }
        if (arrayList.size() > 0) {
            return (EntHolder)arrayList.get(0);
        }
        return null;
    }

    private void checkForEntitiesWuthOverlappingKeys() {
        this.overlappingEntities.clear();
        Iterator iterator = this.getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            List list = this.getRelationSet().getRelationsTo(entity);
            if (list.size() <= 1) continue;
            for (int i = 0; i < list.size() - 1; ++i) {
                Relation relation = (Relation)list.get(i);
                Entity entity2 = relation.getOtherEntity(entity);
                if (entity2 == entity) continue;
                for (int j = i + 1; j < list.size(); ++j) {
                    Relation relation2 = (Relation)list.get(j);
                    Entity entity3 = relation2.getOtherEntity(entity);
                    if (entity3 == entity) continue;
                    this.checkOverlappingKeys(entity, relation, relation2, this.overlappingEntities);
                }
            }
        }
    }

    private void checkOverlappingKeys(Entity entity, Relation relation, Relation relation2, List list) {
        AttrHolder[] attrHolderArray;
        Object object;
        int n;
        int n2;
        Attribute[] attributeArray = (Attribute[])entity.getAllElementsGeneratedBy(relation.getObjectID());
        Attribute[] attributeArray2 = (Attribute[])entity.getAllElementsGeneratedBy(relation2.getObjectID());
        ArrayList<List> arrayList = new ArrayList<List>();
        ArrayList<List> arrayList2 = new ArrayList<List>();
        for (n2 = 0; n2 < attributeArray.length; ++n2) {
            arrayList.add(attributeArray[n2].getAlldelegates());
        }
        for (n2 = 0; n2 < attributeArray2.length; ++n2) {
            arrayList2.add(attributeArray2[n2].getAlldelegates());
        }
        AttrHolder[][] attrHolderArray2 = new AttrHolder[attributeArray.length][attributeArray2.length];
        EntHolder entHolder = this.getHolderFor(entity, list);
        boolean bl = false;
        if (entHolder == null) {
            entHolder = new EntHolder();
            entHolder.ent = entity;
            bl = true;
        }
        KeyObject keyObject = entity.getPK();
        for (n = 0; n < attributeArray.length; ++n) {
            ArrayList<AttrHolder> arrayList3 = new ArrayList<AttrHolder>();
            for (int i = 0; i < attributeArray2.length; ++i) {
                if (!this.hasCommonElement((List)arrayList.get(n), (List)arrayList2.get(i))) continue;
                AttrHolder attrHolder = new AttrHolder();
                object = attributeArray[n];
                attrHolderArray = attributeArray2[i];
                if (((ContainedObjectWithDomain)object).isPKElement()) {
                    attrHolder.attr1 = object;
                    attrHolder.attr2 = attrHolderArray;
                } else if (attrHolderArray.isPKElement()) {
                    attrHolder.attr1 = attrHolderArray;
                    attrHolder.attr2 = object;
                } else if (((ContainedObject)object).getName().toUpperCase().indexOf(attrHolderArray.getName().toUpperCase()) > -1) {
                    attrHolder.attr1 = attrHolderArray;
                    attrHolder.attr2 = object;
                } else if (attrHolderArray.getName().toUpperCase().indexOf(((ContainedObject)object).getName().toUpperCase()) > -1) {
                    attrHolder.attr1 = object;
                    attrHolder.attr2 = attrHolderArray;
                } else {
                    attrHolder.attr1 = object;
                    attrHolder.attr2 = attrHolderArray;
                }
                if (keyObject != null && (keyObject.contains((ContainedObject)object) || keyObject.contains((ContainedObject)attrHolderArray))) {
                    attrHolder.inpk = true;
                }
                entHolder.attrHolders.add(attrHolder);
                arrayList3.add(attrHolder);
                attrHolderArray2[n][i] = attrHolder;
            }
            for (AttrHolder attrHolder : arrayList3) {
                attrHolder.relatedHolders.addAll(arrayList3);
            }
        }
        if (entHolder.attrHolders.size() > 0) {
            for (n = 0; n < attributeArray.length; ++n) {
                for (int i = 0; i < attributeArray2.length; ++i) {
                    AttrHolder attrHolder = attrHolderArray2[n][i];
                    if (attrHolder == null) continue;
                    for (int j = 0; j < attributeArray.length; ++j) {
                        object = attrHolderArray2[j][i];
                        if (object == null) continue;
                        attrHolderArray = attrHolder.relatedHolders.toArray(new AttrHolder[0]);
                        for (int k = 0; k < attrHolderArray.length; ++k) {
                            if (attrHolderArray[k].relatedHolders.contains(object)) continue;
                            attrHolderArray[k].relatedHolders.add(object);
                        }
                    }
                }
            }
            if (bl) {
                list.add(entHolder);
            }
        }
    }

    private EntHolder getHolderFor(Entity entity, List list) {
        for (EntHolder entHolder : list) {
            if (entHolder.ent != entity) continue;
            return entHolder;
        }
        return null;
    }

    private boolean hasCommonElement(List list, List list2) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list2.contains(list.get(i))) continue;
            return true;
        }
        return false;
    }

    public List getEntitiesWuthOverlappingKeys(boolean bl) {
        if (bl) {
            this.checkForEntitiesWuthOverlappingKeys();
        }
        return this.overlappingEntities;
    }

    public void resetIdentifyingRelationships() {
    }

    public void synchronizeFKAttributesName() {
        boolean bl = this.getAppView().getSettings().isKeepFKNamesSynchronized();
        if (bl) {
            Iterator iterator = this.getGlobalCandidateKeySet().iterator();
            while (iterator.hasNext()) {
                CandidateKey candidateKey = (CandidateKey)iterator.next();
                ContainedObject[] containedObjectArray = candidateKey.getElements();
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    Attribute attribute = (Attribute)containedObjectArray[i];
                    if (attribute.isFKAttribute()) continue;
                    attribute.propagateNameToFKAttributes(attribute.getName());
                }
            }
        }
    }

    public void updateFontsAndColors(boolean bl) {
        Object object;
        Iterator iterator = this.getEntitySet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getNoteSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getRelationSet().iterator();
        while (iterator.hasNext()) {
            object = (DesignObject)iterator.next();
            if (bl) {
                ((DesignObject)object).setBackgroundColor(null);
            } else if (((DesignObject)object).getBackgroundColor() == null) {
                ((DesignObject)object).setBackgroundColor(((DesignObject)object).getTopView().getDefaultLineColor());
            }
            ((DesignObject)object).setUseDefaultColor(bl);
        }
        iterator = this.getInheritanceRelationSet().iterator();
        while (iterator.hasNext()) {
            object = (DesignObject)iterator.next();
            if (bl) {
                ((DesignObject)object).setBackgroundColor(null);
            } else if (((DesignObject)object).getBackgroundColor() == null) {
                ((DesignObject)object).setBackgroundColor(((DesignObject)object).getTopView().getDefaultLineColor());
            }
            ((DesignObject)object).setUseDefaultColor(bl);
        }
        iterator = this.getLabelSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
    }

    @Override
    public List getNamingOptionsHolderList() {
        if (this.namingOptionsHolderList == null) {
            this.namingOptionsHolderList = new ArrayList();
            this.namingOptionsHolderList.add(new NamingOptionsHolder(Entity.class, 254));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(Attribute.class, 254));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(EntityView.class, 254));
        }
        return this.namingOptionsHolderList;
    }

    @Override
    public void setMainViewVisible(boolean bl, boolean bl2) {
        super.setMainViewVisible(bl, bl2);
        if (bl && this.getMainView().isBoxInBox()) {
            this.fixBoxInBox(this.getMainView());
        }
    }

    public void fixBoxInBox(DesignPartView designPartView) {
        Object object;
        ObjectListener objectListener;
        Object object2;
        Iterator iterator = this.getEntitySet().iterator();
        while (iterator.hasNext()) {
            object2 = (Entity)iterator.next();
            if (!((Entity)object2).isHierarchicalRoot() || (objectListener = ((MultiShapedDesignObject)object2).getFirstViewForDPV(designPartView)) == null || (object = ((TopView)objectListener).getCellView()) == null) continue;
            ((oracle.dbtools.crest.swingui.diagram.logical.EntityView)object).updateParent();
        }
        object2 = new ArrayList();
        iterator = this.getEntitySet().iterator();
        while (iterator.hasNext()) {
            AbstractCellView abstractCellView;
            objectListener = (Entity)iterator.next();
            if (((Entity)objectListener).isHierarchicalEntityType() || (object = ((MultiShapedDesignObject)((Object)objectListener)).getFirstViewForDPV(designPartView)) == null || (abstractCellView = ((TopView)object).getCellView()) == null) continue;
            object2.add(abstractCellView.getCell());
        }
        if (object2.size() > 0) {
            designPartView.getWorkSpace().getDiagramLayoutCache().toFront(object2.toArray());
        }
    }

    public boolean isSubviewToNewDesign() {
        return this.subviewToNewDesign;
    }

    public void setSubviewToNewDesign(boolean bl) {
        this.subviewToNewDesign = bl;
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Entity");
        arrayList.add("Relation");
        arrayList.add("Hierarchy relation");
        arrayList.add("EntityView");
        arrayList.add("Arc");
        arrayList.add("Note");
        arrayList.add("MainView");
        arrayList.add("SubView");
        return arrayList;
    }

    @Override
    public String getStoragePath() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "logical").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "logical/" + this.getName() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean setName(String string) {
        return true;
    }

    @Override
    public StorableObject createObject(String string, String string2, String string3) {
        DesignObject designObject = null;
        if ("Entity".equalsIgnoreCase(string)) {
            designObject = this.getEntitySet().createEntity(string2);
        } else if ("EntityView".equalsIgnoreCase(string) || "View".equalsIgnoreCase(string)) {
            designObject = this.getEntityViewSet().createEntityView(string2);
        } else if ("Relation".equalsIgnoreCase(string)) {
            designObject = this.recreateRelation(string2);
        } else if ("Hierarchy relation".equalsIgnoreCase(string)) {
            designObject = this.recreateInheritanceRelation(string2);
        } else if ("Arc".equalsIgnoreCase(string)) {
            designObject = this.getArcSet().createArc(string2);
        } else if ("Note".equalsIgnoreCase(string)) {
            designObject = this.getNoteSet().createNote(string2);
        }
        if (designObject != null && string3 != null && string3.length() > 0) {
            designObject.setName(string3);
        }
        return designObject;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("entity", "Entity");
            this.f2tMap.put("relation", "Relation");
            this.f2tMap.put("inheritance", "Hierarchy relation");
            this.f2tMap.put("view", "View");
            this.f2tMap.put("arc", "Arc");
            this.f2tMap.put("note", "Note");
        }
        return this.f2tMap;
    }

    public static void initObjectDetails(Design design, File file, String string, StorableObjectStatusHelper storableObjectStatusHelper, String string2) {
        storableObjectStatusHelper.treePath.add(new TreePathHelper(MDConfiguration.getDefaultInstance().get("nameLogDesign"), new File(design.getLogicalDesign().getStorageName()), LogicalDesign.class));
        if ("entity".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Entity.class;
            storableObjectStatusHelper.objectType = "Entity";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(ENTITY_SET_NAME, file.getParentFile(), EntitySet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((LogicalDesign)storableObjectStatusHelper.designPart).getEntitySet();
                storableObjectStatusHelper.storableObject = ((LogicalDesign)storableObjectStatusHelper.designPart).getEntitySet().getObjectByID(string2);
            }
        } else if ("view".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = EntityView.class;
            storableObjectStatusHelper.objectType = "View";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(VIEW_SET_NAME, file.getParentFile(), EntityViewSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((LogicalDesign)storableObjectStatusHelper.designPart).getEntityViewSet();
                storableObjectStatusHelper.storableObject = ((LogicalDesign)storableObjectStatusHelper.designPart).getEntityViewSet().getObjectByID(string2);
            }
        } else if ("relation".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Relation.class;
            storableObjectStatusHelper.objectType = "Relation";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(RELATION_SET_NAME, file.getParentFile(), RelationSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((LogicalDesign)storableObjectStatusHelper.designPart).getRelationSet();
                storableObjectStatusHelper.storableObject = ((LogicalDesign)storableObjectStatusHelper.designPart).getRelationSet().getObjectByID(string2);
            }
        } else if ("inheritance".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = InheritanceRelation.class;
            storableObjectStatusHelper.objectType = "Hierarchy relation";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(INHERITANCE_RELATION_SET_NAME, file.getParentFile(), InheritanceRelationSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((LogicalDesign)storableObjectStatusHelper.designPart).getInheritanceRelationSet();
                storableObjectStatusHelper.storableObject = ((LogicalDesign)storableObjectStatusHelper.designPart).getInheritanceRelationSet().getObjectByID(string2);
            }
        } else if ("arc".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Arc.class;
            storableObjectStatusHelper.objectType = "Arc";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(ARC_SET_NAME, file.getParentFile(), ArcSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((LogicalDesign)storableObjectStatusHelper.designPart).getArcSet();
                storableObjectStatusHelper.storableObject = ((LogicalDesign)storableObjectStatusHelper.designPart).getArcSet().getObjectByID(string2);
            }
        } else if ("note".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Note.class;
            storableObjectStatusHelper.objectType = "Note";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(NOTE_SET_NAME, file.getParentFile(), NoteSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((LogicalDesign)storableObjectStatusHelper.designPart).getNoteSet();
                storableObjectStatusHelper.storableObject = ((LogicalDesign)storableObjectStatusHelper.designPart).getNoteSet().getObjectByID(string2);
            }
        } else if ("subviews".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = DPVLogicalSubView.class;
            storableObjectStatusHelper.treePath.add(new TreePathHelper(DIAGRAM_SET_NAME, file.getParentFile(), DPVLogicalSubView.class));
            if (storableObjectStatusHelper.designPart != null) {
                LogicalDesign logicalDesign = (LogicalDesign)storableObjectStatusHelper.designPart;
                storableObjectStatusHelper.storableObject = logicalDesign.getMainView().getDPVId().equals(string2) ? logicalDesign.getMainView() : logicalDesign.getSubViewByID(string2);
            }
        }
    }

    public void updateParentChildEntities() {
        ArrayList<InheritanceHelper> arrayList = new ArrayList<InheritanceHelper>();
        Iterator iterator = this.getInheritanceRelationSet().iterator();
        while (iterator.hasNext()) {
            InheritanceRelation object = (InheritanceRelation)iterator.next();
            InheritanceHelper inheritanceHelper = new InheritanceHelper();
            inheritanceHelper.inh = object;
            inheritanceHelper.source = object.getSourceEntity();
            inheritanceHelper.target = object.getTargetEntity();
            arrayList.add(inheritanceHelper);
        }
        for (InheritanceHelper inheritanceHelper : arrayList) {
            if (inheritanceHelper.processed) continue;
            if (inheritanceHelper.source != null && inheritanceHelper.target != null) {
                this.updateForParent(inheritanceHelper.source, arrayList);
                if (inheritanceHelper.target.getHierarchicalParent() != inheritanceHelper.source) {
                    try {
                        inheritanceHelper.target.setHierarchicalParent(inheritanceHelper.source, inheritanceHelper.inh);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error in reseting parent entities - inheritance " + inheritanceHelper.inh.getName(), exception);
                    }
                }
            } else {
                inheritanceHelper.todelete = true;
            }
            inheritanceHelper.processed = true;
        }
        for (InheritanceHelper inheritanceHelper : arrayList) {
            if (!inheritanceHelper.todelete) continue;
            inheritanceHelper.inh.remove();
        }
    }

    private void updateForParent(Entity entity, List list) {
        for (int i = 0; i < list.size(); ++i) {
            InheritanceHelper inheritanceHelper = (InheritanceHelper)list.get(i);
            if (inheritanceHelper.processed || inheritanceHelper.target != entity || inheritanceHelper.source == null) continue;
            if (inheritanceHelper.source != null && inheritanceHelper.target != null) {
                this.updateForParent(inheritanceHelper.source, list);
                if (inheritanceHelper.target.getHierarchicalParent() != inheritanceHelper.source) {
                    try {
                        inheritanceHelper.target.setHierarchicalParent(inheritanceHelper.source, inheritanceHelper.inh);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error in reseting parent entities - inheritance " + inheritanceHelper.inh.getName(), exception);
                    }
                }
            } else {
                inheritanceHelper.todelete = true;
            }
            inheritanceHelper.processed = true;
        }
    }

    @Override
    public void doAfterLoad() {
        if (!this.getDesign().isOldRepositoryType()) {
            this.updateParentChildEntities();
            Iterator iterator = this.getGlobalCandidateKeySet().iterator();
            while (iterator.hasNext()) {
                CandidateKey candidateKey = (CandidateKey)iterator.next();
                candidateKey.updateContainedObjects();
                candidateKey.updateElementsCollection();
            }
        }
        this.setViewListeners();
        super.doAfterLoad();
    }

    public Glossary createGlossaryFromModel() {
        Object object;
        Object object2;
        Object object3;
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        Glossary glossary = new Glossary(null);
        NamingStandardRule namingStandardRule = this.getDesign().getNamingStandardRule();
        char c = namingStandardRule.getLogicalSeparatorChar();
        String string = "" + c;
        boolean bl = "Title Case".equalsIgnoreCase(namingStandardRule.getLogicalSep());
        if ("".equals(string) || bl) {
            string = " ";
        }
        Iterator iterator = this.getEntitySet().iterator();
        while (iterator.hasNext()) {
            object3 = (Entity)iterator.next();
            this.processObjectName((DesignObject)object3, treeMap, treeMap2, string);
            object2 = ((ContainerObject)object3).getElements();
            for (int i = 0; i < ((ContainedObject[])object2).length; ++i) {
                if (object2[i].isFKElement()) continue;
                this.processObjectName(object2[i], treeMap, treeMap2, string);
            }
            object = ((ContainerWithKeyObject)object3).getKeys();
            for (int i = 0; i < ((KeyObject[])object).length; ++i) {
                this.processObjectName(object[i], treeMap, treeMap2, string);
            }
        }
        this.getAppView();
        object3 = ApplicationView.basePath + "/templates/ABBREVS_SAMPLE.csv";
        object2 = new TreeMap();
        object = new File((String)object3);
        if (((File)object).exists()) {
            this.loadAbbreviations((Map)object2, (File)object);
        }
        this.getAppView();
        object3 = ApplicationView.basePath + "/templates/plurals.csv";
        TreeMap treeMap3 = new TreeMap();
        object = new File((String)object3);
        if (((File)object).exists()) {
            this.loadPlurals(treeMap3, (File)object);
        }
        this.addWords(treeMap, (Map)object2, treeMap3, glossary);
        glossary.setDirty(true);
        glossary.setName(this.getDesign().getName());
        glossary.setDescription("generated from logical model of design " + this.getDesign().getName());
        GlossaryDialog glossaryDialog = new GlossaryDialog(this.getAppView(), glossary);
        glossaryDialog.showDialog();
        return glossary;
    }

    private void processObjectName(DesignObject designObject, Map map, Map map2, String string) {
        String[] stringArray = designObject.getName().split(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].toUpperCase();
            String string3 = (String)map2.get(string2);
            if (string3 != null) continue;
            map.put(stringArray[i], "");
            map2.put(string2, stringArray[i]);
        }
    }

    private void addWords(Map map, Map map2, Map map3, Glossary glossary) {
        for (String string : map.keySet()) {
            String string2 = string.toUpperCase();
            String string3 = (String)map2.get(string2);
            String string4 = (String)map3.get(string2);
            if (string == null) continue;
            GlossaryWord glossaryWord = glossary.createGlossaryWordWithID();
            glossaryWord.setName(string);
            if (string3 != null) {
                glossaryWord.setAbbreviation(string3);
            }
            if (string4 == null) continue;
            glossaryWord.setPlural(string4.toUpperCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAbbreviations(Map map, File file) {
        try {
            int n = 44;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getAbsolutePath()));
            int n2 = 0;
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    ++n2;
                    try {
                        int n3 = string.indexOf(n);
                        if (n3 > -1) {
                            String string2 = string.substring(0, n3).trim();
                            String string3 = string.substring(n3 + 1, string.length()).trim();
                            if (!"".equals(string2) && !"".equals(string3)) {
                                map.put(string2.toUpperCase(), string3);
                            }
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error in processing file with abbreviations", exception);
                    }
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                LOGGER.error("Error in loading file with abbreviations", iOException);
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    StringBuffer stringBuffer = new StringBuffer("Cannot close file with abbreviations ");
                    stringBuffer.append(file.getAbsolutePath());
                    LOGGER.error(stringBuffer.toString());
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuffer stringBuffer = new StringBuffer("Can not open file with abbreviations ");
            stringBuffer.append(file.getAbsolutePath());
            LOGGER.error(stringBuffer.toString(), fileNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPlurals(Map map, File file) {
        try {
            int n = 44;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getAbsolutePath()));
            int n2 = 0;
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    ++n2;
                    try {
                        int n3 = string.indexOf(n);
                        if (n3 > -1) {
                            String string2 = string.substring(0, n3).trim();
                            String string3 = string.substring(n3 + 1, string.length()).trim();
                            if (!"".equals(string2) && !"".equals(string3)) {
                                map.put(string2.toUpperCase(), string3);
                            }
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error in processing file with plurals", exception);
                    }
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                LOGGER.error("Error in loading file with plurals", iOException);
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    StringBuffer stringBuffer = new StringBuffer("Cannot close file with plurals ");
                    stringBuffer.append(file.getAbsolutePath());
                    LOGGER.error(stringBuffer.toString());
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuffer stringBuffer = new StringBuffer("Can not open file with plurals ");
            stringBuffer.append(file.getAbsolutePath());
            LOGGER.error(stringBuffer.toString(), fileNotFoundException);
        }
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        if (this.getMainView() != null) {
            this.getMainView().getWorkSpace().updateSettings();
        }
        this.sortCollections();
    }

    public void openLogicalModel() {
        if (!this.isLoaded()) {
            this.getAppView().getXMLTransformationManager().openDesignPart(this);
            this.setLoaded(true);
        }
    }

    @Override
    public List getObjectsWithMeasurements() {
        DesignObject designObject;
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        Iterator iterator = this.getEntitySet().iterator();
        while (iterator.hasNext()) {
            designObject = (Entity)iterator.next();
            if (designObject.getMeasurements().size() > 0) {
                arrayList.add(designObject);
            }
            for (Attribute designObject2 : Arrays.asList(((ContainerObject)designObject).getElements())) {
                if (designObject2.getMeasurements().size() <= 0) continue;
                arrayList.add(designObject2);
            }
        }
        iterator = this.getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            designObject = (EntityView)iterator.next();
            if (designObject.getMeasurements().size() > 0) {
                arrayList.add(designObject);
            }
            for (DesignObject designObject2 : Arrays.asList(((ContainerObject)designObject).getElements())) {
                if (designObject2.getMeasurements().size() <= 0) continue;
                arrayList.add(designObject2);
            }
        }
        iterator = this.getRelationSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Relation)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getInheritanceRelationSet().iterator();
        while (iterator.hasNext()) {
            designObject = (InheritanceRelation)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getArcSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Arc)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getNoteSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Note)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getTypeSubstitutionSet().iterator();
        while (iterator.hasNext()) {
            designObject = (TypeSubstitution)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        return arrayList;
    }

    private void setViewListeners() {
        Iterator iterator = this.getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            EntityView entityView = (EntityView)iterator.next();
            if (!entityView.isParsed()) continue;
            for (SQLNameHelper sQLNameHelper : entityView.getSQLNames()) {
                DesignObject designObject = this.getDesign().getDesignObject(sQLNameHelper.getID());
                if (designObject == null) continue;
                designObject.addObjectListener(entityView);
            }
        }
    }

    @Override
    protected List getObjectWichAllowClassificationTypes() {
        ArrayList arrayList = new ArrayList();
        this.getEntitySet().addAllElementsTo(arrayList);
        return arrayList;
    }

    class InheritanceHelper {
        InheritanceRelation inh;
        Entity source;
        Entity target;
        boolean processed = false;
        boolean todelete = false;

        InheritanceHelper() {
        }
    }

    public class AttributePlaceHolder
    extends DesignObjectPlaceHolder {
        public AttributePlaceHolder(DesignObject designObject) {
            super(designObject);
        }

        @Override
        public String toString() {
            if (this.getDesignObject() instanceof Attribute && !((Attribute)this.getDesignObject()).isFKAttribute()) {
                return this.getDesignObject().getLongName();
            }
            return super.toString();
        }
    }

    public class AttrHolder {
        public Attribute attr1;
        public Attribute attr2;
        public boolean inpk = false;
        public boolean overlap = false;
        public boolean overlapped = false;
        public boolean readOnly = false;
        public List relatedHolders = new ArrayList();

        public String toString() {
            if (this.attr1 != null && this.attr2 != null) {
                return this.attr1.getName() + " - " + this.attr2.getName();
            }
            return "";
        }
    }

    public class EntHolder {
        public Entity ent;
        public List attrHolders = new ArrayList();
    }
}

