/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.logical.RelationSet;
import oracle.dbtools.crest.swingui.logical.TVRelation;

public class InheritanceRelationSet
extends RelationSet {
    public static final Object[] PROTOTYPE_ARRAY = new InheritanceRelation[0];
    private IDGenerator pseudoGenerator = new IDGenerator();

    public InheritanceRelationSet(DesignPart designPart) {
        super(designPart);
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default inheritance relation name");
    }

    @Override
    public Relation createRelation(String string) {
        if (this.getDesign().isLoading()) {
            InheritanceRelation inheritanceRelation = new InheritanceRelation(this.getDesignPart());
            inheritanceRelation.setObjectID(string);
            inheritanceRelation.setDesign(this.getDesign());
            inheritanceRelation.setDesignObjectSet(this);
            this.getDesign().addDesignObject(inheritanceRelation);
            this.add(inheritanceRelation);
            inheritanceRelation.setNameOnTarget("Sub Type");
            inheritanceRelation.setNameOnSource("Super Type");
            return inheritanceRelation;
        }
        throw new IllegalArgumentException("InheritanceRelations should be created using createRelation(String, Entity, Entity)");
    }

    public InheritanceRelation createInheritanceRelation() {
        InheritanceRelation inheritanceRelation = new InheritanceRelation(this.getDesignPart());
        inheritanceRelation.setDesign(this.getDesign());
        inheritanceRelation.setDesignObjectSet(this);
        this.getDesign().addDesignObject(inheritanceRelation);
        this.add(inheritanceRelation);
        inheritanceRelation.setNameOnTarget("Sub Type");
        inheritanceRelation.setNameOnSource("Super Type");
        return inheritanceRelation;
    }

    public Relation createRelation(String string, Entity entity, Entity entity2) {
        InheritanceRelation inheritanceRelation = new InheritanceRelation(this.getDesignPart());
        inheritanceRelation.setObjectID(string);
        inheritanceRelation.setDesign(this.getDesign());
        inheritanceRelation.setDesignObjectSet(this);
        this.getDesign().addDesignObject(inheritanceRelation);
        this.add(inheritanceRelation);
        ((Relation)inheritanceRelation).setTargetEntity(entity2);
        ((Relation)inheritanceRelation).setSourceEntity(entity);
        inheritanceRelation.setNameOnTarget("Sub Type");
        inheritanceRelation.setNameOnSource("Super Type");
        ((TVRelation)inheritanceRelation.getTopView()).addConnection();
        inheritanceRelation.setSourceTV(inheritanceRelation.getSourceTVEntity());
        inheritanceRelation.setTargetTV(inheritanceRelation.getTargetTVEntity());
        return inheritanceRelation;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTOTYPE_ARRAY;
    }

    public IDGenerator getPseudoGenerator() {
        return this.pseudoGenerator;
    }

    public InheritanceRelation getInheritanceRelation(Entity entity, Entity entity2) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            InheritanceRelation inheritanceRelation = (InheritanceRelation)iterator.next();
            if (inheritanceRelation.getSourceEntity() != entity || inheritanceRelation.getTargetEntity() != entity2) continue;
            return inheritanceRelation;
        }
        return null;
    }

    public InheritanceRelation getInheritanceRelationFor(Entity entity, Entity entity2) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            InheritanceRelation inheritanceRelation = (InheritanceRelation)iterator.next();
            if ((inheritanceRelation.getSourceEntity() != entity || inheritanceRelation.getTargetEntity() != entity2) && (inheritanceRelation.getSourceEntity() != entity2 || inheritanceRelation.getTargetEntity() != entity)) continue;
            return inheritanceRelation;
        }
        return null;
    }

    public List getSubtypesOf(Entity entity) {
        ArrayList<InheritanceRelation> arrayList = new ArrayList<InheritanceRelation>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            InheritanceRelation inheritanceRelation = (InheritanceRelation)iterator.next();
            if (inheritanceRelation.getSourceEntity() != entity) continue;
            arrayList.add(inheritanceRelation);
        }
        return arrayList;
    }
}

