/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.ApplyAttributesNamingStandards;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;

public class FKAttributeManager
implements ObjectListener,
ContainerObjectListener {
    private static final Attribute[] ATTRIBUTE_ARRAY_PROTOTYPE = new Attribute[0];
    public static boolean CAN_SYNCHRONIZE = true;
    private Relation relation;
    private boolean needSync = false;
    private List sourceAttributes = new ArrayList();
    private List targetAttributes = new ArrayList();
    private Entity source;
    private Entity target;
    private KeyObject sourcePk;
    private KeyObject targetPk;
    private Map fkSort = new HashMap();
    private static final Logger LOGGER = new Logger(FKAttributeManager.class);

    public FKAttributeManager(Relation relation) {
        this.relation = relation;
        relation.addObjectListener(this);
        this.source = relation.getSourceEntity();
        this.target = relation.getTargetEntity();
        this.makeAttributesForEndpoint(relation.getSourceConnection());
        this.makeAttributesForEndpoint(relation.getTargetConnection());
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.PK_CHANGED) || objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE) || objectChangeEvent.isType(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED)) {
            this.makeAttributesForEndpoints();
        } else if (objectChangeEvent.isType(ObjectChangeEvent.RELATION_CARDINALITY_CHANGED)) {
            this.makeAttributesForEndpoints();
            this.source = this.relation.getSourceEntity();
            this.target = this.relation.getTargetEntity();
            if (this.source != null) {
                this.source.updateRelationStatus(this.relation);
            }
            if (this.target != null) {
                this.target.updateRelationStatus(this.relation);
            }
        } else if (objectChangeEvent.isType(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED)) {
            if (this.relation.getSourceEntity() != null && !this.relation.getSourceEntity().equals(this.source)) {
                if (this.source != null) {
                    this.source.removeObjectListener(this);
                    this.source.removeContainerListener(this);
                    this.source.updateRelationStatus(this.relation);
                }
                this.source = this.relation.getSourceEntity();
                if (this.source != null) {
                    this.source.addObjectListener(this);
                    this.source.addContainerListener(this);
                }
                this.makeAttributesForEndpoints();
            } else if (this.relation.getTargetEntity() != null && !this.relation.getTargetEntity().equals(this.target)) {
                if (this.target != null) {
                    this.target.removeObjectListener(this);
                    this.target.removeContainerListener(this);
                    this.target.updateRelationStatus(this.relation);
                }
                this.target = this.relation.getTargetEntity();
                if (this.target != null) {
                    this.target.addObjectListener(this);
                    this.target.addContainerListener(this);
                }
                this.makeAttributesForEndpoints();
            }
        } else {
            if (objectChangeEvent.isType(ObjectChangeEvent.OBJECT_REMOVED)) {
                if (this.relation.equals(objectChangeEvent.getAffected())) {
                    this.removeAllFKAttributes();
                    return;
                }
                if (objectChangeEvent.getAffected().equals(this.sourcePk)) {
                    this.removeFKAttributesForEndPoints(this.targetAttributes);
                    this.makeAttributesForEndpoint(this.relation.getTargetConnection());
                } else if (objectChangeEvent.getAffected().equals(this.targetPk)) {
                    this.removeFKAttributesForEndPoints(this.sourceAttributes);
                    this.makeAttributesForEndpoint(this.relation.getSourceConnection());
                }
                return;
            }
            return;
        }
    }

    @Override
    public void changed(ContainerObject containerObject, ContainerObjectEvent containerObjectEvent) {
        if (containerObjectEvent.isType(0) || containerObjectEvent.isType(1) || containerObjectEvent.isType(9)) {
            if (containerObject.equals(this.sourcePk)) {
                if (this.sourcePk.isUnique()) {
                    this.removeFKAttributesForEndPoints(this.targetAttributes, this.sourcePk);
                }
                this.makeAttributesForEndpoint(this.relation.getTargetConnection());
            } else if (containerObject.equals(this.targetPk)) {
                if (this.targetPk.isUnique()) {
                    this.removeFKAttributesForEndPoints(this.sourceAttributes, this.targetPk);
                }
                this.makeAttributesForEndpoint(this.relation.getSourceConnection());
            }
        }
        if (containerObject instanceof Entity && (containerObjectEvent.isType(5) || containerObjectEvent.isType(4)) && ((Entity)containerObject).getKeySet().size() == 1) {
            this.makeAttributesForEndpoints();
        }
    }

    private void removeFKAttributesForEndPoints(List list) {
        Attribute[] attributeArray = list.toArray(new Attribute[0]);
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeArray[i].setTemporaryWriteable(true);
            attributeArray[i].remove();
            attributeArray[i].setDelegate(null);
            attributeArray[i].setTemporaryWriteable(false);
        }
        list.clear();
    }

    private void removeFKAttributesForEndPoints(List list, KeyObject keyObject) {
        Attribute[] attributeArray = list.toArray(new Attribute[0]);
        for (int i = 0; i < attributeArray.length; ++i) {
            Attribute attribute = attributeArray[i];
            if (attribute.getDelegate() != null && keyObject.contains(attribute.getDelegate())) continue;
            attribute.setTemporaryWriteable(true);
            attribute.remove();
            attribute.setDelegate(null);
            attribute.setTemporaryWriteable(false);
        }
        list.clear();
    }

    private boolean isValid() {
        return this.relation != null && this.relation.isValid();
    }

    private boolean isInvalid() {
        return !this.isValid();
    }

    private Design getDesign() {
        return this.relation.getDesignPart().getDesign();
    }

    private void makeAttributesForEndpoints() {
        this.makeAttributesForEndpoint(this.relation.getSourceConnection());
        if (!this.relation.isSelfRefrence()) {
            this.makeAttributesForEndpoint(this.relation.getTargetConnection());
        }
    }

    public void reSync() {
        if (CAN_SYNCHRONIZE && this.needSync) {
            this.makeAttributesForEndpoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAttributesForEndpoint(Relation.Connection connection) {
        if (!CAN_SYNCHRONIZE) {
            this.needSync = true;
            return;
        }
        boolean bl = this.getDesign().getAppView().getSettings().isUseFirstUniqueForIdentifyingRelation();
        if (this.isInvalid()) {
            return;
        }
        Entity entity = connection.getOtherEntity();
        KeyObject keyObject = entity.getHierarchicalPK();
        Entity entity2 = connection.getEntity();
        Relation relation = connection.getRelation();
        if (keyObject == null) {
            keyObject = entity.getPKorUnique();
        }
        boolean bl2 = false;
        int[] nArray = relation.getPKProviderEndPoint();
        for (int i = 0; i < nArray.length; ++i) {
            if (relation.getEntity(nArray[i]) != entity) continue;
            bl2 = true;
        }
        List list = this.getFKSetFor(connection);
        ArrayList arrayList = new ArrayList(list);
        if (bl2 && !connection.getRelation().getIsBeingRemoved() && keyObject != null && (connection.isOneCardinality() && !connection.getOtherConnection().isOneCardinality() || connection.getOtherConnection().isOneCardinality() && (relation.getDominantRole() == relation.getNONEEntity() || connection.isOneCardinality() && entity == relation.getDominantRole() || relation.isIdentifying() && !connection.isOneCardinality()))) {
            KeyObject keyObject2;
            Attribute[] attributeArray = (Attribute[])keyObject.getElements();
            this.reuseCreateOrRemoveFKAttributes(attributeArray, list, connection);
            Attribute[] attributeArray2 = list.toArray(new Attribute[0]);
            list.clear();
            block4: for (int i = 0; i < attributeArray.length; ++i) {
                for (int j = 0; j < attributeArray2.length; ++j) {
                    if (attributeArray2[j].getDelegate() == null || !attributeArray2[j].getDelegate().equals(attributeArray[i])) continue;
                    list.add(attributeArray2[j]);
                    continue block4;
                }
            }
            if (connection.getRelation().isIdentifying()) {
                if (!connection.getEntity().hasPK()) {
                    try {
                        connection.getEntity().removeObjectListener(this);
                        KeyObject keyObject3 = null;
                        if (bl) {
                            keyObject3 = connection.getEntity().getPKorUnique();
                        }
                        if (keyObject3 == null) {
                            keyObject3 = connection.getEntity().createCandidateKey();
                            keyObject3.setName(ApplyAttributesNamingStandards.createPrimaryIdentifierName(connection.getEntity().getName(), this.getDesign().getDLSettings().getNamingStandardRule()));
                        }
                        keyObject3.setPK(true);
                    }
                    finally {
                        connection.getEntity().addObjectListener(this);
                    }
                }
                if (!this.getDesign().isLoading()) {
                    Entity entity3 = connection.getEntity();
                    CandidateKey candidateKey = (CandidateKey)entity3.getPK();
                    candidateKey.addElement(this.relation);
                    candidateKey.setDirty(true);
                }
            } else {
                Entity entity4 = connection.getEntity();
                CandidateKey candidateKey = (CandidateKey)entity4.getPK();
                if (candidateKey != null) {
                    candidateKey.removeElement(this.relation);
                    if (!this.getDesign().isLoading()) {
                        candidateKey.setDirty(true);
                    }
                }
            }
            if ((keyObject2 = this.getPkListeneningTo(connection.getOtherConnection())) != null) {
                keyObject2.removeObjectListener(this);
                keyObject2.removeContainerListener(this);
            }
            keyObject.addObjectListener(this);
            keyObject.addContainerListener(this);
            this.setPkListeneningTo(connection.getOtherConnection(), keyObject);
        } else {
            KeyObject keyObject4 = this.getPkListeneningTo(connection.getOtherConnection());
            if (keyObject4 != null) {
                keyObject4.removeObjectListener(this);
                keyObject4.removeContainerListener(this);
            }
            if (!connection.getEntity().isBST()) {
                Attribute[] attributeArray = list.toArray(new Attribute[0]);
                for (int i = 0; i < attributeArray.length; ++i) {
                    attributeArray[i].setTemporaryWriteable(true);
                    attributeArray[i].remove();
                    attributeArray[i].setDelegate(null);
                    attributeArray[i].setTemporaryWriteable(false);
                }
                list.clear();
            }
        }
        if (!((Object)arrayList).equals(list)) {
            this.relation.fireFK_AttributesChanged();
        }
    }

    private KeyObject getPkListeneningTo(Relation.Connection connection) {
        return connection.isSource() ? this.sourcePk : this.targetPk;
    }

    private void setPkListeneningTo(Relation.Connection connection, KeyObject keyObject) {
        if (connection.isSource()) {
            this.sourcePk = keyObject;
        } else {
            this.targetPk = keyObject;
        }
    }

    private void reuseCreateOrRemoveFKAttributes(Attribute[] attributeArray, List list, Relation.Connection connection) {
        Object object;
        int n;
        int n2;
        List<Attribute> list2;
        Object object2;
        Entity entity = connection.getEntity();
        Entity entity2 = connection.getOtherEntity();
        if (entity.isBST() || entity2.isBST() && attributeArray[0].isOid()) {
            if (entity.isBST()) {
                if (entity2.isBST()) {
                    object2 = entity.getExactRefToStructurtedType(entity2.getBasedOnStructuredType(), entity2);
                    if (object2 == null) {
                        object2 = entity.getRefToStructurtedType(entity2.getBasedOnStructuredType(), entity2);
                    }
                    if (object2 != null) {
                        this.replaceRefWithFKAttribute((Attribute)object2, connection);
                    }
                } else {
                    this.matchPKtoFKattributes(entity, entity2, connection);
                }
            } else if (entity2.isBST()) {
                object2 = entity.getExactRefToStructurtedType(entity2.getBasedOnStructuredType(), entity2);
                if (object2 == null) {
                    object2 = entity.getRefToStructurtedType(entity2.getBasedOnStructuredType(), entity2);
                }
                if (object2 == null) {
                    this.createRefToStructuredType(entity2.getBasedOnStructuredType(), connection);
                } else {
                    this.replaceRefWithFKAttribute((Attribute)object2, connection);
                }
                list2 = connection.getEntity().getAllElementsListGeneratedBy(this.relation);
                list.clear();
                list.addAll(list2);
            }
        } else {
            object2 = connection.getEntity().getAllElementsListGeneratedBy(this.relation);
            object2 = this.replacePlainWithFKAttributes(connection, (List)object2);
            list.clear();
            list.addAll(object2);
        }
        object2 = list.toArray(new Attribute[0]);
        list2 = new ArrayList();
        for (n2 = 0; n2 < ((Attribute[])object2).length; ++n2) {
            n = 0;
            for (int i = 0; i < attributeArray.length; ++i) {
                if (object2[n2].getDelegate() == null || !object2[n2].getDelegate().equals(attributeArray[i])) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                Attribute attribute = object2[n2];
                object = new ArrayList();
                object.addAll(this.getDesign().getExtendedMap().getOrCreateCollector(attribute).getAllMappings());
                list.remove(attribute);
                attribute.remove();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    XtdMapping xtdMapping = (XtdMapping)iterator.next();
                    if (!xtdMapping.isDeleted()) continue;
                    this.getDesign().getExtendedMap().removeMapping(xtdMapping);
                }
                continue;
            }
            list2.add(object2[n2]);
            n = 0;
        }
        object2 = list2.toArray(new Attribute[0]);
        if (((Attribute[])object2).length < attributeArray.length) {
            for (n2 = 0; n2 < attributeArray.length; ++n2) {
                n = 0;
                for (int i = 0; i < ((Attribute[])object2).length; ++i) {
                    if (object2[i].getDelegate() == null || !object2[i].getDelegate().equals(attributeArray[n2])) continue;
                    n = 1;
                    break;
                }
                if (n != 0 || attributeArray[n2].isFKAttribute() && attributeArray[n2].getDelegate() != null && attributeArray[n2].getDelegate().getContainer() == entity) continue;
                this.createAttribute(connection, attributeArray[n2]);
            }
        }
        list2 = connection.getEntity().getAllElementsListGeneratedBy(this.relation);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < attributeArray.length; ++n) {
            boolean bl = false;
            object = null;
            for (int i = 0; i < list2.size(); ++i) {
                object = (Attribute)list2.get(i);
                if (((Attribute)object).getDelegate() == null || ((Attribute)object).getDelegate() != attributeArray[n]) continue;
                bl = true;
                break;
            }
            if (!bl || object == null) continue;
            arrayList.add(object);
        }
        list.clear();
        list.addAll(arrayList);
    }

    private void matchPKtoFKattributes(Entity entity, Entity entity2, Relation.Connection connection) {
        KeyObject keyObject = entity2.getPK();
        if (keyObject != null) {
            Object object2;
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            for (Object object2 : keyObject.getElementsCollection()) {
                Attribute attribute = entity.findBestMatchForFKattr((Attribute)object2, arrayList);
                if (attribute == null) {
                    return;
                }
                arrayList.add(attribute);
            }
            object2 = keyObject.getElements();
            if (arrayList.size() == ((ContainedObject[])object2).length) {
                this.fkSort.clear();
                for (int i = 0; i < ((ContainedObject[])object2).length; ++i) {
                    Attribute attribute = (Attribute)object2[i];
                    Attribute attribute2 = (Attribute)arrayList.get(i);
                    attribute2.setReferedAttribute(attribute.getObjectID());
                    this.replacePlaneWithFKAttribute(attribute2, connection);
                }
            }
        }
    }

    private void replaceRefWithFKAttribute(Attribute attribute, Relation.Connection connection) {
        Attribute attribute2;
        Entity entity = connection.getOtherEntity();
        Attribute attribute3 = null;
        String string = attribute.getReferedAttribute();
        if (string == null && entity.isBST()) {
            Attribute attribute4 = (Attribute)entity.getOidElement();
            if (attribute4 != null) {
                string = attribute4.getObjectID();
                attribute3 = attribute4;
            }
        } else if (string != null && entity.isBST() && (attribute2 = (Attribute)entity.getOidElement()) != null) {
            string = attribute2.getObjectID();
            attribute3 = attribute2;
        }
        attribute.setTemporaryWriteable(true);
        if (string != null) {
            attribute.setReferedAttribute(string);
        }
        if (attribute3 != null) {
            attribute.setDelegate(attribute3);
        }
        attribute.setConnection(connection);
        attribute.setScopeId(entity.getObjectID());
        attribute.setTemporaryWriteable(false);
    }

    private void replacePlaneWithFKAttribute(Attribute attribute, Relation.Connection connection) {
        DesignObject designObject;
        Entity entity = connection.getOtherEntity();
        DesignObject designObject2 = null;
        String string = attribute.getReferedAttribute();
        if (string == null && entity.isBST() && (designObject = (Attribute)entity.getOidElement()) != null) {
            string = designObject.getObjectID();
            designObject2 = designObject;
        }
        if (string != null && (designObject = attribute.getDesign().getDesignObject(string)) instanceof Attribute) {
            designObject2 = (Attribute)designObject;
        }
        attribute.setTemporaryWriteable(true);
        if (string != null) {
            attribute.setReferedAttribute(string);
        }
        if (designObject2 != null) {
            attribute.setDelegate((Attribute)designObject2);
        }
        attribute.setConnection(connection);
        attribute.setTemporaryWriteable(false);
    }

    private Attribute createRefToStructuredType(StructuredType structuredType, Relation.Connection connection) {
        Entity entity = connection.getEntity();
        Entity entity2 = connection.getOtherEntity();
        Attribute attribute = (Attribute)entity2.getOidElement();
        if (attribute == null || !entity2.isBST()) {
            return null;
        }
        String string = (String)entity.getReferIDMap().get(attribute.getObjectID());
        Attribute attribute2 = this.createAttribute(entity.getDesignPart(), connection, attribute, attribute.getDesign(), string, attribute);
        attribute2.setTemporaryWriteable(true);
        attribute2.setScopeId(entity2.getObjectID());
        attribute2.setGeneratorID(connection.getRelation().getObjectID());
        attribute2.setUse((short)3);
        attribute2.setStructuredType(structuredType);
        attribute2.setReference(true);
        if (attribute != null && entity2.isBST() && structuredType.isParentOf(entity2.getBasedOnStructuredType())) {
            attribute2.setReferedAttribute(attribute.getObjectID());
        }
        String string2 = structuredType.getName().substring(0, 1).toLowerCase() + structuredType.getName().substring(1);
        attribute2.setName(string2);
        attribute2.setTemporaryWriteable(false);
        return attribute2;
    }

    private Attribute createAttribute(Relation.Connection connection, Attribute attribute) {
        Entity entity = connection.getEntity();
        Entity entity2 = connection.getOtherEntity();
        String string = (String)entity.getReferIDMap().get(attribute.getObjectID());
        Attribute attribute2 = this.createAttribute(entity.getDesignPart(), connection, attribute, attribute.getDesign(), string, attribute);
        attribute2.setTemporaryWriteable(true);
        attribute2.setScopeId(attribute.getScopeId());
        attribute2.setAllowSubtypeSubstitution(attribute.isAllowSubtypeSubstitution());
        attribute2.setReferedAttribute(attribute.getObjectID());
        Settings settings = this.getDesign().getAppView().getSettings();
        Design.DLSettings dLSettings = this.getDesign().getDLSettings();
        if (!settings.isKeepFKNamesSynchronized()) {
            attribute2.setName(ApplyAttributesNamingStandards.createRelationAttributeName(entity2, attribute, dLSettings.getNamingStandardRule()));
        } else {
            attribute2.setName(attribute.getName());
        }
        attribute2.setTemporaryWriteable(false);
        return attribute2;
    }

    private Attribute createAttribute(DesignPart designPart, Relation.Connection connection, Attribute attribute, Design design, String string, Attribute attribute2) {
        Attribute attribute3 = new Attribute(designPart);
        attribute3.setContainer(connection.getEntity());
        attribute3.setTemporaryWriteable(true);
        attribute3.setConnectionIfNull(connection);
        attribute3.setDesign(design);
        attribute3.setDelegate(attribute2);
        attribute3.setComment(attribute.getComment());
        attribute3.setUse(attribute.getUse());
        attribute3.setStructuredType(attribute.getStructuredType());
        attribute3.setStructAttributeID(attribute.getStructAttributeID());
        attribute3.setRestrictedTypeSubstitution(attribute.isRestrictedTypeSubstitution());
        attribute3.setScopeId(attribute.getScopeId());
        attribute3.setAllowSubtypeSubstitution(attribute.isAllowSubtypeSubstitution());
        attribute3.setDomain(attribute.getDomain());
        attribute3.setLogicalDatatype(attribute.getLogicalDatatype());
        attribute3.copyParametersFrom(attribute);
        attribute3.setDistinctType(attribute.getDistinctType());
        connection.getEntity().add(attribute3);
        if (!design.getLogicalDesign().getAttributeSet().add(attribute3)) {
            LOGGER.error("FKAttributeManager: can not add FKAttribute to AttributeSet. FKAttributeManager.createAttribute");
        }
        this.relation.getDesign().getLogicalDesign().getAttributeSet().add(attribute3);
        this.getFKSetFor(connection).add(attribute3);
        attribute3.setGeneratorID(this.relation.getObjectID());
        attribute3.setTemporaryWriteable(false);
        return attribute3;
    }

    private List getFKSetFor(Relation.Connection connection) {
        return connection.isSource() ? this.sourceAttributes : this.targetAttributes;
    }

    public List replacePlainWithFKAttributes(Relation.Connection connection, List list) {
        Attribute[] attributeArray = list.toArray(ATTRIBUTE_ARRAY_PROTOTYPE);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        this.fkSort.clear();
        for (int i = 0; i < attributeArray.length; ++i) {
            Attribute attribute = attributeArray[i];
            if (!attribute.isFKAttribute()) {
                DesignObject designObject;
                Entity entity = connection.getOtherEntity();
                Attribute attribute2 = null;
                String string = attribute.getReferedAttribute();
                if (string == null && entity.isBST() && (designObject = (Attribute)entity.getOidElement()) != null) {
                    string = designObject.getObjectID();
                    attribute2 = designObject;
                }
                attribute.setTemporaryWriteable(true);
                if (string != null) {
                    attribute.setReferedAttribute(string);
                    designObject = attribute.getDesign().getDesignObject(string);
                    if (designObject instanceof Attribute) {
                        attribute2 = designObject;
                    }
                }
                if (attribute2 != attribute && attribute2 != null) {
                    attribute.setDelegate(attribute2);
                } else if (attribute2 != null && attribute2 == attribute) {
                    attribute.setReferedAttribute(null);
                    designObject = attribute.getEngColumn(this.getDesign().getRelationalDesign());
                    attribute.setGeneratorID("");
                    attribute = this.createAttribute(connection, attribute2);
                    if (designObject != null) {
                        // empty if block
                    }
                    list.add(i, attribute);
                }
                attribute.setConnection(connection);
                attribute.setTemporaryWriteable(false);
            }
            arrayList.add(attribute);
        }
        return arrayList;
    }

    public Attribute[] getFKAttributes(int n) {
        List list = null;
        if (n == 0) {
            list = this.sourceAttributes;
        } else if (n == 1) {
            list = this.targetAttributes;
        } else {
            throw new IllegalArgumentException("endPoint marker is not Relation.SOURCE or Relation.TARGET, was: " + n);
        }
        return list.toArray(ATTRIBUTE_ARRAY_PROTOTYPE);
    }

    public boolean hasFKAttributesInPK(int n) {
        Attribute[] attributeArray = this.getFKAttributes(n);
        for (int i = 0; i < attributeArray.length; ++i) {
            if (!attributeArray[i].isPKElement()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimaryForeignKey(int n) {
        return this.hasFKAttributesInPK(n);
    }

    protected void removeAllFKAttributes() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.sourceAttributes);
        hashSet.addAll(this.targetAttributes);
        Attribute[] attributeArray = hashSet.toArray(new Attribute[0]);
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getContainerWithKeyObject() != null && !attributeArray[i].getContainerWithKeyObject().isBST()) {
                attributeArray[i].remove();
                continue;
            }
            attributeArray[i].setConnection(null);
        }
    }

    public void removeFromListeners() {
        CandidateKey candidateKey;
        Entity entity = this.relation.getSourceEntity();
        if (entity != null) {
            candidateKey = (CandidateKey)entity.getPKorUnique();
            if (candidateKey != null) {
                candidateKey.getNewElementsCollection().remove(this.relation);
            }
            entity.removeObjectListener(this);
            entity.removeContainerListener(this);
        }
        if ((entity = this.relation.getTargetEntity()) != null) {
            candidateKey = (CandidateKey)entity.getPKorUnique();
            if (candidateKey != null) {
                candidateKey.getNewElementsCollection().remove(this.relation);
            }
            entity.removeObjectListener(this);
            entity.removeContainerListener(this);
        }
        if (this.sourcePk != null) {
            ((CandidateKey)this.sourcePk).getNewElementsCollection().remove(this.relation);
            this.sourcePk.removeObjectListener(this);
            this.sourcePk.removeContainerListener(this);
        }
        if (this.targetPk != null) {
            ((CandidateKey)this.targetPk).getNewElementsCollection().remove(this.relation);
            this.targetPk.removeObjectListener(this);
            this.targetPk.removeContainerListener(this);
        }
    }
}

