/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.AttributeViewSet;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.ViewAttributePlaceHolder;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.logical.EntityViewPropertiesDialogEx;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class EntityView
extends AbstractView
implements EditableFonts {
    public static final String TYPE_VIEW = "EntityView";
    public static final String TYPE_NAMED_QUERY = "NAMED QUERY";
    public static final String[] VIEW_TYPES = new String[]{"EntityView", "NAMED QUERY"};
    private String viewType = "EntityView";
    private List editableFonts;

    public EntityView(DesignPart designPart) {
        super(designPart);
        this.initEditableFonts();
    }

    @Override
    public String getIDPrefix() {
        return MDPreferences.getDefaultInstance().get("entityview id prefix");
    }

    @Override
    public Class getContainedClass() {
        return AttributeView.class;
    }

    public DesignObjectSet getEntitySet() {
        return ((LogicalDesign)this.getDesignPart()).getEntitySet();
    }

    public AttributeViewSet getAttributeViewSet() {
        return ((LogicalDesign)this.getDesignPart()).getAttributeViewSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getAttributeViewSet();
    }

    @Override
    public ContainedObject createContainedObject(String string) {
        AttributeView attributeView = new AttributeView(this.getDesignPart());
        attributeView.setDesign(this.getDesign());
        attributeView.setContainer(this);
        if (string != null) {
            attributeView.setObjectID(string);
        }
        attributeView.setDesignObjectSet(this.getAttributeViewSet());
        this.add(attributeView);
        this.getAttributeViewSet().add(attributeView);
        if (string != null) {
            attributeView.setObjectID(string);
        }
        return attributeView;
    }

    @Override
    public void add(ContainedObject containedObject) {
        if (!this.exists(containedObject)) {
            if (containedObject instanceof AttributeView) {
                if (containedObject.getObjectID() == null) {
                    this.assignLocalID(containedObject);
                }
                containedObject.setDesign(this.getDesign());
                this.getAttributeViewSet().add(containedObject);
                this.phelements.add(new ViewAttributePlaceHolder(this.getDesignPart(), containedObject));
                super.add(containedObject);
                if (((AttributeView)containedObject).getReferencedAttribute() != null) {
                    ((AttributeView)containedObject).getReferencedAttribute().addObjectListener(this);
                }
                if (((AttributeView)containedObject).getView() != null && ((AttributeView)containedObject).getView() != this) {
                    ContainedObject[] containedObjectArray = ((AttributeView)containedObject).getView().getElements();
                    for (int i = 0; i < containedObjectArray.length; ++i) {
                        if (((AttributeView)containedObjectArray[i]).getReferencedAttribute() != ((AttributeView)containedObject).getReferencedAttribute()) continue;
                        ((AttributeView)containedObjectArray[i]).addObjectListener(this);
                    }
                }
            } else {
                AttributeView attributeView = new AttributeView(this.getDesignPart());
                attributeView.setObjectID(this.getDesign().getAppView().getIDGenerator().createNewID());
                attributeView.setName(containedObject.getName());
                attributeView.setDesign(this.getDesign());
                attributeView.setReferencedAttribute((Attribute)containedObject);
                attributeView.setDataType(((Attribute)containedObject).getDataType().toString());
                attributeView.setContainer(this);
                attributeView.setEntity((Entity)containedObject.getContainer());
                this.getAttributeViewSet().add(attributeView);
                this.phelements.add(new ViewAttributePlaceHolder(this.getDesignPart(), attributeView));
                super.add(attributeView);
                if (attributeView.getView() != this) {
                    attributeView.addObjectListener(this);
                }
                containedObject.addObjectListener(this);
            }
        }
    }

    public AttributeView attributeViewAdd(ContainedObject containedObject) {
        if (!this.exists(containedObject)) {
            if (containedObject instanceof AttributeView) {
                if (containedObject.getObjectID() == null) {
                    this.assignLocalID(containedObject);
                }
                containedObject.setDesign(this.getDesign());
                this.getAttributeViewSet().add(containedObject);
                this.phelements.add(new ViewAttributePlaceHolder(this.getDesignPart(), containedObject));
                super.add(containedObject);
                if (((AttributeView)containedObject).getReferencedAttribute() != null) {
                    ((AttributeView)containedObject).getReferencedAttribute().addObjectListener(this);
                }
                if (((AttributeView)containedObject).getView() != null && ((AttributeView)containedObject).getView() != this) {
                    ContainedObject[] containedObjectArray = ((AttributeView)containedObject).getView().getElements();
                    for (int i = 0; i < containedObjectArray.length; ++i) {
                        if (((AttributeView)containedObjectArray[i]).getReferencedAttribute() != ((AttributeView)containedObject).getReferencedAttribute()) continue;
                        ((AttributeView)containedObjectArray[i]).addObjectListener(this);
                    }
                }
                return (AttributeView)containedObject;
            }
            AttributeView attributeView = new AttributeView(this.getDesignPart());
            attributeView.setName(containedObject.getName());
            attributeView.setDesign(this.getDesign());
            attributeView.setReferencedAttribute((Attribute)containedObject);
            attributeView.setDataType(((Attribute)containedObject).getDataType().toString());
            this.getAttributeViewSet().add(attributeView);
            attributeView.setContainer(this);
            attributeView.setEntity((Entity)containedObject.getContainer());
            this.phelements.add(new ViewAttributePlaceHolder(this.getDesignPart(), attributeView));
            super.add(attributeView);
            if (attributeView.getView() != this) {
                attributeView.addObjectListener(this);
            }
            containedObject.addObjectListener(this);
            return attributeView;
        }
        return null;
    }

    private boolean exists(ContainedObject containedObject) {
        if (containedObject instanceof AttributeView) {
            return this.getElementsCollection().contains(containedObject);
        }
        for (AttributeView attributeView : this.getElementsCollection()) {
            if (containedObject != attributeView.getReferencedAttribute()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove(ContainedObject containedObject) {
        this.phelements.removePlaceHolderFor(containedObject);
        this.removeFromOrderBy(containedObject);
        super.remove(containedObject);
        this.getAttributeViewSet().remove(containedObject);
    }

    @Override
    public void addToOrderBy(ContainedObject containedObject, String string) {
        if (containedObject.getObjectID() == null) {
            this.assignLocalID(containedObject);
        }
        containedObject.setContainer(this);
        this.getAttributeViewSet().add(containedObject);
        this.orderByMap.put(containedObject.getObjectID(), string);
        this.orderByList.add(containedObject);
        if (((AttributeView)containedObject).getReferencedAttribute() != null) {
            ((AttributeView)containedObject).getReferencedAttribute().addObjectListener(this);
        }
    }

    public AttributeView getAttributeByObjectID(String string) {
        for (AttributeView attributeView : this.getElementsCollection()) {
            if (!attributeView.getObjectID().equals(string)) continue;
            return attributeView;
        }
        return null;
    }

    @Override
    public void addToContainers(ContainerObject containerObject, String string) {
        this.containerMap.put(string, containerObject.getObjectID());
        if (containerObject instanceof Entity) {
            if (!this.tables.contains(containerObject)) {
                this.tables.add(containerObject);
            }
        } else if (containerObject instanceof EntityView && !this.views.contains(containerObject)) {
            this.views.add(containerObject);
        }
        this.usedContainers.add(new AbstractView.ContainerHolder(containerObject, string));
    }

    @Override
    public void addToContainers(String string, String string2) {
        this.containerMap.put(string2, string);
        ContainerObject containerObject = (ContainerObject)this.getEntitySet().getObjectByID(string);
        if (containerObject != null) {
            if (!this.tables.contains(containerObject)) {
                this.tables.add(containerObject);
            }
            this.usedContainers.add(new AbstractView.ContainerHolder(containerObject, string2));
            this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(string, string2));
        } else {
            EntityView entityView = (EntityView)((LogicalDesign)this.getDesignPart()).getEntityViewSet().getObjectByID(string);
            if (entityView != null) {
                if (!this.views.contains(entityView)) {
                    this.views.add(entityView);
                }
                this.usedContainers.add(new AbstractView.ContainerHolder(entityView, string2));
                this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(string, string2));
            } else {
                this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(string, string2));
            }
        }
    }

    public AttributeView getAttributeViewByName(String string) {
        for (AttributeView attributeView : this.getElementsCollection()) {
            if (!attributeView.getName().equalsIgnoreCase(string)) continue;
            return attributeView;
        }
        return null;
    }

    public AttributeView getAttributeViewByLongName(String string) {
        for (AttributeView attributeView : this.getElementsCollection()) {
            if (!attributeView.getLongName().equalsIgnoreCase(string)) continue;
            return attributeView;
        }
        return null;
    }

    @Override
    public void clearContainers() {
        this.containerMap.clear();
        this.tables.clear();
        this.views.clear();
        this.usedContainers.clear();
    }

    @Override
    public void clear(ContainerObject containerObject) {
        this.tables.remove(containerObject);
        this.views.remove(containerObject);
        Object[] objectArray = this.containerMap.keySet().toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            String string = (String)objectArray[i];
            String string2 = (String)this.containerMap.get(string);
            if (!containerObject.getObjectID().equalsIgnoreCase(string2)) continue;
            this.containerMap.remove(string);
        }
        if (containerObject != this) {
            this.clearElements(containerObject);
        }
        this.clearOrderByElements(containerObject);
        AbstractView.ContainerHolder containerHolder = this.getContainerHolderFor(containerObject);
        if (containerHolder != null) {
            this.usedContainers.remove(containerHolder);
        }
    }

    public void clear(AttributeView attributeView) {
        if (attributeView.getContainer() == this) {
            Iterator iterator = ((LogicalDesign)this.getDesignPart()).getEntityViewSet().iterator();
            while (iterator.hasNext()) {
                EntityView entityView = (EntityView)iterator.next();
                if (entityView == this) continue;
                if (this.getElementsCollection().contains(attributeView)) {
                    entityView.remove(attributeView);
                }
                entityView.removeFromOrderBy(attributeView);
            }
        }
    }

    @Override
    public void clearElements(ContainerObject containerObject) {
        block5: {
            block4: {
                if (!(containerObject instanceof EntityView)) break block4;
                ContainedObject[] containedObjectArray = containerObject.getElements();
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    if (!this.getElementsCollection().contains(containedObjectArray[i])) continue;
                    this.remove(containedObjectArray[i]);
                }
                break block5;
            }
            if (!(containerObject instanceof Entity)) break block5;
            ArrayList<AttributeView> arrayList = new ArrayList<AttributeView>();
            Iterator iterator = this.getElementsCollection().iterator();
            ContainedObject[] containedObjectArray = containerObject.getElements();
            block1: while (iterator.hasNext()) {
                AttributeView attributeView = (AttributeView)iterator.next();
                if (attributeView.getReferencedAttribute() == null) continue;
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    if (attributeView.getReferencedAttribute() != containedObjectArray[i]) continue;
                    arrayList.add(attributeView);
                    continue block1;
                }
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.remove((AttributeView)iterator.next());
            }
        }
    }

    @Override
    public void clearOrderByElements(ContainerObject containerObject) {
        block7: {
            block6: {
                Object object2;
                if (!(containerObject instanceof EntityView)) break block6;
                ArrayList<AttributeView> arrayList = new ArrayList<AttributeView>();
                for (Object object2 : containerObject.getElementsCollection()) {
                    for (AttributeView attributeView : this.orderByList) {
                        if (((AttributeView)object2).getReferencedAttribute() != attributeView.getReferencedAttribute()) continue;
                        arrayList.add(attributeView);
                    }
                }
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    this.removeFromOrderBy((AttributeView)object2.next());
                }
                break block7;
            }
            if (!(containerObject instanceof Entity)) break block7;
            ArrayList<AttributeView> arrayList = new ArrayList<AttributeView>();
            block3: for (AttributeView attributeView : this.orderByList) {
                if (attributeView.getReferencedAttribute() == null) continue;
                for (Attribute attribute : containerObject.getElementsCollection()) {
                    if (attributeView.getReferencedAttribute() != attribute) continue;
                    arrayList.add(attributeView);
                    continue block3;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.removeFromOrderBy((AttributeView)iterator.next());
            }
        }
    }

    @Override
    public void remove() {
        AttributeView attributeView;
        Object object2;
        Iterator iterator = ((LogicalDesign)this.getDesignPart()).getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            object2 = (EntityView)iterator.next();
            ((EntityView)object2).clear(this);
        }
        for (Object object2 : this.getElementsCollection()) {
            this.getAttributeViewSet().remove((DesignObject)object2);
        }
        object2 = new ArrayList();
        iterator = this.getAttributeViewSet().iterator();
        while (iterator.hasNext()) {
            attributeView = (AttributeView)iterator.next();
            if (attributeView.getView() != this) continue;
            ((ArrayList)object2).add(attributeView);
        }
        iterator = ((ArrayList)object2).iterator();
        while (iterator.hasNext()) {
            attributeView = (AttributeView)iterator.next();
            this.getAttributeViewSet().remove(attributeView);
            attributeView.getContainer().remove(attributeView);
        }
        super.remove();
        SetEvent.OBJECT_REMOVED.setAffected(this);
        ((LogicalDesign)this.getDesignPart()).getEntityViewSet().fireChange(SetEvent.OBJECT_REMOVED);
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (designObjectSet instanceof StructuredTypeSet) {
            super.changed(designObjectSet, setEvent);
            return;
        }
        if (SetEvent.OBJECT_REMOVED.equals(setEvent) && setEvent.getAffected() instanceof ContainerObject) {
            ((ContainerObject)setEvent.getAffected()).removeContainerListener(this);
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        boolean bl = false;
        if (!ApplicationView.loading && (objectChangeEvent.isType(ObjectChangeEvent.OBJECT_REMOVED) || objectChangeEvent.isType(ObjectChangeEvent.NAME_CHANGED) || objectChangeEvent.isType(ObjectChangeEvent.SCHEMA_CHANGED))) {
            if (this.sqlNameExists(designObject.getObjectID())) {
                bl = true;
            }
            if (!bl) {
                if (designObject instanceof ContainerObject) {
                    if (this.sqlNameExists(designObject.getObjectID())) {
                        bl = true;
                    }
                } else if (designObject instanceof Attribute) {
                    for (AttributeView attributeView : this.getElementsCollection()) {
                        if (attributeView.getReferencedColumn() == null || attributeView.getReferencedColumn() != designObject) continue;
                        bl = true;
                        break;
                    }
                } else if (designObject instanceof AttributeView) {
                    for (AttributeView attributeView : this.getElementsCollection()) {
                        if (attributeView != designObject && attributeView.getReferencedColumnView() != designObject) continue;
                        bl = true;
                        break;
                    }
                }
            }
            if (bl) {
                this.setValidSQL(!this.isSQLNamesChanged());
                if (!this.isValidSQL()) {
                    this.invalidateLinkedViews();
                }
            }
        }
    }

    protected void invalidateLinkedViews() {
        Iterator iterator = ((LogicalDesign)this.getDesignPart()).getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            EntityView entityView = (EntityView)iterator.next();
            if (entityView == null || !entityView.isValidSQL() || !entityView.sqlNameExists(this.getObjectID())) continue;
            entityView.setValidSQL(false);
            entityView.invalidateLinkedViews();
        }
    }

    @Override
    public void copy(DesignObject designObject) {
        Object object3;
        EntityView entityView = (EntityView)designObject;
        super.copy(entityView);
        entityView.setWhere(this.getWhere());
        entityView.setGroupBy(this.getGroupBy());
        entityView.setHaving(this.getHaving());
        entityView.setUserDefined(this.getUserDefined());
        entityView.setUserDefinedSQL(this.getUserDefinedSQL(entityView.getName()));
        entityView.setBasedOnStructuredType(this.getBasedOnStructuredType());
        for (Object object2 : this.getContainerMap().keySet()) {
            object3 = this.getContainerID((String)object2);
            entityView.addToContainers((String)object3, (String)object2);
        }
        for (Object object3 : this.getOrderByMap().keySet()) {
            Object object2;
            object2 = (AttributeView)this.getObjectByID(this.orderByList, (String)object3);
            if (object2 != null) {
                AttributeView attributeView = new AttributeView(this.getDesignPart());
                ((AttributeView)object2).copy(attributeView);
                attributeView.setView(entityView);
                entityView.addToOrderBy(attributeView, (String)this.getOrderByMap().get(object3));
                continue;
            }
            System.out.println("EntityView.copy: Unable to find AttributeView: " + (String)object3);
        }
        for (int i = 0; i < this.getGroupByList().size(); ++i) {
            AttributeView attributeView;
            object3 = (AttributeView)this.getGroupByList().get(i);
            if (object3 == null || (attributeView = (AttributeView)entityView.getDesign().getCorrObject(((ModelIDObject)object3).getObjectID())) == null) continue;
            entityView.addGroupByList(attributeView);
        }
        if (!this.isBST()) {
            ContainedObject[] containedObjectArray = this.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                object3 = new AttributeView(this.getDesignPart());
                ((AttributeView)containedObjectArray[i]).copy((DesignObject)object3);
                ((AbstractViewElement)object3).setView(entityView);
                ((ContainedObject)object3).setContainer(entityView);
                entityView.add((ContainedObject)object3);
            }
        }
    }

    @Override
    public void importView(DesignObject designObject) {
        DesignObject designObject2;
        Attribute attribute;
        ContainedObject containedObject;
        DesignObject designObject3;
        Object object3;
        EntityView entityView = (EntityView)designObject;
        super.copy(entityView);
        entityView.setWhere(this.getWhere());
        entityView.setGroupBy(this.getGroupBy());
        entityView.setHaving(this.getHaving());
        entityView.setUserDefined(this.getUserDefined());
        entityView.setUserDefinedSQL(this.getUserDefinedSQL());
        entityView.setBasedOnStructuredType(this.getBasedOnStructuredType());
        for (Object object2 : this.getContainerMap().keySet()) {
            object3 = this.getContainerID((String)object2);
            designObject3 = entityView.getDesign().getCorrObject((String)object3);
            if (designObject3 == null) continue;
            entityView.addToContainers(designObject3.getObjectID(), (String)object2);
        }
        for (Object object3 : this.getOrderByMap().keySet()) {
            Object object2;
            object2 = (AttributeView)this.getObjectByID(this.orderByList, (String)object3);
            if (object2 != null) {
                designObject3 = new AttributeView(this.getDesignPart());
                containedObject = ((AttributeView)object2).getReferencedAttribute();
                if (containedObject != null && (attribute = (Attribute)entityView.getDesign().getCorrObject(containedObject.getObjectID())) != null) {
                    ((AttributeView)designObject3).setReferencedAttribute(attribute);
                }
                designObject3.setName(((ContainedObject)object2).getName());
                ((AbstractViewElement)designObject3).setDataType(((AbstractViewElement)object2).getDataType().toString());
                if (((AttributeView)object2).getEntity() != null && (designObject2 = (Entity)entityView.getDesign().getCorrObject(((AttributeView)object2).getEntity().getObjectID())) != null) {
                    ((AttributeView)designObject3).setEntity((Entity)designObject2);
                }
                ((AbstractViewElement)designObject3).setView(entityView);
                designObject3.setDesign(entityView.getDesign());
                entityView.addToOrderBy((ContainedObject)designObject3, (String)this.getOrderByMap().get(object3));
                designObject3.setImportedDesign(this.getDesign());
                designObject3.setImportedId(((ModelIDObject)object2).getObjectID());
                continue;
            }
            System.out.println("EntityView.copy: Unable to find AttributeView: " + (String)object3);
        }
        if (!this.isBST()) {
            for (int i = 0; i < this.getElements().length; ++i) {
                Entity entity;
                object3 = new AttributeView(this.getDesignPart());
                containedObject = (AttributeView)this.getElements()[i];
                attribute = ((AttributeView)containedObject).getReferencedAttribute();
                if (attribute != null && (designObject2 = (Attribute)entityView.getDesign().getCorrObject(attribute.getObjectID())) != null) {
                    ((AttributeView)object3).setReferencedAttribute((ContainedObjectWithDomain)designObject2);
                }
                ((DesignObject)object3).setName(containedObject.getName());
                ((AbstractViewElement)object3).setDataType(((AbstractViewElement)containedObject).getDataType().toString());
                if (((AttributeView)containedObject).getEntity() != null && (entity = (Entity)entityView.getDesign().getCorrObject(((AttributeView)containedObject).getEntity().getObjectID())) != null) {
                    ((AttributeView)object3).setEntity(entity);
                }
                ((AbstractViewElement)object3).setView(entityView);
                ((ModelObject)object3).setDesign(entityView.getDesign());
                ((ContainedObject)object3).setContainer(entityView);
                entityView.add((ContainedObject)object3);
                ((DesignObject)object3).setImportedDesign(this.getDesign());
                ((DesignObject)object3).setImportedId(containedObject.getObjectID());
            }
        }
        for (int i = 0; i < this.getGroupByList().size(); ++i) {
            object3 = (AttributeView)this.getGroupByList().get(i);
            if (object3 == null || (containedObject = (AttributeView)entityView.getDesign().getCorrObject(((ModelIDObject)object3).getObjectID())) == null) continue;
            entityView.addGroupByList(containedObject);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            EntityViewPropertiesDialogEx entityViewPropertiesDialogEx = new EntityViewPropertiesDialogEx(this.getDesign().getAppView(), this);
            entityViewPropertiesDialogEx.initProperties(this);
            entityViewPropertiesDialogEx.show();
        }
    }

    @Override
    public void updateElements(List list) {
        for (int i = 0; i < list.size(); ++i) {
            TypeElement typeElement = (TypeElement)list.get(i);
            AttributeView attributeView = (AttributeView)this.getElementByStructAttributeID(typeElement.getObjectID());
            if (attributeView == null) {
                attributeView = new AttributeView(this.getDesignPart());
                attributeView.setName(typeElement.getName());
                attributeView.setStructAttributeID(typeElement.getObjectID());
                this.addAttribute(attributeView);
            }
            this.copyTEToAttribute(typeElement, attributeView);
        }
    }

    private void copyTEToAttribute(TypeElement typeElement, AttributeView attributeView) {
        attributeView.setName(typeElement.getName());
        attributeView.setDataType(typeElement.getDataType());
        attributeView.setReference(typeElement.isReference());
        if (typeElement.getType() instanceof StructuredType) {
            attributeView.setStructuredType((StructuredType)typeElement.getType());
        } else {
            attributeView.setStructuredType(null);
        }
    }

    public void addAttribute(AttributeView attributeView) {
        attributeView.setDesign(this.getDesign());
        attributeView.setContainer(this);
        this.add(attributeView);
    }

    public List getRefColumns() {
        ArrayList<AttributeView> arrayList = new ArrayList<AttributeView>();
        if (this.isBST()) {
            ContainedObject[] containedObjectArray = this.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                AttributeView attributeView = (AttributeView)containedObjectArray[i];
                if (!attributeView.isReference()) continue;
                arrayList.add(attributeView);
            }
        }
        return arrayList;
    }

    public String getViewType() {
        return this.viewType;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_VIEW;
    }

    public void setViewType(String string) {
        this.viewType = string;
    }

    @Override
    public AbstractViewElement createViewElement(DesignPart designPart) {
        return new AttributeView(designPart);
    }

    @Override
    public DesignObjectSet getTableSet() {
        return this.getEntitySet();
    }

    public TableView getEngTableView(RelationalDesign relationalDesign) {
        RepositoryObject repositoryObject;
        TableView tableView;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
        if (list.size() > 0 && (tableView = (TableView)((XtdMapping)(repositoryObject = (XtdMapping)list.get(0))).getObjectMappedTo(this)) != null) {
            return tableView;
        }
        repositoryObject = (TableView)this.getGenerator();
        if (repositoryObject != null && ((DesignObject)repositoryObject).getDesignPart() == relationalDesign) {
            return repositoryObject;
        }
        repositoryObject = (TableView)relationalDesign.getTableViewSet().getObjectGeneratedBy(this.getObjectID());
        return repositoryObject;
    }

    public XtdMapping getDeletedMapping(String string) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, string);
        if (list.size() > 0) {
            XtdMapping xtdMapping = (XtdMapping)list.get(0);
            return xtdMapping;
        }
        return null;
    }

    public void updateDeletedMappings(String string, String string2, String string3) {
        for (ContainedObject containedObject : this.getElementsCollection()) {
            XtdMapping xtdMapping = containedObject.getDeletedMapping(string, string3);
            if (xtdMapping == null) continue;
            xtdMapping.setRecreatedContainerID(string2);
        }
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject("Logical View")) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject("Logical View")) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.resetAllTopViewsCustomFormat();
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
            this.setUseDefaultColor(true);
        } else if (DefaultFontAndColor.isModified("Logical View")) {
            DefaultFontAndColor defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject("Logical View");
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
            this.setUseDefaultColor(bl);
        }
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "view/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

