/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.GlobalCandidateKeySet;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public class EntitySet
extends DesignObjectSet {
    private static final Object[] PROTO = new Entity[0];
    private GlobalCandidateKeySet globalKeySet;

    public EntitySet(DesignPart designPart) {
        super(designPart);
        this.getGlobalCandidateKeySet();
        this.requireSort = true;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default entity name");
    }

    @Override
    public Object getParent() {
        return this.getDesign().getLogicalDesign();
    }

    @Override
    public void remove(DesignObject designObject) {
        designObject.setParent(null);
        super.remove(designObject);
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO;
    }

    public Entity createEntity(String string) {
        Entity entity = new Entity(this.getDesignPart());
        entity.setObjectID(string);
        entity.setDesign(this.getDesign());
        entity.setParent(this);
        entity.initIndexFilters();
        this.getDesign().addDesignObject(entity);
        this.add(entity);
        return entity;
    }

    public GlobalCandidateKeySet getGlobalCandidateKeySet() {
        if (this.globalKeySet == null) {
            this.globalKeySet = new GlobalCandidateKeySet(this);
            this.globalKeySet.setName(Messages.getString("EntitySet.CandidateKeys"));
            this.globalKeySet.addSetListener((LogicalDesign)this.getDesignPart());
        }
        return this.globalKeySet;
    }

    @Override
    public void removeAll() {
        Object[] objectArray = this.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            DesignObject designObject = (DesignObject)objectArray[i];
            designObject.remove();
        }
        super.removeAll();
    }
}

