/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeSet;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.GlobalIndexSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.editor.logical.KeyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.logical.TVRelation;

public class CandidateKey
extends KeyObject {
    private static Set keyStateSet = null;
    private String synonym = "";
    private List newElementsCollection = new ArrayList();

    public CandidateKey(DesignPart designPart) {
        super(designPart);
        this.unique = true;
    }

    @Override
    public String getObjectTypeName() {
        return "Candidate Key";
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("altkey id prefix");
    }

    protected AttributeSet getAttributeSet() {
        return this.getDesign().getLogicalDesign().getAttributeSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getAttributeSet();
    }

    private boolean checkKeyStateValue(String string) {
        if (keyStateSet == null) {
            keyStateSet = new HashSet();
            keyStateSet.addAll(Arrays.asList(KEY_STATES));
        }
        return keyStateSet.contains(string);
    }

    public void setKeyState(String string) {
        if (this.checkKeyStateValue(string)) {
            if ("Unique Key".equalsIgnoreCase(string)) {
                if (this.isPK()) {
                    this.setPK(false);
                }
                this.setColumnsState(true);
            } else if ("Primary Key".equalsIgnoreCase(string)) {
                this.setPK(true);
                if (this.getContainerWithKeyObject() != null) {
                    this.getContainerWithKeyObject().setPK(this);
                }
            }
        }
    }

    public String getKeyState() {
        return this.isPK() ? "Primary Key" : "Unique Key";
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String string) {
        if (!this.synonym.equals(string)) {
            this.synonym = string;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    @Override
    public boolean hasAliveGenerator() {
        ModelIDObject modelIDObject;
        GlobalIndexSet globalIndexSet = this.getDesign().getRelationalDesign().getGlobalIndexSet();
        return ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID()) || (modelIDObject = globalIndexSet.getObjectByID(this.getGeneratorID())) != null;
    }

    public Index getEngIndex(RelationalDesign relationalDesign) {
        RepositoryObject repositoryObject;
        Index index;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
        if (list.size() > 0 && (index = (Index)((XtdMapping)(repositoryObject = (XtdMapping)list.get(0))).getObjectMappedTo(this)) != null) {
            return index;
        }
        repositoryObject = (Index)this.getGenerator();
        if (repositoryObject != null && ((DesignObject)repositoryObject).getDesignPart() == relationalDesign) {
            return repositoryObject;
        }
        repositoryObject = (Index)relationalDesign.getGlobalIndexSet().getObjectGeneratedBy(this.getObjectID());
        return repositoryObject;
    }

    public Index getEngIndex(RelationalDesign relationalDesign, Table table) {
        RepositoryObject repositoryObject2;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
        for (RepositoryObject repositoryObject2 : list) {
            Index index = (Index)((XtdMapping)repositoryObject2).getObjectMappedTo(this);
            if (index == null || index.getContainerWithKeyObject() != table) continue;
            return index;
        }
        repositoryObject2 = (Index)this.getGenerator();
        if (repositoryObject2 != null && ((DesignObject)repositoryObject2).getDesignPart() == relationalDesign && ((KeyObject)repositoryObject2).getContainerWithKeyObject() == table) {
            return repositoryObject2;
        }
        repositoryObject2 = (Index)relationalDesign.getGlobalIndexSet().getObjectGeneratedBy(this.getObjectID());
        if (repositoryObject2 != null && ((KeyObject)repositoryObject2).getContainerWithKeyObject() == table) {
            return repositoryObject2;
        }
        return null;
    }

    public XtdMapping getMappingFor(Table table) {
        if (table != null) {
            RelationalDesign relationalDesign = (RelationalDesign)table.getDesignPart();
            List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
            for (XtdMapping xtdMapping : list) {
                Index index;
                DesignObject designObject = xtdMapping.getObjectMappedTo(this);
                if (!(designObject instanceof Index) || (index = (Index)designObject) == null || index.getContainerWithKeyObject() != table) continue;
                return xtdMapping;
            }
        }
        return null;
    }

    public List getMappingsFor(Table table) {
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        if (table != null) {
            RelationalDesign relationalDesign = (RelationalDesign)table.getDesignPart();
            List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
            for (XtdMapping xtdMapping : list) {
                Index index;
                DesignObject designObject = xtdMapping.getObjectMappedTo(this);
                if (!(designObject instanceof Index) || (index = (Index)designObject) == null || index.getContainerWithKeyObject() != table) continue;
                arrayList.add(xtdMapping);
            }
        }
        return arrayList;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            KeyPropertiesDialogEx keyPropertiesDialogEx = new KeyPropertiesDialogEx(this.getDesign().getAppView(), this);
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.getContainerObject().getElementsCollection());
            keyPropertiesDialogEx.setAttributesList(arrayList);
            keyPropertiesDialogEx.initProperties(this);
            keyPropertiesDialogEx.show();
        }
    }

    @Override
    protected void clearStructure() {
    }

    @Override
    protected void updateStructure() {
    }

    @Override
    public void clearElements() {
        super.clearElements();
        this.getNewElementsCollection().clear();
    }

    @Override
    public ContainedObject getElement(int n) {
        return super.getElement(n);
    }

    @Override
    public ContainedObject getElementByID(String string) {
        return super.getElementByID(string);
    }

    @Override
    public ContainedObject getElementByName(String string) {
        return super.getElementByName(string);
    }

    @Override
    public ContainedObject[] getElements() {
        return super.getElements();
    }

    @Override
    public Collection getElementsCollection() {
        return super.getElementsCollection();
    }

    @Override
    public Collection getElementsCollectionImmutable() {
        return super.getElementsCollectionImmutable();
    }

    public List getNewElementsCollection() {
        return this.newElementsCollection;
    }

    @Override
    public void add(ContainedObject containedObject) {
        if (!this.getNewElementsCollection().contains(containedObject)) {
            if (containedObject instanceof Attribute && ((Attribute)containedObject).isFKAttribute()) {
                Relation relation = (Relation)this.getDesign().getDesignObject(containedObject.getGeneratorID());
                if (relation != null && !this.getNewElementsCollection().contains(relation)) {
                    this.addElement(relation);
                }
            } else {
                this.getNewElementsCollection().add(containedObject);
            }
        }
        if (!this.getElementsCollection().contains(containedObject)) {
            super.add(containedObject);
        }
    }

    @Override
    public void remove(ContainedObject containedObject) {
        this.getNewElementsCollection().remove(containedObject);
        super.remove(containedObject);
    }

    public void addElement(DesignObject designObject) {
        block10: {
            block8: {
                int n;
                block9: {
                    if (this.getNewElementsCollection().contains(designObject)) break block8;
                    if (designObject instanceof Relation) break block9;
                    this.getNewElementsCollection().add(designObject);
                    break block10;
                }
                Relation relation = (Relation)designObject;
                boolean bl = false;
                Attribute[] attributeArray = relation.getFKAttributes((Entity)this.getContainerWithKeyObject());
                for (int i = 0; i < attributeArray.length; ++i) {
                    if (!this.getElementsCollection().contains(attributeArray[i])) {
                        super.add(attributeArray[i]);
                    }
                    if (!this.getNewElementsCollection().contains(attributeArray[i])) continue;
                    if (!bl) {
                        n = this.getNewElementsCollection().indexOf(attributeArray[i]);
                        this.getNewElementsCollection().add(n, designObject);
                        bl = true;
                    }
                    this.getNewElementsCollection().remove(attributeArray[i]);
                }
                if (!bl) {
                    this.getNewElementsCollection().add(designObject);
                }
                relation.addObjectListener(this);
                CandidateKey candidateKey = (CandidateKey)this.getContainerWithKeyObject().getPKorUnique();
                if (candidateKey != this) break block10;
                relation.setIdentifying(true);
                relation.setDirty(true);
                n = relation.getEndPointFor((Entity)this.getContainerWithKeyObject());
                relation.setOptional(n, Boolean.FALSE);
                for (TVRelation tVRelation : relation.getAllTVRelations()) {
                    if (tVRelation == null) continue;
                    tVRelation.resetEdgeParams(true);
                }
                break block10;
            }
            if (designObject instanceof Relation) {
                Relation relation = (Relation)designObject;
                Attribute[] attributeArray = relation.getFKAttributes((Entity)this.getContainerWithKeyObject());
                for (int i = 0; i < attributeArray.length; ++i) {
                    if (!this.getElementsCollection().contains(attributeArray[i])) {
                        this.add(attributeArray[i]);
                    }
                    if (!this.getNewElementsCollection().contains(attributeArray[i])) continue;
                    this.getNewElementsCollection().remove(attributeArray[i]);
                }
            }
        }
    }

    public void removeElement(DesignObject designObject) {
        if (this.getNewElementsCollection().contains(designObject)) {
            this.getNewElementsCollection().remove(designObject);
            if (designObject instanceof Relation) {
                Relation relation = (Relation)designObject;
                relation.removeObjectListener(this);
                Attribute[] attributeArray = relation.getFKAttributes((Entity)this.getContainerWithKeyObject());
                for (int i = 0; i < attributeArray.length; ++i) {
                    super.remove(attributeArray[i]);
                }
                if (relation.isIdentifying()) {
                    relation.setIdentifying(false);
                    relation.setDirty(true);
                    if (relation.getTopView() != null) {
                        ((TVRelation)relation.getTopView()).resetEdgeParams(true);
                    }
                }
            }
        }
    }

    @Override
    public boolean contains(ContainedObject containedObject) {
        return super.contains(containedObject);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return super.containsAll(collection);
    }

    public void updateElementsCollection() {
        DesignObject designObject2;
        super.getElementsCollection().clear();
        for (DesignObject designObject2 : this.getNewElementsCollection()) {
            if (designObject2 instanceof ContainedObject) {
                super.getElementsCollection().add(designObject2);
                continue;
            }
            if (!(designObject2 instanceof Relation)) continue;
            Relation relation = (Relation)designObject2;
            Attribute[] attributeArray = relation.getFKAttributes((Entity)this.getContainerWithKeyObject());
            for (int i = 0; i < attributeArray.length; ++i) {
                super.getElementsCollection().add(attributeArray[i]);
            }
        }
        designObject2 = (Entity)this.getContainerWithKeyObject();
        if (designObject2 != null && ((ContainerWithKeyObject)designObject2).hasKey(this)) {
            this.sharedEvent.setType(9);
            this.fireChange(this.sharedEvent);
        }
    }

    public boolean moveElementToIndex(DesignObject designObject, int n) {
        if (this.getNewElementsCollection().contains(designObject) && this.getNewElementsCollection().size() > n && n >= 0) {
            this.getNewElementsCollection().remove(designObject);
            this.getNewElementsCollection().add(n, designObject);
            this.sharedEvent.setType(7);
            this.sharedEvent.setElement(designObject);
            return true;
        }
        return false;
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.FK_ATTRIBUTES_CHANGED)) {
            this.updateElementsCollection();
        }
        if (objectChangeEvent.isType(ObjectChangeEvent.OBJECT_REMOVED)) {
            designObject.removeObjectListener(this);
            this.removeElement(designObject);
        }
        super.changed(designObject, objectChangeEvent);
    }

    public boolean shouldBeEngineered(XtdMapping xtdMapping) {
        return xtdMapping.getKeys().contains(this.getObjectID());
    }

    public void updateContainedObjects() {
        Iterator iterator = this.getNewElementsCollection().iterator();
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Attribute) {
                Attribute attribute = (Attribute)e;
                if (attribute.isFKAttribute()) {
                    Relation relation = (Relation)this.getDesign().getDesignObject(attribute.getGeneratorID());
                    if (relation == null || arrayList.contains(relation)) continue;
                    arrayList.add(relation);
                    continue;
                }
                arrayList.add(attribute);
                continue;
            }
            arrayList.add((DesignObject)e);
        }
        this.getNewElementsCollection().clear();
        this.getNewElementsCollection().addAll(arrayList);
    }

    @Override
    public void remove() {
        Entity entity = this.getEntity();
        if (entity != null) {
            for (Relation relation : this.getRelations()) {
                if (!relation.isIdentifying() || entity.getKeysUsingRelationsip(relation).size() != 1) continue;
                relation.setIdentifying(false);
            }
        }
        super.remove();
    }

    public List getRelations() {
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        for (DesignObject designObject : this.getNewElementsCollection()) {
            if (!(designObject instanceof Relation)) continue;
            arrayList.add(designObject);
        }
        return arrayList;
    }

    public Entity getEntity() {
        return (Entity)this.getContainerWithKeyObject();
    }
}

