/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.logical.AttributePropertiesDialogEx;

public class Attribute
extends ContainedObjectWithDomain
implements ObjectListener,
ConstrainedObject {
    public static final String DEFAULT_NAME = "Attribute";
    public static boolean propagateFKName = true;
    protected Attribute delegate;
    private String preferredAbbreviation = "";
    private String source = "";
    private Relation.Connection connection = null;

    public Attribute(DesignPart designPart) {
        super(designPart);
    }

    public Attribute(DesignPart designPart, Relation.Connection connection, Attribute attribute) {
        super(designPart);
        this.connection = connection;
        this.setDelegate(attribute);
    }

    @Override
    public String getObjectTypeName() {
        return DEFAULT_NAME;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("attribute id prefix");
    }

    public boolean isFKAttribute() {
        return this.connection != null;
    }

    @Override
    public boolean isFKElement() {
        return this.isFKAttribute();
    }

    @Override
    public boolean hasAliveGenerator() {
        DesignObject designObject;
        ColumnSet columnSet = this.getDesign().getRelationalDesign().getColumnSet();
        return ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID()) || (designObject = columnSet.getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            AttributePropertiesDialogEx attributePropertiesDialogEx = new AttributePropertiesDialogEx(this.getDesign().getAppView(), this, false);
            attributePropertiesDialogEx.initProperties(this);
            attributePropertiesDialogEx.show();
        }
    }

    public Column getEngColumn(RelationalDesign relationalDesign, Table table) {
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                Column column = (Column)xtdMapping.getObjectMappedTo(this);
                if (column == null || column.getContainerWithKeyObject() != table) continue;
                return column;
            }
        }
        return null;
    }

    public XtdMapping getMappingFor(RelationalDesign relationalDesign, Table table) {
        List list;
        if (table != null && (list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID())).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                Column column = (Column)xtdMapping.getObjectMappedTo(this);
                if (column == null || column.getContainerWithKeyObject() != table) continue;
                return xtdMapping;
            }
        }
        return null;
    }

    public List getMappingsFor(RelationalDesign relationalDesign, Table table) {
        List list;
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        if (table != null && (list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID())).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                Column column = (Column)xtdMapping.getObjectMappedTo(this);
                if (column == null || column.getContainerWithKeyObject() != table) continue;
                arrayList.add(xtdMapping);
            }
        }
        return arrayList;
    }

    public Column getEngColumn(RelationalDesign relationalDesign) {
        RepositoryObject repositoryObject;
        DesignObject designObject;
        Column column = null;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
        if (list.size() > 0 && (designObject = (Column)(repositoryObject = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null) {
            return designObject;
        }
        if (this.getGenerator() instanceof Column) {
            column = (Column)this.getGenerator();
        }
        if (column != null && column.getDesignPart() == relationalDesign) {
            return column;
        }
        column = (Column)relationalDesign.getColumnSet().getObjectGeneratedBy(this.getObjectID());
        if (column == null && this.isFKAttribute() && !this.hasCircularRef() && (repositoryObject = this.getGenerator()) != null && repositoryObject instanceof Relation && (repositoryObject = (designObject = (Relation)repositoryObject).getGenerator()) != null && repositoryObject instanceof FKIndexAssociation) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)repositoryObject;
            String string = this.getReferedAttribute();
            Attribute attribute = (Attribute)this.getDesign().getDesignObject(string);
            if (attribute != null) {
                Column column2 = attribute.getEngColumn(relationalDesign);
                Table table = ((Entity)this.getContainer()).getEngTable(relationalDesign);
                if (table != null && column2 != null) {
                    Column column3 = table.getFKColumn(fKIndexAssociation, column2);
                    return column3;
                }
            }
        }
        return column;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public void copy(DesignObject designObject) {
        Attribute attribute = (Attribute)designObject;
        super.copy(attribute);
        attribute.setDesignObjectSet(this.getDesignObjectSet());
        attribute.setUnique(this.isUnique());
        attribute.setNullsAllowed(this.getNullsAllowed());
        attribute.setUse(this.getUse());
        if (this.getUse() == 0) {
            attribute.setDomain(this.getDomain());
        } else if (this.getUse() == 1) {
            attribute.setLogicalDatatype(this.getLogicalDatatype());
        } else if (this.getUse() == 3) {
            attribute.setStructuredType(this.getStructuredType());
            List list = attribute.getPermittedSubTypes();
            list.clear();
            list.addAll(this.getPermittedSubTypes());
        } else if (this.getUse() == 4) {
            attribute.setCollectionType(this.getCollectionType());
        } else if (this.getUse() == 2) {
            attribute.setDistinctType(this.getDistinctType());
        }
        attribute.setReference(this.isReference());
        if (this.getUse() == 1) {
            attribute.setDataTypeParameter("size", this.getSize());
            attribute.setDataTypeParameter("precision", this.getPrecision());
            attribute.setDataTypeParameter("scale", this.getScale());
        }
        attribute.setUsesDefaultValue(this.getUsesDefaultValue());
        attribute.setUseDomainConstraints(this.getUseDomainConstraints());
        attribute.setDefaultValue(this.getDefaultValue());
        attribute.setSourceType(this.getSourceType());
        attribute.setSource(this.getSource());
        attribute.setFormulaDesc(this.getFormulaDesc());
        attribute.setScopeId(this.getScopeId());
        attribute.setAllowSubtypeSubstitution(this.isAllowSubtypeSubstitution());
        attribute.setRestrictedTypeSubstitution(this.isRestrictedTypeSubstitution());
        if (!this.getUseDomainConstraints()) {
            EngCOPropertiesComparator.copyCheckConstraint(this, attribute);
            EngCOPropertiesComparator.copyRangeConstraint(this, attribute);
            EngCOPropertiesComparator.copyLOVConstraint(this, attribute);
        }
        attribute.setSynonym(this.getSynonym());
        attribute.setPreferredAbbreviation(this.getPreferredAbbreviation());
    }

    public void importAttribute(DesignObject designObject) {
        Attribute attribute = (Attribute)designObject;
        super.copy(attribute);
        attribute.setDesignObjectSet(this.getDesignObjectSet());
        attribute.setUnique(this.isUnique());
        attribute.setNullsAllowed(this.getNullsAllowed());
        attribute.setUse(this.getUse());
        attribute.setReference(this.isReference());
        if (this.getDomain() != null) {
            Domain domain = this.getDomain();
            Domain domain2 = (Domain)attribute.getDesign().getDomainSet().getByName(domain.getName());
            if (domain2 != null) {
                attribute.setDomain(domain2);
            } else {
                domain2 = domain;
                domain2.copy(domain);
                domain2.setDesign(attribute.getDesign());
                domain2.setOwnerDesign(attribute.getDesign());
                domain2.setDirty(true);
                attribute.getDesign().getDomainSet().add(domain2);
                attribute.setDomain(domain2);
            }
        }
        attribute.setLogicalDatatype(this.getLogicalDatatype());
        attribute.setDataTypeParameter("size", this.getSize());
        attribute.setDataTypeParameter("precision", this.getPrecision());
        attribute.setDataTypeParameter("scale", this.getScale());
        attribute.setUsesDefaultValue(this.getUsesDefaultValue());
        attribute.setUseDomainConstraints(this.getUseDomainConstraints());
        attribute.setDefaultValue(this.getDefaultValue());
        attribute.setSourceType(this.getSourceType());
        attribute.setFormulaDesc(this.getFormulaDesc());
        attribute.setScopeId(this.getScopeId());
        attribute.setAllowSubtypeSubstitution(this.isAllowSubtypeSubstitution());
        attribute.setRestrictedTypeSubstitution(this.isRestrictedTypeSubstitution());
        attribute.setImportedId(this.getObjectID());
        attribute.setImportedDesign(this.getDesign());
    }

    public List getAlldelegates() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (Attribute attribute = this.getDelegate(); attribute != null && !arrayList.contains(attribute); attribute = attribute.getDelegate()) {
            arrayList.add(attribute);
        }
        return arrayList;
    }

    public Attribute getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Attribute attribute) {
        if (this.delegate != attribute) {
            if (this.delegate != null) {
                this.delegate.removeObjectListener(this);
            }
            this.delegate = attribute;
            if (this.delegate != null && !this.hasCircularRef()) {
                this.delegate.addObjectListener(this);
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    @Override
    public boolean setName(String string) {
        if (string != null && string.equals(this.name)) {
            return true;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        propagateFKName = this.getDesign().getAppView().getSettings().isKeepFKNamesSynchronized();
        boolean bl = super.setName(string);
        if (!this.getDesign().isLoading() && !ApplicationView.importing && bl && propagateFKName) {
            arrayList.add(this);
            this.propagateNameToDependent(string, arrayList);
        }
        return bl;
    }

    public void propagateNameToFKAttributes(String string) {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        propagateFKName = this.getDesign().getAppView().getSettings().isKeepFKNamesSynchronized();
        if (propagateFKName) {
            arrayList.add(this);
            this.propagateNameToDependent(string, arrayList);
        }
    }

    private boolean setPropagatedName(String string, List list) {
        if (!list.contains(this)) {
            boolean bl = super.setName(string);
            if (bl && propagateFKName) {
                list.add(this);
                this.propagateNameToDependent(string, list);
            }
            return bl;
        }
        return false;
    }

    private void propagateNameToDependent(String string, List list) {
        List list2 = ((LogicalDesign)this.getDesignPart()).getAttributeSet().getDependentOnDelegate(this);
        for (Attribute attribute : list2) {
            attribute.setPropagatedName(string, list);
        }
    }

    public String getPreferredAbbreviation() {
        return this.preferredAbbreviation;
    }

    public void setPreferredAbbreviation(String string) {
        this.preferredAbbreviation = string;
    }

    public String getLogicalRepresentationName() {
        String string = "";
        if (this.getUse() == 0) {
            return this.getDomain().getLogicalRepresentationName(this.getDesign().getDLSettings().isLogicalTypeForDomainPresentation());
        }
        if (this.getUse() == 1) {
            string = this.getLogicalDatatype().getName();
            String string2 = this.getDataTypeParameter("size");
            if (string2 != null && !"".equals(string2)) {
                if (!"".equals(string2) && !"0".equals(string2)) {
                    return string + " (" + string2 + ")";
                }
                return string;
            }
            String string3 = this.getDataTypeParameter("precision");
            if (string3 != null && !"".equals(string3)) {
                if (!"".equals(string3) && !"0".equals(string3)) {
                    String string4 = this.getDataTypeParameter("scale");
                    if (string4 != null && !"".equals(string4) && !"0".equals(string4)) {
                        return string + " (" + string3 + "," + string4 + ")";
                    }
                    return string + " (" + string3 + ")";
                }
                return string;
            }
            return string;
        }
        if (this.getUse() == 3) {
            if (this.isReference()) {
                return "REF " + this.getStructuredType().getName();
            }
            return this.getStructuredType().getName();
        }
        if (this.getUse() == 2) {
            return this.getDistinctType().getName();
        }
        if (this.getUse() == 4) {
            return this.getCollectionType().getName();
        }
        return string;
    }

    @Override
    public void addAVT(AVT aVT) {
        if (!this.getUseDomainConstraints()) {
            super.addAVT(aVT);
        }
    }

    @Override
    public Set getAVTs() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getAVTs();
        }
        return super.getAVTs();
    }

    @Override
    public void removeAVT(AVT aVT) {
        if (!this.getUseDomainConstraints()) {
            super.removeAVT(aVT);
        }
    }

    @Override
    public void clearAVTs() {
        if (!this.getUseDomainConstraints()) {
            super.clearAVTs();
        }
    }

    @Override
    public ConstraintEnumeration getValueList() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getValueList();
        }
        return super.getValueList();
    }

    @Override
    public void setValueList(ConstraintEnumeration constraintEnumeration) {
        if (!this.getUseDomainConstraints()) {
            super.setValueList(constraintEnumeration);
        }
    }

    @Override
    public CheckConstraint getCheck() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getCheck();
        }
        return super.getCheck();
    }

    @Override
    public void setCheck(CheckConstraint checkConstraint) {
        if (!this.getUseDomainConstraints()) {
            super.setCheck(checkConstraint);
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public boolean shouldBeEngineered(XtdMapping xtdMapping) {
        return xtdMapping.getAttributes().contains(this.getObjectID());
    }

    @Override
    public Domain getDomain() {
        if (this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getDomain();
        }
        return super.getDomain();
    }

    protected String getOriginatingTableName() {
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        arrayList.add(this);
        arrayList.add(this.getContainerWithKeyObject());
        String string = this.getContainerWithKeyObject().getName();
        Attribute attribute = this.delegate;
        while (attribute != null) {
            arrayList.add(attribute);
            ContainerWithKeyObject containerWithKeyObject = attribute.getContainerWithKeyObject();
            if (containerWithKeyObject != null) {
                string = containerWithKeyObject.getName();
                if (arrayList.contains(containerWithKeyObject)) {
                    attribute = null;
                    continue;
                }
                arrayList.add(containerWithKeyObject);
                if (attribute.isFKAttribute()) {
                    if (!arrayList.contains(attribute = attribute.getDelegate())) continue;
                    attribute = null;
                    continue;
                }
                attribute = null;
                continue;
            }
            attribute = null;
        }
        return string;
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }

    @Override
    public ContainedObject getDelegateElement() {
        return this.getDelegate();
    }

    @Override
    public void setDomain(Domain domain) {
        if (this.getDelegate() == null) {
            super.setDomain(domain);
        }
    }

    @Override
    public Datatype getDataType() {
        if (this.isReference() || this.getDelegate() == null || this.getDelegate() != null && this.hasCircularRef()) {
            return super.getDataType();
        }
        return this.getDelegate().getDataType();
    }

    @Override
    public LogicalDatatype getLogicalDatatype() {
        if (this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getLogicalDatatype();
        }
        return super.getLogicalDatatype();
    }

    private String getOriginatingAttributeName() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        arrayList.add(this);
        String string = this.getName();
        Attribute attribute = this.delegate;
        while (attribute != null) {
            arrayList.add(attribute);
            if (attribute.isFKAttribute()) {
                if (!arrayList.contains(attribute = attribute.getDelegate())) continue;
                attribute = null;
                continue;
            }
            string = attribute.getName();
            attribute = null;
        }
        return string;
    }

    public Attribute getOriginatingAttribute() {
        if (!this.isFKAttribute()) {
            return null;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        arrayList.add(this);
        Attribute attribute = this.delegate;
        boolean bl = false;
        while (!bl) {
            arrayList.add(attribute);
            if (attribute != null && attribute.isFKAttribute()) {
                if (!arrayList.contains(attribute = attribute.getDelegate())) continue;
                attribute = null;
                bl = true;
                continue;
            }
            bl = true;
        }
        return attribute;
    }

    public boolean hasCircularRef() {
        if (this.delegate == null) {
            return false;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        arrayList.add(this);
        Attribute attribute = this.delegate;
        boolean bl = false;
        while (!bl) {
            arrayList.add(attribute);
            if (attribute != null && attribute.isFKAttribute()) {
                if (!arrayList.contains(attribute = attribute.getDelegate())) continue;
                return true;
            }
            bl = true;
        }
        return false;
    }

    @Override
    public String toString() {
        String string;
        if (!this.isFKAttribute()) {
            return this.getName();
        }
        String string2 = this.getOriginatingTableName();
        String string3 = this.getOriginatingAttributeName();
        if (this.getRelation() != null) {
            String string4 = this.getRelation().getName();
            string = !string2.equals("") ? string2 + "." + string3 + "," + string4 : string3 + "," + string4;
        } else {
            string = !string2.equals("") ? string2 + "." + string3 : super.getName();
        }
        return string;
    }

    @Override
    public String getDataTypeParameter(String string) {
        if (this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getDataTypeParameter(string);
        }
        return super.getDataTypeParameter(string);
    }

    public Relation.Connection getConnection() {
        return this.connection;
    }

    public void setConnectionIfNull(Relation.Connection connection) {
        if (this.connection == null) {
            this.connection = connection;
        }
    }

    public Relation getRelation() {
        if (this.hasRelation()) {
            return this.connection.getRelation();
        }
        return null;
    }

    @Override
    public boolean getNullsAllowed() {
        if (!this.isFKAttribute()) {
            return super.getNullsAllowed();
        }
        return !this.isPKElement() && this.isValid() && this.getConnection().isOptional();
    }

    public boolean hasRelation() {
        return this.getConnection() != null;
    }

    public boolean isValid() {
        return this.hasDelegate() && this.hasRelation();
    }

    private int getPositionInPKOfDelegate() {
        return this.getDelegate().getPositionInPK();
    }

    public int getPositionInRelation() {
        return this.getPositionInPKOfDelegate();
    }

    @Override
    public void setNullsAllowed(boolean bl) {
        if (!this.isFKAttribute()) {
            super.setNullsAllowed(bl);
        }
    }

    public void setDefaultName() {
        if (this.isValid()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getDelegate().getContainerWithKeyObject().getName());
            stringBuffer.append('.');
            String string = this.getDelegate().getName();
            if (string.indexOf(46) > 0) {
                string = string.substring(string.indexOf(46) + 1);
            }
            stringBuffer.append(string);
            int n = 0;
            while (this.connection.getEntity().getElementByName(stringBuffer.toString()) != null) {
                stringBuffer.append(++n);
            }
            this.setName(stringBuffer.toString());
        }
    }

    public void setConnection(Relation.Connection connection) {
        this.connection = connection;
    }

    @Override
    public short getUse() {
        if (this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getUse();
        }
        return super.getUse();
    }

    @Override
    public void setObjectID(String string) {
        super.setObjectID(string);
        this.getObjectID();
    }

    @Override
    public void setComment(String string) {
        if (!ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION || this.getDelegate() == null) {
            super.setComment(string);
        }
    }

    @Override
    public void setNotes(String string) {
        if (!ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION || this.getDelegate() == null) {
            super.setNotes(string);
        }
    }

    @Override
    public String getComment() {
        if (ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getComment();
        }
        return super.getComment();
    }

    @Override
    public String getNotes() {
        if (ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getNotes();
        }
        return super.getNotes();
    }

    @Override
    public void setCommentInRDBMS(String string) {
        if (!(string == null || "null".equalsIgnoreCase(string) || ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null)) {
            super.setCommentInRDBMS(string);
        }
    }

    @Override
    public String getCommentInRDBMS() {
        String string = ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null && !this.hasCircularRef() ? this.getDelegate().getCommentInRDBMS() : super.getCommentInRDBMS();
        string = string == null ? "" : string;
        return string;
    }

    public String getCommentInRDBMStoStore() {
        if (ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null && !this.hasCircularRef()) {
            return null;
        }
        return super.getCommentInRDBMS();
    }

    public String getCommentToStore() {
        if (ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null && !this.hasCircularRef()) {
            return null;
        }
        return super.getComment();
    }

    public String getNotesToStore() {
        if (ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null && !this.hasCircularRef()) {
            return null;
        }
        return super.getNotes();
    }
}

