/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.impact.ImpA_Entity;
import oracle.dbtools.crest.model.design.impact.ImpA_Relation;
import oracle.dbtools.crest.model.design.impact.ImpA_TableView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_Table
extends ModelIdObjectSelection {
    private Table table;

    public ImpA_Table(Table table, ModelIdObjectSelection modelIdObjectSelection, boolean bl) {
        super(table);
        this.table = table;
        this.setParent(modelIdObjectSelection);
        if (bl) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addTableNodes(this);
        this.loaded = true;
    }

    private void addTableNodes(ImpA_Table impA_Table) {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Table.Mappings"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
        impA_Table.addChild(modelIdObjectSelection);
        if (this.table.getObjectID() != null) {
            List list = this.table.getDesign().getExtendedMap().getMappingsForDesignPart(this.table, this.table.getDesign().getLogicalDesign().getObjectID());
            for (XtdMapping xtdMapping : list) {
                DesignObject designObject = xtdMapping.getObjectMappedTo(this.table);
                if (designObject == null) continue;
                if (designObject instanceof Entity) {
                    if (!modelIdObjectSelection.hasAsParent(designObject)) {
                        modelIdObjectSelection.addChild(new ImpA_Entity((Entity)designObject, modelIdObjectSelection, false));
                        continue;
                    }
                    modelIdObjectSelection.addChild(new ModelIdObjectSelection(designObject));
                    continue;
                }
                if (!modelIdObjectSelection.hasAsParent(designObject)) {
                    modelIdObjectSelection.addChild(new ImpA_Relation((Relation)designObject, modelIdObjectSelection, false));
                    continue;
                }
                modelIdObjectSelection.addChild(new ModelIdObjectSelection(designObject));
            }
        }
        modelIdObjectSelection.sort();
        this.addTableViews();
        this.addSubViews();
    }

    private void addTableViews() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Table.DependentViews"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        this.addChild(modelIdObjectSelection);
        ArrayList<TableView> arrayList = new ArrayList<TableView>();
        Iterator iterator = ((RelationalDesign)this.table.getDesignPart()).getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            if (tableView.getContainerHolderFor(this.table) == null && (!tableView.isValidSQL() || !tableView.sqlNameExists(this.table.getObjectID()))) continue;
            arrayList.add(tableView);
        }
        if (arrayList.size() > 0) {
            for (TableView tableView : arrayList) {
                if (!modelIdObjectSelection.hasAsParent(tableView)) {
                    modelIdObjectSelection.addChild(new ImpA_TableView(tableView, modelIdObjectSelection));
                    continue;
                }
                modelIdObjectSelection.addChild(new ModelIdObjectSelection(tableView));
            }
        }
        modelIdObjectSelection.sort();
    }

    private void addSubViews() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Table.UsedInSubViews"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
        this.addChild(modelIdObjectSelection);
        for (DesignPartView designPartView : this.table.getAffectedDPVs()) {
            if (!designPartView.isMasterDPV() || designPartView.isMainDiagram()) continue;
            PlaceHolder placeHolder = designPartView.getPlaceHolder();
            ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(placeHolder);
            modelIdObjectSelection2.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
        modelIdObjectSelection.sort();
    }
}

