/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.impact.ImpA_FKAssociation;
import oracle.dbtools.crest.model.design.impact.ImpA_Table;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_Relation
extends ModelIdObjectSelection {
    private Relation relation;

    public ImpA_Relation(Relation relation, ModelIdObjectSelection modelIdObjectSelection, boolean bl) {
        super(relation);
        this.relation = relation;
        this.setParent(modelIdObjectSelection);
        if (bl) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addRelationNodes(this);
        this.loaded = true;
    }

    private void addRelationNodes(ImpA_Relation impA_Relation) {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Relation.Mappings"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("M_TO_N_RELATION_ICON"));
        impA_Relation.addChild(modelIdObjectSelection);
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(Messages.getString("ImpA_Relation.RelationalModels"));
        modelIdObjectSelection2.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
        Iterator iterator = this.relation.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (this.relation.getObjectID() == null) continue;
            List list = this.relation.getDesign().getExtendedMap().getMappingsForDesignPart(this.relation, relationalDesign.getObjectID());
            ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(relationalDesign.getName());
            modelIdObjectSelection3.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
            modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            for (XtdMapping xtdMapping : list) {
                DesignObject designObject = xtdMapping.getObjectMappedTo(this.relation);
                if (designObject == null) continue;
                if (designObject instanceof FKIndexAssociation) {
                    if (!modelIdObjectSelection3.hasAsParent(designObject)) {
                        modelIdObjectSelection3.addChild(new ImpA_FKAssociation((FKIndexAssociation)designObject, modelIdObjectSelection3, false));
                        continue;
                    }
                    modelIdObjectSelection3.addChild(new ModelIdObjectSelection(designObject));
                    continue;
                }
                if (!modelIdObjectSelection3.hasAsParent(designObject)) {
                    modelIdObjectSelection3.addChild(new ImpA_Table((Table)designObject, modelIdObjectSelection3, false));
                    continue;
                }
                modelIdObjectSelection3.addChild(new ModelIdObjectSelection(designObject));
            }
        }
    }

    @Override
    public String getLongName() {
        if (this.object != null) {
            return this.object.toString();
        }
        return "";
    }

    @Override
    public String toString() {
        return this.getLongName();
    }
}

