/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.impact.ImpA_EntityView;
import oracle.dbtools.crest.model.design.impact.ImpA_Table;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_Entity
extends ModelIdObjectSelection {
    private Entity entity;

    public ImpA_Entity(Entity entity, ModelIdObjectSelection modelIdObjectSelection, boolean bl) {
        super(entity);
        this.entity = entity;
        this.setParent(modelIdObjectSelection);
        if (bl) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addEntityNodes();
        this.addEntityViews();
        this.addProcessModel();
        this.addDimensionalModels();
        this.addSubViews();
        this.loaded = true;
    }

    private void addEntityNodes() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.Mappings"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        this.addChild(modelIdObjectSelection);
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.RelationalModels"));
        modelIdObjectSelection2.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
        Iterator iterator = this.entity.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            ModelIdObjectSelection modelIdObjectSelection3 = null;
            if (relationalDesign.isLoaded()) {
                modelIdObjectSelection3 = new ModelIdObjectSelection(relationalDesign.getName());
                modelIdObjectSelection3.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            } else {
                modelIdObjectSelection3 = new ModelIdObjectSelection(relationalDesign.getName() + "(not loaded)");
                modelIdObjectSelection3.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            }
            if (this.entity.getObjectID() == null) continue;
            List list = relationalDesign.getDesign().getExtendedMap().getMappingsForDesignPart(this.entity, relationalDesign.getObjectID());
            for (XtdMapping xtdMapping : list) {
                Object object;
                if (relationalDesign.isLoaded()) {
                    object = (Table)xtdMapping.getObjectMappedTo(this.entity);
                    if (object == null) continue;
                    if (!modelIdObjectSelection2.hasAsParent((ModelIDObject)object)) {
                        modelIdObjectSelection3.addChild(new ImpA_Table((Table)object, modelIdObjectSelection2, false));
                        continue;
                    }
                    modelIdObjectSelection3.addChild(new ModelIdObjectSelection((ModelIDObject)object));
                    continue;
                }
                object = xtdMapping.getOtherName(this.entity.getObjectID());
                modelIdObjectSelection3.addChild(new ModelIdObjectSelection((String)object + "(not loaded)"));
            }
        }
    }

    private void addEntityViews() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.DependentViews"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        this.addChild(modelIdObjectSelection);
        ArrayList<EntityView> arrayList = new ArrayList<EntityView>();
        Iterator iterator = this.entity.getDesign().getLogicalDesign().getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            EntityView entityView = (EntityView)iterator.next();
            if (entityView.getContainerHolderFor(this.entity) == null) continue;
            arrayList.add(entityView);
        }
        for (EntityView entityView : arrayList) {
            if (!modelIdObjectSelection.hasAsParent(entityView)) {
                modelIdObjectSelection.addChild(new ImpA_EntityView(entityView, modelIdObjectSelection));
                continue;
            }
            modelIdObjectSelection.addChild(new ModelIdObjectSelection(entityView));
        }
    }

    private void addProcessModel() {
        ModelIdObjectSelection modelIdObjectSelection;
        Process process;
        int n;
        Object object;
        Object object22;
        ModelObject modelObject;
        Object object3;
        ModelObject modelObject2;
        ModelObject modelObject3;
        TreeMap<String, DFDholder> treeMap = new TreeMap<String, DFDholder>();
        TreeMap<String, DFDholder> treeMap2 = new TreeMap<String, DFDholder>();
        ArrayList<Flow> arrayList = new ArrayList<Flow>();
        ProcessModel processModel = this.entity.getDesign().getProcessModel();
        Iterator<Object> iterator = processModel.getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            modelObject3 = (DataFlowDesign)iterator.next();
            modelObject2 = ((DataFlowDesign)modelObject3).getTopLevelDataFlowDesign();
            object3 = ((DataFlowDesign)modelObject3).getProcessSet().iterator();
            while (object3.hasNext()) {
                modelObject = (Process)object3.next();
                if (((Process)modelObject).getType() != 0) continue;
                for (Object object22 : ((Process)modelObject).getProcessedEntitiesAndFlows(false, this.entity)) {
                    if (((Process.ProcessedObject)object22).getObject() != this.entity) continue;
                    if (((Process.ProcessedObject)object22).isInbound()) {
                        object = (DFDholder)treeMap.get(((ModelIDObject)modelObject2).getObjectID());
                        if (object == null) {
                            object = new DFDholder();
                            ((DFDholder)object).dfd = modelObject2;
                            ((DFDholder)object).list = new ArrayList();
                            treeMap.put(((ModelIDObject)modelObject2).getObjectID(), (DFDholder)object);
                        }
                        if (!((DFDholder)object).list.contains(modelObject)) {
                            ((DFDholder)object).list.add(modelObject);
                        }
                    } else {
                        object = (DFDholder)treeMap2.get(((ModelIDObject)modelObject2).getObjectID());
                        if (object == null) {
                            object = new DFDholder();
                            ((DFDholder)object).dfd = modelObject2;
                            ((DFDholder)object).list = new ArrayList();
                            treeMap2.put(((ModelIDObject)modelObject2).getObjectID(), (DFDholder)object);
                        }
                        if (!((DFDholder)object).list.contains(modelObject)) {
                            ((DFDholder)object).list.add(modelObject);
                        }
                    }
                    if (arrayList.contains(((Process.ProcessedObject)object22).getFlow())) continue;
                    arrayList.add(((Process.ProcessedObject)object22).getFlow());
                }
            }
        }
        modelObject3 = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.ProcessModel"));
        modelObject3.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
        this.addChild((ModelIdObjectSelection)modelObject3);
        modelObject2 = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.InboundProcesses"));
        modelObject2.setIcon(GUIConfiguration.getInstance().getIcon("PROCESS_ICON"));
        ((ModelIdObjectSelection)modelObject3).addChild((ModelIdObjectSelection)modelObject2);
        object3 = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.OutboundProcesses"));
        ((ModelObject)object3).setIcon(GUIConfiguration.getInstance().getIcon("PROCESS_ICON"));
        ((ModelIdObjectSelection)modelObject3).addChild((ModelIdObjectSelection)object3);
        modelObject = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.Flows"));
        modelObject.setIcon(GUIConfiguration.getInstance().getIcon("FLOW_ICON"));
        ((ModelIdObjectSelection)modelObject3).addChild((ModelIdObjectSelection)modelObject);
        for (String string : treeMap.keySet()) {
            object22 = (DFDholder)treeMap.get(string);
            if (((DFDholder)object22).list.size() <= 0) continue;
            Collections.sort(((DFDholder)object22).list, ModelObjectSet.UPPERCASE_NAME_COMPARATOR);
            object = new ModelIdObjectSelection(((DFDholder)object22).dfd);
            ((ModelIdObjectSelection)modelObject2).addChild((ModelIdObjectSelection)object);
            for (n = 0; n < ((DFDholder)object22).list.size(); ++n) {
                process = (Process)((DFDholder)object22).list.get(n);
                modelIdObjectSelection = new ModelIdObjectSelection(process);
                ((ModelIdObjectSelection)object).addChild(modelIdObjectSelection);
            }
        }
        for (String string : treeMap2.keySet()) {
            object22 = (DFDholder)treeMap2.get(string);
            if (((DFDholder)object22).list.size() <= 0) continue;
            Collections.sort(((DFDholder)object22).list, ModelObjectSet.UPPERCASE_NAME_COMPARATOR);
            object = new ModelIdObjectSelection(((DFDholder)object22).dfd);
            ((ModelIdObjectSelection)object3).addChild((ModelIdObjectSelection)object);
            for (n = 0; n < ((DFDholder)object22).list.size(); ++n) {
                process = (Process)((DFDholder)object22).list.get(n);
                modelIdObjectSelection = new ModelIdObjectSelection(process);
                ((ModelIdObjectSelection)object).addChild(modelIdObjectSelection);
            }
        }
        Collections.sort(arrayList, ModelObjectSet.UPPERCASE_NAME_COMPARATOR);
        for (DesignObject designObject : arrayList) {
            object22 = new ModelIdObjectSelection(designObject);
            ((ModelIdObjectSelection)modelObject).addChild((ModelIdObjectSelection)object22);
        }
    }

    private void addDimensionalModels() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.DimensionalModels"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
        this.addChild(modelIdObjectSelection);
        Iterator iterator = this.entity.getDesign().getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
            this.addDimensionalModel(multidimensionalDesign, modelIdObjectSelection);
        }
    }

    private void addDimensionalModel(MultidimensionalDesign multidimensionalDesign, ModelIdObjectSelection modelIdObjectSelection) {
        ModelObject modelObject;
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(multidimensionalDesign);
        modelIdObjectSelection2.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
        ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.Cubes"));
        modelIdObjectSelection3.setIcon(GUIConfiguration.getInstance().getIcon("CUBE_ICON"));
        modelIdObjectSelection2.addChild(modelIdObjectSelection3);
        Iterator iterator = multidimensionalDesign.getCubeSet().iterator();
        while (iterator.hasNext()) {
            modelObject = (Cube)iterator.next();
            if (!((Cube)modelObject).getFactEntities().contains(this.entity)) continue;
            modelIdObjectSelection3.addChild(new ModelIdObjectSelection((ModelIDObject)modelObject));
        }
        modelObject = new ModelIdObjectSelection(Messages.getString("ImpA_Entity.Levels"));
        modelObject.setIcon(GUIConfiguration.getInstance().getIcon("LEVEL_ICON"));
        modelIdObjectSelection2.addChild((ModelIdObjectSelection)modelObject);
        iterator = multidimensionalDesign.getLevelSet().iterator();
        while (iterator.hasNext()) {
            Level level = (Level)iterator.next();
            if (level.getLevelEntity() != this.entity) continue;
            ((ModelIdObjectSelection)modelObject).addChild(new ModelIdObjectSelection(level));
        }
    }

    private void addSubViews() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Table.UsedInSubViews"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
        this.addChild(modelIdObjectSelection);
        for (DesignPartView designPartView : this.entity.getAffectedDPVs()) {
            if (!designPartView.isMasterDPV() || designPartView.isMainDiagram()) continue;
            PlaceHolder placeHolder = designPartView.getPlaceHolder();
            ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(placeHolder);
            modelIdObjectSelection2.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
        modelIdObjectSelection.sort();
    }

    class DFDholder {
        DataFlowDesign dfd;
        List list;

        DFDholder() {
        }
    }
}

