/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_ColumnView
extends LongNameObjectSelection {
    private ColumnView columnView;

    public ImpA_ColumnView(ColumnView columnView, ModelIdObjectSelection modelIdObjectSelection, boolean bl) {
        super(columnView);
        this.columnView = columnView;
        this.setParent(modelIdObjectSelection);
        if (bl) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addDependentColumnViews();
        this.loaded = true;
    }

    private void addDependentColumnViews() {
        ModelObject modelObject;
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        Iterator iterator = ((RelationalDesign)this.columnView.getDesignPart()).getColumnViewSet().iterator();
        while (iterator.hasNext()) {
            modelObject = (ColumnView)iterator.next();
            if (((AbstractViewElement)modelObject).getReferencedColumnView() == null || ((AbstractViewElement)modelObject).getReferencedColumnView() != this.columnView) continue;
            arrayList.add(modelObject);
        }
        if (arrayList.size() > 0) {
            modelObject = new ModelIdObjectSelection(Messages.getString("ImpA_ColumnView.DependentViewColumns"));
            modelObject.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
            this.addChild((ModelIdObjectSelection)modelObject);
            for (ColumnView columnView : arrayList) {
                if (!((ModelIdObjectSelection)modelObject).hasAsParent(columnView)) {
                    ((ModelIdObjectSelection)modelObject).addChild(new ImpA_ColumnView(columnView, (ModelIdObjectSelection)modelObject, false));
                    continue;
                }
                ((ModelIdObjectSelection)modelObject).addChild(new ModelIdObjectSelection(columnView));
            }
        }
    }
}

