/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.glossary;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;

public class WordPropertiesComparator
implements GeneralPropertiesComparator {
    public static String NAME = Messages.getString("WordPropertiesComparator.Name");
    public static String PLURAL = Messages.getString("WordPropertiesComparator.Plural");
    public static String ABBREVIATION = Messages.getString("WordPropertiesComparator.Abbreviation");
    public static String ALT_ABBREVIATION = Messages.getString("WordPropertiesComparator.AlternateAbbreviation");
    public static String PRIMARY_WORD = Messages.getString("WordPropertiesComparator.PrimaryWord");
    public static String CLASS_WORD = Messages.getString("WordPropertiesComparator.ClassWord");
    public static String MODIFIER = Messages.getString("WordPropertiesComparator.Modifier");
    public static String QUALIFIER = Messages.getString("WordPropertiesComparator.Qualifier");
    public static String DESCRIPTION = Messages.getString("WordPropertiesComparator.Description");
    public static String COMMENT = Messages.getString("WordPropertiesComparator.Comment");
    public static String NOTES = Messages.getString("WordPropertiesComparator.Notes");
    private GlossaryWord left_word;
    private GlossaryWord right_word;
    protected List propertiesList = new ArrayList();

    public WordPropertiesComparator(GlossaryWord glossaryWord, GlossaryWord glossaryWord2) {
        this.left_word = glossaryWord;
        this.right_word = glossaryWord2;
        this.initPropertiesList();
    }

    @Override
    public List getPropertiesList() {
        return this.propertiesList;
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
    }

    @Override
    public String getLeftName() {
        if (this.left_word != null) {
            return this.left_word.getName();
        }
        return "";
    }

    @Override
    public String getRightName() {
        if (this.right_word != null) {
            return this.right_word.getName();
        }
        return "";
    }

    protected void initNameProperty() {
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(NAME);
        engPropertyHolder.setLeftValue(this.left_word != null ? this.left_word.getName() : "");
        engPropertyHolder.setRightValue(this.right_word != null ? this.right_word.getName() : "");
        if (this.left_word != null && this.right_word != null && !this.left_word.getName().equals(this.right_word.getName())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
    }

    protected void initCommentsAndNotes() {
    }

    protected void copyPropertiesFromLeftToRight() {
        if (this.left_word != null && this.right_word != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(NAME)) {
                    this.right_word.setName(this.left_word.getName());
                    continue;
                }
                if (engPropertyHolder.getName().equals(PLURAL)) {
                    this.right_word.setPlural(this.left_word.getPlural());
                    continue;
                }
                if (engPropertyHolder.getName().equals(ABBREVIATION)) {
                    this.right_word.setAbbreviation(this.left_word.getAbbreviation());
                    continue;
                }
                if (engPropertyHolder.getName().equals(ALT_ABBREVIATION)) {
                    this.right_word.setAltAbbrevation(this.left_word.getAltAbbrevation());
                    continue;
                }
                if (engPropertyHolder.getName().equals(PRIMARY_WORD)) {
                    this.right_word.setPrimaryWord(this.left_word.isPrimaryWord());
                    continue;
                }
                if (engPropertyHolder.getName().equals(CLASS_WORD)) {
                    this.right_word.setClassWord(this.left_word.isClassWord());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MODIFIER)) {
                    this.right_word.setModifier(this.left_word.isModifier());
                    continue;
                }
                if (engPropertyHolder.getName().equals(QUALIFIER)) {
                    this.right_word.setQualifier(this.left_word.isQualifier());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(DESCRIPTION)) continue;
                this.right_word.setShortDescription(this.left_word.getShortDescription());
            }
        }
        if (this.isDirty()) {
            this.right_word.setDirty(true);
        }
    }

    @Override
    public boolean isModified() {
        for (EngPropertyHolder engPropertyHolder : this.getPropertiesList()) {
            if (!engPropertyHolder.getName().equals(NAME) && engPropertyHolder.isModified()) {
                return true;
            }
            if (!engPropertyHolder.getName().equals(NAME) || !engPropertyHolder.isModified() || !engPropertyHolder.isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getID() {
        if (this.left_word != null && this.right_word != null) {
            return this.left_word.getId() + this.right_word.getId();
        }
        if (this.left_word != null) {
            return this.left_word.getId();
        }
        if (this.right_word != null) {
            return this.right_word.getId();
        }
        return "null";
    }

    protected boolean isDirty() {
        for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
            if (!engPropertyHolder.isModified() || !engPropertyHolder.isSelected()) continue;
            return true;
        }
        return false;
    }

    public EngPropertyHolder getPropertyHolderByName(String string) {
        for (EngPropertyHolder engPropertyHolder : this.getPropertiesList()) {
            if (!engPropertyHolder.getName().equals(string)) continue;
            return engPropertyHolder;
        }
        return null;
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(PLURAL);
        engPropertyHolder.setLeftValue(this.left_word != null ? this.left_word.getPlural() : "");
        engPropertyHolder.setRightValue(this.right_word != null ? this.right_word.getPlural() : "");
        if (this.left_word != null && this.right_word != null && !this.left_word.getPlural().equals(this.right_word.getPlural())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(ABBREVIATION);
        engPropertyHolder.setLeftValue(this.left_word != null ? this.left_word.getAbbreviation() : "");
        engPropertyHolder.setRightValue(this.right_word != null ? this.right_word.getAbbreviation() : "");
        if (this.left_word != null && this.right_word != null && !this.left_word.getAbbreviation().equals(this.right_word.getAbbreviation())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(ALT_ABBREVIATION);
        engPropertyHolder.setLeftValue(this.left_word != null ? this.left_word.getAltAbbrevation() : "");
        engPropertyHolder.setRightValue(this.right_word != null ? this.right_word.getAltAbbrevation() : "");
        if (this.left_word != null && this.right_word != null && !this.left_word.getAltAbbrevation().equals(this.right_word.getAltAbbrevation())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(PRIMARY_WORD);
        engPropertyHolder.setLeftValue(this.left_word != null ? String.valueOf(this.left_word.isPrimaryWord()) : "");
        engPropertyHolder.setRightValue(this.right_word != null ? String.valueOf(this.right_word.isPrimaryWord()) : "");
        if (this.left_word != null && this.right_word != null && this.left_word.isPrimaryWord() != this.right_word.isPrimaryWord()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(CLASS_WORD);
        engPropertyHolder.setLeftValue(this.left_word != null ? String.valueOf(this.left_word.isClassWord()) : "");
        engPropertyHolder.setRightValue(this.right_word != null ? String.valueOf(this.right_word.isClassWord()) : "");
        if (this.left_word != null && this.right_word != null && this.left_word.isClassWord() != this.right_word.isClassWord()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(MODIFIER);
        engPropertyHolder.setLeftValue(this.left_word != null ? String.valueOf(this.left_word.isModifier()) : "");
        engPropertyHolder.setRightValue(this.right_word != null ? String.valueOf(this.right_word.isModifier()) : "");
        if (this.left_word != null && this.right_word != null && this.left_word.isModifier() != this.right_word.isModifier()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(QUALIFIER);
        engPropertyHolder.setLeftValue(this.left_word != null ? String.valueOf(this.left_word.isQualifier()) : "");
        engPropertyHolder.setRightValue(this.right_word != null ? String.valueOf(this.right_word.isQualifier()) : "");
        if (this.left_word != null && this.right_word != null && this.left_word.isQualifier() != this.right_word.isQualifier()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
    }
}

