/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.glossary;

import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.util.options.namingstandards.NamingConstants;

public class GlossaryWord
implements NamingConstants {
    public static String EMPTY = "";
    private String name = "";
    private String abbreviation = "";
    private String altAbbrevation = "";
    private String shortDescription = "";
    private String plural = "";
    private String id = "";
    private String importID = "";
    private String type = "";
    private boolean dirty;
    private Glossary glossary;
    private boolean classWord = false;
    private boolean primaryWord = false;
    private boolean modifier = false;
    private boolean qualifier = false;

    public GlossaryWord(Glossary glossary) {
        this.glossary = glossary;
        this.dirty = true;
        glossary.setDirty(true);
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String string) {
        if (!string.equals(this.abbreviation)) {
            this.abbreviation = string;
            this.setDirty(true);
        }
    }

    public String getAltAbbrevation() {
        return this.altAbbrevation;
    }

    public void setAltAbbrevation(String string) {
        if (!string.equals(this.altAbbrevation)) {
            this.altAbbrevation = string;
            this.setDirty(true);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (!string.equals(this.name)) {
            String string2 = this.name;
            this.name = string;
            this.setDirty(true);
            this.glossary.updateMaps(string2, string, this);
        }
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String string) {
        if (!string.equals(this.shortDescription)) {
            this.shortDescription = string;
            this.setDirty(true);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        if (!string.equals(this.type)) {
            this.type = string;
            this.setDirty(true);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        if (bl) {
            this.glossary.setDirty(true);
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isClassWord() {
        return this.classWord;
    }

    public void setClassWord(boolean bl) {
        if (this.classWord != bl) {
            this.classWord = bl;
            this.setDirty(true);
        }
    }

    public boolean isModifier() {
        return this.modifier;
    }

    public void setModifier(boolean bl) {
        if (this.modifier != bl) {
            this.modifier = bl;
            this.setDirty(true);
        }
    }

    public boolean isPrimaryWord() {
        return this.primaryWord;
    }

    public void setPrimaryWord(boolean bl) {
        if (this.primaryWord != bl) {
            this.primaryWord = bl;
            this.setDirty(true);
        }
    }

    public boolean isQualifier() {
        return this.qualifier;
    }

    public void setQualifier(boolean bl) {
        if (this.qualifier != bl) {
            this.qualifier = bl;
            this.setDirty(true);
        }
    }

    public String getImportID() {
        return this.importID;
    }

    public void setImportID(String string) {
        this.importID = string;
    }

    public void copyTo(GlossaryWord glossaryWord) {
        glossaryWord.setName(this.getName());
        glossaryWord.setAbbreviation(this.getAbbreviation());
        glossaryWord.setAltAbbrevation(this.getAltAbbrevation());
        glossaryWord.setPlural(this.getPlural());
        glossaryWord.setClassWord(this.isClassWord());
        glossaryWord.setPrimaryWord(this.isPrimaryWord());
        glossaryWord.setModifier(this.isModifier());
        glossaryWord.setQualifier(this.isQualifier());
        glossaryWord.setShortDescription(this.getShortDescription());
    }

    public String getPlural() {
        return this.plural;
    }

    public void setPlural(String string) {
        this.plural = string;
    }
}

