/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.glossary;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.namingstandards.WordRule;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Glossary {
    private String name;
    private String id;
    private String description;
    private String fileName = "";
    private File file;
    private boolean dirty = false;
    private boolean newID = false;
    private boolean loaded = false;
    private int loadError = 0;
    private List words = new ArrayList();
    private static final Logger LOGGER;
    private String indent = "   ";
    private static final Comparator COMPARATOR;
    public static String GLOSSARY_TAG;
    public static String VERSION;
    public static String GLOSSARY_WORD;
    public static String WORD_NAME;
    public static String PLURAL;
    public static String ABBREVIATION;
    public static String ALT_ABBREVIATION;
    public static String SHORT_DESCRIPTION;
    public static String WORD_TYPE;
    public static String WORD_ID;
    public static String IMPORT_ID;
    public static String GL_CLASS_WORD;
    public static String GL_PRIMARY_WORD;
    public static String GL_MODIFIER;
    public static String GL_QUALIFIER;
    static String TRUE;
    public static String SPACE;
    public static String CHARACTER;
    public static String[] SEPARATOR_TYPES;
    static String MW_SEPARATOR;
    static String INCOMPLETE_MODIFIERS;
    static String CASE_SENSITIVE;
    static String SEPARATOR_TYPE;
    static String UNIQUE_ABBREVIATIONS;
    private Map wordsMap = new TreeMap();
    private Map wordsUpperCaseMap = new TreeMap();
    private char multiWordSeparator_def = (char)45;
    private boolean caseSensitive_def = false;
    private boolean incompleteModifiers_def = false;
    private String separatorType_def = CHARACTER;
    private boolean uniqueAbbreviations_def = false;
    private char multiWordSeparator = this.multiWordSeparator_def;
    private boolean caseSensitive = this.caseSensitive_def;
    private boolean incompleteModifiers = this.incompleteModifiers_def;
    private String separatorType = this.separatorType_def;
    private boolean uniqueAbbreviations = this.uniqueAbbreviations_def;
    private static File lastExpFolder;
    List nameSizeDescList = new ArrayList();
    List abbrSizeDescList = new ArrayList();
    List altAbbrSizeDescList = new ArrayList();
    Map abbreviationsMap = new TreeMap();
    Map altAbbreviationsMap = new TreeMap();
    String lastError = "";
    WordRule lastRule;
    String[] importOptions = new String[]{Messages.getString("Glossary.Update"), Messages.getString("Glossary.Skip")};
    String mess = Messages.getString("Glossary.wordsImportedBefore");

    public Glossary(File file) {
        this.file = file;
        this.id = new GUID().toString();
        this.newID = true;
        this.setDirty(true);
        if (file != null) {
            this.fileName = file.getPath();
            this.open(file);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string != null && string.equals(this.name)) {
            return;
        }
        this.name = string;
        this.setDirty(true);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getShortFileName() {
        return this.file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(File file) {
        block21: {
            if (file != null && file.isFile()) {
                if (!file.exists()) {
                    this.clearGlossary();
                } else {
                    BufferedReader bufferedReader = null;
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
                        InputSource inputSource = new InputSource(bufferedReader);
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder documentBuilder = null;
                        try {
                            documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                            // empty catch block
                        }
                        if (documentBuilder == null) break block21;
                        try {
                            Document document = documentBuilder.parse(inputSource);
                            Element element = document.getDocumentElement();
                            if (element == null) break block21;
                            String string = element.getTagName();
                            if (GLOSSARY_TAG.equalsIgnoreCase(string)) {
                                this.clearGlossary();
                                this.parseXMLDocument(element);
                                this.loaded = true;
                                this.dirty = this.newID;
                                break block21;
                            }
                            this.loaded = false;
                            this.loadError = -1;
                        }
                        catch (SAXException sAXException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public List getTerms(String string, char c, boolean bl) {
        ArrayList<NamePart> arrayList = new ArrayList<NamePart>();
        String[] stringArray = this.getWords(string, c, bl, false, false, false);
        for (int i = 0; i < stringArray.length; ++i) {
            GlossaryWord glossaryWord = null;
            stringArray[i] = stringArray[i].trim();
            glossaryWord = this.isCaseSensitive() ? (GlossaryWord)this.wordsMap.get(stringArray[i]) : (GlossaryWord)this.wordsUpperCaseMap.get(stringArray[i].toUpperCase());
            NamePart namePart = new NamePart(stringArray[i]);
            namePart.word = glossaryWord;
            namePart.existsInGlossary = glossaryWord != null;
            arrayList.add(namePart);
        }
        return arrayList;
    }

    public List getTerms(String string, char c, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[] stringArray = this.getWords(string, c, bl, bl2, bl3, bl4);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            GlossaryWord glossaryWord = null;
            if (!bl2 || bl2 && !bl4) {
                glossaryWord = this.isCaseSensitive() ? (GlossaryWord)this.wordsMap.get(stringArray[i]) : (GlossaryWord)this.wordsUpperCaseMap.get(stringArray[i].toUpperCase());
            }
            if (glossaryWord == null && bl2) {
                object = stringArray[i].toUpperCase();
                List list = (List)this.abbreviationsMap.get(object);
                if (list != null && list.size() > 0) {
                    glossaryWord = (GlossaryWord)list.get(0);
                }
                if (glossaryWord == null && (list = (List)this.altAbbreviationsMap.get(object)) != null && list.size() > 0) {
                    glossaryWord = (GlossaryWord)list.get(0);
                }
            }
            if (glossaryWord == null && stringArray.length == 1) {
                glossaryWord = this.getWordByPlural(string);
            }
            object = new NamePart(stringArray[i]);
            ((NamePart)object).word = glossaryWord;
            ((NamePart)object).existsInGlossary = glossaryWord != null;
            arrayList.add(object);
        }
        return arrayList;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public int getLoadError() {
        return this.loadError;
    }

    public GlossaryWord createGlossaryWordWithID() {
        GlossaryWord glossaryWord = this.createGlossaryWord(null);
        glossaryWord.setId(new GUID().toString());
        return glossaryWord;
    }

    public GlossaryWord createGlossaryWord(String string) {
        GlossaryWord glossaryWord = new GlossaryWord(this);
        if (string != null) {
            glossaryWord.setId(string);
        }
        this.words.add(glossaryWord);
        return glossaryWord;
    }

    public void clearGlossary() {
        this.words.clear();
        this.nameSizeDescList.clear();
        this.abbreviationsMap.clear();
        this.altAbbreviationsMap.clear();
        this.abbrSizeDescList.clear();
        this.altAbbrSizeDescList.clear();
        this.loaded = false;
        this.dirty = false;
    }

    private void parseXMLDocument(Element element) {
        String string = element.getAttribute(WORD_NAME);
        this.setName(StringUtilities.decodeAttributeValue(string));
        String string2 = element.getAttribute(SHORT_DESCRIPTION);
        this.setDescription(StringUtilities.decodeAttributeValue(string2));
        String string3 = element.getAttribute(UNIQUE_ABBREVIATIONS);
        if (string3 != null && !"".equals(string3)) {
            this.uniqueAbbreviations = "true".equalsIgnoreCase(string3);
        }
        if ((string3 = element.getAttribute(CASE_SENSITIVE)) != null && !"".equals(string3)) {
            this.caseSensitive = "true".equalsIgnoreCase(string3);
        }
        if ((string3 = element.getAttribute(INCOMPLETE_MODIFIERS)) != null && !"".equals(string3)) {
            this.incompleteModifiers = "true".equalsIgnoreCase(string3);
        }
        if ((string3 = element.getAttribute(SEPARATOR_TYPE)) != null && !"".equals(string3)) {
            this.separatorType = string3;
        }
        if ((string3 = element.getAttribute(MW_SEPARATOR)) != null && string3.length() > 0) {
            this.multiWordSeparator = string3.charAt(0);
        }
        if ((string3 = element.getAttribute(WORD_ID)) != null && !"".equals(string3)) {
            this.id = string3;
            this.newID = false;
        } else {
            if (this.id == null) {
                this.id = new GUID().toString();
            }
            this.setDirty(true);
            this.newID = true;
        }
        NodeList nodeList = element.getElementsByTagName(GLOSSARY_WORD);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string4;
            String string5;
            String string6;
            String string7;
            Element element2 = (Element)nodeList.item(i);
            String string8 = element2.getAttribute(WORD_NAME);
            if (string8 == null || "".equals(string8)) continue;
            String string9 = element2.getAttribute(WORD_ID);
            if (string9 == null || "".equals(string9)) {
                string9 = new GUID().toString();
            }
            GlossaryWord glossaryWord = this.createGlossaryWord(string9);
            String string10 = StringUtilities.decodeAttributeValue(string8);
            glossaryWord.setName(string10);
            String string11 = element2.getAttribute(PLURAL);
            if (string11 != null) {
                glossaryWord.setPlural(StringUtilities.decodeAttributeValue(string11));
            }
            if ((string7 = element2.getAttribute(ABBREVIATION)) != null) {
                glossaryWord.setAbbreviation(StringUtilities.decodeAttributeValue(string7));
            }
            if ((string6 = element2.getAttribute(ALT_ABBREVIATION)) != null) {
                glossaryWord.setAltAbbrevation(StringUtilities.decodeAttributeValue(string6));
            }
            if ((string5 = element2.getAttribute(GL_CLASS_WORD)) != null && TRUE.equalsIgnoreCase(string5)) {
                glossaryWord.setClassWord(true);
            }
            if ((string5 = element2.getAttribute(GL_PRIMARY_WORD)) != null && TRUE.equalsIgnoreCase(string5)) {
                glossaryWord.setPrimaryWord(true);
            }
            if ((string5 = element2.getAttribute(GL_MODIFIER)) != null && TRUE.equalsIgnoreCase(string5)) {
                glossaryWord.setModifier(true);
            }
            if ((string5 = element2.getAttribute(GL_QUALIFIER)) != null && TRUE.equalsIgnoreCase(string5)) {
                glossaryWord.setQualifier(true);
            }
            if ((string4 = element2.getAttribute(SHORT_DESCRIPTION)) != null) {
                glossaryWord.setShortDescription(StringUtilities.decodeAttributeValue(string4));
            }
            glossaryWord.setDirty(false);
        }
    }

    String convertName(String string) {
        String[] stringArray;
        String string2 = "";
        char c = '\u0000';
        if (string.indexOf(45) > 0) {
            stringArray = string.split("-");
            c = '-';
        } else if (string.indexOf(32) > 0) {
            stringArray = string.split(" ");
            c = ' ';
        } else {
            stringArray = new String[]{string};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = Character.toUpperCase(stringArray[i].charAt(0)) + stringArray[i].toLowerCase().substring(1, stringArray[i].length());
            string2 = i == 0 ? string3 : (c != '\u0000' ? string2 + c + string3 : string2 + string3);
        }
        return string2;
    }

    public void saveAs(ApplicationView applicationView) {
        try {
            Serializable serializable;
            URLFilter uRLFilter = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".glossary") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("Glossary.CWDGlossaryFiles");
                }
            };
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(0);
            uRLChooser.setSelectionMode(0);
            uRLChooser.setShowJarsAsDirs(false);
            uRLChooser.setURLFilter(uRLFilter);
            if (lastExpFolder != null) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastExpFolder));
            } else {
                String string = applicationView.getSettings().getDefaultSavePath();
                if (string != null && string.length() > 0) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                } else {
                    serializable = applicationView.getUserHomeDirectory();
                    if (serializable != null) {
                        uRLChooser.setSelectedURL((URL)serializable);
                    }
                }
            }
            int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("Glossary.CWDSaveGlossaryFile"));
            if (n == 0 && (serializable = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                lastExpFolder = ((File)serializable).getParentFile();
                this.saveOutput((File)serializable, applicationView, true);
            }
        }
        catch (IOException iOException) {
            LOGGER.error("", iOException);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("Glossary.CanNotwriteToFile"), iOException.getMessage()}, Messages.getString("Glossary.WriteEror"), 0);
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("Glossary.UnexpectedError"), throwable.getMessage()}, Messages.getString("Glossary.WriteError"), 0);
        }
    }

    private void saveOutput(File file, ApplicationView applicationView, boolean bl) throws IOException {
        int n;
        File file2 = file;
        String string = file2.getName().toLowerCase();
        if (!string.endsWith(".glossary") && !string.endsWith(".glossary")) {
            file2 = new File(file2.getPath() + ".glossary");
        }
        if (bl && file2.exists() && applicationView != null && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("Glossary.FileExists"), file2.getAbsolutePath()), Messages.getString("Glossary.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return;
        }
        StringBuffer stringBuffer = this.makeContent();
        file2.getParentFile().mkdirs();
        file2.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        outputStreamWriter.write(stringBuffer.toString());
        outputStreamWriter.close();
        this.file = file2;
        this.fileName = this.file.getPath();
    }

    public void save() {
        try {
            if (this.file != null) {
                this.saveOutput(this.file, null, false);
            } else {
                this.saveAs(ApplicationView.getInstance());
            }
        }
        catch (IOException iOException) {
            LOGGER.error("Glossary error during save", iOException);
        }
    }

    private GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    private StringBuffer makeContent() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MDConfiguration.getDefaultInstance().get("xml.documenttype")).append("\n");
        this.appendGlossaryBegin(stringBuffer);
        this.appendWords(stringBuffer);
        this.appendGlossaryEnd(stringBuffer);
        return stringBuffer;
    }

    private void appendGlossaryBegin(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        String string = StringUtilities.encodeAttributeValue(this.getName());
        String string2 = StringUtilities.encodeAttributeValue(this.getDescription());
        String string3 = "";
        string3 = string3 + " " + WORD_ID + "=\"" + this.id + "\"";
        if (this.incompleteModifiers != this.incompleteModifiers_def) {
            string3 = string3 + " " + INCOMPLETE_MODIFIERS + "=\"" + String.valueOf(this.incompleteModifiers) + "\"";
        }
        if (this.uniqueAbbreviations != this.uniqueAbbreviations_def) {
            string3 = string3 + " " + UNIQUE_ABBREVIATIONS + "=\"" + String.valueOf(this.uniqueAbbreviations) + "\"";
        }
        if (this.caseSensitive != this.caseSensitive_def) {
            string3 = string3 + " " + CASE_SENSITIVE + "=\"" + String.valueOf(this.caseSensitive) + "\"";
        }
        if (this.multiWordSeparator != this.multiWordSeparator_def || !this.separatorType.equalsIgnoreCase(this.separatorType_def)) {
            string3 = string3 + " " + SEPARATOR_TYPE + "=\"" + String.valueOf(this.separatorType) + "\" " + MW_SEPARATOR + "=\"" + String.valueOf(this.multiWordSeparator) + "\"";
        }
        if ("".equalsIgnoreCase(string3)) {
            stringBuffer.append("<" + GLOSSARY_TAG + " name=\"" + string + "\" " + SHORT_DESCRIPTION + "=\"" + string2 + "\" " + ">\n");
        } else {
            stringBuffer.append("<" + GLOSSARY_TAG + " name=\"" + string + "\" " + SHORT_DESCRIPTION + "=\"" + string2 + "\"" + string3 + " >\n");
        }
    }

    private void appendGlossaryEnd(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("</" + GLOSSARY_TAG + ">\n");
    }

    private void appendWords(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        for (GlossaryWord glossaryWord : this.words) {
            String string = StringUtilities.encodeAttributeValue(glossaryWord.getName());
            String string2 = StringUtilities.encodeAttributeValue(glossaryWord.getPlural());
            String string3 = StringUtilities.encodeAttributeValue(glossaryWord.getAbbreviation());
            String string4 = StringUtilities.encodeAttributeValue(glossaryWord.getAltAbbrevation());
            String string5 = StringUtilities.encodeAttributeValue(glossaryWord.getShortDescription());
            String string6 = "";
            if (glossaryWord.isClassWord()) {
                string6 = string6 + " " + GL_CLASS_WORD + "=\"true\"";
            }
            if (glossaryWord.isPrimaryWord()) {
                string6 = string6 + " " + GL_PRIMARY_WORD + "=\"true\"";
            }
            if (glossaryWord.isModifier()) {
                string6 = string6 + " " + GL_MODIFIER + "=\"true\"";
            }
            if (glossaryWord.isQualifier()) {
                string6 = string6 + " " + GL_QUALIFIER + "=\"true\"";
            }
            stringBuffer.append(this.indent + "<" + GLOSSARY_WORD + " name=\"" + string + "\" " + PLURAL + "=\"" + string2 + "\" " + ABBREVIATION + "=\"" + string3 + "\" " + ALT_ABBREVIATION + "=\"" + string4 + "\"" + string6 + " " + WORD_ID + "=\"" + glossaryWord.getId() + "\" " + IMPORT_ID + "=\"" + glossaryWord.getImportID() + "\" " + SHORT_DESCRIPTION + "=\"" + string5 + "\" " + "/>\n");
        }
    }

    public List getWords() {
        return this.words;
    }

    public GlossaryWord getWordByName(String string) {
        for (GlossaryWord glossaryWord : this.words) {
            if (!string.equals(glossaryWord.getName())) continue;
            return glossaryWord;
        }
        return null;
    }

    public GlossaryWord getDifferentWordByName(String string, GlossaryWord glossaryWord) {
        for (GlossaryWord glossaryWord2 : this.words) {
            if (glossaryWord2 == glossaryWord || !string.equals(glossaryWord2.getName())) continue;
            return glossaryWord2;
        }
        return null;
    }

    public boolean removeWord(GlossaryWord glossaryWord) {
        return this.words.remove(glossaryWord);
    }

    public void clearDirtyFlag() {
        for (GlossaryWord glossaryWord : this.words) {
            glossaryWord.setDirty(false);
        }
        this.setDirty(false);
    }

    private String[] getWords(String string, char c, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        char c2 = this.getMW_SeparatorChar();
        if (!bl) {
            if (c2 != c && c != '\u0000') {
                return string.split(String.valueOf(c));
            }
            return this.getWordsWithReverseScan(string, c, bl2, bl3, bl4);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (Character.isUpperCase(c3)) {
                String string2;
                boolean bl5 = false;
                if (i > 0 && string.charAt(i - 1) == c2) {
                    bl5 = true;
                }
                if (!bl5 && !"".equals(string2 = stringBuffer.toString().trim())) {
                    arrayList.add(string2);
                    stringBuffer.setLength(0);
                }
                stringBuffer.append(c3);
                continue;
            }
            stringBuffer.append(c3);
        }
        String string3 = stringBuffer.toString().trim();
        if (!"".equals(string3)) {
            arrayList.add(string3);
            stringBuffer.setLength(0);
        }
        return arrayList.toArray(new String[0]);
    }

    public void prepareUtilityMaps() {
        WordNameSizeDescComparator wordNameSizeDescComparator = new WordNameSizeDescComparator();
        WordAbbrevSizeDescComparator wordAbbrevSizeDescComparator = new WordAbbrevSizeDescComparator();
        WordAltAbbrevNameSizeDescComparator wordAltAbbrevNameSizeDescComparator = new WordAltAbbrevNameSizeDescComparator();
        this.nameSizeDescList.clear();
        this.abbreviationsMap.clear();
        this.altAbbreviationsMap.clear();
        this.altAbbrSizeDescList.clear();
        this.altAbbrSizeDescList.clear();
        this.nameSizeDescList.addAll(this.words);
        Collections.sort(this.nameSizeDescList, wordNameSizeDescComparator);
        for (GlossaryWord glossaryWord : this.words) {
            List<GlossaryWord> list;
            String string;
            if (!"".equals(glossaryWord.getAbbreviation().trim())) {
                string = glossaryWord.getAbbreviation().toUpperCase();
                list = (ArrayList<GlossaryWord>)this.abbreviationsMap.get(string);
                if (list == null) {
                    list = new ArrayList<GlossaryWord>();
                }
                list.add(glossaryWord);
                this.abbreviationsMap.put(string, list);
                this.abbrSizeDescList.add(glossaryWord);
            }
            if ("".equals(glossaryWord.getAltAbbrevation().trim())) continue;
            string = glossaryWord.getAltAbbrevation().toUpperCase();
            list = (List)this.altAbbreviationsMap.get(string);
            if (list == null) {
                list = new ArrayList();
            }
            list.add(glossaryWord);
            this.altAbbreviationsMap.put(string, list);
            this.altAbbrSizeDescList.add(glossaryWord);
        }
        Collections.sort(this.abbrSizeDescList, wordAbbrevSizeDescComparator);
        Collections.sort(this.altAbbrSizeDescList, wordAltAbbrevNameSizeDescComparator);
    }

    /*
     * WARNING - void declaration
     */
    private String[] getWordsWithReverseScan(String string, char c, boolean bl, boolean bl2, boolean bl3) {
        String string2;
        Object object;
        Object object3;
        Object object4;
        String string3 = "";
        if (c != '\u0000') {
            string3 = String.valueOf(c);
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        String string4 = string;
        if (!this.isCaseSensitive()) {
            string4 = string.toUpperCase();
        }
        linkedList.add(string4);
        if (!bl) {
            object4 = new ArrayList();
            if (!bl || bl && !bl3) {
                object4.addAll(this.nameSizeDescList);
            }
            object3 = object4.iterator();
            block0: while (object3.hasNext() && this.hasString(linkedList)) {
                GlossaryWord object22 = (GlossaryWord)object3.next();
                object = object22.getName();
                if (!this.isCaseSensitive()) {
                    object = ((String)object).toUpperCase();
                }
                Object[] objectArray = linkedList.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    String string5;
                    int n;
                    if (!(objectArray[i] instanceof String) || (n = (string5 = (String)objectArray[i]).indexOf((String)object)) <= -1 || n > 0 && c != '\u0000' && string5.charAt(n - 1) != c) continue;
                    string2 = string5.substring(0, n);
                    String string6 = "";
                    if (n + ((String)object).length() + 1 < string5.length()) {
                        string6 = string5.substring(n + ((String)object).length());
                    }
                    linkedList.set(i, object22);
                    if (!"".equals(string6)) {
                        linkedList.add(i + 1, string6);
                    }
                    if ("".equals(string2) || string3.equalsIgnoreCase(string2)) continue block0;
                    linkedList.add(i, string2);
                    continue block0;
                }
            }
        }
        if (bl) {
            object4 = this.abbrSizeDescList.iterator();
            block2: while (object4.hasNext() && this.hasString(linkedList)) {
                object3 = (GlossaryWord)object4.next();
                String string7 = ((GlossaryWord)object3).getAbbreviation();
                if (!this.isCaseSensitive()) {
                    String string8 = string7.toUpperCase();
                }
                object = linkedList.toArray();
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    void var11_15;
                    String string9;
                    int n;
                    if (!(object[i] instanceof String) || (n = (string9 = (String)object[i]).indexOf((String)var11_15)) <= -1) continue;
                    String string10 = string9.substring(0, n);
                    string2 = "";
                    if (n + var11_15.length() + 1 < string9.length()) {
                        string2 = string9.substring(n + var11_15.length());
                    }
                    linkedList.set(i, object3);
                    if (!"".equals(string2)) {
                        linkedList.add(i + 1, string2);
                    }
                    if ("".equals(string10) || string3.equalsIgnoreCase(string10)) continue block2;
                    linkedList.add(i, string10);
                    continue block2;
                }
            }
            object4 = this.altAbbrSizeDescList.iterator();
            block4: while (object4.hasNext() && this.hasString(linkedList)) {
                object3 = (GlossaryWord)object4.next();
                String string11 = ((GlossaryWord)object3).getAltAbbrevation();
                if (!this.isCaseSensitive()) {
                    String string12 = string11.toUpperCase();
                }
                object = linkedList.toArray();
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    void var11_19;
                    String string13;
                    int n;
                    if (!(object[i] instanceof String) || (n = (string13 = (String)object[i]).indexOf((String)var11_19)) <= -1) continue;
                    String string14 = string13.substring(0, n);
                    string2 = "";
                    if (n + var11_19.length() + 1 < string13.length()) {
                        string2 = string13.substring(n + var11_19.length());
                    }
                    linkedList.set(i, object3);
                    if (!"".equals(string2)) {
                        linkedList.add(i + 1, string2);
                    }
                    if ("".equals(string14) || string3.equalsIgnoreCase(string14)) continue block4;
                    linkedList.add(i, string14);
                    continue block4;
                }
            }
        }
        object4 = new ArrayList();
        for (Object e : linkedList) {
            if (e instanceof GlossaryWord) {
                object4.add(((GlossaryWord)e).getName());
                continue;
            }
            if (!(e instanceof String)) continue;
            object4.add(e);
        }
        return object4.toArray(new String[0]);
    }

    private boolean hasString(List list) {
        for (Object e : list) {
            if (!(e instanceof String)) continue;
            return true;
        }
        return false;
    }

    private boolean isConfirmToRules(List list, List list2, boolean bl, boolean bl2) {
        if (list.size() > list2.size()) {
            this.lastError = MessageFormat.format(Messages.getString("Glossary.NameHasNWords"), list.size(), list2.size());
            return false;
        }
        Iterator iterator = list.iterator();
        String string = "";
        int n = 0;
        boolean bl3 = true;
        while (iterator.hasNext()) {
            NamePart namePart = (NamePart)iterator.next();
            if (namePart.word != null || this.isIncompleteModifiers()) continue;
            ++n;
            if (bl3) {
                string = "'" + namePart.namePart + "'";
                bl3 = false;
                continue;
            }
            string = string + " , " + "'" + namePart.namePart + "'";
        }
        if (!"".equals(string)) {
            this.lastError = bl && bl2 ? (n > 1 ? MessageFormat.format(Messages.getString("Glossary.PartsAreNotDefinedAsAbbreviations"), string, this.getName()) : MessageFormat.format(Messages.getString("Glossary.PartsIsNotDefinedAsAbbreviations"), string, this.getName())) : (n > 1 ? MessageFormat.format(Messages.getString("Glossary.PartsAreNotDefinedInGlossary"), string, this.getName()) : MessageFormat.format(Messages.getString("Glossary.PartsIsNotDefinedInGlossary"), string, this.getName()));
            return false;
        }
        return this.confirmToRules(list, 0, list2, 0);
    }

    private boolean isConfirmToGlossary(List list, boolean bl, boolean bl2) {
        Iterator iterator = list.iterator();
        String string = "";
        int n = 0;
        boolean bl3 = true;
        while (iterator.hasNext()) {
            NamePart namePart = (NamePart)iterator.next();
            if (namePart.word != null || this.isIncompleteModifiers()) continue;
            ++n;
            if (bl3) {
                string = "'" + namePart.namePart + "'";
                bl3 = false;
                continue;
            }
            string = string + " , " + "'" + namePart.namePart + "'";
        }
        if (!"".equals(string)) {
            this.lastError = bl && bl2 ? (n > 1 ? MessageFormat.format(Messages.getString("Glossary.PartsAreNotDefinedAsAbbreviations"), string, this.getName()) : MessageFormat.format(Messages.getString("Glossary.PartsIsNotDefinedAsAbbreviations"), string, this.getName())) : (n > 1 ? MessageFormat.format(Messages.getString("Glossary.PartsAreNotDefinedInGlossary"), string, this.getName()) : MessageFormat.format(Messages.getString("Glossary.PartsIsNotDefinedInGlossary"), string, this.getName()));
            return false;
        }
        return true;
    }

    private boolean confirmToRules(List list, int n, List list2, int n2) {
        int n3;
        NamePart namePart = (NamePart)list.get(n);
        int n4 = list.size() - 1 - n;
        if (n4 > (n3 = list2.size() - 1 - n2)) {
            this.lastError = Messages.getString("Glossary.NameDoesntMatch");
            return false;
        }
        for (int i = n2; i < list2.size() - n4; ++i) {
            WordRule wordRule;
            this.lastRule = wordRule = (WordRule)list2.get(i);
            boolean bl = this.areCompatible(namePart, wordRule);
            if (bl) {
                if (n4 == 0) {
                    if (n3 == 0) {
                        return true;
                    }
                    WordRule wordRule2 = this.getFirstMandatoryRule(list2, i + 1);
                    if (wordRule2 != null) {
                        this.lastError = MessageFormat.format(Messages.getString("Glossary.MissingMandatory"), wordRule2.getWordType());
                        return false;
                    }
                    return true;
                }
                if (n3 == 0 || i == list2.size() - 1) {
                    this.lastError = Messages.getString("Glossary.NametooLong");
                    return false;
                }
                boolean bl2 = this.confirmToRules(list, n + 1, list2, i + 1);
                if (bl2) {
                    return true;
                }
            }
            if (!wordRule.isMandatory()) continue;
            this.lastError = MessageFormat.format(Messages.getString("Glossary.MissingWordOfType"), this.lastError, this.lastRule.getWordType());
            return false;
        }
        this.lastError = Messages.getString("Glossary.166");
        return false;
    }

    private boolean areCompatible(NamePart namePart, WordRule wordRule) {
        if (namePart.word == null) {
            if (this.isIncompleteModifiers()) {
                return wordRule.getWordType().equals("Modifier") || wordRule.getWordType().equals("Qualifier");
            }
            return false;
        }
        if (wordRule.getWordType().equals("Modifier") && namePart.word.isModifier()) {
            return true;
        }
        if (wordRule.getWordType().equals("Prime Word") && namePart.word.isPrimaryWord()) {
            return true;
        }
        if (wordRule.getWordType().equals("Class Word") && namePart.word.isClassWord()) {
            return true;
        }
        return wordRule.getWordType().equals("Qualifier") && namePart.word.isQualifier();
    }

    private WordRule getFirstMandatoryRule(List list, int n) {
        for (int i = n; i < list.size(); ++i) {
            WordRule wordRule = (WordRule)list.get(i);
            if (!wordRule.isMandatory()) continue;
            return wordRule;
        }
        return null;
    }

    public String checkValidName(String string, List list, char c, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.lastError = "";
        this.lastRule = null;
        List list2 = bl3 ? this.getTerms(string, c, bl, bl3, bl2, bl4) : this.getTerms(string, c, bl);
        boolean bl5 = false;
        bl5 = list.size() > 0 ? this.isConfirmToRules(list2, list, bl3, bl4) : this.isConfirmToGlossary(list2, bl3, bl4);
        if (bl5) {
            return null;
        }
        return this.lastError;
    }

    public void updateMaps(String string, String string2, GlossaryWord glossaryWord) {
        if (string != null && !"".equalsIgnoreCase(string)) {
            GlossaryWord glossaryWord2 = (GlossaryWord)this.wordsMap.remove(string);
            if (glossaryWord2 != glossaryWord) {
                throw new RuntimeException(MessageFormat.format(Messages.getString("Glossary.InconsistencyInGlossaryNormalMap"), string, string2));
            }
            glossaryWord2 = (GlossaryWord)this.wordsUpperCaseMap.remove(string.toUpperCase());
            if (glossaryWord2 != glossaryWord) {
                throw new RuntimeException(MessageFormat.format(Messages.getString("Glossary.InconsistencyInGlossaryUpperCaseMap"), string, string2));
            }
            this.wordsMap.put(string2, glossaryWord);
            this.wordsUpperCaseMap.put(string2.toUpperCase(), glossaryWord);
        } else if (string != null && "".equalsIgnoreCase(string)) {
            this.wordsMap.put(string2, glossaryWord);
            this.wordsUpperCaseMap.put(string2.toUpperCase(), glossaryWord);
        }
    }

    public void sortWords() {
        Collections.sort(this.words, COMPARATOR);
    }

    public char getMultiWordSeparator() {
        return this.multiWordSeparator;
    }

    public void setMultiWordSeparator(char c) {
        if (this.multiWordSeparator != c) {
            this.multiWordSeparator = c;
            this.setDirty(true);
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        if (this.caseSensitive != bl) {
            this.caseSensitive = bl;
            this.setDirty(true);
        }
    }

    public void setIncompleteModifiers(boolean bl) {
        if (this.incompleteModifiers != bl) {
            this.incompleteModifiers = bl;
            this.setDirty(true);
        }
    }

    public boolean isIncompleteModifiers() {
        return this.incompleteModifiers;
    }

    public String getSeparatorType() {
        return this.separatorType;
    }

    public void setSeparatorType(String string) {
        if (!this.separatorType.equalsIgnoreCase(string)) {
            this.separatorType = string;
            this.setDirty(true);
        }
    }

    public boolean isUniqueAbbreviations() {
        return this.uniqueAbbreviations;
    }

    public void setUniqueAbbreviations(boolean bl) {
        if (this.uniqueAbbreviations != bl) {
            this.uniqueAbbreviations = bl;
            this.setDirty(true);
        }
    }

    public char getMW_SeparatorChar() {
        if (this.separatorType.equalsIgnoreCase(SPACE)) {
            return ' ';
        }
        return this.multiWordSeparator;
    }

    public String validateMultiWordsForSpaces(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        if (' ' != c) {
            boolean bl = true;
            for (GlossaryWord glossaryWord : this.words) {
                if (glossaryWord.getName().trim().indexOf(32) <= 0) continue;
                if (bl) {
                    bl = false;
                    stringBuffer.append(MessageFormat.format(Messages.getString("Glossary.CurrentSeparatorSetTo"), Character.valueOf(c)));
                    stringBuffer.append(Messages.getString("Glossary.ThereAreWordsWithSPACECharacter"));
                    stringBuffer.append("\n").append(glossaryWord.getName());
                    continue;
                }
                stringBuffer.append("\n").append(glossaryWord.getName());
            }
        }
        return stringBuffer.toString();
    }

    public void replaceSeparator(char c, char c2) {
        for (GlossaryWord glossaryWord : this.words) {
            String string = glossaryWord.getName().trim();
            String string2 = string.replaceAll("\\" + String.valueOf(c), "\\" + String.valueOf(c2));
            glossaryWord.setName(string2);
        }
    }

    public List getWordsWithNoneUniqueAbbreviations() {
        Object object;
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        TreeMap treeMap = new TreeMap();
        for (Object object2 : this.words) {
            if ("".equals(((GlossaryWord)object2).getAbbreviation().trim())) {
                arrayList2.add(object2);
                continue;
            }
            object = ((GlossaryWord)object2).getAbbreviation().toUpperCase();
            List<Object> list = (ArrayList<Object>)treeMap.get(object);
            if (list == null) {
                list = new ArrayList<Object>();
            }
            list.add(object2);
            treeMap.put(object, list);
            object = ((GlossaryWord)object2).getAltAbbrevation();
            if ("".equalsIgnoreCase((String)object)) continue;
            list = (List)treeMap.get(object = ((String)object).toUpperCase());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(object2);
            treeMap.put(object, list);
        }
        for (Object object2 : treeMap.keySet()) {
            object = (List)treeMap.get(object2);
            if (object.size() <= 1) continue;
            arrayList.addAll(object);
        }
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importERwinGlossaryFile(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            String string;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), IdeUtil.getIdeEncoding());
            bufferedReader = new BufferedReader(inputStreamReader);
            ArrayList arrayList = new ArrayList();
            while ((string = bufferedReader.readLine()) != null) {
                this.parseERwinLine(string, stringBuffer, arrayList);
            }
            if (arrayList.size() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(Messages.getString("Glossary.UnclassifiedWordsS"));
                } else {
                    stringBuffer.append(Messages.getString("Glossary.UnclassifiedWords"));
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringBuffer.append(arrayList.get(i)).append("\n");
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuffer.toString();
    }

    private void parseERwinLine(String string, StringBuffer stringBuffer, List list) {
        if (!"".equalsIgnoreCase(string)) {
            String[] stringArray;
            int n = string.length() - 1;
            String string2 = string;
            if (string.charAt(n) == ',') {
                string2 = string.substring(0, n);
            }
            if ((stringArray = string2.split(",")).length > 0) {
                GlossaryWord glossaryWord = (GlossaryWord)this.wordsUpperCaseMap.get(stringArray[0].toUpperCase());
                if (glossaryWord != null) {
                    stringBuffer.append(Messages.getString("Glossary.NameExists")).append(" - ").append(string).append("\n");
                } else {
                    glossaryWord = this.createGlossaryWordWithID();
                    glossaryWord.setName(stringArray[0]);
                    if (stringArray.length > 1 && !"".equalsIgnoreCase(stringArray[1])) {
                        glossaryWord.setAbbreviation(stringArray[1]);
                    }
                    if (stringArray.length > 2 && !"".equalsIgnoreCase(stringArray[2])) {
                        glossaryWord.setAltAbbrevation(stringArray[2]);
                    }
                    boolean bl = false;
                    if (stringArray.length > 3 && !"".equalsIgnoreCase(stringArray[3]) && "X".equalsIgnoreCase(stringArray[3])) {
                        glossaryWord.setPrimaryWord(true);
                        bl = true;
                    }
                    if (stringArray.length > 4 && !"".equalsIgnoreCase(stringArray[4]) && "X".equalsIgnoreCase(stringArray[4])) {
                        glossaryWord.setModifier(true);
                        bl = true;
                    }
                    if (stringArray.length > 5 && !"".equalsIgnoreCase(stringArray[5]) && "X".equalsIgnoreCase(stringArray[5])) {
                        glossaryWord.setModifier(true);
                        bl = true;
                    }
                    if (stringArray.length > 6 && !"".equalsIgnoreCase(stringArray[6]) && "X".equalsIgnoreCase(stringArray[6])) {
                        glossaryWord.setClassWord(true);
                        bl = true;
                    }
                    if (stringArray.length > 7 && !"".equalsIgnoreCase(stringArray[7])) {
                        String string3 = "";
                        for (int i = 7; i < stringArray.length; ++i) {
                            string3 = i == 7 ? stringArray[i] : string3 + ',' + stringArray[i];
                        }
                        glossaryWord.setShortDescription(string3);
                    }
                    if (!bl) {
                        list.add(string);
                    }
                }
            } else {
                stringBuffer.append(string).append("\n");
            }
        }
    }

    public String importGlossary(File file, ApplicationView applicationView) {
        JCheckBox jCheckBox = new JCheckBox(Messages.getString("Glossary.ApplyForAll"));
        Object[] objectArray = new Object[]{this.mess, Messages.getString("Glossary.OldL"), Messages.getString("Glossary.NewL"), jCheckBox};
        StringBuffer stringBuffer = new StringBuffer();
        TreeMap<String, GlossaryWord> treeMap = new TreeMap<String, GlossaryWord>();
        for (GlossaryWord glossaryWord : this.words) {
            if ("".equalsIgnoreCase(glossaryWord.getImportID())) continue;
            treeMap.put(glossaryWord.getImportID(), glossaryWord);
        }
        int n = -1;
        Glossary glossary = new Glossary(file);
        for (GlossaryWord glossaryWord : glossary.getWords()) {
            GlossaryWord glossaryWord2 = (GlossaryWord)treeMap.get(glossaryWord.getId());
            if (glossaryWord2 == null) {
                String string;
                if (this.isCaseSensitive()) {
                    string = glossaryWord.getName().trim();
                    glossaryWord2 = (GlossaryWord)this.wordsMap.get(string);
                } else {
                    string = glossaryWord.getName().trim().toUpperCase();
                    glossaryWord2 = (GlossaryWord)this.wordsMap.get(string);
                }
                if (glossaryWord2 != null) {
                    stringBuffer.append(Messages.getString("Glossary.NameExists")).append(glossaryWord2.getName()).append("\n");
                    continue;
                }
                GlossaryWord glossaryWord3 = this.createGlossaryWordWithID();
                glossaryWord.copyTo(glossaryWord3);
                glossaryWord3.setImportID(glossaryWord.getId());
                continue;
            }
            if (!jCheckBox.isSelected()) {
                objectArray[1] = MessageFormat.format(Messages.getString("Glossary.Old"), glossaryWord2.getName());
                objectArray[2] = MessageFormat.format(Messages.getString("Glossary.New"), glossaryWord.getName());
                n = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), objectArray, Messages.getString("Glossary.WordsImport"), 0, 3, null, this.importOptions, this.importOptions[0]);
            }
            if (n != 0) continue;
            glossaryWord.copyTo(glossaryWord2);
        }
        return stringBuffer.toString();
    }

    public void exportAsCSVFile(File file, ApplicationView applicationView) throws IOException {
        int n;
        if (file.exists() && applicationView != null && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("Glossary.FileExists"), file.getAbsolutePath()), Messages.getString("Glossary.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return;
        }
        StringBuffer stringBuffer = this.makeExportContent();
        file.getParentFile().mkdirs();
        file.createNewFile();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), IdeUtil.getIdeEncoding());
        outputStreamWriter.write(stringBuffer.toString());
        outputStreamWriter.flush();
        outputStreamWriter.close();
    }

    private StringBuffer makeExportContent() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendFirstRow(stringBuffer);
        this.appendRows(stringBuffer);
        return stringBuffer;
    }

    private void appendFirstRow(StringBuffer stringBuffer) {
        stringBuffer.append(MessageFormat.format(Messages.getString("Glossary.NameAbbreviationAltAbbreviation"), "\n"));
    }

    private void appendRows(StringBuffer stringBuffer) {
        for (GlossaryWord glossaryWord : this.words) {
            String string = glossaryWord.getName().trim();
            if ("".equals(string)) continue;
            stringBuffer.append(string).append(",");
            String string2 = glossaryWord.getAbbreviation().trim();
            if (!"".equals(string2)) {
                stringBuffer.append(string2).append(",");
            } else {
                stringBuffer.append(",");
            }
            string2 = glossaryWord.getAltAbbrevation().trim();
            if (!"".equals(string2)) {
                stringBuffer.append(string2).append(",");
            } else {
                stringBuffer.append(",");
            }
            if (glossaryWord.isPrimaryWord()) {
                stringBuffer.append("X,");
            } else {
                stringBuffer.append(",");
            }
            if (glossaryWord.isClassWord()) {
                stringBuffer.append("X,");
            } else {
                stringBuffer.append(",");
            }
            if (glossaryWord.isModifier()) {
                stringBuffer.append("X,");
            } else {
                stringBuffer.append(",");
            }
            if (glossaryWord.isQualifier()) {
                stringBuffer.append("X,");
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append("" + glossaryWord.getShortDescription().replaceAll("\\n+", " "));
            stringBuffer.append("\n");
        }
    }

    public GlossaryWord getWordByPlural(String string) {
        if (string != null && !"".equals(string)) {
            for (GlossaryWord glossaryWord : this.words) {
                if (!(this.isCaseSensitive() ? string.equals(glossaryWord.getPlural()) : string.equalsIgnoreCase(glossaryWord.getPlural()))) continue;
                return glossaryWord;
            }
        }
        return null;
    }

    static {
        COMPARATOR = new StringComparator();
        GLOSSARY_TAG = "cwd_glossary";
        VERSION = "version";
        GLOSSARY_WORD = "glossaryWord";
        WORD_NAME = "name";
        PLURAL = "plural";
        ABBREVIATION = "abbreviation";
        ALT_ABBREVIATION = "alt_abbreviation";
        SHORT_DESCRIPTION = "description";
        WORD_TYPE = "type";
        WORD_ID = "id";
        IMPORT_ID = "import_id";
        GL_CLASS_WORD = "class_word";
        GL_PRIMARY_WORD = "primary_word";
        GL_MODIFIER = "modifier";
        GL_QUALIFIER = "qualifier";
        TRUE = "true";
        SPACE = "Space";
        CHARACTER = "Character";
        SEPARATOR_TYPES = new String[]{CHARACTER, SPACE};
        MW_SEPARATOR = "mw_separator";
        INCOMPLETE_MODIFIERS = "incomplete_modifiers";
        CASE_SENSITIVE = "case_sensitive";
        SEPARATOR_TYPE = "separator_type";
        UNIQUE_ABBREVIATIONS = "unique_abbreviations";
        lastExpFolder = null;
        LOGGER = new Logger(Glossary.class);
    }

    public static class WordAltAbbrevNameSizeDescComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            int n2 = ((GlossaryWord)object).getAltAbbrevation().length();
            if (n2 < (n = ((GlossaryWord)object2).getAltAbbrevation().length())) {
                return 1;
            }
            if (n2 > n) {
                return -1;
            }
            return 0;
        }
    }

    public static class WordAbbrevSizeDescComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            int n2 = ((GlossaryWord)object).getAbbreviation().length();
            if (n2 < (n = ((GlossaryWord)object2).getAbbreviation().length())) {
                return 1;
            }
            if (n2 > n) {
                return -1;
            }
            return 0;
        }
    }

    public static class WordNameSizeDescComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            int n2 = ((GlossaryWord)object).getName().length();
            if (n2 < (n = ((GlossaryWord)object2).getName().length())) {
                return 1;
            }
            if (n2 > n) {
                return -1;
            }
            return 0;
        }
    }

    public class NamePart {
        public String namePart;
        boolean existsInGlossary = false;
        public GlossaryWord word;

        NamePart(String string) {
            this.namePart = string;
        }
    }

    public static class StringComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }
}

