/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.engineering.AbstractEngineering;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.FK_RelationComparator;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.FKAttributeManager;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.logging.Logger;

public class ReverseEngineering
extends AbstractEngineering {
    private boolean notForNewObjects = false;
    private String typeName = "";
    private List properties = new ArrayList();
    private static final Logger LOGGER = new Logger(ReverseEngineering.class);
    private List fkeys = new ArrayList();

    public ReverseEngineering(Design design) {
        super(design);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Map map) {
        this.comparatorsMap = map;
        AbstractEngineering.useSameOptionForAll = false;
        this.design.setPropagatePKChahges(false);
        this.design.getLogicalDesign().getMainView().getUndoManager().setLocked(true);
        this.targetDesPartID = this.design.getLogicalDesign().getObjectID();
        try {
            DesignObject designObject;
            this.xmap = this.design.getRelationalDesign().getRMExtendedMap();
            this.fkeys.clear();
            this.notForNewObjects = this.design.getNotForNewObjects();
            if (!this.design.getRelationalDesign().getMainView().isAutoRoute()) {
                this.design.getLogicalDesign().getMainView().setAutoRoute(false);
                this.design.getLogicalDesign().getMainView().getWorkSpace().updateSettings();
            }
            this.design.getRelationalDesign().getFKIndexAssociationSet().addAllElementsTo(this.fkeys);
            try {
                FKAttributeManager.CAN_SYNCHRONIZE = false;
                this.processTables();
                this.processForeignKeys();
            }
            finally {
                FKAttributeManager.CAN_SYNCHRONIZE = true;
                try {
                    Iterator iterator = this.design.getLogicalDesign().getRelationSet().iterator();
                    while (iterator.hasNext()) {
                        designObject = (Relation)iterator.next();
                        ((Relation)designObject).getFKAttributeManager().reSync();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            for (int i = 0; i < this.fkeys.size(); ++i) {
                designObject = (FKIndexAssociation)this.fkeys.get(i);
                this.processSelfRefColumns((FKIndexAssociation)designObject);
            }
            Iterator iterator = this.design.getLogicalDesign().getGlobalCandidateKeySet().iterator();
            while (iterator.hasNext()) {
                designObject = (CandidateKey)iterator.next();
                ((CandidateKey)designObject).updateContainedObjects();
            }
            this.setColumnsScopeId();
            this.processTableViews();
            this.processTypeSubstitutions();
            this.engineerAllSubviews(this.design);
            this.resetRelationTopViews();
            this.processArcs();
            this.processSQLNames();
            if (this.design.getLogicalDesign().getMainView().isAutoRoute()) {
                this.design.getLogicalDesign().getMainView().getWorkSpace().updateSettings();
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("ReverseEngineering.execute()", runtimeException);
            runtimeException.printStackTrace();
        }
        finally {
            this.design.setPropagatePKChahges(true);
            this.design.getLogicalDesign().getMainView().getUndoManager().setLocked(false);
        }
    }

    private void processTables() {
        Iterator iterator = this.design.getRelationalDesign().getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (table.isMtoNjoinCandidate()) continue;
            this.processTable(table);
        }
    }

    private void processTable(Table table) {
        if (!table.isMtoNjoinCandidate()) {
            List list;
            Relation relation = (Relation)table.getDesign().getLogicalDesign().getRelationSet().getObjectGeneratedBy(table);
            if (relation != null) {
                relation.remove();
            }
            if ((list = this.xmap.getMappingsForDesignPart(table, this.targetDesPartID)).size() == 0) {
                if (table.shouldBeEngineered()) {
                    XtdMapping xtdMapping;
                    String string = this.getDesign().transformNameFromRelationalToLogical(table);
                    Entity entity = this.design.getLogicalDesign().createEntity(string);
                    XtdMapping xtdMapping2 = this.xmap.createMapping(entity, table);
                    xtdMapping2.initializeContained();
                    this.copyPropertiesFromTableToEntity(table, entity);
                    if (this.design.isEngineerCoordinates()) {
                        this.setGraphicalPropertiesOnNewObject(table, entity);
                    }
                    if ((xtdMapping = table.getDeletedMapping()) != null) {
                        table.updateDeletedMappings(xtdMapping.getDeletedID(), entity.getObjectID(), entity.getDesignPartId());
                        this.xmap.removeMapping(xtdMapping);
                    }
                    if (table.getBasedOnStructuredType() == null) {
                        this.processColumns(table, entity, xtdMapping2);
                    } else {
                        this.processColumnsBST(table, entity, xtdMapping2);
                    }
                    this.processIndexes(table, entity, xtdMapping2);
                }
            } else {
                for (XtdMapping xtdMapping : list) {
                    DesignObject designObject;
                    if (!xtdMapping.isRevEngineer() || (designObject = xtdMapping.getObjectMappedTo(table)) == null || !(designObject instanceof Entity)) continue;
                    Entity entity = (Entity)designObject;
                    EngPropertiesComparator engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(table.getObjectID() + entity.getObjectID());
                    if (engPropertiesComparator != null) {
                        engPropertiesComparator.copySelectedProperties();
                    }
                    if (this.design.isEngineerCoordinates()) {
                        this.setGraphicalPropertiesOnNewObject(table, entity);
                    }
                    if (table.getBasedOnStructuredType() == null) {
                        this.processColumns(table, entity, xtdMapping);
                    } else {
                        this.processColumnsBST(table, entity, xtdMapping);
                    }
                    this.processIndexes(table, entity, xtdMapping);
                }
            }
        }
    }

    private void processIndexes() {
        Iterator iterator = this.design.getRelationalDesign().getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (table.isMtoNjoinCandidate()) continue;
            this.processTable(table);
        }
    }

    private void processTableIndexes(Table table) {
        if (!table.isMtoNjoinCandidate()) {
            Relation relation = (Relation)table.getDesign().getLogicalDesign().getRelationSet().getObjectGeneratedBy(table);
            if (relation != null) {
                relation.remove();
            }
            List list = this.xmap.getMappingsForDesignPart(table, this.targetDesPartID);
            for (XtdMapping xtdMapping : list) {
                DesignObject designObject;
                if (!xtdMapping.isRevEngineer() || (designObject = xtdMapping.getObjectMappedTo(table)) == null || !(designObject instanceof Entity)) continue;
                Entity entity = (Entity)designObject;
                this.processIndexes(table, entity, xtdMapping);
            }
        }
    }

    private void processTypeSubstitutions() {
        Iterator iterator = this.design.getRelationalDesign().getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (table.isMtoNjoinCandidate() || !table.isBST()) continue;
            this.processTableTypeSubstitution(table);
        }
    }

    private void processTableTypeSubstitution(Table table) {
        List list;
        if (!table.isMtoNjoinCandidate() && (list = this.xmap.getMappingsForDesignPart(table, this.targetDesPartID)).size() > 0) {
            for (XtdMapping xtdMapping : list) {
                ObjectListener objectListener;
                TVTypeSubstitution tVTypeSubstitution;
                DesignPartView designPartView;
                DesignPartView designPartView2;
                DesignObject designObject;
                if (!xtdMapping.isRevEngineer() || (designObject = xtdMapping.getObjectMappedTo(table)) == null || !(designObject instanceof Entity)) continue;
                Entity entity = (Entity)designObject;
                EngPropertiesComparator engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(table.getObjectID() + entity.getObjectID());
                if (engPropertiesComparator == null) {
                    engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(table.getObjectID());
                }
                if (engPropertiesComparator == null) continue;
                EngPropertyHolder engPropertyHolder = engPropertiesComparator.getPropertyHolderByName(EngPropertiesComparator.ENT_TABLE_TYPE_SUBSTITUTION);
                if (engPropertyHolder != null && engPropertyHolder.isSelected()) {
                    designPartView2 = this.getDesign().getLogicalDesign().getMainView();
                    designPartView = this.getDesign().getRelationalDesign().getMainView();
                    if (table.getTypeSubstitution() != null) {
                        TopView topView;
                        DesignObject designObject2;
                        tVTypeSubstitution = (TVTypeSubstitution)table.getTypeSubstitution().getViewFor(designPartView);
                        objectListener = (Table)table.getTypeSubstitution().getParentContainerObject();
                        Entity entity2 = null;
                        if (entity.getTypeSubstitution() != null) {
                            entity2 = (Entity)entity.getTypeSubstitution().getParentContainerObject();
                            designObject2 = ((Table)objectListener).getEngEntity();
                            if (designObject2 == null) continue;
                            entity.getTypeSubstitution().setParentCV((ContainerView)((MultiShapedDesignObject)designObject2).getFirstViewForDPV(designPartView2));
                            topView = (TVTypeSubstitution)entity.getTypeSubstitution().getViewFor(designPartView2);
                            if (!this.design.isEngineerCoordinates() || this.design.getLogicalDesign().getMainView().isAutoRoute()) continue;
                            ApplicationView.loading = true;
                            ReverseEngineering.copyConnectionPoints(tVTypeSubstitution, (TVConnector)topView);
                            ApplicationView.loading = false;
                            continue;
                        }
                        entity2 = ((Table)objectListener).getEngEntity();
                        if (entity2 == null) continue;
                        ApplicationView.loading = true;
                        designObject2 = this.getDesign().getLogicalDesign().createTypeSubstitution();
                        topView = (ContainerView)entity.getFirstViewForDPV(designPartView2);
                        ContainerView containerView = (ContainerView)entity2.getFirstViewForDPV(designPartView2);
                        ((TypeSubstitution)designObject2).setChildCV((ContainerView)topView);
                        ((TypeSubstitution)designObject2).setParentCV(containerView);
                        ((TypeSubstitution)designObject2).addToAllDPVs();
                        TVTypeSubstitution tVTypeSubstitution2 = (TVTypeSubstitution)entity.getTypeSubstitution().getViewFor(designPartView2);
                        if (this.design.isEngineerCoordinates() && !this.design.getLogicalDesign().getMainView().isAutoRoute()) {
                            ReverseEngineering.copyConnectionPoints(tVTypeSubstitution, tVTypeSubstitution2);
                        }
                        ApplicationView.loading = false;
                        continue;
                    }
                    if (entity == null || entity.getTypeSubstitution() == null) continue;
                    entity.getTypeSubstitution().remove();
                    continue;
                }
                if (!this.design.isEngineerCoordinates() || entity.getTypeSubstitution() == null || table.getTypeSubstitution() == null) continue;
                designPartView2 = this.getDesign().getLogicalDesign().getMainView();
                designPartView = this.getDesign().getRelationalDesign().getMainView();
                tVTypeSubstitution = (TVTypeSubstitution)entity.getTypeSubstitution().getViewFor(designPartView2);
                objectListener = (TVTypeSubstitution)table.getTypeSubstitution().getViewFor(designPartView);
                if (tVTypeSubstitution == null || objectListener == null || this.design.getLogicalDesign().getMainView().isAutoRoute()) continue;
                ReverseEngineering.copyConnectionPoints((TVConnector)objectListener, tVTypeSubstitution);
            }
        }
    }

    private void copyPropertiesFromTableToEntity(Table table, Entity entity) {
        entity.setGeneratorID(table.getObjectID());
        entity.setBasedOnStructuredType(table.getBasedOnStructuredType());
        if (!this.notForNewObjects) {
            this.typeName = Design.ENTITY_TABLE;
            this.properties = this.design.getEntTablePropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.MIN_VOLUMES)) {
                entity.setMinVolumes(table.getMinVolumes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.EXPECTED_VOLUMES)) {
                entity.setExpectedVolumes(table.getExpectedVolumes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.MAX_VOLUMES)) {
                entity.setMaxVolumes(table.getMaxVolumes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.GROWTH_PERCENT)) {
                entity.setGrowthPercent(table.getGrowthPercent());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.GROWTH_TYPE)) {
                entity.setGrowthType(table.getGrowthType());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NORMAL_FORM)) {
                entity.setNormalForm(table.getNormalForm());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.ADEQUATELY_NORMALIZED)) {
                entity.setAdequatelyNormalized(table.getAdequatelyNormalized());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.TABLE_TYPE)) {
                entity.setTypeID(table.getTypeID());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.TEMP_TABLE_SCOPE)) {
                entity.setScope(table.getScope());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                entity.setComment(table.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                entity.setCommentInRDBMS(table.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                entity.setNotes(table.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.SHORT_NAME_ABBR)) {
                entity.setShortName(table.getAbbreviation());
            }
        } else {
            entity.setMinVolumes(table.getMinVolumes());
            entity.setExpectedVolumes(table.getExpectedVolumes());
            entity.setMaxVolumes(table.getMaxVolumes());
            entity.setGrowthPercent(table.getGrowthPercent());
            entity.setGrowthType(table.getGrowthType());
            entity.setNormalForm(table.getNormalForm());
            entity.setAdequatelyNormalized(table.getAdequatelyNormalized());
            entity.setTypeID(table.getTypeID());
            entity.setScope(table.getScope());
            entity.setComment(table.getComment());
            entity.setCommentInRDBMS(table.getCommentInRDBMS());
            entity.setNotes(table.getNotes());
            entity.setShortName(table.getAbbreviation());
        }
    }

    private Attribute getOrCreateAttribue(Table table, Entity entity, XtdMapping xtdMapping, Column column, String string) {
        Table table2;
        Entity entity2;
        Column column2;
        ModelIDObject modelIDObject = null;
        Attribute attribute = null;
        if (column.isFKColumn() && (column2 = column.getDelegate()) != null && (entity2 = (table2 = (Table)column2.getContainerWithKeyObject()).getEngEntity()) != null && (modelIDObject = column2.getEngAttribute(entity2)) != null && (attribute = entity.getAttributeReferingDelegate(modelIDObject.getObjectID())) != null) {
            return attribute;
        }
        attribute = entity.createAttribute(string);
        if (modelIDObject != null && attribute != null) {
            attribute.setReferedAttribute(modelIDObject.getObjectID());
        }
        return attribute;
    }

    private void processColumns(Table table, Entity entity, XtdMapping xtdMapping) {
        if (entity != null) {
            ContainedObject[] containedObjectArray = table.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Object object;
                Column column = (Column)containedObjectArray[i];
                List list = column.getMappingsFor(entity);
                if (list.size() == 0) {
                    if (column.isFKColumn() && column.getFKIndexAssociation() != null && column.getFKIndexAssociation().getEngInheritanceRelation() != null || !column.shouldBeEngineered(xtdMapping)) continue;
                    String string = this.getDesign().transformNameFromRelationalToLogical(column);
                    RepositoryObject repositoryObject = entity.createAttribute(string);
                    this.xmap.createMapping((DesignObject)repositoryObject, column);
                    xtdMapping.getColumns().remove(column.getObjectID());
                    this.copyPropertiesFromColumnToAttribute(column, (Attribute)repositoryObject);
                    object = column.getDeletedMapping(entity);
                    if (object == null) continue;
                    this.xmap.removeMapping((XtdMapping)object);
                    continue;
                }
                for (RepositoryObject repositoryObject : list) {
                    if (!((XtdMapping)repositoryObject).isRevEngineer()) continue;
                    object = null;
                    Attribute attribute = (Attribute)((XtdMapping)repositoryObject).getObjectMappedTo(column);
                    if (attribute != null) {
                        object = (EngPropertiesComparator)this.comparatorsMap.get(column.getObjectID() + attribute.getObjectID());
                    }
                    if (object == null) continue;
                    ((EngPropertiesComparator)object).copySelectedProperties();
                }
            }
        }
    }

    private void processColumnsBST(Table table, Entity entity, XtdMapping xtdMapping) {
        if (entity != null) {
            ContainedObject[] containedObjectArray = table.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                List list = column.getMappingsFor(entity);
                if (list.size() != 0) continue;
                Attribute attribute = null;
                if (column.isOid()) {
                    attribute = (Attribute)entity.getOidElement();
                } else {
                    String string = column.getStructAttributeID();
                    attribute = (Attribute)entity.getElementByStructAttributeID(string);
                }
                if (attribute == null) continue;
                this.xmap.createMapping(attribute, column);
                xtdMapping.getColumns().remove(column.getObjectID());
            }
        }
    }

    private void copyPropertiesFromColumnToAttribute(Column column, Attribute attribute) {
        if (!column.isFKColumn()) {
            attribute.setGeneratorID(column.getObjectID());
        }
        attribute.setDomain(column.getDomain());
        attribute.setUnique(column.isUnique());
        attribute.setNullsAllowed(column.getNullsAllowed());
        attribute.setLogicalDatatype(column.getLogicalDatatype());
        attribute.setStructuredType(column.getStructuredType());
        attribute.setCollectionType(column.getCollectionType());
        attribute.setDistinctType(column.getDistinctType());
        attribute.setAllowSubtypeSubstitution(column.isAllowSubtypeSubstitution());
        attribute.setReference(column.isReference());
        attribute.setUse(column.getUse());
        attribute.copyParametersFrom(column);
        attribute.setUseDomainConstraints(column.getUseDomainConstraints());
        if (!column.getUseDomainConstraints()) {
            EngCOPropertiesComparator.copyCheckConstraint(column, attribute);
            EngCOPropertiesComparator.copyRangeConstraint(column, attribute);
            EngCOPropertiesComparator.copyLOVConstraint(column, attribute);
        }
        if (!this.notForNewObjects) {
            this.typeName = Design.ATTRIBUTE_COLUMN;
            this.properties = this.design.getAttrColPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.CHECK_CONSTRAINT_NAME)) {
                attribute.setConstraintName(column.getConstraintName());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.USES_DEFUALT_VALUE)) {
                attribute.setUsesDefaultValue(column.getUsesDefaultValue());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.DEFAULT_VALUE)) {
                attribute.setDefaultValue(column.getDefaultValue());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                attribute.setComment(column.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                attribute.setCommentInRDBMS(column.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                attribute.setNotes(column.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.SOURCE_TYPE)) {
                attribute.setSourceType(column.getSourceType());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.FORMULA_DESC)) {
                this.copyFormulaDesc(column, attribute);
            }
        } else {
            attribute.setConstraintName(column.getConstraintName());
            attribute.setUsesDefaultValue(column.getUsesDefaultValue());
            attribute.setDefaultValue(column.getDefaultValue());
            attribute.setComment(column.getComment());
            attribute.setCommentInRDBMS(column.getCommentInRDBMS());
            attribute.setNotes(column.getNotes());
            attribute.setSourceType(column.getSourceType());
            this.copyFormulaDesc(column, attribute);
        }
    }

    private void copyFormulaDesc(Column column, Attribute attribute) {
        String string;
        String string2 = column.getFormulaDesc();
        attribute.setFormulaDesc(string2);
        if (!(string2 == null || string2.length() <= 0 || (string = attribute.getSourceType()) != null && string.equalsIgnoreCase("Aggregate"))) {
            attribute.setSourceType("Derived");
        }
    }

    private void setColumnsScopeId() {
        Iterator iterator = this.design.getRelationalDesign().getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            ContainedObject[] containedObjectArray = table.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                Attribute attribute = column.getEngAttribute();
                if (attribute == null) continue;
                if (column.getScope() == null) {
                    attribute.setScopeId(null);
                    continue;
                }
                attribute.setScopeId(((Table)column.getScope()).getEngEntity().getObjectID());
            }
        }
    }

    private boolean isResultFromInheritance(Index index) {
        if (!index.isPK()) {
            return false;
        }
        for (Column column : index.getElementsCollection()) {
            if (!column.isFKColumn()) {
                return false;
            }
            if (column.getFKIndexAssociation().getEngInheritanceRelation() != null) continue;
            return false;
        }
        return true;
    }

    private void processIndexes(Table table, Entity entity, XtdMapping xtdMapping) {
        if (entity != null) {
            KeyObject[] keyObjectArray = table.getKeys();
            for (int i = 0; i < keyObjectArray.length; ++i) {
                RepositoryObject repositoryObject;
                Index index = (Index)keyObjectArray[i];
                if (!index.isPK() && (!index.getIndexState().equalsIgnoreCase("Unique Constraint") || this.isResultFromInheritance(index))) continue;
                List list = index.getMappingsFor(entity);
                if (list.size() == 0) {
                    if (!index.shouldBeEngineered(xtdMapping)) continue;
                    Object object = null;
                    if (index.isOidKey() && (object = (CandidateKey)entity.getOidKey()) != null) {
                        ((CandidateKey)object).clearElements();
                    }
                    if (object == null) {
                        object = entity.createCandidateKeyNoAddToKeys(new GUID().toString());
                    }
                    Object object2 = this.getDesign().transformNameFromRelationalToLogical(index);
                    ((DesignObject)object).setName((String)object2);
                    this.xmap.createMapping((DesignObject)object, index);
                    xtdMapping.getIndexes().remove(index.getObjectID());
                    this.copyPropertiesFromIndexToKey(index, (CandidateKey)object);
                    entity.add((KeyObject)object);
                    if (index.isPK()) {
                        entity.setPK((KeyObject)object);
                    }
                    if ((repositoryObject = index.getDeletedMapping(entity)) == null) continue;
                    this.xmap.removeMapping((XtdMapping)repositoryObject);
                    continue;
                }
                for (Object object2 : list) {
                    if (!((XtdMapping)object2).isRevEngineer() || (repositoryObject = (CandidateKey)((XtdMapping)object2).getObjectMappedTo(index)) == null) continue;
                    EngPropertiesComparator engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(index.getObjectID() + repositoryObject.getObjectID());
                    if (engPropertiesComparator != null) {
                        engPropertiesComparator.copySelectedProperties();
                        continue;
                    }
                    if (repositoryObject == null) continue;
                    ReverseEngineering.synchronizeColumnsFromIndexToKey(index, repositoryObject);
                }
            }
        }
    }

    private void copyPropertiesFromIndexToKey(KeyObject keyObject, CandidateKey candidateKey) {
        candidateKey.setGeneratorID(keyObject.getObjectID());
        if (!this.notForNewObjects) {
            this.typeName = Design.KEY_INDEX;
            this.properties = this.design.getKeyIdxPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                candidateKey.setCommentInRDBMS(keyObject.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                candidateKey.setComment(keyObject.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                candidateKey.setNotes(keyObject.getNotes());
            }
        } else {
            candidateKey.setCommentInRDBMS(keyObject.getCommentInRDBMS());
            candidateKey.setComment(keyObject.getComment());
            candidateKey.setNotes(keyObject.getNotes());
        }
        ContainedObject[] containedObjectArray = keyObject.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            ContainedObject containedObject = containedObjectArray[i];
            List list = this.xmap.getMappingsForDesignPart(containedObject, this.targetDesPartID);
            if (list.size() <= 0) continue;
            for (XtdMapping xtdMapping : list) {
                Attribute attribute = (Attribute)xtdMapping.getObjectMappedTo(containedObject);
                if (attribute == null || attribute.getContainer() != candidateKey.getContainerObject()) continue;
                candidateKey.add(attribute);
            }
        }
        if (keyObject.isPK()) {
            candidateKey.makePK();
        }
    }

    public static void synchronizeColumnsFromIndexToKey(Index index, KeyObject keyObject) {
        int n;
        ContainedObject[] containedObjectArray = index.getElements();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Entity entity = (Entity)keyObject.getContainerWithKeyObject();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            Column column = (Column)containedObjectArray[i];
            Attribute attribute = column.getEngAttribute(entity);
            if (attribute == null) continue;
            arrayList.add(attribute);
            keyObject.add(attribute);
        }
        ContainedObject[] containedObjectArray2 = keyObject.getElements();
        for (n = 0; n < containedObjectArray2.length; ++n) {
            if (arrayList.contains(containedObjectArray2[n])) continue;
            keyObject.remove(containedObjectArray2[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            keyObject.moveToIndex((ContainedObject)arrayList.get(n), n);
        }
    }

    private void processForeignKeys() {
        for (int i = 0; i < this.fkeys.size(); ++i) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)this.fkeys.get(i);
            Table table = (Table)fKIndexAssociation.getContainerWithKeyObject();
            if (!fKIndexAssociation.shouldBeEngineered() || table.getEngRelation() != null) continue;
            this.processFK(fKIndexAssociation);
        }
    }

    private boolean isIdentifyingRelCandidate(FKIndexAssociation fKIndexAssociation) {
        KeyObject keyObject = fKIndexAssociation.getContainerWithKeyObject().getPK();
        if (keyObject == null) {
            return false;
        }
        for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
            if (column.hasCircularRef()) {
                return false;
            }
            if (keyObject.contains(column)) continue;
            return false;
        }
        return true;
    }

    public void processSelfRefColumns(FKIndexAssociation fKIndexAssociation) {
        if (fKIndexAssociation.getEngInheritanceRelation() != null) {
            return;
        }
        Table table = (Table)fKIndexAssociation.getContainerWithKeyObject();
        if (!table.isMtoNjoinCandidate()) {
            List list = this.xmap.getMappingsForDesignPart(fKIndexAssociation, this.targetDesPartID);
            for (XtdMapping xtdMapping : list) {
                DesignObject designObject = xtdMapping.getObjectMappedTo(fKIndexAssociation);
                if (designObject == null) continue;
                Relation relation = (Relation)designObject;
                for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
                    Attribute attribute;
                    Attribute attribute2;
                    Column column2;
                    if (column != (column2 = column.getReferencedColumn(fKIndexAssociation))) continue;
                    Table table2 = fKIndexAssociation.getRemoteTable();
                    Table table3 = (Table)fKIndexAssociation.getContainerWithKeyObject();
                    Entity entity = table2.getEngEntity();
                    Entity entity2 = table3.getEngEntity();
                    if (entity == null || entity2 != entity || (attribute2 = entity.getAttributeForDelegate(attribute = column2.getEngAttribute(entity), relation)) == null) continue;
                    XtdMapping xtdMapping2 = attribute2.getMappingFor((RelationalDesign)table3.getDesignPart(), table3);
                    if (xtdMapping2 == null) {
                        xtdMapping2 = this.xmap.createMapping(attribute2, column);
                    }
                    xtdMapping2.setRevEngineer(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFK(FKIndexAssociation fKIndexAssociation) {
        block26: {
            List list;
            block27: {
                if (fKIndexAssociation.getEngInheritanceRelation() != null) {
                    return;
                }
                Table table = (Table)fKIndexAssociation.getContainerWithKeyObject();
                if (table.isMtoNjoinCandidate()) break block26;
                list = this.xmap.getMappingsForDesignPart(fKIndexAssociation, this.targetDesPartID);
                if (list.size() != 0) break block27;
                LogicalDesign logicalDesign = this.design.getLogicalDesign();
                Table table2 = fKIndexAssociation.getRemoteTable();
                Table table3 = (Table)fKIndexAssociation.getContainerWithKeyObject();
                Entity entity = table2.getEngEntity();
                Entity entity2 = table3.getEngEntity();
                if (entity == null || entity2 == null) break block26;
                Relation relation = logicalDesign.createRelation();
                relation.setFireCardinalityChange(false);
                try {
                    relation.setName(fKIndexAssociation.getName());
                    this.xmap.createMapping(relation, fKIndexAssociation);
                    relation.setGeneratorID(fKIndexAssociation.getObjectID());
                    relation.setTargetEntity(entity2);
                    relation.setSourceEntity(entity);
                    this.prepareFKAttributes(fKIndexAssociation, relation);
                    this.setOptionality(relation, fKIndexAssociation);
                    relation.setCardinality(0, 1);
                    if (fKIndexAssociation.isOneToOne()) {
                        relation.setCardinality(1, 1);
                        relation.setDominantRole(entity);
                    }
                    if (this.isIdentifyingRelCandidate(fKIndexAssociation)) {
                        relation.setIdentifying(true);
                        if (fKIndexAssociation.isOneToOne()) {
                            // empty if block
                        }
                    }
                    if (fKIndexAssociation.getTable() == fKIndexAssociation.getRemoteTable()) {
                        relation.setOptionalSource(true);
                        relation.setDominantRole(null);
                    }
                    if (!fKIndexAssociation.isMandatory()) {
                        relation.setDeleteRule(fKIndexAssociation.getDeleteRule());
                    }
                }
                finally {
                    relation.setFireCardinalityChange(true);
                    relation.setTargetCardinality(relation.getTargetCardinality());
                }
                this.copyPropertiesFromFKToRelation(fKIndexAssociation, relation);
                TVRelation tVRelation = (TVRelation)relation.getTopView();
                if (tVRelation == null || !this.design.isEngineerCoordinates() || this.design.getLogicalDesign().getMainView().isAutoRoute()) break block26;
                TVFKRelation tVFKRelation = (TVFKRelation)fKIndexAssociation.getViewFor(fKIndexAssociation.getDesignPart().getMainView());
                ReverseEngineering.copyConnectionPoints(tVFKRelation, tVRelation);
                tVRelation.resetEdgeParams();
                break block26;
            }
            for (XtdMapping xtdMapping : list) {
                Relation relation;
                DesignObject designObject = xtdMapping.getObjectMappedTo(fKIndexAssociation);
                if (designObject == null) continue;
                EngPropertiesComparator engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(fKIndexAssociation.getObjectID() + designObject.getObjectID());
                if (engPropertiesComparator != null) {
                    Object object;
                    engPropertiesComparator.copySelectedProperties();
                    if (!(designObject instanceof Relation)) continue;
                    boolean bl = false;
                    FK_RelationComparator fK_RelationComparator = null;
                    if (engPropertiesComparator instanceof FK_RelationComparator) {
                        fK_RelationComparator = (FK_RelationComparator)engPropertiesComparator;
                        bl = fK_RelationComparator.isMandatoryDefined();
                    }
                    Relation relation2 = (Relation)designObject;
                    this.prepareFKAttributes(fKIndexAssociation, relation2);
                    relation2.setFireCardinalityChange(false);
                    try {
                        if (this.isIdentifyingRelCandidate(fKIndexAssociation)) {
                            relation2.setIdentifying(true);
                        } else {
                            relation2.setIdentifying(false);
                        }
                        relation2.setCardinality(0, 1);
                        if (fKIndexAssociation.isOneToOne()) {
                            relation2.setCardinality(1, 1);
                        }
                        if (!bl) {
                            this.setOptionality(relation2, fKIndexAssociation);
                        } else {
                            object = engPropertiesComparator.getPropertyHolderByName(PropertyNames.MANDATORY);
                            if (object != null && (((EngPropertyHolder)object).isModified() && ((EngPropertyHolder)object).isSelected() || !((EngPropertyHolder)object).isModified())) {
                                this.setOptionality(relation2, fKIndexAssociation);
                            }
                            if (!fKIndexAssociation.isMandatory() && (object = engPropertiesComparator.getPropertyHolderByName(PropertyNames.DELETE_RULE)) != null && ((EngPropertyHolder)object).isModified() && ((EngPropertyHolder)object).isSelected()) {
                                relation2.setDeleteRule(fKIndexAssociation.getDeleteRule());
                            }
                        }
                    }
                    finally {
                        relation2.setFireCardinalityChange(true);
                        relation2.setTargetCardinality(relation2.getTargetCardinality());
                    }
                    if ((object = (TVRelation)relation2.getTopView()) == null || !this.design.isEngineerCoordinates() || this.design.getLogicalDesign().getMainView().isAutoRoute()) continue;
                    TVFKRelation tVFKRelation = (TVFKRelation)fKIndexAssociation.getViewFor(fKIndexAssociation.getDesignPart().getMainView());
                    ReverseEngineering.copyConnectionPoints(tVFKRelation, (TVConnector)object);
                    ((TVRelation)object).resetEdgeParams();
                    continue;
                }
                if (xtdMapping.getObjectMappedTo(fKIndexAssociation) instanceof InheritanceRelation || (relation = (Relation)xtdMapping.getObjectMappedTo(fKIndexAssociation)) == null) continue;
                if (this.isIdentifyingRelCandidate(fKIndexAssociation)) {
                    relation.setIdentifying(true);
                } else {
                    relation.setIdentifying(false);
                }
                this.setOptionality(relation, fKIndexAssociation);
            }
        }
    }

    private void setOptionality(Relation relation, FKIndexAssociation fKIndexAssociation) {
        Entity entity;
        DesignObject designObject;
        Iterator iterator = fKIndexAssociation.getLocalFKIndex().getElementsCollection().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            designObject = (Column)iterator.next();
            if (!((ContainedObject)designObject).getNullsAllowed()) continue;
            bl = true;
            break;
        }
        if ((entity = ((Table)(designObject = (Table)fKIndexAssociation.getContainerWithKeyObject())).getEngEntity()) != null) {
            if (entity == relation.getSourceEntity()) {
                relation.setOptionalSource(bl);
                if (!bl) {
                    if ("RESTRICT".equalsIgnoreCase(fKIndexAssociation.getDeleteRule())) {
                        relation.setOptionalTarget(true);
                    } else if ("CASCADE".equalsIgnoreCase(fKIndexAssociation.getDeleteRule())) {
                        relation.setOptionalTarget(false);
                    }
                }
            }
            if (entity == relation.getTargetEntity()) {
                relation.setOptionalTarget(bl);
                if (!bl) {
                    if ("RESTRICT".equalsIgnoreCase(fKIndexAssociation.getDeleteRule())) {
                        relation.setOptionalSource(true);
                    } else if ("CASCADE".equalsIgnoreCase(fKIndexAssociation.getDeleteRule())) {
                        relation.setOptionalSource(false);
                    }
                }
            }
        }
    }

    private void copyPropertiesFromFKToRelation(FKIndexAssociation fKIndexAssociation, Relation relation) {
        relation.setTemporaryWriteable(true);
        if (!this.notForNewObjects) {
            this.typeName = Design.RELATION_FK;
            this.properties = this.design.getRelFKPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                relation.setComment(fKIndexAssociation.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                relation.setNotes(fKIndexAssociation.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                relation.setCommentInRDBMS(fKIndexAssociation.getCommentInRDBMS());
            }
        } else {
            relation.setComment(fKIndexAssociation.getComment());
            relation.setNotes(fKIndexAssociation.getNotes());
            relation.setCommentInRDBMS(fKIndexAssociation.getCommentInRDBMS());
        }
        relation.setTemporaryWriteable(false);
    }

    private void prepareFKAttributes(FKIndexAssociation fKIndexAssociation, Relation relation) {
        for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
            Attribute attribute;
            Entity entity;
            Object object;
            Column column2;
            Attribute attribute2;
            if (column.getAssociationsCount() == 1) {
                attribute2 = column.getEngAttribute();
                column2 = column.getReferencedColumn(fKIndexAssociation);
                if (column == column2) continue;
                if (attribute2 != null) {
                    attribute2.setGeneratorID(relation.getObjectID());
                }
                if (attribute2 == null || column2 == null) continue;
                object = column2.getEngAttribute();
                if (object == null) {
                    object = column2.getEngAttribute();
                }
                if (object == null) continue;
                attribute2.setReferedAttribute(((ModelIDObject)object).getObjectID());
                continue;
            }
            if (column.getAssociationsCount() <= 1) continue;
            attribute2 = column.getEngAttribute();
            column2 = column.getReferencedColumn(fKIndexAssociation);
            object = null;
            if (attribute2 != null) {
                object = attribute2.getReferedAttribute();
            }
            Attribute attribute3 = column2.getEngAttribute();
            if (attribute2 != null && object == null) {
                if (attribute2 != null) {
                    attribute2.setGeneratorID(relation.getObjectID());
                }
                if (attribute3 == null) {
                    attribute3 = column2.getEngAttribute();
                }
                if (attribute3 == null) continue;
                attribute2.setReferedAttribute(attribute3.getObjectID());
                continue;
            }
            if (attribute2 == null || attribute3 == null || attribute2.isFKAttribute() && attribute2.getDelegate() == attribute3 || object != null && attribute3.getObjectID().equals(object) || (entity = ((Table)fKIndexAssociation.getContainerWithKeyObject()).getEngEntity()) == null || (attribute = entity.getAttributeReferingDelegate(attribute3.getObjectID())) != null) continue;
            attribute = entity.createAttribute(attribute3.getLongName());
            attribute.setReferedAttribute(attribute3.getObjectID());
            this.copyPropertiesFromColumnToAttribute(column, attribute);
            attribute.setGeneratorID(relation.getObjectID());
            this.xmap.createMapping(attribute, column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void engineerAllSubviews(Design design) {
        DPVLogicalSubView dPVLogicalSubView;
        DPVRelational dPVRelational;
        Iterator iterator = design.getRelationalDesign().getPhysicalDesignSubviews().iterator();
        RelationalDesign relationalDesign = design.getRelationalDesign();
        LogicalDesign logicalDesign = design.getLogicalDesign();
        if (design.isEngineerAsSubView()) {
            dPVRelational = (DPVRelational)relationalDesign.getMainView();
            dPVLogicalSubView = (DPVLogicalSubView)logicalDesign.getSubViewGeneratedByDPV(dPVRelational.getDPVId());
            if (dPVLogicalSubView == null) {
                if (dPVRelational.getGeneratorId() != null && !"".equalsIgnoreCase(dPVRelational.getGeneratorId())) {
                    dPVLogicalSubView = (DPVLogicalSubView)logicalDesign.getSubViewByID(dPVRelational.getGeneratorId());
                }
                if (dPVLogicalSubView == null) {
                    dPVLogicalSubView = (DPVLogicalSubView)logicalDesign.createDesignPartSubView();
                    dPVLogicalSubView.setName("From_RM_" + dPVRelational.getName());
                    dPVLogicalSubView.setGeneratorId(dPVRelational.getDPVId());
                    this.xmap.createMapping(dPVLogicalSubView.getPlaceHolder(), relationalDesign.getMainDPVPlaceHolder());
                }
            }
            try {
                dPVLogicalSubView.getUndoManager().setLocked(true);
                for (Object object : dPVRelational.getTVTables()) {
                    if (!((TopView)object).getModel().shouldBeEngineered()) continue;
                    this.engineerTableSynonyms((TVTable)object, dPVLogicalSubView);
                }
                for (Object object : dPVRelational.getTVViews()) {
                    this.engineerTableViewSynonyms((TVView)object, dPVLogicalSubView);
                }
            }
            finally {
                dPVLogicalSubView.getUndoManager().setLocked(false);
            }
            dPVLogicalSubView.setVisible(true);
        }
        while (iterator.hasNext()) {
            Object object;
            object = (DesignPartViewPlaceHolder)iterator.next();
            if (!((DesignObject)object).shouldBeEngineered()) continue;
            dPVRelational = (DPVRelationalSubView)((DesignPartViewPlaceHolder)object).getDesignPartView();
            dPVLogicalSubView = (DPVLogicalSubView)logicalDesign.getSubViewGeneratedByDPV(dPVRelational.getDPVId());
            if (dPVLogicalSubView == null) {
                if (dPVRelational.getGeneratorId() != null && !"".equalsIgnoreCase(dPVRelational.getGeneratorId())) {
                    dPVLogicalSubView = (DPVLogicalSubView)logicalDesign.getSubViewByID(dPVRelational.getGeneratorId());
                }
                if (dPVLogicalSubView == null) {
                    dPVLogicalSubView = (DPVLogicalSubView)logicalDesign.createDesignPartSubView();
                    dPVLogicalSubView.setName("From_RM_" + dPVRelational.getName());
                    dPVLogicalSubView.setGeneratorId(dPVRelational.getDPVId());
                    this.copyPropertiesFromSubViewToSubView((DPVRelationalSubView)((DesignPartViewPlaceHolder)object).getDesignPartView(), dPVLogicalSubView);
                    this.xmap.createMapping(dPVRelational.getPlaceHolder(), dPVLogicalSubView.getPlaceHolder());
                }
            }
            try {
                dPVLogicalSubView.getUndoManager().setLocked(true);
                for (TopView topView : dPVRelational.getTVTables()) {
                    if (!topView.getModel().shouldBeEngineered()) continue;
                    this.engineerTableSynonyms((TVTable)topView, dPVLogicalSubView);
                }
                for (TopView topView : dPVRelational.getTVFKRelations()) {
                    FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)topView.getModel();
                    Relation relation = fKIndexAssociation.getEngRelation();
                    if (relation == null) continue;
                    TVRelation tVRelation = (TVRelation)relation.getViewFor(dPVLogicalSubView);
                    if (tVRelation == null) {
                        relation.getSourceTV(dPVLogicalSubView);
                        relation.getTargetTV(dPVLogicalSubView);
                        tVRelation = (TVRelation)relation.getViewFor(dPVLogicalSubView);
                    }
                    if (tVRelation == null || !design.isEngineerCoordinates() || design.getLogicalDesign().getMainView().isAutoRoute()) continue;
                    ReverseEngineering.copyConnectionPoints((TVConnector)topView, tVRelation);
                    tVRelation.resetEdgeParams();
                }
                for (TopView topView : dPVRelational.getTVViews()) {
                    this.engineerTableViewSynonyms((TVView)topView, dPVLogicalSubView);
                }
            }
            finally {
                dPVLogicalSubView.getUndoManager().setLocked(false);
            }
            dPVLogicalSubView.setVisible(dPVRelational.isVisible());
        }
    }

    private void engineerTableSynonyms(TVTable tVTable, DesignPartView designPartView) {
        Entity entity;
        Table table = (Table)tVTable.getModel();
        if (ModelIDObject.USER_GENERATED.equalsIgnoreCase(table.getGeneratorID())) {
            entity = (Entity)table.getDesign().getLogicalDesign().getEntitySet().getObjectGeneratedBy(table.getObjectID());
        } else {
            entity = (Entity)table.getDesign().getLogicalDesign().getEntitySet().getObjectByID(table.getGeneratorID());
            if (entity == null) {
                entity = (Entity)table.getDesign().getLogicalDesign().getEntitySet().getObjectGeneratedBy(table.getObjectID());
            }
        }
        if (entity != null) {
            TVEntity tVEntity = (TVEntity)entity.getTopViewByGeneratorID(designPartView, tVTable.getGeneratorID());
            if (tVEntity == null) {
                tVEntity = (TVEntity)entity.getTopViewByID(designPartView, tVTable.getViewID());
            }
            if (tVEntity == null || tVEntity.getDesignPartView() != designPartView) {
                tVEntity = (TVEntity)entity.getTopView().createViewSynonim(designPartView);
                tVEntity.setGeneratorID(tVTable.getViewID());
                tVEntity.addTVRelations(designPartView);
            }
            if (table.getDesign().isEngineerCoordinates()) {
                designPartView.getApplicationView().setGraphicalPropsFor(tVEntity, designPartView.getApplicationView().getGraphicalPropsFor(tVTable));
            }
        } else if (table.isMtoNjoinCandidate()) {
            // empty if block
        }
    }

    private void resetRelationTopViews() {
        Iterator iterator = this.design.getLogicalDesign().getRelationSet().iterator();
        while (iterator.hasNext()) {
            Relation relation = (Relation)iterator.next();
            for (TVRelation tVRelation : relation.getAllTVRelations()) {
                tVRelation.resetEdgeParams();
            }
        }
    }

    private void processTableViews() {
        Iterator iterator = this.design.getRelationalDesign().getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            this.processTableView(tableView);
        }
    }

    private void processTableView(TableView tableView) {
        block4: {
            List list;
            block3: {
                XtdMapping xtdMapping;
                list = this.xmap.getMappingsForDesignPart(tableView, this.targetDesPartID);
                if (list.size() != 0) break block3;
                if (!tableView.shouldBeEngineered()) break block4;
                String string = this.getDesign().transformNameFromRelationalToLogical(tableView);
                EntityView entityView = this.design.getLogicalDesign().createEntityView(string);
                this.xmap.createMapping(entityView, tableView);
                this.copyPropertiesFromTableViewToEntityView(tableView, entityView);
                if (this.design.isEngineerCoordinates()) {
                    this.setGraphicalPropertiesOnNewObject(tableView, entityView);
                }
                if ((xtdMapping = tableView.getDeletedMapping()) == null) break block4;
                tableView.updateDeletedMappings(xtdMapping.getDeletedID(), entityView.getObjectID(), entityView.getDesignPartId());
                this.xmap.removeMapping(xtdMapping);
                break block4;
            }
            for (XtdMapping xtdMapping : list) {
                DesignObject designObject;
                if (!xtdMapping.isRevEngineer() || (designObject = xtdMapping.getObjectMappedTo(tableView)) == null || !(designObject instanceof EntityView)) continue;
                EntityView entityView = (EntityView)designObject;
                EngPropertiesComparator engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(tableView.getObjectID() + entityView.getObjectID());
                if (engPropertiesComparator != null) {
                    engPropertiesComparator.copySelectedProperties();
                }
                if (!this.design.isEngineerCoordinates()) continue;
                this.setGraphicalPropertiesOnNewObject(tableView, entityView);
            }
        }
    }

    private void copyPropertiesFromTableViewToEntityView(TableView tableView, EntityView entityView) {
        DesignObject designObject;
        Object object;
        ContainedObject[] containedObjectArray2;
        entityView.setGeneratorID(tableView.getObjectID());
        entityView.setBasedOnStructuredType(tableView.getBasedOnStructuredType());
        if (!this.notForNewObjects) {
            this.typeName = Design.ENTVIEW_TBLVIEW;
            this.properties = this.design.getViewPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                entityView.setComment(tableView.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                entityView.setCommentInRDBMS(tableView.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                entityView.setNotes(tableView.getNotes());
            }
        } else {
            entityView.setComment(tableView.getComment());
            entityView.setCommentInRDBMS(tableView.getCommentInRDBMS());
            entityView.setNotes(tableView.getNotes());
        }
        entityView.setWhere(tableView.getWhere());
        entityView.setGroupBy(tableView.getGroupBy());
        entityView.setHaving(tableView.getHaving());
        entityView.setUserDefined(tableView.getUserDefined());
        entityView.setUserDefinedSQL(tableView.getUserDefinedSQL());
        entityView.setLayoutSQL(tableView.getLayoutSQL());
        entityView.setParsed(tableView.isParsed());
        entityView.setIncorrectSQL(tableView.isIncorrectSQL());
        entityView.setValidSQL(tableView.isValidSQL());
        for (Object object2 : tableView.getUsedContainers()) {
            Entity entity;
            containedObjectArray2 = ((AbstractView.ContainerHolder)object2).getAlias();
            object = ((AbstractView.ContainerHolder)object2).getContainer().getObjectID();
            designObject = (Table)this.design.getRelationalDesign().getTableSet().getObjectByID((String)object);
            if (designObject == null || (entity = ((Table)designObject).getEngEntity()) == null) continue;
            entityView.addToContainers(entity, (String)containedObjectArray2);
        }
        for (ContainedObject[] containedObjectArray2 : tableView.getOrderByMap().keySet()) {
            Object object2;
            object2 = (ColumnView)tableView.getObjectByID(tableView.getOrderByList(), (String)containedObjectArray2);
            if (object2 != null) {
                object = new AttributeView(entityView.getDesignPart());
                ((ModelObject)object).setDesign(entityView.getDesign());
                this.copyColumnToAttribute((ColumnView)object2, (AttributeView)object);
                ((AbstractViewElement)object).setView(entityView);
                entityView.addToOrderBy((ContainedObject)object, (String)tableView.getOrderByMap().get(containedObjectArray2));
                continue;
            }
            System.out.println("ReverseEngineering.copyPropertiesFromTableViewToEntityView: Unable to find ColumnView: " + (String)containedObjectArray2);
        }
        if (!tableView.isBST()) {
            containedObjectArray2 = tableView.getElements();
            for (int i = 0; i < containedObjectArray2.length; ++i) {
                designObject = new AttributeView(entityView.getDesignPart());
                designObject.setDesign(entityView.getDesign());
                this.copyColumnToAttribute((ColumnView)containedObjectArray2[i], (AttributeView)designObject);
                ((AbstractViewElement)designObject).setView(entityView);
                ((ContainedObject)designObject).setContainer(entityView);
                entityView.add((ContainedObject)designObject);
            }
        }
        for (int i = 0; i < tableView.getGroupByList().size(); ++i) {
            ColumnView columnView = (ColumnView)tableView.getGroupByList().get(i);
            if (columnView == null || (designObject = (AttributeView)entityView.getElementGeneratedBy(columnView.getObjectID())) == null) continue;
            entityView.addGroupByList((ContainedObject)designObject);
        }
    }

    public void copyColumnToAttribute(ColumnView columnView, AttributeView attributeView) {
        DesignObject designObject;
        attributeView.setGeneratorID(columnView.getObjectID());
        columnView.copyDefaults(attributeView);
        attributeView.setTableAlias(columnView.getTableAlias());
        attributeView.setAlias(columnView.getAlias());
        attributeView.setExpression(columnView.getExpression());
        attributeView.setDataType(columnView.getDataType());
        if (columnView.getReferencedColumn() != null) {
            designObject = ((Column)columnView.getReferencedColumn()).getEngAttribute();
            attributeView.setReferencedColumn((ContainedObjectWithDomain)designObject);
        }
        if (columnView.getTable() != null) {
            designObject = ((Table)columnView.getTable()).getEngEntity();
            attributeView.setEntity((Entity)designObject);
        }
        attributeView.setScopeId(columnView.getScopeId());
        attributeView.setReference(columnView.isReference());
        attributeView.setStructuredType(columnView.getStructuredType());
    }

    public static void copyConnectionPoints(TVConnector tVConnector, TVConnector tVConnector2) {
        DesignPartView.copyConnectionPoints(tVConnector, tVConnector2);
    }

    private void engineerTableViewSynonyms(TVView tVView, DesignPartView designPartView) {
        EntityView entityView;
        TableView tableView = (TableView)tVView.getModel();
        if (ModelIDObject.USER_GENERATED.equalsIgnoreCase(tableView.getGeneratorID())) {
            entityView = (EntityView)tableView.getDesign().getLogicalDesign().getEntityViewSet().getObjectGeneratedBy(tableView.getObjectID());
        } else {
            entityView = (EntityView)tableView.getDesign().getLogicalDesign().getEntityViewSet().getObjectByID(tableView.getGeneratorID());
            if (entityView == null) {
                entityView = (EntityView)tableView.getDesign().getLogicalDesign().getEntityViewSet().getObjectGeneratedBy(tableView.getObjectID());
            }
        }
        if (entityView != null) {
            TVEntityView tVEntityView = (TVEntityView)entityView.getTopViewByGeneratorID(designPartView, tVView.getGeneratorID());
            if (tVEntityView == null) {
                tVEntityView = (TVEntityView)entityView.getTopViewByID(designPartView, tVView.getViewID());
            }
            if (tVEntityView == null || tVEntityView.getDesignPartView() != designPartView) {
                tVEntityView = (TVEntityView)entityView.getTopView().createViewSynonim(designPartView);
                tVEntityView.setGeneratorID(tVView.getViewID());
            }
            if (tableView.getDesign().isEngineerCoordinates()) {
                designPartView.getApplicationView().setGraphicalPropsFor(tVEntityView, designPartView.getApplicationView().getGraphicalPropsFor(tVView));
            }
        }
    }

    private void copyPropertiesFromSubViewToSubView(DPVRelationalSubView dPVRelationalSubView, DPVLogicalSubView dPVLogicalSubView) {
        dPVLogicalSubView.getPlaceHolder().setComment(dPVRelationalSubView.getPlaceHolder().getComment());
        dPVLogicalSubView.getPlaceHolder().setNotes(dPVRelationalSubView.getPlaceHolder().getNotes());
    }

    private boolean checkIfSelected(String string, List list, String string2) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (!string.equalsIgnoreCase(Design.ENTITY_TABLE)) break block5;
                            for (EngPropertyHolder engPropertyHolder : list) {
                                if (!engPropertyHolder.getName().equalsIgnoreCase(string2) || !engPropertyHolder.isSelected()) continue;
                                return true;
                            }
                            break block6;
                        }
                        if (!string.equalsIgnoreCase(Design.ATTRIBUTE_COLUMN)) break block7;
                        for (EngPropertyHolder engPropertyHolder : list) {
                            if (!engPropertyHolder.getName().equalsIgnoreCase(string2) || !engPropertyHolder.isSelected()) continue;
                            return true;
                        }
                        break block6;
                    }
                    if (!string.equalsIgnoreCase(Design.ENTVIEW_TBLVIEW)) break block8;
                    for (EngPropertyHolder engPropertyHolder : list) {
                        if (!engPropertyHolder.getName().equalsIgnoreCase(string2) || !engPropertyHolder.isSelected()) continue;
                        return true;
                    }
                    break block6;
                }
                if (!string.equalsIgnoreCase(Design.KEY_INDEX)) break block9;
                for (EngPropertyHolder engPropertyHolder : list) {
                    if (!engPropertyHolder.getName().equalsIgnoreCase(string2) || !engPropertyHolder.isSelected()) continue;
                    return true;
                }
                break block6;
            }
            if (!string.equalsIgnoreCase(Design.RELATION_FK)) break block6;
            for (EngPropertyHolder engPropertyHolder : list) {
                if (!engPropertyHolder.getName().equalsIgnoreCase(string2) || !engPropertyHolder.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    private void processArcs() {
        Iterator iterator = this.design.getRelationalDesign().getArcSet().iterator();
        String string = this.design.getLogicalDesign().getObjectID();
        while (iterator.hasNext()) {
            FKArc fKArc = (FKArc)iterator.next();
            List list = this.xmap.getMappingsForDesignPart(fKArc, string);
            if (list.size() != 0) continue;
            this.createNewArc(fKArc);
        }
    }

    private void createNewArc(FKArc fKArc) {
        Entity entity;
        Table table = fKArc.getTable();
        if (table != null && (entity = table.getEngEntity()) != null) {
            DesignObject designObject2;
            ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
            for (DesignObject designObject2 : fKArc.getFkeys()) {
                Relation relation = designObject2.getEngRelation(entity);
                if (relation == null) continue;
                arrayList.add(relation);
            }
            if (arrayList.size() > 1) {
                arrayList.add(0, entity);
            }
            if ((designObject2 = ((LogicalDesign)entity.getDesignPart()).createArc(arrayList.toArray())) != null) {
                this.xmap.createMapping(designObject2, fKArc);
            }
        }
    }

    private void processSQLNames() {
        Iterator iterator = this.design.getRelationalDesign().getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            this.processSQLNamesForView(tableView);
        }
    }

    private void processSQLNamesForView(TableView tableView) {
        List list = this.xmap.getMappingsForDesignPart(tableView, this.targetDesPartID);
        for (XtdMapping xtdMapping : list) {
            DesignObject designObject;
            if (!xtdMapping.isRevEngineer() || (designObject = xtdMapping.getObjectMappedTo(tableView)) == null || !(designObject instanceof EntityView)) continue;
            EntityView entityView = (EntityView)designObject;
            entityView.getSQLNames().clear();
            entityView.setValidSQL(false);
            for (SQLNameHelper sQLNameHelper : tableView.getSQLNames()) {
                Object object;
                DesignObject designObject2 = this.getDesign().getDesignObject(sQLNameHelper.getID());
                if (designObject2 != null) {
                    Object object2;
                    DesignObject designObject3;
                    if (designObject2 instanceof Table) {
                        object = (Table)designObject2;
                        designObject3 = ((Table)object).getEngEntity();
                        if (designObject3 != null) {
                            object2 = new SQLNameHelper(true, false);
                            ((SQLNameHelper)object2).setID(designObject3.getObjectID());
                            ((SQLNameHelper)object2).setTableName(designObject3.getName());
                            if (tableView.canSetSchemaToTablesOnRE() && ((ContainerObject)object).getSchemaObject() != null) {
                                ((SQLNameHelper)object2).setSchema(((ContainerObject)object).getSchemaObject().getName());
                            }
                            entityView.getSQLNames().add(object2);
                            designObject3.addObjectListener(entityView);
                            continue;
                        }
                        entityView.setIncorrectSQL(true);
                        continue;
                    }
                    if (designObject2 instanceof TableView) {
                        object = (TableView)designObject2;
                        designObject3 = ((TableView)object).getEngEntityView();
                        if (designObject3 != null) {
                            object2 = new SQLNameHelper(true, true);
                            ((SQLNameHelper)object2).setID(designObject3.getObjectID());
                            ((SQLNameHelper)object2).setTableName(designObject3.getName());
                            if (tableView.canSetSchemaToTablesOnRE() && ((ContainerObject)designObject3).getSchemaObject() != null) {
                                ((SQLNameHelper)object2).setSchema(((ContainerObject)designObject3).getSchemaObject().getName());
                            }
                            entityView.getSQLNames().add(object2);
                            designObject3.addObjectListener(entityView);
                            continue;
                        }
                        entityView.setIncorrectSQL(true);
                        continue;
                    }
                    if (designObject2 instanceof Column) {
                        object = (Column)designObject2;
                        designObject3 = ((Column)object).getEngAttribute();
                        if (designObject3 != null) {
                            object2 = new SQLNameHelper(false, false);
                            ((SQLNameHelper)object2).setID(designObject3.getObjectID());
                            ((SQLNameHelper)object2).setTableName(((ContainedObject)designObject3).getContainer().getName());
                            ((SQLNameHelper)object2).setColumnName(((ContainedObject)designObject3).getName());
                            entityView.getSQLNames().add(object2);
                            designObject3.addObjectListener(entityView);
                            continue;
                        }
                        entityView.setIncorrectSQL(true);
                        continue;
                    }
                    if (!(designObject2 instanceof ColumnView)) continue;
                    object = (ColumnView)designObject2;
                    designObject3 = (TableView)((ContainedObject)object).getContainer();
                    object2 = ((ContainerObject)designObject3).getElementByName(((ContainedObject)object).getName());
                    if (object2 != null) {
                        SQLNameHelper sQLNameHelper2 = new SQLNameHelper(false, false);
                        sQLNameHelper2.setID(((ModelIDObject)object2).getObjectID());
                        sQLNameHelper2.setTableName(((ContainedObject)object2).getContainer().getName());
                        sQLNameHelper2.setColumnName(((ContainedObject)object2).getName());
                        entityView.getSQLNames().add(sQLNameHelper2);
                        ((DesignObject)object2).addObjectListener(entityView);
                        continue;
                    }
                    entityView.setIncorrectSQL(true);
                    continue;
                }
                object = sQLNameHelper.clone();
                entityView.getSQLNames().add(object);
            }
        }
    }
}

