/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.FWDEngineering;
import oracle.dbtools.crest.model.design.engineering.RelationFKComparator;
import oracle.dbtools.crest.model.design.engineering.ReverseEngineering;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.TVConnector;

public class FEEntityHierarchy {
    private String targetDesPartID;
    private RelationalDesign pdes;
    private FWDEngineering fwdEngineering;
    private ExtendedMap xmap;
    private Design design;
    private Map comparatorsMap;
    private static String _ID = "_ID";

    public FEEntityHierarchy(FWDEngineering fWDEngineering, Design design, RelationalDesign relationalDesign) {
        this.fwdEngineering = fWDEngineering;
        this.targetDesPartID = relationalDesign.getObjectID();
        this.pdes = relationalDesign;
        this.design = design;
        this.xmap = design.getExtendedMap();
    }

    public void processInhEntity(Entity entity) {
        if (entity.isHierarchicalEntityType()) {
            if ("Single Table".equals(entity.getFwdEngineeringStrategyName())) {
                this.singleTableInheritance(entity);
            } else if ("Table per child".equals(entity.getFwdEngineeringStrategyName())) {
                this.tablePerChildInheritance(entity);
            } else if ("Table for each entity".equals(entity.getFwdEngineeringStrategyName())) {
                this.processEntity(entity, 3);
            }
        }
    }

    private void processKeys_Single(Entity entity, Table table, XtdMapping xtdMapping) {
        Index index;
        CandidateKey candidateKey = (CandidateKey)entity.getPK();
        this.fwdEngineering.processKeys(entity, table, xtdMapping);
        if (entity.isHierarchicalEntityType()) {
            int n = entity.getHierarchicalChildrenCount();
            for (int i = 0; i < n; ++i) {
                Entity entity2 = entity.getHierarchicalChild(i);
                XtdMapping xtdMapping2 = entity2.getMappingFor(table);
                if (xtdMapping2 == null) continue;
                this.processKeys_Single(entity2, table, xtdMapping2);
            }
        }
        if (candidateKey != null && (index = candidateKey.getEngIndex(this.pdes)) != null) {
            index.setPK(true);
        }
    }

    public void processRoot(Entity entity) {
        if (entity.isHierarchicalRoot()) {
            if ("Single Table".equals(entity.getFwdEngineeringStrategyName())) {
                this.processEntSingle(entity);
            } else if ("Table per child".equals(entity.getFwdEngineeringStrategyName())) {
                this.processEntLeaf(entity);
            } else if ("Table for each entity".equals(entity.getFwdEngineeringStrategyName())) {
                this.processEntAll(entity);
            }
        }
    }

    private void processEntAll(Entity entity) {
        ArrayList arrayList = new ArrayList();
        this.addEntity(entity, arrayList);
        for (Entity entity2 : arrayList) {
            this.deleteMappedTables(entity2, 3);
        }
        for (Entity entity2 : arrayList) {
            this.processEntity(entity2, 3);
        }
    }

    private void processEntSingle(Entity entity) {
        ArrayList arrayList = new ArrayList();
        this.addEntity(entity, arrayList);
        for (Entity entity2 : arrayList) {
            this.deleteMappedTables(entity2, 1);
            if (entity2 == entity) continue;
        }
        this.processEntity(entity, 1);
    }

    private void processEntLeaf(Entity entity) {
        ArrayList arrayList = new ArrayList();
        ArrayList<Entity> arrayList2 = new ArrayList<Entity>();
        this.addEntity(entity, arrayList);
        for (Entity entity2 : arrayList) {
            this.deleteMappedTables(entity2, 2);
            if (entity2.hasHierarchicalChildren()) continue;
            arrayList2.add(entity2);
        }
        for (Entity entity2 : arrayList2) {
            this.processEntity(entity2, 2);
        }
    }

    private void addEntity(Entity entity, List list) {
        list.add(entity);
        int n = entity.getHierarchicalChildrenCount();
        for (int i = 0; i < n; ++i) {
            Entity entity2 = entity.getHierarchicalChild(i);
            this.addEntity(entity2, list);
        }
    }

    private void singleTableInheritance(Entity entity) {
        if (entity.isHierarchicalEntityType()) {
            if (entity.isHierarchicalRoot()) {
                this.processEntity(entity, 1);
            } else {
                this.deleteMappedTables(entity, 1);
            }
        }
    }

    private void deleteMappedTables(Entity entity, int n) {
        List list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
        for (XtdMapping xtdMapping : list) {
            Table table;
            DesignObject designObject;
            int n2 = xtdMapping.getInheritanceType();
            if (n2 == 0 && entity.isHierarchicalRoot() && "Single Table".equals(entity.getFwdEngineeringStrategyName()) || n2 == n || !((designObject = xtdMapping.getObjectMappedTo(entity)) instanceof Table) || (table = (Table)designObject) == null || !this.fwdEngineering.shouldDelete(table)) continue;
            List list2 = this.xmap.getMappingsForDesignPart(table, entity.getDesignPart().getObjectID());
            list2.addAll(this.getMappingsOfAllElements(table));
            table.removeAllFKAssociations();
            table.removeDependentFKAssociations();
            table.remove();
            for (XtdMapping xtdMapping2 : list2) {
                this.xmap.removeMapping(xtdMapping2);
            }
        }
    }

    private List getMappingsOfAllElements(Table table) {
        List list;
        Object object2;
        String string = this.design.getLogicalDesign().getObjectID();
        ArrayList arrayList = new ArrayList();
        for (Object object2 : table.getElementsCollection()) {
            List list2 = this.xmap.getMappingsForDesignPart((DesignObject)object2, string);
            arrayList.addAll(list2);
        }
        object2 = table.getKeys();
        for (int i = 0; i < ((KeyObject[])object2).length; ++i) {
            DesignObject designObject = (Index)object2[i];
            list = null;
            list = designObject.isFK() ? this.xmap.getMappingsForDesignPart(designObject.getFKAssociation(), string) : this.xmap.getMappingsForDesignPart(designObject, string);
            arrayList.addAll(list);
        }
        Collection collection = this.pdes.getFKIndexAssociationSet().getAssociationsWith(table);
        for (DesignObject designObject : collection) {
            list = this.xmap.getMappingsForDesignPart(designObject, string);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private void tablePerChildInheritance(Entity entity) {
        if (entity.isHierarchicalEntityType()) {
            if (!entity.hasHierarchicalChildren()) {
                this.processEntity(entity, 2);
            } else {
                this.deleteMappedTables(entity, 2);
            }
        }
    }

    private void processEntity(Entity entity, int n) {
        block9: {
            List list;
            block8: {
                XtdMapping xtdMapping;
                list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
                if (list.size() != 0) break block8;
                if (!entity.shouldBeEngineered()) break block9;
                String string = entity.getDesign().transformNameFromLogicalToRelational(entity);
                Table table = this.pdes.createTable(string);
                XtdMapping xtdMapping2 = this.xmap.createMapping(entity, table);
                xtdMapping2.setInheritanceType(n);
                xtdMapping2.initializeContained();
                this.copyPropertiesFromEntityToTable(entity, table);
                if (this.design.isEngineerCoordinates()) {
                    this.fwdEngineering.setGraphicalPropertiesOnNewObject(entity, table);
                }
                if ((xtdMapping = entity.getDeletedMapping(table.getDesignPartId())) == null) break block9;
                entity.updateDeletedMappings(xtdMapping.getDeletedID(), table.getObjectID(), table.getDesignPartId());
                this.xmap.removeMapping(xtdMapping);
                break block9;
            }
            for (XtdMapping xtdMapping : list) {
                Table table;
                if (n == 3 && xtdMapping.getInheritanceType() != 3 || n == 2 && xtdMapping.getInheritanceType() == 3) {
                    table = (Table)xtdMapping.getObjectMappedTo(entity);
                    if (table != null) {
                        table.removeAllFKAssociations();
                        table.removeAllKeys();
                        table.removeAll();
                        xtdMapping.initializeContained();
                    }
                } else {
                    table = (Table)xtdMapping.getObjectMappedTo(entity);
                    if (table != null) {
                        EngPropertiesComparator engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(entity.getObjectID() + table.getObjectID());
                        if (engPropertiesComparator != null) {
                            engPropertiesComparator.copySelectedProperties();
                        }
                        if (this.design.isEngineerCoordinates()) {
                            this.fwdEngineering.setGraphicalPropertiesOnNewObject(entity, table);
                        }
                    }
                }
                xtdMapping.setInheritanceType(n);
            }
        }
    }

    private void copyPropertiesFromEntityToTable(Entity entity, Table table) {
        table.setGeneratorID(entity.getObjectID());
        table.setComment(entity.getComment());
        table.setNotes(entity.getNotes());
        table.setCommentInRDBMS(entity.getCommentInRDBMS());
        table.setTypeID(entity.getTypeID());
        table.setScope(entity.getScope());
        table.setBasedOnStructuredType(entity.getBasedOnStructuredType());
        this.copyVolumesProps(entity, table);
        table.setAbbreviation(entity.getShortName());
    }

    private void copyVolumesProps(Entity entity, Table table) {
        table.setMinVolumes(entity.getMinVolumes());
        table.setExpectedVolumes(entity.getExpectedVolumes());
        table.setMaxVolumes(entity.getMaxVolumes());
        table.setGrowthPercent(entity.getGrowthPercent());
        table.setGrowthType(entity.getGrowthType());
        table.setNormalForm(entity.getNormalForm());
        table.setAdequatelyNormalized(entity.getAdequatelyNormalized());
    }

    void inheritancePostProcessing(Object[] objectArray) {
        Entity entity;
        int n;
        for (n = 0; n < objectArray.length; ++n) {
            entity = (Entity)objectArray[n];
            List list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
            for (XtdMapping xtdMapping : list) {
                DesignObject designObject = xtdMapping.getObjectMappedTo(entity);
                if (designObject == null || !(designObject instanceof Table)) continue;
                Table table = (Table)designObject;
                if (!entity.isHierarchicalEntityType()) continue;
                if ("Table for each entity".equals(entity.getFwdEngineeringStrategyName())) {
                    this.fwdEngineering.processAttributes(entity, table, xtdMapping);
                    this.fwdEngineering.processKeys(entity, table, xtdMapping);
                    continue;
                }
                if ("Single Table".equals(entity.getFwdEngineeringStrategyName())) {
                    if (!entity.isHierarchicalRoot()) continue;
                    this.processAttributes_Single(entity, table, xtdMapping);
                    this.processKeys_Single(entity, table, xtdMapping);
                    continue;
                }
                if (!"Table per child".equals(entity.getFwdEngineeringStrategyName()) || entity.hasHierarchicalChildren()) continue;
                this.processAttributes_Leaf(entity, table, xtdMapping);
                this.processKeys_Leaf(entity, table, xtdMapping);
            }
        }
        for (n = 0; n < objectArray.length; ++n) {
            entity = (Entity)objectArray[n];
            if (!entity.isHierarchicalEntityType() || !"Table for each entity".equals(entity.getFwdEngineeringStrategyName()) || !entity.isHierarchicalRoot()) continue;
            this.createFKeys(entity);
        }
    }

    private void createFKeys(Entity entity) {
        XtdMapping xtdMapping;
        Table table;
        List list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
        if (list.size() == 1 && (table = (Table)(xtdMapping = (XtdMapping)list.get(0)).getObjectMappedTo(entity)) != null) {
            CandidateKey candidateKey = (CandidateKey)entity.getPKorUnique();
            KeyObject keyObject = null;
            if (candidateKey != null) {
                keyObject = candidateKey.getEngIndex(this.pdes);
            }
            if (keyObject == null && (keyObject = table.getPKorUnique()) == null) {
                keyObject = this.createSurrogatePKandColumn(table);
                if (candidateKey != null && keyObject != null) {
                    XtdMapping xtdMapping2 = this.xmap.createMapping(candidateKey, keyObject);
                    xtdMapping2.setInheritanceType(3);
                    xtdMapping2.setCreationTime(System.currentTimeMillis());
                }
            }
            int n = entity.getHierarchicalChildrenCount();
            for (int i = 0; i < n; ++i) {
                Entity entity2 = entity.getHierarchicalChild(i);
                this.createFKey(entity2, candidateKey, keyObject);
            }
        }
    }

    private Index createSurrogatePKandColumn(Table table) {
        Index index = table.createIndex();
        index.setPK(true);
        Column column = table.createColumn();
        column.setName(table.getName() + _ID);
        LogicalDatatype logicalDatatype = (LogicalDatatype)table.getDesign().getLogicalDatatypeSet().getByName("Numeric", false);
        if (logicalDatatype == null) {
            logicalDatatype = table.getDesign().getLogicalDatatypeSet().getFirstNumberDataType();
        }
        if (logicalDatatype != null) {
            column.setLogicalDatatype(logicalDatatype);
            column.setUse((short)1);
        }
        String string = ApplyNamingStandards.createPK_Name(table.getName(), table.getDesign().getDLSettings().getNamingStandardRule(), table.getDesignPart().getName(), table.getAbbreviation());
        index.setName(string);
        index.add(column);
        table.moveToIndex(column, 0);
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFKey(Entity entity, CandidateKey candidateKey, KeyObject keyObject) {
        Table table = entity.getEngTable(this.pdes);
        if (table != null) {
            DesignObject designObject;
            DesignObject designObject2;
            RepositoryObject repositoryObject;
            RepositoryObject repositoryObject2;
            InheritanceRelation inheritanceRelation = (InheritanceRelation)entity.getInheritanceRelation();
            List list = this.xmap.getMappingsForDesignPart(inheritanceRelation, this.targetDesPartID);
            if (list.size() == 0) {
                repositoryObject2 = table.getFKIndexAssociationFor(keyObject);
                if (repositoryObject2 == null) {
                    this.design.setPropagatePKChahges(true);
                    try {
                        repositoryObject2 = table.addFK(keyObject, inheritanceRelation);
                    }
                    finally {
                        this.design.setPropagatePKChahges(false);
                    }
                }
                repositoryObject = this.xmap.createMapping(inheritanceRelation, (DesignObject)repositoryObject2);
                ((XtdMapping)repositoryObject).setInheritanceType(4);
                ((XtdMapping)repositoryObject).setCreationTime(System.currentTimeMillis());
                for (Column column : ((FKIndexAssociation)repositoryObject2).getLocalFKIndex().getElementsCollection()) {
                    Column column2 = column.getDelegate();
                    if (column2 == null || (designObject2 = column2.getEngAttribute()) == null) continue;
                    designObject = null;
                    if (((Attribute)designObject2).isFKAttribute()) {
                        designObject = ((Attribute)designObject2).getOriginatingAttribute();
                    }
                    repositoryObject = designObject != null ? this.xmap.createMapping(designObject, column) : this.xmap.createMapping(designObject2, column);
                    ((XtdMapping)repositoryObject).setInheritanceType(5);
                    ((XtdMapping)repositoryObject).setCreationTime(System.currentTimeMillis());
                }
            }
            if ((list = this.xmap.getMappingsForDesignPart(inheritanceRelation, this.targetDesPartID)).size() > 0) {
                repositoryObject2 = (XtdMapping)list.get(0);
                repositoryObject = table.getFKIndexAssociationFor(keyObject);
                if (repositoryObject != null && repositoryObject == ((XtdMapping)repositoryObject2).getObjectMappedTo(inheritanceRelation)) {
                    Index index = this.synchronizeFKandSetPK((FKIndexAssociation)repositoryObject, (Index)keyObject, entity, candidateKey);
                    int n = entity.getHierarchicalChildrenCount();
                    for (int i = 0; i < n; ++i) {
                        designObject2 = entity.getHierarchicalChild(i);
                        designObject = (CandidateKey)((ContainerWithKeyObject)designObject2).getPK();
                        if (designObject != null) {
                            this.createFKey((Entity)designObject2, (CandidateKey)designObject, index);
                            continue;
                        }
                        this.createFKey((Entity)designObject2, candidateKey, index);
                    }
                }
            }
        }
    }

    private Index synchronizeFKandSetPK(FKIndexAssociation fKIndexAssociation, Index index, Entity entity, CandidateKey candidateKey) {
        Table table = (Table)fKIndexAssociation.getContainerWithKeyObject();
        fKIndexAssociation.synchronizeFKColumns();
        CandidateKey candidateKey2 = (CandidateKey)entity.getPK();
        Index index2 = null;
        if (candidateKey2 != null) {
            index2 = candidateKey2.getEngIndex(this.pdes);
        } else if (candidateKey != null) {
            index2 = candidateKey.getEngIndex(this.pdes, table);
        }
        if (index2 != null) {
            for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
                if (index2.contains(column)) continue;
                index2.add(column);
            }
            return index2;
        }
        index2 = (Index)table.getPK();
        if (index2 == null) {
            index2 = table.createIndex();
            index2.setPK(true);
            String string = ApplyNamingStandards.createPK_Name(table.getName(), table.getDesign().getDLSettings().getNamingStandardRule(), table.getDesignPart().getName(), table.getAbbreviation());
            index2.setName(string);
            index2.getElementsCollection().addAll(fKIndexAssociation.getLocalFKIndex().getElementsCollection());
            if (candidateKey != null && index2 != null) {
                XtdMapping xtdMapping = this.xmap.createMapping(candidateKey, index2);
                xtdMapping.setInheritanceType(3);
                xtdMapping.setCreationTime(System.currentTimeMillis());
            }
        } else {
            for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
                if (index2.contains(column)) continue;
                index2.add(column);
            }
        }
        return index2;
    }

    private void processAttributes_Single(Entity entity, Table table, XtdMapping xtdMapping) {
        this.fwdEngineering.processAttributes(entity, table, xtdMapping);
        if (entity.isHierarchicalEntityType()) {
            int n = entity.getHierarchicalChildrenCount();
            for (int i = 0; i < n; ++i) {
                Entity entity2 = entity.getHierarchicalChild(i);
                XtdMapping xtdMapping2 = entity2.getMappingFor(table);
                if (xtdMapping2 != null) {
                    this.processAttributes_Single(entity2, table, xtdMapping2);
                    continue;
                }
                XtdMapping xtdMapping3 = this.xmap.createMapping(entity2, table);
                xtdMapping3.initializeContained();
                xtdMapping3.setInheritanceType(1);
                this.processAttributes_Single(entity2, table, xtdMapping3);
            }
        }
    }

    private void processAttributes_Leaf(Entity entity, Table table, XtdMapping xtdMapping) {
        Entity entity2;
        if (entity.isHierarchicalEntityType() && (entity2 = entity.getHierarchicalParent()) != null) {
            XtdMapping xtdMapping2 = entity2.getMappingFor(table);
            if (xtdMapping2 != null) {
                this.processAttributes_Leaf(entity2, table, xtdMapping2);
            } else {
                XtdMapping xtdMapping3 = this.xmap.createMapping(entity2, table);
                xtdMapping3.initializeContained();
                xtdMapping3.setInheritanceType(2);
                this.processAttributes_Leaf(entity2, table, xtdMapping3);
            }
        }
        this.fwdEngineering.processAttributes(entity, table, xtdMapping);
    }

    private void processKeys_Leaf(Entity entity, Table table, XtdMapping xtdMapping) {
        XtdMapping xtdMapping2;
        Entity entity2;
        this.fwdEngineering.processKeys(entity, table, xtdMapping);
        if (entity.isHierarchicalEntityType() && (entity2 = entity.getHierarchicalParent()) != null && (xtdMapping2 = entity2.getMappingFor(table)) != null) {
            this.processKeys_Leaf(entity2, table, xtdMapping2);
        }
    }

    private List getRelationMappingsFor(List list, Entity entity, Entity entity2) {
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        for (XtdMapping xtdMapping : list) {
            if (!entity.getObjectID().equals(xtdMapping.getRealSourceEntityID()) || !entity2.getObjectID().equals(xtdMapping.getRealTargetEntityID())) continue;
            arrayList.add(xtdMapping);
        }
        if (arrayList.size() == 0) {
            for (XtdMapping xtdMapping : list) {
                if (xtdMapping.getRealSourceEntityID() != null || xtdMapping.getRealTargetEntityID() != null) continue;
                arrayList.add(xtdMapping);
            }
        } else {
            return arrayList;
        }
        if (arrayList.size() != list.size()) {
            arrayList.clear();
        }
        return arrayList;
    }

    void processRelation(Relation relation) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        ArrayList<Entity> arrayList2 = new ArrayList<Entity>();
        Entity entity = relation.getSourceEntity();
        Entity entity2 = relation.getTargetEntity();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (entity.isHierarchicalEntityType()) {
            if ("Table per child".equals(entity.getFwdEngineeringStrategyName())) {
                arrayList.addAll(entity.getHierarchicalLeaves());
                n = 2;
            } else if ("Single Table".equals(entity.getFwdEngineeringStrategyName())) {
                arrayList.add(entity.getHierarchicalRoot());
                n = 1;
            } else if ("Table for each entity".equals(entity.getFwdEngineeringStrategyName())) {
                arrayList.add(entity);
                n = 3;
            }
        } else {
            arrayList.add(entity);
        }
        if (entity2.isHierarchicalEntityType()) {
            if ("Table per child".equals(entity2.getFwdEngineeringStrategyName())) {
                arrayList2.addAll(entity2.getHierarchicalLeaves());
                n2 = 2;
            } else if ("Single Table".equals(entity2.getFwdEngineeringStrategyName())) {
                arrayList2.add(entity2.getHierarchicalRoot());
                n2 = 1;
            } else if ("Table for each entity".equals(entity2.getFwdEngineeringStrategyName())) {
                arrayList2.add(entity2);
                n2 = 3;
            }
        } else {
            arrayList2.add(entity2);
        }
        n3 = n != 0 ? n : n2;
        List list = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
        this.clearPreviousIntermediateTables(relation, list, arrayList, arrayList2);
        for (int i = 0; i < arrayList.size(); ++i) {
            Entity entity3 = (Entity)arrayList.get(i);
            for (int j = 0; j < arrayList2.size(); ++j) {
                Entity entity4 = (Entity)arrayList2.get(j);
                if (relation.isManyToMany()) {
                    this.processRelationManyToMany(relation, entity3, entity4, n3);
                }
                if (entity == entity2) {
                    this.processRelation(relation, entity3, entity3, n3);
                    continue;
                }
                this.processRelation(relation, entity3, entity4, n3);
            }
        }
    }

    private void clearPreviousIntermediateTables(Relation relation, List list, List list2, List list3) {
        for (XtdMapping xtdMapping : list) {
            DesignObject designObject = xtdMapping.getObjectMappedTo(relation);
            if (designObject == null || 0 == xtdMapping.getInheritanceType() || this.containsDesObject(list2, xtdMapping.getRealSourceEntityID()) && this.containsDesObject(list3, xtdMapping.getRealTargetEntityID()) || !this.fwdEngineering.shouldDelete(designObject) || !(designObject instanceof Table)) continue;
            designObject.remove();
            this.xmap.removeMapping(xtdMapping);
        }
    }

    private boolean containsDesObject(List list, String string) {
        for (DesignObject designObject : list) {
            if (!designObject.getObjectID().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void removeDeletedMapping(Relation relation, DesignObject designObject) {
        XtdMapping xtdMapping = relation.getDeletedMapping(designObject.getDesignPartId(), designObject.getObjectID());
        if (xtdMapping != null) {
            this.xmap.removeMapping(xtdMapping);
        }
    }

    private void copyPropertiesFromRelationToTable(Relation relation, Table table) {
        table.setTemporaryWriteable(true);
        table.setName(relation.getName());
        table.setComment(relation.getComment());
        table.setNotes(relation.getNotes());
        table.setCommentInRDBMS(relation.getCommentInRDBMS());
        table.setTemporaryWriteable(false);
    }

    private List getMatched(Relation relation, List list, Entity entity, List list2) {
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        for (XtdMapping xtdMapping : list) {
            DesignObject designObject = xtdMapping.getObjectMappedTo(relation);
            if (designObject == null || !(designObject instanceof FKIndexAssociation)) continue;
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)designObject;
            for (XtdMapping xtdMapping2 : list2) {
                DesignObject designObject2 = xtdMapping2.getObjectMappedTo(entity);
                if (designObject2 == null || !(designObject2 instanceof Table) || designObject2 != fKIndexAssociation.getRemoteTable() && designObject2 != fKIndexAssociation.getContainerWithKeyObject()) continue;
                arrayList.add(xtdMapping2);
            }
        }
        return arrayList;
    }

    private List getMappingsForTables(Relation relation, List list, Table table, Table table2) {
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        for (XtdMapping xtdMapping : list) {
            FKIndexAssociation fKIndexAssociation;
            DesignObject designObject = xtdMapping.getObjectMappedTo(relation);
            if (designObject == null || !(designObject instanceof FKIndexAssociation) || ((fKIndexAssociation = (FKIndexAssociation)designObject).getContainerWithKeyObject() != table || fKIndexAssociation.getRemoteTable() != table2) && (fKIndexAssociation.getContainerWithKeyObject() != table2 || fKIndexAssociation.getRemoteTable() != table)) continue;
            arrayList.add(xtdMapping);
        }
        return arrayList;
    }

    private void processRelation(Relation relation, Entity entity, Entity entity2, int n) {
        List list = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
        Entity entity3 = relation.getSourceEntity();
        Entity entity4 = relation.getTargetEntity();
        List list2 = this.getRelationMappingsFor(list, entity, entity2);
        Table table = null;
        Table table2 = null;
        List list3 = entity.getEngTables(this.pdes);
        List list4 = entity2.getEngTables(this.pdes);
        List list5 = null;
        List list6 = null;
        if (list2.size() > 0) {
            list5 = this.getMatched(relation, list2, entity, list3);
            list6 = this.getMatched(relation, list2, entity2, list4);
        } else {
            list5 = list3;
            list6 = list4;
        }
        for (int i = 0; i < list5.size(); ++i) {
            XtdMapping xtdMapping = (XtdMapping)list5.get(i);
            table = (Table)xtdMapping.getObjectMappedTo(entity);
            for (int j = 0; j < list6.size(); ++j) {
                ContainerWithKeyObject containerWithKeyObject;
                Object object;
                Object object2;
                Object object3;
                XtdMapping xtdMapping2 = (XtdMapping)list6.get(j);
                table2 = (Table)xtdMapping2.getObjectMappedTo(entity2);
                if (table == null || table2 == null) continue;
                int[] nArray = relation.getPKProviderEndPoint();
                List list7 = this.getMappingsForTables(relation, list2, table, table2);
                if (list7.size() == 1 && (object3 = ((XtdMapping)(object2 = (XtdMapping)list7.get(0))).getObjectMappedTo(relation)) != null && object3 instanceof Table) {
                    ((DesignObject)object3).remove();
                    this.removeDeletedMapping(relation, (DesignObject)object3);
                    list7.clear();
                }
                if (list7.size() > 0 && nArray.length == 0) {
                    object2 = new ArrayList(list7);
                    object3 = object2.iterator();
                    while (object3.hasNext()) {
                        XtdMapping xtdMapping3 = (XtdMapping)object3.next();
                        object = xtdMapping3.getObjectMappedTo(relation);
                        if (object == null || !this.fwdEngineering.shouldDelete((DesignObject)object)) continue;
                        if (object instanceof FKIndexAssociation) {
                            ((FKIndexAssociation)object).setSilentRemove(true);
                        }
                        ((DesignObject)object).remove();
                        this.removeDeletedMapping(relation, (DesignObject)object);
                        list7.remove(object);
                    }
                } else if (list7.size() == 2 && nArray.length == 1) {
                    object2 = relation.getEntity(nArray[0]);
                    object3 = null;
                    if (object2 == entity3) {
                        object3 = table;
                    } else if (object2 == entity4) {
                        object3 = table2;
                    }
                    for (int k = 0; k < list7.size(); ++k) {
                        FKIndexAssociation fKIndexAssociation;
                        Table table3;
                        object = (XtdMapping)list7.get(k);
                        DesignObject designObject = ((XtdMapping)object).getObjectMappedTo(relation);
                        if (designObject == null || !(designObject instanceof FKIndexAssociation) || (table3 = (fKIndexAssociation = (FKIndexAssociation)designObject).getRemoteTable()) == object3 || !this.fwdEngineering.shouldDelete(fKIndexAssociation)) continue;
                        fKIndexAssociation.setSilentRemove(true);
                        fKIndexAssociation.remove();
                        this.removeDeletedMapping(relation, fKIndexAssociation);
                    }
                } else if (list7.size() == 1 && nArray.length == 2) {
                    object2 = (XtdMapping)list7.get(0);
                    object3 = ((XtdMapping)object2).getObjectMappedTo(relation);
                    if (object3 != null && object3 instanceof FKIndexAssociation) {
                        FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)object3;
                        object = fKIndexAssociation.getRemoteTable();
                        for (int k = 0; k < nArray.length; ++k) {
                            containerWithKeyObject = relation.getEntity(nArray[k]);
                            Table table4 = null;
                            if (containerWithKeyObject == entity3) {
                                table4 = table;
                            } else if (containerWithKeyObject == entity4) {
                                table4 = table2;
                            }
                            if (object == table4) continue;
                            this.createFK(relation, entity3, entity4, table, table2, entity, entity2, nArray[k]);
                            break;
                        }
                    }
                } else if (list7.size() == 1 && nArray.length == 1) {
                    FKIndexAssociation fKIndexAssociation;
                    object2 = relation.getEntity(nArray[0]);
                    object3 = null;
                    if (object2 == entity3) {
                        object3 = table;
                    } else if (object2 == entity4) {
                        object3 = table2;
                    }
                    XtdMapping xtdMapping4 = (XtdMapping)list7.get(0);
                    object = xtdMapping4.getObjectMappedTo(relation);
                    if (object != null && object instanceof FKIndexAssociation && (containerWithKeyObject = (fKIndexAssociation = (FKIndexAssociation)object).getRemoteTable()) != object3 && this.fwdEngineering.shouldDelete(fKIndexAssociation)) {
                        fKIndexAssociation.setSilentRemove(true);
                        fKIndexAssociation.remove();
                        this.removeDeletedMapping(relation, fKIndexAssociation);
                    }
                }
                if (list7.size() == 0) {
                    for (int k = 0; k < nArray.length; ++k) {
                        this.createFK(relation, entity3, entity4, table, table2, entity, entity2, nArray[k]);
                    }
                }
                object2 = list7.iterator();
                while (object2.hasNext()) {
                    object3 = (XtdMapping)object2.next();
                    DesignObject designObject = ((XtdMapping)object3).getObjectMappedTo(relation);
                    if (designObject == null) continue;
                    object = (EngPropertiesComparator)this.comparatorsMap.get(relation.getObjectID() + designObject.getObjectID());
                    RelationFKComparator relationFKComparator = null;
                    boolean bl = false;
                    if (object != null) {
                        ((EngPropertiesComparator)object).copySelectedProperties();
                        if (object instanceof RelationFKComparator && (relationFKComparator = (RelationFKComparator)object) != null && relationFKComparator.isMandatoryDefined()) {
                            bl = true;
                        }
                    }
                    if (relation.isManyToMany()) continue;
                    for (int k = 0; k < nArray.length; ++k) {
                        this.synchronizeFKColumns((XtdMapping)object3, relation, entity3, entity4, table, table2, nArray[k], bl);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRelationManyToMany(Relation relation, Entity entity, Entity entity2, int n) {
        List list = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
        List list2 = this.getRelationMappingsFor(list, entity, entity2);
        Table table = entity.getEngTable(this.pdes);
        Table table2 = entity2.getEngTable(this.pdes);
        if (table != null && table2 != null && relation.isManyToMany()) {
            Object object;
            DesignObject designObject;
            RepositoryObject repositoryObject2;
            if (list2.size() > 1) {
                for (RepositoryObject repositoryObject2 : list2) {
                    designObject = ((XtdMapping)repositoryObject2).getObjectMappedTo(relation);
                    if (designObject == null || !this.fwdEngineering.shouldDelete(designObject)) continue;
                    designObject.remove();
                    this.removeDeletedMapping(relation, designObject);
                }
                list2.clear();
            } else if (list2.size() == 1) {
                object = (XtdMapping)list2.get(0);
                repositoryObject2 = ((XtdMapping)object).getObjectMappedTo(relation);
                if (repositoryObject2 != null && !(repositoryObject2 instanceof Table)) {
                    if (this.fwdEngineering.shouldDelete((DesignObject)repositoryObject2)) {
                        ((DesignObject)repositoryObject2).remove();
                        this.removeDeletedMapping(relation, (DesignObject)repositoryObject2);
                    }
                    list2.clear();
                } else if (repositoryObject2 != null && repositoryObject2 instanceof Table) {
                    EngPropertiesComparator engPropertiesComparator;
                    designObject = (Table)repositoryObject2;
                    this.synchronizeFK(table, table2, (Table)designObject, relation);
                    if (designObject != null && (engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(relation.getObjectID() + designObject.getObjectID())) != null) {
                        engPropertiesComparator.copySelectedProperties();
                    }
                }
            }
            if (list2.size() == 0) {
                this.design.setPropagatePKChahges(true);
                try {
                    object = this.pdes.createTable();
                    this.copyPropertiesFromRelationToTable(relation, (Table)object);
                    repositoryObject2 = this.xmap.createMapping(relation, (DesignObject)object);
                    ((XtdMapping)repositoryObject2).setRealSourceEntityID(entity.getObjectID());
                    ((XtdMapping)repositoryObject2).setRealTargetEntityID(entity2.getObjectID());
                    ((XtdMapping)repositoryObject2).setInheritanceType(n);
                    designObject = ((Table)object).createIndex();
                    ((KeyObject)designObject).makePK();
                    if (table.getPK() != null && table2.getPK() != null) {
                        this.addFKFor(table, table2, (Table)object, (Index)designObject, relation);
                        this.addFKFor(table2, table, (Table)object, (Index)designObject, relation);
                    }
                    ((XtdMapping)repositoryObject2).setCreationTime(System.currentTimeMillis());
                }
                finally {
                    this.design.setPropagatePKChahges(false);
                }
            }
        }
    }

    private void synchronizeFKColumns(XtdMapping xtdMapping, Relation relation, Entity entity, Entity entity2, Table table, Table table2, int n, boolean bl) {
        DesignObject designObject = xtdMapping.getObjectMappedTo(relation);
        if (designObject != null && designObject instanceof FKIndexAssociation) {
            KeyObject keyObject;
            Object object;
            Object object2;
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)designObject;
            Entity entity3 = relation.getEntity(n);
            Entity entity4 = relation.getEntity(relation.getOtherEndPoint(n));
            Table table3 = null;
            Table table4 = null;
            if (entity3 == entity) {
                table3 = table;
                table4 = table2;
            } else if (entity3 == entity2) {
                table3 = table2;
                table4 = table;
            }
            if (table3 != null && table3 == fKIndexAssociation.getRemoteTable() && table4 != null && table4 == fKIndexAssociation.getContainerWithKeyObject()) {
                ContainedObject[] containedObjectArray;
                object2 = relation.getFKAttributes(entity4);
                object = null;
                keyObject = (CandidateKey)entity3.getPKorUnique();
                Entity entity5 = null;
                if (keyObject == null && (keyObject = (CandidateKey)entity3.getHierarchicalPK()) != null) {
                    entity5 = (Entity)keyObject.getContainerWithKeyObject();
                }
                if (keyObject != null) {
                    object = ((CandidateKey)keyObject).getEngIndex(this.pdes, table3);
                }
                if (object == null) {
                    object = (Index)table3.getPKorUnique();
                }
                if (object != null) {
                    containedObjectArray = object.getElements();
                    fKIndexAssociation.getLocalFKIndex().getElementsCollection().clear();
                    for (int i = 0; i < containedObjectArray.length; ++i) {
                        Column column;
                        Attribute attribute;
                        Column column2 = (Column)containedObjectArray[i];
                        Attribute attribute2 = column2.getEngAttribute(entity3);
                        Column column3 = table4.getFKColumn(fKIndexAssociation, column2);
                        if (attribute2 != null) {
                            if (attribute2.isFKAttribute() && (attribute = attribute2.getDelegate()) != null && (column = attribute.getEngColumn(this.pdes, table4)) != null && column.getContainer() == table4) {
                                column.addFKAssociation(column2, fKIndexAssociation);
                                fKIndexAssociation.getLocalFKIndex().add(column);
                                continue;
                            }
                            if (column3 == null) {
                                attribute = this.getAttributeforDelegate((ContainedObject[])object2, attribute2);
                                if (attribute == null || (column = attribute.getEngColumn(this.pdes, table4)) == null || column.getContainer() != table4) continue;
                                column.addFKAssociation(column2, fKIndexAssociation);
                                fKIndexAssociation.getLocalFKIndex().add(column);
                                continue;
                            }
                            attribute = this.getAttributeforDelegate((ContainedObject[])object2, attribute2);
                            if (attribute == null) continue;
                            column = attribute.getEngColumn(this.pdes, table4);
                            if (column != null && column.getContainer() == table4) {
                                column.addFKAssociation(column2, fKIndexAssociation);
                                fKIndexAssociation.getLocalFKIndex().add(column);
                                continue;
                            }
                            fKIndexAssociation.getLocalFKIndex().add(column3);
                            continue;
                        }
                        if (attribute2 != null || entity5 == null) continue;
                        attribute = column2.getEngAttribute(entity5);
                        if (attribute != null) {
                            attribute2 = entity4.getFKAttributeForOriginating(attribute, relation);
                        }
                        if (column3 == null && attribute2 != null) {
                            column = attribute2.getEngColumn(this.pdes, table4);
                            if (column == null || column.getContainer() != table4) continue;
                            column.addFKAssociation(column2, fKIndexAssociation);
                            fKIndexAssociation.getLocalFKIndex().add(column);
                            continue;
                        }
                        if (column3 == null) continue;
                        fKIndexAssociation.getLocalFKIndex().add(column3);
                    }
                }
                containedObjectArray = table4.getAllFKColumns(fKIndexAssociation);
                Index index = fKIndexAssociation.getLocalFKIndex();
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    if (index.contains(containedObjectArray[i])) continue;
                    ((Column)containedObjectArray[i]).removeFKAssociation(fKIndexAssociation.getObjectID());
                }
            }
            if (fKIndexAssociation != null) {
                if (!bl) {
                    int n2 = relation.getOtherEndPoint(n);
                    if (relation.getArc() != null) {
                        fKIndexAssociation.setMandatory(false);
                    } else {
                        fKIndexAssociation.setMandatory(!relation.isOptional(n2));
                    }
                }
                if (relation.isOneToOne()) {
                    object2 = fKIndexAssociation.getTable();
                    object = fKIndexAssociation.getColumns();
                    if (((Column[])object).length > 0 && (keyObject = ((Table)object2).getUniqueIndex_PK_UK((Column[])object)) == null) {
                        keyObject = ((Table)object2).getIndex((Column[])object);
                        if (keyObject == null) {
                            keyObject = ((Table)object2).createIndex();
                            for (int i = 0; i < ((Column[])object).length; ++i) {
                                ((Index)keyObject).add(object[i]);
                            }
                        }
                        ((Index)keyObject).setIndexState("Unique Plain Index");
                    }
                }
                this.fwdEngineering.synchronizeDeleteRule(relation, fKIndexAssociation, n);
                object2 = (TVConnector)fKIndexAssociation.getViewFor(fKIndexAssociation.getDesignPart().getMainView());
                object = (TVConnector)relation.getViewFor(relation.getDesignPart().getMainView());
                if (this.design.isEngineerCoordinates() && object2 != null && object != null) {
                    ReverseEngineering.copyConnectionPoints((TVConnector)object, (TVConnector)object2);
                }
            }
        }
    }

    private Attribute getAttributeforDelegate(ContainedObject[] containedObjectArray, Attribute attribute) {
        for (int i = 0; i < containedObjectArray.length; ++i) {
            Attribute attribute2 = (Attribute)containedObjectArray[i];
            if (!attribute2.isFKAttribute() || attribute2.getDelegate() != attribute) continue;
            return attribute2;
        }
        return null;
    }

    private void createFK(Relation relation, Entity entity, Entity entity2, Table table, Table table2, Entity entity3, Entity entity4, int n) {
        Entity entity5 = relation.getEntity(n);
        Entity entity6 = relation.getEntity(relation.getOtherEndPoint(n));
        Table table3 = null;
        Table table4 = null;
        if (entity5 == entity) {
            table3 = table;
            table4 = table2;
        } else if (entity5 == entity2) {
            table3 = table2;
            table4 = table;
        }
        if (table3 != null) {
            Index index = null;
            CandidateKey candidateKey = (CandidateKey)entity5.getPKorUnique();
            if (candidateKey == null) {
                candidateKey = (CandidateKey)entity5.getHierarchicalPK();
            }
            if (candidateKey != null) {
                index = candidateKey.getEngIndex(this.pdes, table3);
                if (index == null) {
                    index = (Index)table3.getPKorUnique();
                }
                if (index != null) {
                    Attribute attribute;
                    FKIndexAssociation fKIndexAssociation = table4.addFK((KeyObject)index, relation);
                    String string = relation.getName();
                    string = table4.getDesign().transformNameFromLogicalToRelational(relation);
                    fKIndexAssociation.setName(string);
                    XtdMapping xtdMapping = this.xmap.createMapping(relation, fKIndexAssociation);
                    xtdMapping.setRealSourceEntityID(entity3.getObjectID());
                    xtdMapping.setRealTargetEntityID(entity4.getObjectID());
                    ContainedObject[] containedObjectArray = relation.getFKAttributes(entity6);
                    if (containedObjectArray.length == 0 && entity5 == entity6) {
                        int n2 = relation.getEndPointFor(entity5);
                        n2 = relation.getOtherEndPoint(n2);
                        containedObjectArray = relation.getFKAttributes(n2);
                    }
                    if (containedObjectArray.length == 0 && entity5.getBasedOnStructuredType() != null && (attribute = entity6.getExactRefToStructurtedType(entity5.getBasedOnStructuredType(), entity5)) != null) {
                        containedObjectArray = new Attribute[]{attribute};
                    }
                    this.addFKColumns(containedObjectArray, entity5, index, table4, fKIndexAssociation, candidateKey, relation);
                    int n3 = relation.getOtherEndPoint(n);
                    fKIndexAssociation.setMandatory(!relation.isOptional(n3));
                    this.fwdEngineering.synchronizeDeleteRule(relation, fKIndexAssociation, n);
                    this.fwdEngineering.copyPropertiesFromRelationToFK(relation, fKIndexAssociation);
                    TVConnector tVConnector = (TVConnector)fKIndexAssociation.getViewFor(fKIndexAssociation.getDesignPart().getMainView());
                    TVConnector tVConnector2 = (TVConnector)relation.getViewFor(relation.getDesignPart().getMainView());
                    if (this.design.isEngineerCoordinates() && tVConnector != null && tVConnector2 != null) {
                        ReverseEngineering.copyConnectionPoints(tVConnector2, tVConnector);
                    }
                }
            }
        }
    }

    private void addFKFor(Table table, Table table2, Table table3, Index index, Relation relation) {
        Index index2 = (Index)table.getPK();
        if (index2 == null) {
            index2 = (Index)table.getPKorUnique();
        }
        if (index2 != null && (table == table2 && table3.getNumberOfFKAssociationFor(index2) < 2 || table != table2 && !table3.hasFKAssociationFor(index2))) {
            FKIndexAssociation fKIndexAssociation = table3.addFK((KeyObject)index2, relation);
            Column[] columnArray = fKIndexAssociation.getColumns();
            for (int i = 0; i < columnArray.length; ++i) {
                index.add(columnArray[i]);
            }
            fKIndexAssociation.setDeleteRule("CASCADE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeFK(Table table, Table table2, Table table3, Relation relation) {
        FKIndexAssociation fKIndexAssociation;
        Index index = (Index)table3.getPK();
        if (index == null) {
            index = table3.createIndex();
            index.makePK();
        }
        this.design.setPropagatePKChahges(true);
        try {
            this.addFKFor(table, table2, table3, index, relation);
            this.addFKFor(table2, table, table3, index, relation);
        }
        finally {
            this.design.setPropagatePKChahges(false);
        }
        Index index2 = (Index)table.getPKorUnique();
        if (index2 != null && (fKIndexAssociation = table3.getFKIndexAssociationFor(table.getPKorUnique())) != null) {
            fKIndexAssociation.synchronizeFKColumns();
            for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
                if (index.contains(column)) continue;
                index.add(column);
            }
        }
        if ((index2 = (Index)table2.getPKorUnique()) != null && (fKIndexAssociation = table3.getFKIndexAssociationFor(index2)) != null) {
            fKIndexAssociation.synchronizeFKColumns();
            for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
                if (index.contains(column)) continue;
                index.add(column);
            }
        }
    }

    private void addFKColumns(ContainedObject[] containedObjectArray, Entity entity, Index index, Table table, FKIndexAssociation fKIndexAssociation, KeyObject keyObject, Relation relation) {
        ContainedObject[] containedObjectArray2 = index.getElements();
        for (int i = 0; i < containedObjectArray2.length; ++i) {
            Column column;
            Attribute attribute;
            Column column2 = (Column)containedObjectArray2[i];
            Attribute attribute2 = column2.getEngAttribute(entity);
            if (attribute2 == null) {
                attribute2 = column2.getEngAttribute((Entity)keyObject.getContainerWithKeyObject());
            }
            if (attribute2 == null) continue;
            if (attribute2.isFKAttribute() && (attribute = attribute2.getDelegate()) != null && (column = attribute.getEngColumn(this.pdes, table)) != null && column.getContainer() == table) {
                column.addFKAssociation(column2, fKIndexAssociation);
                fKIndexAssociation.getLocalFKIndex().add(column);
                continue;
            }
            attribute = this.getAttributeforDelegate(containedObjectArray, attribute2);
            if (attribute == null || (column = attribute.getEngColumn(this.pdes, table)) == null || column.getContainer() != table) continue;
            if (column.hasOtherFK_forRelation(fKIndexAssociation, relation)) {
                Column column3 = table.createColumnFK(column2, fKIndexAssociation);
                column3.setName(column.getName());
                continue;
            }
            column.addFKAssociation(column2, fKIndexAssociation);
            fKIndexAssociation.getLocalFKIndex().add(column);
        }
    }

    public void setComparatorsMap(Map map) {
        this.comparatorsMap = map;
    }
}

