/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import javax.swing.JComponent;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class EngineeringObjectSelection
extends ModelIdObjectSelection {
    private GeneralPropertiesComparator propertiesComparator;
    private EngineeringObjectSelection correspondentNode;
    private JComponent dependentComponent;
    private boolean editable = true;
    private String rname;
    private boolean logicalModelObject = false;
    private boolean relationalModelObject = false;
    protected XtdMapping mapping;
    protected XtdMapping containerMapping;
    private boolean updateDependent = true;

    public EngineeringObjectSelection(ModelIDObject modelIDObject, XtdMapping xtdMapping, XtdMapping xtdMapping2) {
        super(modelIDObject);
        if (modelIDObject instanceof DesignObject) {
            this.logicalModelObject = ((DesignObject)modelIDObject).getDesignPart() instanceof LogicalDesign;
            this.relationalModelObject = ((DesignObject)modelIDObject).getDesignPart() instanceof RelationalDesign;
        }
        this.mapping = xtdMapping;
        this.containerMapping = xtdMapping2;
        this.selected = this.getObjectSelectionStatus();
    }

    public EngineeringObjectSelection(ModelIDObject modelIDObject, XtdMapping xtdMapping) {
        this(modelIDObject, xtdMapping, null);
    }

    public EngineeringObjectSelection(ModelIDObject modelIDObject) {
        super(modelIDObject);
        if (modelIDObject instanceof DesignObject) {
            this.logicalModelObject = ((DesignObject)modelIDObject).getDesignPart() instanceof LogicalDesign;
            this.relationalModelObject = ((DesignObject)modelIDObject).getDesignPart() instanceof RelationalDesign;
        }
        this.selected = this.getObject().getShouldEngineer();
    }

    public EngineeringObjectSelection(String string) {
        super(string);
    }

    public GeneralPropertiesComparator getPropertiesComparator() {
        return this.propertiesComparator;
    }

    public void setPropertiesComparator(GeneralPropertiesComparator generalPropertiesComparator) {
        this.propertiesComparator = generalPropertiesComparator;
    }

    public EngineeringObjectSelection getCorrespondentNode() {
        return this.correspondentNode;
    }

    public void setCorrespondentNode(EngineeringObjectSelection engineeringObjectSelection) {
        this.correspondentNode = engineeringObjectSelection;
    }

    public void applySelectionToEngineering() {
        ModelIDObject modelIDObject = this.getObject();
        if (this.getObject() != null) {
            if (this.mapping != null) {
                if (this.isLogicalModelObject()) {
                    this.mapping.setFwEngineer(this.isSelected());
                } else if (this.isRelationalModelObject()) {
                    this.mapping.setRevEngineer(this.isSelected());
                }
            } else if (this.mapping == null && this.containerMapping != null) {
                String string = this.getObject().getObjectID();
                if (this.isLogicalModelObject()) {
                    if (this.getObject() instanceof Attribute) {
                        if (this.isSelected()) {
                            if (!this.containerMapping.getAttributes().contains(string)) {
                                this.containerMapping.getAttributes().add(string);
                            }
                        } else {
                            this.containerMapping.getAttributes().remove(string);
                        }
                    } else if (this.getObject() instanceof KeyObject) {
                        if (this.isSelected()) {
                            if (!this.containerMapping.getKeys().contains(string)) {
                                this.containerMapping.getKeys().add(string);
                            }
                        } else {
                            this.containerMapping.getKeys().remove(string);
                        }
                    }
                } else if (this.isRelationalModelObject()) {
                    if (modelIDObject instanceof Column) {
                        if (this.isSelected()) {
                            if (!this.containerMapping.getColumns().contains(string)) {
                                this.containerMapping.getColumns().add(string);
                            }
                        } else {
                            this.containerMapping.getColumns().remove(string);
                        }
                    } else if (modelIDObject instanceof Index) {
                        if (this.isSelected()) {
                            if (!this.containerMapping.getIndexes().contains(string)) {
                                this.containerMapping.getIndexes().add(string);
                            }
                        } else {
                            this.containerMapping.getIndexes().remove(string);
                        }
                    }
                }
            }
            this.getObject().setShouldEngineer(this.isSelected());
        }
        int n = this.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            EngineeringObjectSelection engineeringObjectSelection = (EngineeringObjectSelection)this.getChild(i);
            engineeringObjectSelection.applySelectionToEngineering();
        }
    }

    private boolean getObjectSelectionStatus() {
        if (this.getObject() != null) {
            if (this.mapping != null) {
                if (this.isLogicalModelObject()) {
                    return this.mapping.isFwEngineer();
                }
                if (this.isRelationalModelObject()) {
                    return this.mapping.isRevEngineer();
                }
            } else if (this.mapping == null && this.containerMapping != null) {
                String string = this.getObject().getObjectID();
                if (this.isLogicalModelObject()) {
                    if (this.getObject() instanceof Attribute) {
                        return this.containerMapping.getAttributes().contains(string);
                    }
                    if (this.getObject() instanceof CandidateKey) {
                        return this.containerMapping.getKeys().contains(string);
                    }
                } else if (this.isRelationalModelObject()) {
                    if (this.getObject() instanceof Column) {
                        return this.containerMapping.getColumns().contains(string);
                    }
                    if (this.getObject() instanceof Index) {
                        return this.containerMapping.getIndexes().contains(string);
                    }
                }
            }
            return this.getObject().getShouldEngineer();
        }
        return false;
    }

    public void setStatus(int n) {
        if (n == STATE_MODIFIED) {
            if (this.status != STATE_NEW && this.status != STATE_DELETED) {
                this.status = n;
            }
        } else {
            this.status = n;
        }
    }

    public boolean isModified() {
        if (this.propertiesComparator != null && this.propertiesComparator instanceof EngPropertiesComparator) {
            if (((EngPropertiesComparator)this.propertiesComparator).isReadOnly()) {
                return false;
            }
            return this.propertiesComparator.isModified();
        }
        return false;
    }

    public boolean hasChildsWithChangeStatus() {
        for (EngineeringObjectSelection engineeringObjectSelection : this.childs) {
            if (!engineeringObjectSelection.isModified() && this.status == STATE_UNCHANGED) continue;
            return true;
        }
        for (EngineeringObjectSelection engineeringObjectSelection : this.childs) {
            if (!engineeringObjectSelection.hasChildsWithChangeStatus()) continue;
            return true;
        }
        return false;
    }

    public void resetModifiedStatus() {
        for (EngineeringObjectSelection engineeringObjectSelection : this.childs) {
            engineeringObjectSelection.resetModifiedStatus();
            if (engineeringObjectSelection.getStatus() == STATE_UNCHANGED) continue;
            this.setStatus(STATE_MODIFIED);
        }
        if (this.isModified() || this.hasChildsWithChangeStatus()) {
            this.setStatus(STATE_MODIFIED);
        }
    }

    @Override
    public String getName() {
        ModelIDObject modelIDObject = this.getObject();
        if (modelIDObject != null) {
            if (this.rname != null) {
                return this.rname;
            }
            if (modelIDObject instanceof KeyObject && ((KeyObject)modelIDObject).isPK()) {
                if (this.logicalModelObject) {
                    return "(PUID) " + modelIDObject.getName();
                }
                return "(PK) " + modelIDObject.getName();
            }
            return modelIDObject.getName();
        }
        if (this.rname != null) {
            return this.rname;
        }
        return super.getName();
    }

    @Override
    public boolean setName(String string) {
        this.rname = string;
        super.setName(string);
        return true;
    }

    public JComponent getDependentComponent() {
        return this.dependentComponent;
    }

    public void setDependentComponent(JComponent jComponent) {
        this.dependentComponent = jComponent;
    }

    @Override
    public void setSelected(boolean bl) {
        boolean bl2 = this.selected;
        super.setSelected(bl);
        if (bl2 != bl && this.updateDependent && this.dependentComponent != null) {
            this.dependentComponent.updateUI();
        }
    }

    public void setSelected(boolean bl, boolean bl2) {
        boolean bl3 = this.updateDependent;
        this.updateDependent = bl2;
        this.setSelected(bl);
        this.updateDependent = bl3;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public boolean isFiltered(List list) {
        for (Integer n : list) {
            if (n.intValue() != this.getStatus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFilteredChilds(List list) {
        for (EngineeringObjectSelection engineeringObjectSelection : this.getChilds()) {
            if (!engineeringObjectSelection.isFiltered(list) && !engineeringObjectSelection.hasFilteredChilds(list)) continue;
            return true;
        }
        return false;
    }

    public boolean isLogicalModelObject() {
        return this.logicalModelObject;
    }

    public boolean isRelationalModelObject() {
        return this.relationalModelObject;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }
}

