/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public abstract class EngPropertiesComparator
extends PropertyNames
implements GeneralPropertiesComparator {
    private DesignObject left_do;
    private DesignObject right_do;
    private boolean readOnly = false;
    protected List propertiesList = new ArrayList();

    public EngPropertiesComparator(DesignObject designObject, DesignObject designObject2) {
        this.left_do = designObject;
        this.right_do = designObject2;
    }

    @Override
    public List getPropertiesList() {
        return this.propertiesList;
    }

    @Override
    public abstract void copySelectedProperties();

    @Override
    public String getLeftName() {
        if (this.left_do != null) {
            return this.left_do.getName();
        }
        return "";
    }

    @Override
    public String getRightName() {
        if (this.right_do != null) {
            return this.right_do.getName();
        }
        return "";
    }

    protected void initNameProperty() {
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(NAME);
        engPropertyHolder.setLeftValue(this.left_do != null ? this.left_do.getName() : "");
        engPropertyHolder.setRightValue(this.right_do != null ? this.right_do.getName() : "");
        if (this.left_do != null && this.right_do != null && !this.left_do.getName().equals(this.right_do.getName())) {
            if (this.getDesign().isApplyNameStandardization()) {
                String string = "";
                string = this.left_do.getDesignPart() instanceof LogicalDesign ? this.getDesign().transformNameFromLogicalToRelational(this.left_do) : this.getDesign().transformNameFromRelationalToLogical(this.left_do);
                if (!string.equals(this.right_do.getName())) {
                    engPropertyHolder.setModified(true);
                    engPropertyHolder.setSelected(true);
                }
            } else {
                engPropertyHolder.setModified(true);
                engPropertyHolder.setSelected(true);
            }
        }
        this.propertiesList.add(engPropertyHolder);
    }

    protected void initNameTranslationProperty() {
        Object object;
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(NAME_TRANSLATION);
        String string = "";
        String string2 = "";
        boolean bl = false;
        if (this.left_do != null) {
            if (this.isFromLogicalToRelational()) {
                string = this.getDesign().transformNameFromLogicalToRelational(this.left_do);
                if (this.left_do instanceof Attribute) {
                    string2 = ((Attribute)this.left_do).getPreferredAbbreviation();
                } else if (this.left_do instanceof Entity) {
                    string2 = ((Entity)this.left_do).getPreferredAbbreviation();
                }
                if (!"".equals(string2) && this.getDesign().isUsePreferredAbbreviation()) {
                    engPropertyHolder.setLeftValue("(Pr.Abbr.)" + string2);
                    if (this.right_do != null && !string.equals(this.right_do.getName()) && (object = this.getPropertyHolderByName(NAME)) != null) {
                        ((EngPropertyHolder)object).setModified(true);
                        ((EngPropertyHolder)object).setSelected(true);
                    }
                    if (string.equalsIgnoreCase(string2)) {
                        bl = true;
                    }
                } else {
                    engPropertyHolder.setLeftValue(string);
                }
            } else {
                string = this.getDesign().transformNameFromRelationalToLogical(this.left_do);
                object = this.left_do.getName().trim();
                if (this.right_do != null) {
                    if (this.right_do instanceof Attribute) {
                        string2 = ((Attribute)this.right_do).getPreferredAbbreviation();
                    } else if (this.right_do instanceof Entity) {
                        string2 = ((Entity)this.right_do).getPreferredAbbreviation();
                    }
                    if (!"".equals(string2) && this.getDesign().isUsePreferredAbbreviation()) {
                        engPropertyHolder.setRightValue("(Pr.Abbr.)" + string2);
                        if (((String)object).equalsIgnoreCase(string2)) {
                            bl = true;
                        }
                    } else {
                        engPropertyHolder.setLeftValue(string);
                    }
                }
                engPropertyHolder.setLeftValue(string);
            }
        }
        if (this.left_do != null && this.right_do != null && !bl && !string.equals(this.right_do.getName()) && (object = this.getPropertyHolderByName(NAME)) != null) {
            ((EngPropertyHolder)object).setModified(true);
            ((EngPropertyHolder)object).setSelected(true);
        }
        engPropertyHolder.setModified(false);
        engPropertyHolder.setSelected(false);
        this.propertiesList.add(engPropertyHolder);
    }

    protected void initCommentsAndNotes() {
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(COMMENT);
        engPropertyHolder.setLeftValue(this.left_do != null ? this.left_do.getComment() : "");
        engPropertyHolder.setRightValue(this.right_do != null ? this.right_do.getComment() : "");
        if (this.left_do != null && this.right_do != null && !this.left_do.getComment().equals(this.right_do.getComment())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(COMMENT_IN_RDBMS);
        engPropertyHolder.setLeftValue(this.left_do != null ? this.left_do.getCommentInRDBMS() : "");
        engPropertyHolder.setRightValue(this.right_do != null ? this.right_do.getCommentInRDBMS() : "");
        if (this.left_do != null && this.right_do != null && !this.left_do.getCommentInRDBMS().equals(this.right_do.getCommentInRDBMS())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(NOTES);
        engPropertyHolder.setLeftValue(this.left_do != null ? this.left_do.getNotes() : "");
        engPropertyHolder.setRightValue(this.right_do != null ? this.right_do.getNotes() : "");
        if (this.left_do != null && this.right_do != null && !this.left_do.getNotes().equals(this.right_do.getNotes())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
    }

    protected void copyPropertiesFromLeftToRight() {
        if (this.left_do != null && this.right_do != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(NAME)) {
                    if (this.shouldApplyNametranslation()) {
                        if (this.isFromLogicalToRelational()) {
                            this.right_do.setName(this.getDesign().transformNameFromLogicalToRelational(this.left_do));
                            continue;
                        }
                        this.right_do.setName(this.getDesign().transformNameFromRelationalToLogical(this.left_do));
                        continue;
                    }
                    this.right_do.setName(this.left_do.getName());
                    continue;
                }
                if (engPropertyHolder.getName().equals(COMMENT)) {
                    this.right_do.setComment(this.left_do.getComment());
                    continue;
                }
                if (engPropertyHolder.getName().equals(COMMENT_IN_RDBMS)) {
                    this.right_do.setCommentInRDBMS(this.left_do.getCommentInRDBMS());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(NOTES)) continue;
                this.right_do.setNotes(this.left_do.getNotes());
            }
        }
        if (this.isDirty()) {
            this.right_do.setDirty(true);
        }
    }

    @Override
    public boolean isModified() {
        for (EngPropertyHolder engPropertyHolder : this.getPropertiesList()) {
            if (!engPropertyHolder.getName().equals(NAME) && engPropertyHolder.isModified() && !engPropertyHolder.isFiltered()) {
                return true;
            }
            if (!engPropertyHolder.getName().equals(NAME) || !engPropertyHolder.isModified() || engPropertyHolder.isFiltered() || !engPropertyHolder.isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getID() {
        if (this.left_do != null && this.right_do != null) {
            return this.left_do.getObjectID() + this.right_do.getObjectID();
        }
        if (this.left_do != null) {
            return this.left_do.getObjectID();
        }
        if (this.right_do != null) {
            return this.right_do.getObjectID();
        }
        return "null";
    }

    protected boolean isDirty() {
        for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
            if (!engPropertyHolder.isModified() || !engPropertyHolder.isSelected()) continue;
            return true;
        }
        return false;
    }

    public EngPropertyHolder getPropertyHolderByName(String string) {
        for (EngPropertyHolder engPropertyHolder : this.getPropertiesList()) {
            if (!engPropertyHolder.getName().equals(string)) continue;
            return engPropertyHolder;
        }
        return null;
    }

    private boolean isFromLogicalToRelational() {
        return this.left_do.getDesignPart() instanceof LogicalDesign;
    }

    public Design getDesign() {
        return this.left_do.getDesign();
    }

    protected boolean shouldApplyNametranslation() {
        return true;
    }

    protected boolean hasToBeRename() {
        return false;
    }

    protected boolean hasToBeDrop() {
        return false;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void applyCompareFilter(List list, boolean bl) {
        ArrayList<EngPropertyHolder> arrayList = new ArrayList<EngPropertyHolder>();
        ArrayList<EngPropertyHolder> arrayList2 = new ArrayList<EngPropertyHolder>();
        for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
            if (this.isHolderselected(engPropertyHolder.getName(), list)) {
                arrayList.add(engPropertyHolder);
                engPropertyHolder.setFiltered(false);
                continue;
            }
            arrayList2.add(engPropertyHolder);
            engPropertyHolder.setFiltered(true);
            engPropertyHolder.setEditable(false);
        }
        this.propertiesList.clear();
        this.propertiesList.addAll(arrayList);
        if (!bl) {
            this.propertiesList.addAll(arrayList2);
        }
    }

    protected boolean isHolderselected(String string, List list) {
        for (EngPropertyHolder engPropertyHolder : list) {
            if (!engPropertyHolder.getName().equalsIgnoreCase(string)) continue;
            return engPropertyHolder.isSelected();
        }
        return true;
    }
}

