/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.AbstractConstraint;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;

public abstract class EngCOPropertiesComparator
extends EngPropertiesComparator {
    private static final Logger LOGGER = new Logger(Settings.class);
    private ContainedObjectWithDomain left_co;
    private ContainedObjectWithDomain right_co;

    public EngCOPropertiesComparator(ContainedObjectWithDomain containedObjectWithDomain, ContainedObjectWithDomain containedObjectWithDomain2) {
        super(containedObjectWithDomain, containedObjectWithDomain2);
        this.left_co = containedObjectWithDomain;
        this.right_co = containedObjectWithDomain2;
    }

    public static String decodeDataTypeKindToString(ContainedObjectWithDomain containedObjectWithDomain) {
        short s = containedObjectWithDomain.getUse();
        if (s == 0) {
            return "Domain(" + containedObjectWithDomain.getDomain().getName() + ")";
        }
        if (s == 1) {
            return "Logical Type(" + containedObjectWithDomain.getLogicalDatatype().getName() + ")";
        }
        if (s == 2) {
            return "Distinct Type(" + containedObjectWithDomain.getDistinctType().getName() + ")";
        }
        if (s == 3) {
            return "Structured Type";
        }
        if (s == 4) {
            return "Collection Type";
        }
        return "";
    }

    public static String getType(ContainedObjectWithDomain containedObjectWithDomain) {
        String string = "";
        try {
            string = containedObjectWithDomain.getDesign().getDomainSet().getDefaultDomain().getDataType().toString();
        }
        catch (Exception exception) {
            LOGGER.error("EngCOPropertiesComparator: Unable to get default domain: ", exception);
        }
        short s = containedObjectWithDomain.getUse();
        if (s == 0 && containedObjectWithDomain.getDomain() != null) {
            string = containedObjectWithDomain.getDataType().toString();
        } else if (s == 1) {
            string = containedObjectWithDomain.getDataType().toString();
        } else if (s == 2) {
            if (containedObjectWithDomain.getDistinctType() != null) {
                string = containedObjectWithDomain.getDataType().toString();
            }
        } else if (s == 3) {
            if (containedObjectWithDomain.getStructuredType() != null) {
                string = containedObjectWithDomain.isReference() ? "REF " + containedObjectWithDomain.getStructuredType().getName() : containedObjectWithDomain.getStructuredType().getName();
            }
        } else if (s == 4 && containedObjectWithDomain.getCollectionType() != null) {
            string = containedObjectWithDomain.getCollectionType().getName();
        }
        return string;
    }

    private static boolean isDatatypeCompatible(ContainedObjectWithDomain containedObjectWithDomain, ContainedObjectWithDomain containedObjectWithDomain2) {
        String string;
        String string2;
        Datatype datatype = containedObjectWithDomain.getDataType();
        Datatype datatype2 = containedObjectWithDomain2.getDataType();
        if (datatype.getName().equalsIgnoreCase(datatype2.getName()) && datatype.getName().equalsIgnoreCase("VARCHAR2") && (string2 = containedObjectWithDomain.getSizeOnly()).equalsIgnoreCase(string = containedObjectWithDomain2.getSizeOnly())) {
            String string3;
            String string4 = containedObjectWithDomain.getUnits();
            return string4.equalsIgnoreCase(string3 = containedObjectWithDomain2.getUnits()) || !"CHAR".equals(string4) && !"CHAR".equals(string3);
        }
        return false;
    }

    public static void processDataTypeAndUse(List list, ContainedObjectWithDomain containedObjectWithDomain, ContainedObjectWithDomain containedObjectWithDomain2) {
        String string = containedObjectWithDomain != null ? EngCOPropertiesComparator.getType(containedObjectWithDomain) : "";
        String string2 = containedObjectWithDomain2 != null ? EngCOPropertiesComparator.getType(containedObjectWithDomain2) : "";
        String string3 = containedObjectWithDomain != null ? EngCOPropertiesComparator.decodeDataTypeKindToString(containedObjectWithDomain) : "";
        String string4 = containedObjectWithDomain2 != null ? EngCOPropertiesComparator.decodeDataTypeKindToString(containedObjectWithDomain2) : "";
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(DATA_TYPE);
        engPropertyHolder.setDDLHolder(true);
        engPropertyHolder.setLeftValue(string);
        engPropertyHolder.setRightValue(string2);
        if (containedObjectWithDomain != null && containedObjectWithDomain2 != null && !string.equals(string2)) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
            if (EngCOPropertiesComparator.isDatatypeCompatible(containedObjectWithDomain, containedObjectWithDomain2)) {
                engPropertyHolder.setSelected(false);
            }
        }
        list.add(engPropertyHolder);
        boolean bl = false;
        if (containedObjectWithDomain != null) {
            bl = containedObjectWithDomain.getDesignPart().getAppView().getSettings().isUseDataTypeKindInCompare();
        } else if (containedObjectWithDomain2 != null) {
            bl = containedObjectWithDomain2.getDesignPart().getAppView().getSettings().isUseDataTypeKindInCompare();
        }
        engPropertyHolder = new EngPropertyHolder(DATA_TYPE_KIND);
        engPropertyHolder.setLeftValue(string3);
        engPropertyHolder.setRightValue(string4);
        if (containedObjectWithDomain != null && containedObjectWithDomain2 != null && !string3.equals(string4)) {
            engPropertyHolder.setModified(true);
            if (bl && !PropertiesComparator.DDL_ONLY) {
                engPropertyHolder.setSelected(true);
            } else {
                engPropertyHolder.setEditable(false);
                engPropertyHolder.setFiltered(true);
            }
        }
        list.add(engPropertyHolder);
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        if (this.getDesign().isApplyNameStandardization()) {
            this.initNameTranslationProperty();
        }
        EngCOPropertiesComparator.processDataTypeAndUse(this.propertiesList, this.left_co, this.right_co);
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(MANDATORY);
        engPropertyHolder.setDDLHolder(true);
        engPropertyHolder.setLeftValue(this.left_co != null ? String.valueOf(!this.left_co.getNullsAllowed()) : "");
        engPropertyHolder.setRightValue(this.right_co != null ? String.valueOf(!this.right_co.getNullsAllowed()) : "");
        if (this.left_co != null && this.right_co != null && this.left_co.getNullsAllowed() != this.right_co.getNullsAllowed()) {
            if (this.left_co.isFKElement() && this.right_co.isFKElement()) {
                engPropertyHolder.setEditable(false);
                engPropertyHolder.setSelected(false);
                engPropertyHolder.setRightValue(engPropertyHolder.getRightValue() + "(FK)");
            } else {
                engPropertyHolder.setSelected(true);
                engPropertyHolder.setModified(true);
            }
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(DEFAULT_VALUE);
        engPropertyHolder.setDDLHolder(true);
        engPropertyHolder.setLeftValue(this.left_co != null ? this.left_co.getDefaultValue() : "");
        engPropertyHolder.setRightValue(this.right_co != null ? this.right_co.getDefaultValue() : "");
        if (this.left_co != null && this.right_co != null && !this.left_co.getDefaultValue().trim().equals(this.right_co.getDefaultValue().trim())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        this.propertiesList.add(EngCOPropertiesComparator.createCheckConstrNamePH(this.left_co, this.right_co));
        engPropertyHolder = new EngPropertyHolder(USE_DOMAIN_CONSTRAINT);
        engPropertyHolder.setLeftValue(this.left_co != null ? String.valueOf(this.left_co.getUseDomainConstraints()) : "");
        engPropertyHolder.setRightValue(this.right_co != null ? String.valueOf(this.right_co.getUseDomainConstraints()) : "");
        if (this.left_co != null && this.right_co != null && this.left_co.getUseDomainConstraints() != this.right_co.getUseDomainConstraints()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        if (this.left_co != null && !this.left_co.getUseDomainConstraints() || this.right_co != null && !this.right_co.getUseDomainConstraints()) {
            this.propertiesList.add(EngCOPropertiesComparator.createCheckConstrPH(this.left_co, this.right_co));
            this.propertiesList.add(EngCOPropertiesComparator.createRangeConstrPH(this.left_co, this.right_co));
            this.propertiesList.add(EngCOPropertiesComparator.createLOVConstraintPH(this.left_co, this.right_co));
        }
        this.initCommentsAndNotes();
        engPropertyHolder = new EngPropertyHolder(SOURCE_TYPE);
        String string = "";
        if (this.left_co != null) {
            string = this.left_co.getSourceType();
            if (this.left_co.getFormulaDesc().length() > 0 && !string.equalsIgnoreCase("Aggregate")) {
                string = "Derived";
            }
        }
        engPropertyHolder.setLeftValue(string);
        engPropertyHolder.setRightValue(this.right_co != null ? this.right_co.getSourceType() : "");
        if (this.left_co != null && this.right_co != null && !string.equals(this.right_co.getSourceType())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(FORMULA_DESC);
        engPropertyHolder.setLeftValue(this.left_co != null ? this.left_co.getFormulaDesc() : "");
        engPropertyHolder.setRightValue(this.right_co != null ? this.right_co.getFormulaDesc() : "");
        if (this.left_co != null && this.right_co != null && !this.left_co.getFormulaDesc().equals(this.right_co.getFormulaDesc())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(TYPE_SUBSTITUTION);
        engPropertyHolder.setLeftValue(this.left_co != null ? String.valueOf(this.left_co.isAllowSubtypeSubstitution()) : "");
        engPropertyHolder.setRightValue(this.right_co != null ? String.valueOf(this.right_co.isAllowSubtypeSubstitution()) : "");
        if (this.left_co != null && this.right_co != null && this.left_co.isAllowSubtypeSubstitution() != this.right_co.isAllowSubtypeSubstitution()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.left_co != null && this.right_co != null) {
            this.right_co.setTemporaryWriteable(true);
            super.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(DATA_TYPE) || engPropertyHolder.getName().equals(DATA_TYPE_KIND)) {
                    this.right_co.setDomain(this.left_co.getDomain());
                    this.right_co.setLogicalDatatype(this.left_co.getLogicalDatatype());
                    this.right_co.copyParametersFrom(this.left_co);
                    this.right_co.setStructuredType(this.left_co.getStructuredType());
                    this.right_co.setDistinctType(this.left_co.getDistinctType());
                    this.right_co.setReference(this.left_co.isReference());
                    this.right_co.setUse(this.left_co.getUse());
                    continue;
                }
                if (engPropertyHolder.getName().equals(TYPE_SUBSTITUTION)) {
                    this.right_co.setAllowSubtypeSubstitution(this.left_co.isAllowSubtypeSubstitution());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MANDATORY)) {
                    this.right_co.setNullsAllowed(this.left_co.getNullsAllowed());
                    continue;
                }
                if (engPropertyHolder.getName().equals(DEFAULT_VALUE)) {
                    this.right_co.setDefaultValue(this.left_co.getDefaultValue());
                    continue;
                }
                if (engPropertyHolder.getName().equals(SOURCE_TYPE)) {
                    this.right_co.setSourceType(engPropertyHolder.getLeftValue());
                    continue;
                }
                if (engPropertyHolder.getName().equals(FORMULA_DESC)) {
                    this.right_co.setFormulaDesc(this.left_co.getFormulaDesc());
                    if (!(this.right_co instanceof Attribute) || this.right_co.getFormulaDesc().length() <= 0 || this.right_co.getSourceType().equalsIgnoreCase("Aggregate")) continue;
                    this.right_co.setSourceType("Derived");
                    continue;
                }
                if (engPropertyHolder.getName().equals(CHECK_CONSTRAINT_NAME)) {
                    this.right_co.setConstraintName(this.left_co.getConstraintName());
                    continue;
                }
                if (engPropertyHolder.getName().equals(USE_DOMAIN_CONSTRAINT)) {
                    this.right_co.setUseDomainConstraints(this.left_co.getUseDomainConstraints());
                    continue;
                }
                if (engPropertyHolder.getName().equals(CHECK_CONSTRAINT)) {
                    EngCOPropertiesComparator.copyCheckConstraint(this.left_co, this.right_co);
                    continue;
                }
                if (engPropertyHolder.getName().equals(RANGE_CONSTRAINT)) {
                    EngCOPropertiesComparator.copyRangeConstraint(this.left_co, this.right_co);
                    continue;
                }
                if (!engPropertyHolder.getName().equals(LOV_CONSTRAINT)) continue;
                EngCOPropertiesComparator.copyLOVConstraint(this.left_co, this.right_co);
            }
            this.right_co.setTemporaryWriteable(false);
        }
    }

    public static EngPropertyHolder createCheckConstrNamePH(ContainedObjectWithDomain containedObjectWithDomain, ContainedObjectWithDomain containedObjectWithDomain2) {
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(CHECK_CONSTRAINT_NAME);
        engPropertyHolder.setDDLHolder(true);
        String string = "";
        if (containedObjectWithDomain != null) {
            string = containedObjectWithDomain.getConstraintName();
        }
        String string2 = "";
        if (containedObjectWithDomain2 != null) {
            string2 = containedObjectWithDomain2.getConstraintName();
        }
        engPropertyHolder.setLeftValue(string);
        engPropertyHolder.setRightValue(string2);
        if (containedObjectWithDomain != null && containedObjectWithDomain2 != null && !string.equalsIgnoreCase(string2)) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        return engPropertyHolder;
    }

    public static EngPropertyHolder createCheckConstrPH(ContainedObjectWithDomain containedObjectWithDomain, ContainedObjectWithDomain containedObjectWithDomain2) {
        Object object;
        LongNameObject longNameObject;
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(CHECK_CONSTRAINT);
        engPropertyHolder.setDDLHolder(true);
        if (containedObjectWithDomain != null && containedObjectWithDomain.getCheck() != null) {
            CheckConstraint checkConstraint = containedObjectWithDomain.getCheck();
            longNameObject = containedObjectWithDomain.getDesignPart().getSelectedRDBMSSite().getType();
            object = checkConstraint.getImplementation(longNameObject);
            object = ((String)object).replaceAll("%COLUMN%", containedObjectWithDomain.getName());
            engPropertyHolder.setLeftValue((String)object);
        } else {
            engPropertyHolder.setLeftValue("");
        }
        if (containedObjectWithDomain2 != null && containedObjectWithDomain2.getCheck() != null) {
            longNameObject = containedObjectWithDomain2.getCheck();
            object = containedObjectWithDomain2.getDesignPart().getSelectedRDBMSSite().getType();
            String string = ((CheckConstraint)longNameObject).getImplementation(object);
            string = string.replaceAll("%COLUMN%", containedObjectWithDomain2.getName());
            engPropertyHolder.setRightValue(string);
        } else {
            engPropertyHolder.setRightValue("");
        }
        if (containedObjectWithDomain != null && containedObjectWithDomain2 != null && !engPropertyHolder.getLeftValue().equals(engPropertyHolder.getRightValue())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        return engPropertyHolder;
    }

    public static EngPropertyHolder createLOVConstraintPH(ContainedObjectWithDomain containedObjectWithDomain, ContainedObjectWithDomain containedObjectWithDomain2) {
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(LOV_CONSTRAINT);
        engPropertyHolder.setDDLHolder(true);
        ConstraintEnumeration constraintEnumeration = null;
        if (containedObjectWithDomain != null && containedObjectWithDomain.getValueList() != null) {
            constraintEnumeration = containedObjectWithDomain.getValueList();
            engPropertyHolder.setLeftValue(constraintEnumeration.getValuesAsString());
        } else {
            engPropertyHolder.setLeftValue("");
        }
        ConstraintEnumeration constraintEnumeration2 = null;
        if (containedObjectWithDomain2 != null && containedObjectWithDomain2.getValueList() != null) {
            constraintEnumeration2 = containedObjectWithDomain2.getValueList();
            engPropertyHolder.setRightValue(constraintEnumeration2.getValuesAsString());
        } else {
            engPropertyHolder.setRightValue("");
        }
        if (containedObjectWithDomain != null && containedObjectWithDomain2 != null && !engPropertyHolder.getLeftValue().equals(engPropertyHolder.getRightValue())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        return engPropertyHolder;
    }

    public static EngPropertyHolder createRangeConstrPH(ContainedObjectWithDomain containedObjectWithDomain, ContainedObjectWithDomain containedObjectWithDomain2) {
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(RANGE_CONSTRAINT);
        engPropertyHolder.setDDLHolder(true);
        if (containedObjectWithDomain != null) {
            engPropertyHolder.setLeftValue(EngCOPropertiesComparator.getAVTsToString(containedObjectWithDomain));
        } else {
            engPropertyHolder.setLeftValue("");
        }
        if (containedObjectWithDomain2 != null) {
            engPropertyHolder.setRightValue(EngCOPropertiesComparator.getAVTsToString(containedObjectWithDomain2));
        } else {
            engPropertyHolder.setRightValue("");
        }
        if (containedObjectWithDomain != null && containedObjectWithDomain2 != null && !EngCOPropertiesComparator.haveEqualAVTs(containedObjectWithDomain, containedObjectWithDomain2)) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        return engPropertyHolder;
    }

    public static boolean isConstrCondConsistent(ContainedObjectWithDomain containedObjectWithDomain, ContainedObjectWithDomain containedObjectWithDomain2) {
        String string = "";
        String string2 = "";
        if (containedObjectWithDomain != null) {
            string = containedObjectWithDomain.getConstraintsText(containedObjectWithDomain.getName().toUpperCase());
        }
        if (containedObjectWithDomain2 != null) {
            string2 = containedObjectWithDomain2.getConstraintsText(containedObjectWithDomain2.getName().toUpperCase());
        }
        return string.equals(string2);
    }

    private static String getAVTsToString(ContainedObject containedObject) {
        StringBuffer stringBuffer = new StringBuffer();
        for (AVT aVT : containedObject.getAVTs()) {
            stringBuffer.append(aVT.getValuesAsString()).append(",").append("\n ");
        }
        int n = stringBuffer.lastIndexOf(",");
        if (n > 0) {
            return stringBuffer.substring(0, n).trim();
        }
        return stringBuffer.toString().trim();
    }

    private static boolean haveEqualAVTs(ContainedObject containedObject, ContainedObject containedObject2) {
        Object[] objectArray;
        Object[] objectArray2 = containedObject.getAVTs().toArray();
        if (objectArray2.length != (objectArray = containedObject2.getAVTs().toArray()).length) {
            return false;
        }
        for (int i = 0; i < objectArray2.length; ++i) {
            if (!(objectArray2[i] instanceof AVT) || !(objectArray[i] instanceof AVT)) {
                return false;
            }
            AVT aVT = (AVT)objectArray2[i];
            AVT aVT2 = (AVT)objectArray[i];
            if (aVT.getBeginValue().equals(aVT2.getBeginValue()) && aVT.getEndValue().equals(aVT2.getEndValue())) continue;
            return false;
        }
        return true;
    }

    public static void copyCheckConstraint(ContainedObject containedObject, ContainedObject containedObject2) {
        if (PropertiesComparator.DDL_ONLY) {
            containedObject2.setUseDomainConstraints(false);
        }
        if (containedObject2.getUseDomainConstraints()) {
            return;
        }
        CheckConstraint checkConstraint = containedObject.getCheck();
        if (checkConstraint == null) {
            containedObject2.setCheck(null);
            return;
        }
        CheckConstraint checkConstraint2 = containedObject2.getCheck();
        if (checkConstraint2 == null) {
            checkConstraint2 = new CheckConstraint();
            checkConstraint2.setDesign(containedObject.getDesign());
        }
        containedObject2.setCheck(checkConstraint2);
        checkConstraint.copyTo(checkConstraint2);
    }

    public static void copyLOVConstraint(ContainedObject containedObject, ContainedObject containedObject2) {
        if (PropertiesComparator.DDL_ONLY) {
            containedObject2.setUseDomainConstraints(false);
        }
        if (containedObject2.getUseDomainConstraints()) {
            return;
        }
        ConstraintEnumeration constraintEnumeration = containedObject.getValueList();
        if (constraintEnumeration == null) {
            containedObject2.setValueList(null);
            return;
        }
        ConstraintEnumeration constraintEnumeration2 = containedObject2.getValueList();
        if (constraintEnumeration2 == null) {
            constraintEnumeration2 = new ConstraintEnumeration();
            constraintEnumeration2.setDesign(containedObject2.getDesign());
        }
        containedObject2.setValueList(constraintEnumeration2);
        ((AbstractConstraint)constraintEnumeration).copyTo(constraintEnumeration2);
    }

    public static void copyRangeConstraint(ContainedObject containedObject, ContainedObject containedObject2) {
        if (PropertiesComparator.DDL_ONLY) {
            containedObject2.setUseDomainConstraints(false);
        }
        if (containedObject2.getUseDomainConstraints()) {
            return;
        }
        Iterator iterator = containedObject.getAVTs().iterator();
        containedObject2.clearAVTs();
        while (iterator.hasNext()) {
            AVT aVT = (AVT)iterator.next();
            AVT aVT2 = new AVT(aVT.getBeginValue(), aVT.getEndValue(), aVT.getDescription());
            containedObject2.addAVT(aVT2);
        }
    }
}

