/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;

public class ColumnAttributeComparator
extends EngCOPropertiesComparator {
    private Attribute attribute;
    private Column column;

    public ColumnAttributeComparator(Column column, Attribute attribute) {
        super(column, attribute);
        this.attribute = attribute;
        this.column = column;
        this.initPropertiesList();
    }

    public ColumnAttributeComparator(Column column, Attribute attribute, List list) {
        this(column, attribute);
        this.applyCompareFilter(list, column.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyScopeFromColumnToAttribute();
        }
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public Column getColumn() {
        return this.column;
    }

    @Override
    protected void initPropertiesList() {
        super.initPropertiesList();
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(SCOPE);
        Entity entity = null;
        if (this.attribute != null && this.attribute.getScope() != null) {
            engPropertyHolder.setRightValue(this.attribute.getScope().getName());
        } else {
            engPropertyHolder.setRightValue("");
        }
        if (this.column != null && this.column.getScope() != null) {
            engPropertyHolder.setLeftValue(this.column.getScope().getName());
            entity = ((Table)this.column.getScope()).getEngEntity();
        } else {
            engPropertyHolder.setLeftValue("");
        }
        if (this.column != null && this.attribute != null && entity != this.attribute.getScope()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
    }

    private void copyScopeFromColumnToAttribute() {
        if (this.column != null && this.attribute != null) {
            this.attribute.setTemporaryWriteable(true);
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected() || !engPropertyHolder.getName().equals(SCOPE)) continue;
                if (this.column.getScope() != null && ((Table)this.column.getScope()).getEngEntity() != null) {
                    this.attribute.setScopeId(((Table)this.column.getScope()).getEngEntity().getObjectID());
                    continue;
                }
                this.attribute.setScopeId(null);
            }
            this.attribute.setTemporaryWriteable(false);
        }
    }

    @Override
    public String getLeftName() {
        return this.column != null ? this.column.getContainerWithKeyObject().getName() + "." + this.column.getName() : "";
    }

    @Override
    public String getRightName() {
        return this.attribute != null ? this.attribute.getContainerWithKeyObject().getName() + "." + this.attribute.getName() : "";
    }
}

