/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class TempDataTypeObject
implements DataTypeObject {
    private DesignObject type;
    private String size;
    private int precision;
    private int scale;
    private boolean isReference;
    private String name = "";
    private Design design;

    public TempDataTypeObject(Design design) {
        this.design = design;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DesignObject getType() {
        return this.type;
    }

    @Override
    public void setType(DesignObject designObject) {
        this.type = designObject;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    @Override
    public String getDataType() {
        return this.formatDataType();
    }

    private String formatDataType() {
        if (this.getType() != null) {
            Object object;
            String string = "";
            int n = 0;
            int n2 = 0;
            String string2 = "NONE";
            if (this.getType() instanceof LogicalDatatype) {
                string = this.size;
                n = this.precision;
                n2 = this.scale;
                string2 = ((LogicalDatatype)this.getType()).getName();
            } else if (this.getType() instanceof DistinctType) {
                object = (DistinctType)this.getType();
                if (((DistinctType)object).getLogicalDataType() != null) {
                    string = ((DistinctType)object).getSize();
                    n = ((DistinctType)object).getPrecision();
                    n2 = ((DistinctType)object).getScale();
                    string2 = ((DistinctType)object).getLogicalDataType().getName();
                }
            } else if (this.getType() instanceof StructuredType) {
                string2 = this.isReference ? "REF " + this.getType().getName() : this.getType().getName();
            }
            object = new StringBuffer(string2);
            boolean bl = false;
            boolean bl2 = false;
            if (string != null && !string.equals("") || n > 0 || n2 > 0) {
                bl = true;
            }
            if (bl) {
                ((StringBuffer)object).append('(');
            }
            if (string != null && !string.equals("")) {
                ((StringBuffer)object).append(string);
                bl2 = true;
            }
            if (n > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n);
                bl2 = true;
            }
            if (n2 > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n2);
            }
            if (bl) {
                ((StringBuffer)object).append(')');
            }
            return ((StringBuffer)object).toString();
        }
        return "NONE";
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setSize(String string) {
        this.size = string;
    }

    @Override
    public void setPrecision(int n) {
        this.precision = n;
    }

    @Override
    public void setScale(int n) {
        this.scale = n;
    }

    @Override
    public RDBMSType getSelectedRDBMSType() {
        return this.design.getSelectedRDBMSType();
    }

    @Override
    public void setReference(boolean bl) {
        this.isReference = bl;
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    public void copyDataType(DataTypeObject dataTypeObject) {
        dataTypeObject.setType(this.getType());
        dataTypeObject.setSize(this.getSize());
        dataTypeObject.setPrecision(this.getPrecision());
        dataTypeObject.setScale(this.getScale());
        dataTypeObject.setReference(this.isReference());
    }
}

