/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.datatypes.TypeElementSet;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.AbstractDTTV;
import oracle.dbtools.crest.swingui.editor.datatypes.StructuredTypePropertiesDialogEx;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.ide.Ide;

public class StructuredType
extends AbstractDTObject
implements ObjectListener,
Datatype,
EditableFonts {
    private StructuredType parentType;
    private String parentTypeID = "";
    private String inheritanceRelationID = "";
    protected ObjectChangeEvent sharedEvent = new ObjectChangeEvent("ChangeEvent");
    private IDGenerator localIDGenerator;
    private IDGenerator methodIDGenerator;
    private Map localIDs = new TreeMap();
    private Map methodIDs = new TreeMap();
    private boolean isFinal = false;
    private boolean instantiable = true;
    private DTInheritance inheritanceRelation;
    private DesignObjectCollection elements = new DesignObjectCollection();
    private DesignObjectCollection methods = new DesignObjectCollection();
    private List editableFonts;
    protected ObjectChangeEvent predefinedEvent = new ObjectChangeEvent(Messages.getString("StructuredType.PredefinedStatusChanged"));
    private static final Logger LOGGER = new Logger(StructuredType.class);
    public static final String TYPE_NAME = "StructuredType";

    public StructuredType(DesignPart designPart) {
        super(designPart);
        this.elements.setParent(this);
        this.elements.setName(Messages.getString("StructuredType.Attributes"));
        this.elements.setElementDescriptor(TypeElement.class);
        this.methods.setParent(this);
        this.methods.setName(Messages.getString("StructuredType.Methods"));
        this.methods.setElementDescriptor(Method.class);
        this.initEditableFonts();
    }

    public TypeElementSet getTypeElementSet() {
        return ((DataTypesDesign)this.getDesignPart()).getTypeElementSet();
    }

    public MethodSet getMethodSet() {
        return ((DataTypesDesign)this.getDesignPart()).getMethodSet();
    }

    public void add(TypeElement typeElement) {
        Object object;
        if (typeElement == null || this.isReadOnly()) {
            return;
        }
        if (this.contains(typeElement)) {
            return;
        }
        if (this.getContainedClass().isAssignableFrom(typeElement.getClass())) {
            if (!(this.getDesign().isLoading() || this.getDesign().getAppView().isImporting() || ((String)(object = this.validateElementName(typeElement.getName(), 0))).equalsIgnoreCase(typeElement.getName()))) {
                String string = MessageFormat.format(Messages.getString("StructuredType.TypeElementExists"), typeElement.getName(), object);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string);
                typeElement.setName((String)object);
            }
        } else {
            LOGGER.error("Class: " + typeElement.getClass());
            LOGGER.error("Expected: " + this.getContainedClass());
            throw new RuntimeException("Wrong class added to container.");
        }
        this.assignLocalID(typeElement);
        typeElement.setParent(this.elements);
        this.elements.add(typeElement);
        typeElement.setStructuredType(this);
        this.getTypeElementSet().add(typeElement);
        typeElement.addObjectListener(this);
        object = new ObjectChangeEvent(ObjectChangeEvent.ELEMENT_ADDED.getDescription());
        ((ObjectChangeEvent)object).setAffected(typeElement);
        this.fireChange((ObjectChangeEvent)object);
    }

    public void addMethod(Method method) {
        if (method == null || this.isReadOnly()) {
            return;
        }
        if (this.containsMethod(method)) {
            return;
        }
        if (!this.getMethodClass().isAssignableFrom(method.getClass())) {
            LOGGER.error("Class: " + method.getClass());
            LOGGER.error("Expected: " + this.getContainedClass());
            throw new RuntimeException("Wrong class added to container.");
        }
        this.assignMethodID(method);
        this.methods.add(method);
        this.getMethodSet().add(method);
        method.setStructuredType(this);
        method.setParent(this.methods);
        method.addObjectListener(this);
        this.sharedEvent.setAffected(method);
        this.fireChange(this.sharedEvent);
    }

    public boolean contains(TypeElement typeElement) {
        return this.elements.contains(typeElement);
    }

    public boolean containsMethod(Method method) {
        return this.methods.contains(method);
    }

    public Class getContainedClass() {
        return TypeElement.class;
    }

    public Class getMethodClass() {
        return Method.class;
    }

    protected void assignLocalID(ModelIDObject modelIDObject) {
        String string = modelIDObject.getObjectID();
        if (string == null) {
            while (this.localIDs.containsKey(string = this.getLocalIDGenerator().createNewID())) {
            }
            this.localIDs.put(string, modelIDObject);
            modelIDObject.setObjectID(string);
        } else {
            this.localIDs.put(string, modelIDObject);
        }
    }

    protected void assignMethodID(ModelIDObject modelIDObject) {
        String string = modelIDObject.getObjectID();
        if (string == null) {
            while (this.methodIDs.containsKey(string = this.getMethodIDGenerator().createNewID())) {
            }
            this.methodIDs.put(string, modelIDObject);
            modelIDObject.setObjectID(string);
        } else {
            this.methodIDs.put(string, modelIDObject);
        }
    }

    public IDGenerator getLocalIDGenerator() {
        if (this.localIDGenerator == null) {
            this.localIDGenerator = new IDGenerator();
            this.localIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.localIDGenerator;
    }

    public IDGenerator getMethodIDGenerator() {
        if (this.methodIDGenerator == null) {
            this.methodIDGenerator = new IDGenerator();
            this.methodIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.methodIDGenerator;
    }

    @Override
    public void remove() {
        this.updateInheritance(null);
        this.removeAll();
        this.removeAllMethods();
        super.remove();
    }

    public void remove(TypeElement typeElement) {
        if (typeElement != null && this.isWriteable()) {
            this.getTypeElementSet().remove(typeElement);
            this.elements.remove(typeElement);
            typeElement.setStructuredType(null);
            this.localIDs.remove(typeElement.getObjectID());
            typeElement.removeObjectListener(this);
            typeElement.setParent(null);
            this.fireChange(ObjectChangeEvent.ELEMENT_REMOVED);
        }
    }

    public TypeElement[] removeAll() {
        TypeElement[] typeElementArray = this.getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            this.remove(typeElementArray[i]);
        }
        return typeElementArray;
    }

    public void removeMethod(Method method) {
        if (method != null && this.isWriteable()) {
            this.getMethodSet().remove(method);
            this.methods.remove(method);
            method.setStructuredType(null);
            this.methodIDs.remove(method.getObjectID());
            method.removeObjectListener(this);
            method.setParent(null);
            this.sharedEvent.setAffected(method);
            this.fireChange(this.sharedEvent);
        }
    }

    public Method[] removeAllMethods() {
        Method[] methodArray = this.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this.removeMethod(methodArray[i]);
        }
        return methodArray;
    }

    public TypeElement[] getElements() {
        return this.toElementObjectArray(this.elements.getElementsList());
    }

    public Method[] getMethods() {
        return this.toMethodObjectArray(this.methods.getElementsList());
    }

    public TypeElement[] toElementObjectArray(Collection collection) {
        return (TypeElement[])collection.toArray((Object[])Array.newInstance(this.getContainedClass(), 0));
    }

    public Method[] toMethodObjectArray(Collection collection) {
        return (Method[])collection.toArray((Object[])Array.newInstance(this.getMethodClass(), 0));
    }

    public TypeElement getElementByID(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            TypeElement typeElement = (TypeElement)iterator.next();
            if (!string.equals(typeElement.getObjectID())) continue;
            iterator = null;
            return typeElement;
        }
        iterator = null;
        return null;
    }

    public Method getMethodByID(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!string.equals(method.getObjectID())) continue;
            iterator = null;
            return method;
        }
        iterator = null;
        return null;
    }

    public TypeElement getElementByName(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            TypeElement typeElement = (TypeElement)iterator.next();
            if (!string.equalsIgnoreCase(typeElement.getName())) continue;
            return typeElement;
        }
        return null;
    }

    public Method getMethodByName(String string) {
        if (string != null) {
            Iterator iterator = this.methods.iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                if (!string.equalsIgnoreCase(method.getName())) continue;
                return method;
            }
        }
        return null;
    }

    public Method getMethodByNameAndNumber(String string, int n) {
        if (string != null) {
            Iterator iterator = this.methods.iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                if (!string.equalsIgnoreCase(method.getName()) || n != method.getNumber()) continue;
                return method;
            }
        }
        return null;
    }

    public Method getMethod(int n) {
        return (Method)this.methods.getElement(n);
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.elements;
            }
            case 1: {
                return this.methods;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.elements) {
            return 0;
        }
        if (modelObject == this.methods) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public StructuredType getParentType() {
        if (this.parentType == null && !"".equalsIgnoreCase(this.parentTypeID)) {
            this.parentType = (StructuredType)this.getDesign().getDesignObject(this.parentTypeID);
            this.parentTypeID = "";
        }
        return this.parentType;
    }

    public void setParentType(StructuredType structuredType, boolean bl) {
        if (this.parentType != structuredType) {
            if (structuredType != null && bl) {
                String string = Messages.getString("StructuredType.TypeElementsCouldBeRenamed");
                int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), string, Messages.getString("StructuredType.Warning"), 0);
                if (n == 0) {
                    StructuredType structuredType2 = structuredType;
                    this.parentType = structuredType;
                    if (!this.getDesign().isLoading()) {
                        this.updateInheritance(structuredType2);
                        if (structuredType != null) {
                            this.refreshChildElementsNames();
                        }
                    }
                    this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
                }
            } else {
                StructuredType structuredType3 = structuredType;
                this.parentType = structuredType;
                if (!this.getDesign().isLoading() && !this.getDesign().getAppView().isImporting()) {
                    this.updateInheritance(structuredType3);
                }
                this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
            }
        }
    }

    public void setParentType(StructuredType structuredType) {
        this.setParentType(structuredType, false);
    }

    public void updateInheritance() {
        if (this.getParentType() != null) {
            this.updateInheritance(this.getParentType());
        }
    }

    @Override
    public int getByteSize() {
        return 0;
    }

    @Override
    public String getSize() {
        return "";
    }

    public boolean isInstantiable() {
        return this.instantiable;
    }

    public void setInstantiable(boolean bl) {
        this.instantiable = bl;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean bl) {
        this.isFinal = bl;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StructuredTypePropertiesDialogEx structuredTypePropertiesDialogEx = new StructuredTypePropertiesDialogEx(this.getDesign().getAppView(), this);
            structuredTypePropertiesDialogEx.initProperties(this);
            structuredTypePropertiesDialogEx.show();
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent == ObjectChangeEvent.OBJECT_REMOVED) {
            if (objectChangeEvent.getAffected() instanceof TypeElement) {
                this.remove((TypeElement)objectChangeEvent.getAffected());
            } else if (objectChangeEvent.getAffected() instanceof Method) {
                this.removeMethod((Method)objectChangeEvent.getAffected());
            }
        } else {
            this.fireChange(objectChangeEvent);
        }
    }

    public boolean isParentOf(StructuredType structuredType) {
        if (structuredType == this) {
            return true;
        }
        for (StructuredType structuredType2 = structuredType.getParentType(); structuredType2 != null; structuredType2 = structuredType2.getParentType()) {
            if (structuredType2 != this) continue;
            return true;
        }
        return false;
    }

    private String validateElementName(String string, int n) {
        String string2 = string;
        for (TypeElement typeElement : this.getParentAndChildElements()) {
            if (!typeElement.getName().equalsIgnoreCase(string2)) continue;
            String string3 = "_".concat(String.valueOf(n));
            if (string2.endsWith(string3)) {
                string2 = string2.substring(0, string2.lastIndexOf(string3));
            }
            string2 = string2.concat("_").concat(String.valueOf(++n));
            string2 = this.validateElementName(string2, n);
            break;
        }
        return string2;
    }

    public List getParentElements() {
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
        for (StructuredType structuredType = this.getParentType(); structuredType != null; structuredType = structuredType.getParentType()) {
            for (int i = 0; i < structuredType.getElements().length; ++i) {
                arrayList.add(structuredType.getElements()[i]);
            }
        }
        return arrayList;
    }

    public List getAllElements() {
        ArrayList arrayList = new ArrayList();
        if (this.getParentType() != null) {
            this.getParentType().addParentElements(arrayList);
        }
        this.elements.addAllElementsTo(arrayList);
        return arrayList;
    }

    public List getChildElements() {
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
        Iterator iterator = ((DataTypesDesign)this.getDesignPart()).getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            if (structuredType.getParentType() != this) continue;
            TypeElement[] typeElementArray = structuredType.getElements();
            for (int i = 0; i < typeElementArray.length; ++i) {
                arrayList.add(typeElementArray[i]);
            }
            arrayList.addAll(structuredType.getChildElements());
        }
        return arrayList;
    }

    public List getParentAndChildElements() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getParentElements());
        arrayList.addAll(this.getChildElements());
        return arrayList;
    }

    protected void refreshChildElementsNames() {
        DesignObject designObject;
        TypeElement[] typeElementArray = this.getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            designObject = typeElementArray[i];
            designObject.setName(this.validateElementName(designObject.getName(), 0));
        }
        Iterator iterator = ((DataTypesDesign)this.getDesignPart()).getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            designObject = (StructuredType)iterator.next();
            if (((StructuredType)designObject).getParentType() != this) continue;
            ((StructuredType)designObject).refreshChildElementsNames();
        }
    }

    public List getAllMethods() {
        ArrayList arrayList = new ArrayList();
        if (this.getParentType() != null) {
            this.getParentType().addParentMethods(arrayList);
        }
        this.methods.addAllElementsTo(arrayList);
        return arrayList;
    }

    private void addParentElements(List list) {
        if (this.getParentType() != null) {
            this.getParentType().addParentElements(list);
        }
        this.elements.addAllElementsTo(list);
    }

    private void addParentMethods(List list) {
        if (this.getParentType() != null) {
            this.getParentType().addParentMethods(list);
        }
        this.methods.addAllElementsTo(list);
    }

    public void setParentTypeID(String string) {
        this.parentTypeID = string;
        DesignObject designObject = this.getDesign().getDesignObject(string);
        if (designObject != null && designObject instanceof StructuredType) {
            this.createInheritance((StructuredType)designObject);
        } else {
            this.getDesignPart().addTask(new CreateInheritanceTask(this));
        }
    }

    public String getParentTypeID() {
        if (this.getParentType() != null) {
            return this.getParentType().getObjectID();
        }
        return this.parentTypeID;
    }

    protected void updateInheritance(StructuredType structuredType) {
        if (structuredType == null) {
            if (this.inheritanceRelation != null) {
                this.inheritanceRelation.remove();
                this.inheritanceRelation = null;
            }
        } else {
            if (this.inheritanceRelation != null) {
                if (this.inheritanceRelation.getSourceDTObject() == this.parentType) {
                    return;
                }
                this.inheritanceRelation.remove();
            }
            this.inheritanceRelation = this.getDesign().getDataTypesDesign().createDTInheritance();
            this.inheritanceRelation.setSourceDTObject(structuredType);
            this.inheritanceRelation.setSourceTV((AbstractDTTV)structuredType.getTopView());
            this.inheritanceRelation.setTargetDTObject(this);
            this.inheritanceRelation.setTargetTV((AbstractDTTV)this.getTopView());
        }
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
        super.fireChange(objectChangeEvent);
        if (!this.getDesign().isLoading()) {
            for (StructuredType structuredType : this.getDesign().getDataTypesDesign().getStructuredTypeSet().getDirectSubtypes(this)) {
                structuredType.changed(this, objectChangeEvent);
            }
        }
    }

    public boolean moveElementToIndex(DesignObject designObject, int n) {
        boolean bl = this.elements.moveElementToIndex(designObject, n);
        this.sharedEvent.setAffected(designObject);
        this.fireChange(this.sharedEvent);
        return bl;
    }

    public boolean moveMethodToIndex(DesignObject designObject, int n) {
        boolean bl = this.methods.moveElementToIndex(designObject, n);
        this.sharedEvent.setAffected(designObject);
        this.fireChange(this.sharedEvent);
        return bl;
    }

    public void setInheritanceRelation(DTInheritance dTInheritance) {
        this.inheritanceRelation = dTInheritance;
    }

    public boolean containsElementOfStructuredType(StructuredType structuredType) {
        if (structuredType.isParentOf(this) || this.isParentOf(structuredType)) {
            return true;
        }
        Object[] objectArray = this.getAllElementsInHierarchy().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            TypeElement typeElement = (TypeElement)objectArray[i];
            if (!(typeElement.getType() instanceof StructuredType) || typeElement.isReference()) continue;
            StructuredType structuredType2 = (StructuredType)typeElement.getType();
            if (structuredType.isParentOf(structuredType2) || structuredType2.isParentOf(structuredType)) {
                return true;
            }
            boolean bl = structuredType2.containsElementOfStructuredType(structuredType);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private StructuredType getRoot() {
        StructuredType structuredType = this;
        while (structuredType.getParentType() != null) {
            structuredType = structuredType.getParentType();
        }
        return structuredType;
    }

    private List getSubTypes() {
        ArrayList<StructuredType> arrayList = new ArrayList<StructuredType>();
        Iterator iterator = this.getDesignObjectSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            if (structuredType.getParentType() != this) continue;
            arrayList.add(structuredType);
        }
        return arrayList;
    }

    public List getAllSubTypes() {
        ArrayList<StructuredType> arrayList = new ArrayList<StructuredType>();
        Iterator iterator = this.getDesignObjectSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            if (structuredType.getParentType() != this) continue;
            arrayList.add(structuredType);
            arrayList.addAll(structuredType.getSubTypes());
        }
        return arrayList;
    }

    public List getAllInstantiableSubTypes(boolean bl) {
        ArrayList<StructuredType> arrayList = new ArrayList<StructuredType>();
        if (bl && this.instantiable) {
            arrayList.add(this);
        }
        Iterator iterator = this.getDesignObjectSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            if (structuredType.getParentType() != this) continue;
            arrayList.addAll(structuredType.getAllInstantiableSubTypes(true));
        }
        return arrayList;
    }

    public boolean hasInstantiableSubtype() {
        Iterator iterator = this.getDesignObjectSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            if (structuredType.getParentType() != this || !structuredType.isInstantiable() && !structuredType.hasInstantiableSubtype()) continue;
            return true;
        }
        return false;
    }

    private List getOwnAndChildsElements() {
        ArrayList arrayList = new ArrayList();
        this.elements.addAllElementsTo(arrayList);
        for (StructuredType structuredType : this.getSubTypes()) {
            arrayList.addAll(structuredType.getOwnAndChildsElements());
        }
        return arrayList;
    }

    public List getAllElementsInHierarchy() {
        return this.getRoot().getOwnAndChildsElements();
    }

    @Override
    public void copy(DesignObject designObject) {
        DesignObject designObject2;
        StructuredType structuredType = (StructuredType)designObject;
        super.copy(structuredType);
        if (this.getParentType() != null) {
            structuredType.setParentTypeID(this.getParentType().getObjectID());
        }
        structuredType.updateInheritance(structuredType.getParentType());
        structuredType.setFinal(this.isFinal());
        structuredType.setInstantiable(this.isInstantiable());
        for (TypeElement designObject3 : Arrays.asList(this.getElements())) {
            designObject2 = new TypeElement(structuredType.getDesignPart(), structuredType);
            designObject3.copy(designObject2);
            designObject3.copyDataType((TypeElement)designObject2);
            designObject2.setDesign(structuredType.getDesign());
            structuredType.add((TypeElement)designObject2);
        }
        for (Method method : Arrays.asList(this.getMethods())) {
            designObject2 = new Method(structuredType.getDesignPart(), structuredType);
            method.copy(designObject2);
            designObject2.setDesign(structuredType.getDesign());
            structuredType.addMethod((Method)designObject2);
        }
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject("Structured Type")) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            Object object;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (object = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject("Structured Type")) != null) {
                for (FontObject fontObject : ((DefaultFontAndColor)object).getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            for (Object object2 : this.getAllTopViews()) {
                ((TopView)object2).setUseCustomFormat(false);
            }
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
            this.setUseDefaultColor(true);
        } else if (DefaultFontAndColor.isModified("Structured Type")) {
            DefaultFontAndColor defaultFontAndColor = this.getDesignPart().getAppView().getSettings().getDefaultFCObject("Structured Type");
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
            this.setUseDefaultColor(bl);
        }
    }

    public TypeElement createTypeElement(String string) {
        TypeElement typeElement = new TypeElement(this.getDesignPart(), this);
        typeElement.setName(string);
        typeElement.setDesign(this.getDesign());
        typeElement.setParent(this);
        this.add(typeElement);
        return typeElement;
    }

    public Method createMethod(String string) {
        Method method = new Method(this.getDesignPart(), this);
        method.setName(string);
        method.setDesign(this.getDesign());
        method.setParent(this);
        this.addMethod(method);
        return method;
    }

    public DTInheritance getInheritanceRelation() {
        return this.inheritanceRelation;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "structuredtype/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public TypeElement createTypeElement() {
        return this.createTypeElement("");
    }

    public Method createMethod() {
        return this.createMethod(null);
    }

    public List getAttributesList() {
        if (this.elements.size() > 0) {
            ArrayList arrayList = new ArrayList();
            this.elements.addAllElementsTo(arrayList);
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public List getMethodsList() {
        if (this.methods.size() > 0) {
            ArrayList arrayList = new ArrayList();
            this.methods.addAllElementsTo(arrayList);
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    private void createInheritance(StructuredType structuredType) {
        this.inheritanceRelation = (DTInheritance)((DataTypesDesign)this.getDesignPart()).getDTInheritanceSet().getObjectByID(this.inheritanceRelationID);
        if (this.inheritanceRelation == null) {
            this.inheritanceRelation = ((DataTypesDesign)this.getDesignPart()).createDTInheritance();
            if (!"".equals(this.inheritanceRelationID)) {
                this.inheritanceRelation.setObjectID(this.inheritanceRelationID);
            }
        }
        this.inheritanceRelation.setSourceDTObject(structuredType);
        this.inheritanceRelation.setTargetDTObject(this);
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        super.translateIdToObject(string, string2);
        if ("inheritanceRelation".equalsIgnoreCase(string)) {
            this.inheritanceRelationID = string2;
        }
        return null;
    }

    @Override
    public boolean hasProxyToDelete() {
        return true;
    }

    public class CreateInheritanceTask
    implements Task {
        private static final String TASK_NAME = "create Inheritance task";
        StructuredType st;

        CreateInheritanceTask(StructuredType structuredType2) {
            this.st = structuredType2;
        }

        @Override
        public boolean execute() {
            StructuredType structuredType = this.st.getParentType();
            if (structuredType != null) {
                this.st.createInheritance(structuredType);
                return this.st.inheritanceRelation != null;
            }
            return false;
        }

        public String toString() {
            return TASK_NAME;
        }
    }
}

