/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;

public class MethodParam
extends DesignObject
implements DataTypeObject {
    private Design design;
    private String size;
    private int precision;
    private int scale;
    private DesignObject type;
    private boolean reference = false;
    private String typeID = "";
    public static final String PARAM_SCALE = "scale";
    public static final String PARAM_PRECISION = "precision";
    public static final String PARAM_SIZE = "size";
    private Method method;
    public static String TYPE_NAME = "arg";

    public MethodParam(DesignPart designPart) {
        super(designPart);
        this.design = designPart.getDesign();
    }

    @Override
    public DesignObject getType() {
        if (this.type == null && !"".equalsIgnoreCase(this.typeID)) {
            this.type = this.getDesign().getDesignObject(this.typeID);
            this.typeID = "";
        } else if (this.type == null) {
            this.type = this.getDesign().getLogicalDatatypeSet().getDefaultType();
        }
        return this.type;
    }

    @Override
    public void setType(DesignObject designObject) {
        this.type = designObject;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    @Override
    public String getDataType() {
        return this.formatDataType();
    }

    private String formatDataType() {
        if (this.getType() != null) {
            Object object;
            String string = "";
            int n = 0;
            int n2 = 0;
            String string2 = "NONE";
            if (this.getType() instanceof Domain) {
                string2 = ((Domain)this.getType()).getName();
            } else if (this.getType() instanceof LogicalDatatype) {
                string = this.size;
                n = this.precision;
                n2 = this.scale;
                string2 = ((LogicalDatatype)this.getType()).getName();
            } else if (this.getType() instanceof DistinctType) {
                object = (DistinctType)this.getType();
                if (((DistinctType)object).getLogicalDataType() != null) {
                    string = ((DistinctType)object).getSize();
                    n = ((DistinctType)object).getPrecision();
                    n2 = ((DistinctType)object).getScale();
                    string2 = ((DistinctType)object).getLogicalDataType().getName();
                }
                string2 = this.getType().getName();
            } else if (this.getType() instanceof StructuredType) {
                string2 = this.getType().getName();
            } else if (this.getType() instanceof CollectionType) {
                string2 = this.getType().getName();
            }
            object = new StringBuffer(string2);
            boolean bl = false;
            boolean bl2 = false;
            if (string != null && !string.equals("") || n > 0 || n2 > 0) {
                bl = true;
            }
            if (bl) {
                ((StringBuffer)object).append('(');
            }
            if (string != null && !string.equals("")) {
                ((StringBuffer)object).append(string);
                bl2 = true;
            }
            if (n > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n);
                bl2 = true;
            }
            if (n2 > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n2);
            }
            if (bl) {
                ((StringBuffer)object).append(')');
            }
            return ((StringBuffer)object).toString();
        }
        return "NONE";
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setSize(String string) {
        this.size = string;
    }

    @Override
    public void setPrecision(int n) {
        this.precision = n;
    }

    @Override
    public void setScale(int n) {
        this.scale = n;
    }

    public void copyDataType(MethodParam methodParam) {
        methodParam.setType(this.getType());
        methodParam.setSize(this.getSize());
        methodParam.setPrecision(this.getPrecision());
        methodParam.setScale(this.getScale());
        methodParam.setReference(this.isReference());
    }

    @Override
    public String toString() {
        return this.getDataType();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "arg";
    }

    @Override
    public boolean isReference() {
        return this.reference;
    }

    @Override
    public void setReference(boolean bl) {
        this.reference = bl;
    }

    public void setTypeID(String string) {
        this.typeID = string;
    }

    public String getDataType(String string) {
        if (this.getType() != null) {
            Object object;
            String string2 = "";
            int n = 0;
            int n2 = 0;
            String string3 = "NONE";
            if (this.getType() instanceof Domain) {
                object = (Domain)this.getType();
                LogicalDatatype logicalDatatype = ((Domain)object).getLogicalDatatype();
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                if (string.toUpperCase().indexOf("ORACLE") == -1) {
                    treeMap.put(PARAM_SIZE, "" + ((Domain)object).getSize());
                    treeMap.put(PARAM_PRECISION, "" + ((Domain)object).getPrecision());
                    treeMap.put(PARAM_SCALE, "" + ((Domain)object).getScale());
                }
                string3 = logicalDatatype.createDataType(string, treeMap).toString();
            } else {
                if (this.getType() instanceof LogicalDatatype) {
                    string2 = this.size;
                    n = this.precision;
                    n2 = this.scale;
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    if (string.toUpperCase().indexOf("ORACLE") == -1) {
                        treeMap.put(PARAM_SIZE, "" + string2);
                        treeMap.put(PARAM_PRECISION, "" + this.precision);
                        treeMap.put(PARAM_SCALE, "" + this.scale);
                    }
                    string3 = ((LogicalDatatype)this.getType()).createDataType(string, treeMap).toString();
                    return string3;
                }
                if (this.getType() instanceof DistinctType) {
                    object = (DistinctType)this.getType();
                    if (((DistinctType)object).getLogicalDataType() != null) {
                        try {
                            string2 = ((DistinctType)object).getSize();
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        n = ((DistinctType)object).getPrecision();
                        n2 = ((DistinctType)object).getScale();
                        string3 = ((DistinctType)object).getLogicalDataType().getName();
                    }
                } else if (this.getType() instanceof StructuredType) {
                    string3 = this.isReference() ? "REF " + this.getType().getName() : this.getType().getName();
                } else if (this.getType() instanceof CollectionType) {
                    string3 = this.getType().getName();
                }
            }
            object = new StringBuffer(string3);
            boolean bl = false;
            boolean bl2 = false;
            if (!string2.equals("") || n > 0 || n2 > 0) {
                bl = true;
            }
            if (bl) {
                ((StringBuffer)object).append('(');
            }
            if (!string2.equals("")) {
                ((StringBuffer)object).append(string2);
                bl2 = true;
            }
            if (n > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n);
                bl2 = true;
            }
            if (n2 > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n2);
            }
            if (bl) {
                ((StringBuffer)object).append(')');
            }
            return ((StringBuffer)object).toString();
        }
        return "NONE";
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        DesignObject designObject = null;
        designObject = this.getDesign().getDesignObject(string2);
        if (designObject != null) {
            return designObject;
        }
        if ("type".equalsIgnoreCase(string)) {
            designObject = this.getDesign().getLogicalDatatypeSet().getObjectByID(string2);
            if (designObject != null) {
                return designObject;
            }
            designObject = this.getDesign().getDataTypesDesign().getDistinctTypeSet().getObjectByID(string2);
        }
        if (designObject != null) {
            return designObject;
        }
        return super.translateIdToObject(string, string2);
    }

    public String getTypeID() {
        if (this.type != null) {
            return this.type.getObjectID();
        }
        return this.typeID;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    @Override
    public String getLongName() {
        if (this.getMethod() != null && this.getMethod().getStructuredType() != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getMethod().getStructuredType().getName()).append(this.getMethod().getName()).append('.').append(this.getName());
            return stringBuffer.toString();
        }
        return super.getLongName();
    }
}

