/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.CollectionTypeSet;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTInheritanceSet;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DTReferenceSet;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.DistinctTypeSet;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParamSet;
import oracle.dbtools.crest.model.design.datatypes.MethodSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.datatypes.TypeElementSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypes;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypesSubView;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.editor.datatypes.DataTypesModelPropertiesDialog;

public class DataTypesDesign
extends DesignPart
implements ObjectListener {
    public static final String OBJECT_TYPE_NAME = "Data Types";
    public static final String SDO_GEOMETRY = "SDO_GEOMETRY";
    public static final String XMLTYPE = "XMLTYPE";
    public static final String DISTINCT_TYPE_SET_NAME = "Distinct Types";
    public static final String COLLECTION_TYPE_SET_NAME = "Collection Types";
    public static final String STRUCTURED_TYPE_SET_NAME = "Structured Types";
    public static final String NOTE_SET_NAME = "Notes";
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    public static final String SDO_GEOMETRY_ID = "47E390DE-0671-C4B1-8428-0F45CBEE18F8";
    public static final String XMLTYPE_ID = "F72C39E0-D1CA-8821-2AD7-A1E95A37D3D1";
    DistinctTypeSet dtSet;
    StructuredTypeSet stSet;
    CollectionTypeSet ctSet;
    private NoteSet noteSet;
    private TypeElementSet teSet;
    private MethodSet methodSet;
    private DTInheritanceSet dtiSet;
    private DTReferenceSet dtrSet;
    private MethodParamSet mpSet;
    private String referencePrefix = "ref_";
    private String collectionPrefix = "array_";
    private String embeddedStructuredTypePrefix = "inst_";
    private String collectionOfRefsPrefix = "array_ref_";
    private String defaultCollectionType_Kind = CollectionType.TYPE_ARRAY;
    private int defaultArrayLimit = 10;
    private String defaultCollectionType_Suffix = "_Array";
    private boolean useRoleInAssociationEndAsName = true;
    private DesignObjectCollection predefinedStCollection;
    private DesignObjectCollection stCollection;
    private DesignObjectCollection ctCollection;
    private DesignObjectCollection predefinedCtCollection;
    public static final String OBJECT_NAME = "DataTypes";

    public DataTypesDesign() {
        this.setVisible(false);
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList arrayList = new ArrayList();
        this.getStructuredTypeSet().addAllElementsTo(arrayList);
        this.getDTInheritanceSet().addAllElementsTo(arrayList);
        this.getDTReferenceSet().addAllElementsTo(arrayList);
        this.getNoteSet().addAllElementsTo(arrayList);
        this.getDiagramViewSet().addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    public String getName() {
        return OBJECT_NAME;
    }

    @Override
    public String toString() {
        return Messages.getString("Design.DataTypes");
    }

    @Override
    public void clearAll() {
        this.getStructuredTypeSet().removeAll();
        this.getStructureTypeCollection().removeAll();
        this.getDistinctTypeSet().removeAll();
        this.getCollectionTypeSet().removeAll();
        this.getTypeElementSet().removeAll();
        this.getMethodSet().removeAll();
        this.getMethodParamSet().removeAll();
        this.getDTInheritanceSet().removeAll();
        this.getDTReferenceSet().removeAll();
        this.getNoteSet().removeAll();
        this.getDiagramViewSet().removeAll();
        this.clearDocuments();
        this.clearResponsibleParties();
        this.setComment("");
        this.setNotes("");
        if (this.predefinedStCollection != null) {
            this.predefinedStCollection.removeAll();
        }
        this.predefinedStCollection = null;
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    public void sortCollections() {
        this.getStructuredTypeSet().sort();
        this.getDistinctTypeSet().sort();
        this.getCollectionTypeSet().sort();
        this.getTypeElementSet().sort();
        this.getMethodSet().sort();
        this.getDTInheritanceSet().sort();
        this.getDTReferenceSet().sort();
        this.getDataTypesDesignSubViews().sort();
        Iterator iterator = this.getDataTypesDesignSubViews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
            designPartView.sortCollections();
        }
    }

    private void addStructureType() {
        Object object;
        DesignObject designObject;
        String string = SDO_GEOMETRY_ID;
        DesignObject designObject2 = this.getStructuredTypeSet().getObjectByID(string);
        if (designObject2 == null) {
            designObject2 = this.getStructuredTypeSet().getByName(SDO_GEOMETRY);
        }
        if (designObject2 == null) {
            designObject = this.getStructuredTypeSet().createStructuredType(string, false);
            designObject.setName(SDO_GEOMETRY);
            ((AbstractDTObject)designObject).setPredefined(true);
            ((AbstractDTObject)designObject).setIsNullInstance(true);
            object = designObject.getObjectID();
            this.getDesign().updateDesignObjectId((String)object, designObject.getObjectID());
            this.getStructuredTypeSet().resetCounter();
            designObject.setDirty(false);
            this.listOfObjectsChanged = false;
        }
        string = XMLTYPE_ID;
        designObject = this.getStructuredTypeSet().getObjectByID(string);
        if (designObject == null) {
            designObject = this.getStructuredTypeSet().getByName(XMLTYPE);
        }
        if (designObject == null) {
            object = this.getStructuredTypeSet().createStructuredType(string, false);
            ((DesignObject)object).setName(XMLTYPE);
            ((AbstractDTObject)object).setPredefined(true);
            ((AbstractDTObject)object).setIsNullInstance(true);
            String string2 = ((ModelIDObject)object).getObjectID();
            this.getDesign().updateDesignObjectId(string2, ((ModelIDObject)object).getObjectID());
            this.getStructuredTypeSet().resetCounter();
            ((DesignObject)object).setDirty(false);
            this.listOfObjectsChanged = false;
        }
    }

    @Override
    protected DesignPartView createDesignPartSubView(String string) {
        DPVDataTypesSubView dPVDataTypesSubView = new DPVDataTypesSubView(this.getDesign().getAppView(), this);
        string = this.getNameVersion(this.subViews, string);
        dPVDataTypesSubView.setName(string);
        DesignPartViewPlaceHolder designPartViewPlaceHolder = new DesignPartViewPlaceHolder((DesignPart)this, dPVDataTypesSubView);
        designPartViewPlaceHolder.setParent(this.subViews);
        this.subViews.add(designPartViewPlaceHolder);
        return dPVDataTypesSubView;
    }

    public SubViewObjectSet getDataTypesDesignSubViews() {
        return this.subViews;
    }

    @Override
    public void doBeforeLoad() {
        this.getPredefinedStCollection().removeAll();
        this.getStructuredTypeSet().removeAll();
        this.addStructureType();
    }

    @Override
    public void doAfterLoad() {
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void load() {
        this.getPredefinedStCollection().removeAll();
        this.getStructuredTypeSet().removeAll();
        this.addStructureType();
        XMLPersistenceManager xMLPersistenceManager = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader abstractXMLReader = xMLPersistenceManager.getDesignPartReader(this);
        if (abstractXMLReader != null) {
            abstractXMLReader.recreateDesign(this.getName(), (DesignPart)this, false);
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVDataTypes(this.getDesign().getAppView(), this);
            this.mainView.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
        }
        return this.mainView;
    }

    @Override
    public boolean isEmpty() {
        return this.getDistinctTypeSet().size() <= 0 && this.getStructuredTypeSet().size() <= 0 && this.getCollectionTypeSet().size() <= 0;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "DT";
    }

    public DistinctTypeSet getDistinctTypeSet() {
        if (this.dtSet == null) {
            this.dtSet = new DistinctTypeSet(this);
            this.dtSet.setDesign(this.getDesign());
            this.dtSet.setName(Messages.getString("DataTypesDesign.DistinctTypes"));
            this.dtSet.setParent(this);
            this.dtSet.addSetListener(this);
        }
        return this.dtSet;
    }

    public StructuredTypeSet getStructuredTypeSet() {
        if (this.stSet == null) {
            this.stSet = new StructuredTypeSet(this);
            this.stSet.setDesign(this.getDesign());
            this.stSet.setName(Messages.getString("DataTypesDesign.StructuredTypes"));
            this.stSet.setParent(this);
            this.stSet.addSetListener(this);
            this.getPredefinedStCollection();
        }
        return this.stSet;
    }

    public CollectionTypeSet getCollectionTypeSet() {
        if (this.ctSet == null) {
            this.ctSet = new CollectionTypeSet(this);
            this.ctSet.setDesign(this.getDesign());
            this.ctSet.setName(Messages.getString("DataTypesDesign.CollectionTypes"));
            this.ctSet.setParent(this);
            this.ctSet.addSetListener(this);
        }
        return this.ctSet;
    }

    public TypeElementSet getTypeElementSet() {
        if (this.teSet == null) {
            this.teSet = new TypeElementSet(this);
            this.teSet.setDesign(this.getDesign());
            this.teSet.setName("TypeElements");
            this.teSet.setParent(this);
            this.teSet.addSetListener(this);
        }
        return this.teSet;
    }

    public MethodSet getMethodSet() {
        if (this.methodSet == null) {
            this.methodSet = new MethodSet(this);
            this.methodSet.setDesign(this.getDesign());
            this.methodSet.setName("Methods");
            this.methodSet.setParent(this);
            this.methodSet.addSetListener(this);
        }
        return this.methodSet;
    }

    public MethodParamSet getMethodParamSet() {
        if (this.mpSet == null) {
            this.mpSet = new MethodParamSet(this);
            this.mpSet.setDesign(this.getDesign());
            this.mpSet.setName("Method Parameters");
            this.mpSet.setParent(this);
            this.mpSet.addSetListener(this);
        }
        return this.mpSet;
    }

    public DTInheritanceSet getDTInheritanceSet() {
        if (this.dtiSet == null) {
            this.dtiSet = new DTInheritanceSet(this);
            this.dtiSet.setDesign(this.getDesign());
            this.dtiSet.setName("Inheritances");
            this.dtiSet.setParent(this);
            this.dtiSet.addSetListener(this);
        }
        return this.dtiSet;
    }

    public DTReferenceSet getDTReferenceSet() {
        if (this.dtrSet == null) {
            this.dtrSet = new DTReferenceSet(this);
            this.dtrSet.setDesign(this.getDesign());
            this.dtrSet.setName("References");
            this.dtrSet.setParent(this);
            this.dtrSet.addSetListener(this);
        }
        return this.dtrSet;
    }

    @Override
    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(NOTE_SET_NAME);
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public DistinctType createDistinctType() {
        return this.getDistinctTypeSet().createDistinctType(null);
    }

    public StructuredType createStructuredType() {
        return this.getStructuredTypeSet().createStructuredType(null, true);
    }

    public CollectionType createCollectionType() {
        return this.getCollectionTypeSet().createCollectionType(null);
    }

    public DTInheritance createDTInheritance() {
        return this.getDTInheritanceSet().createInheritance(null);
    }

    public DTReference createDTReference() {
        return this.getDTReferenceSet().createReference(null);
    }

    @Override
    public Note createNote() {
        return this.getNoteSet().createNote(null);
    }

    @Override
    public Note recreateNote(String string) {
        return this.getNoteSet().createNote(string);
    }

    @Override
    public int getNumberOfChildren() {
        if (this.getMainView().canCreateDisplays()) {
            return 7;
        }
        return 6;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.getDistinctTypeSet();
            }
            case 1: {
                return this.getStructureTypeCollection();
            }
            case 2: {
                return this.getCtCollection();
            }
            case 3: {
                return this.getPredefinedStCollection();
            }
            case 4: {
                return this.getPredefinedCtCollection();
            }
            case 5: {
                return this.subViews;
            }
            case 6: {
                return this.getMainView().getDisplays();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.getDistinctTypeSet()) {
            return 0;
        }
        if (modelObject == this.getStructureTypeCollection()) {
            return 1;
        }
        if (modelObject == this.getCtCollection()) {
            return 2;
        }
        if (modelObject == this.getPredefinedStCollection()) {
            return 3;
        }
        if (modelObject == this.getPredefinedCtCollection()) {
            return 4;
        }
        if (modelObject == this.subViews) {
            return 5;
        }
        if (modelObject == this.getMainView().getDisplays()) {
            return 6;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (setEvent == SetEvent.OBJECT_ADDED) {
            AbstractDTObject abstractDTObject;
            if (designObjectSet instanceof StructuredTypeSet) {
                abstractDTObject = (StructuredType)setEvent.getAffected();
                if (abstractDTObject.isPredefined()) {
                    if (!this.getPredefinedStCollection().contains(abstractDTObject)) {
                        abstractDTObject.setParent(this.getPredefinedStCollection());
                        this.getPredefinedStCollection().add(abstractDTObject);
                        this.getStructureTypeCollection().remove(abstractDTObject);
                        ((TVStructuredType)abstractDTObject.getTopView()).remove(false);
                    }
                } else if (!this.getStructureTypeCollection().contains(abstractDTObject)) {
                    abstractDTObject.setParent(this.getStructureTypeCollection());
                    this.getStructureTypeCollection().add(abstractDTObject);
                    this.getPredefinedStCollection().remove(abstractDTObject);
                }
            }
            if (designObjectSet instanceof CollectionTypeSet) {
                abstractDTObject = (CollectionType)setEvent.getAffected();
                if (abstractDTObject.isPredefined()) {
                    if (!this.getPredefinedCtCollection().contains(abstractDTObject)) {
                        abstractDTObject.setParent(this.getPredefinedCtCollection());
                        this.getPredefinedCtCollection().add(abstractDTObject);
                        this.getCtCollection().remove(abstractDTObject);
                    }
                } else if (!this.getCtCollection().contains(abstractDTObject)) {
                    abstractDTObject.setParent(this.getCtCollection());
                    this.getCtCollection().add(abstractDTObject);
                    this.getPredefinedCtCollection().remove(abstractDTObject);
                }
            }
            this.fireAdded(setEvent.getAffected());
        } else if (setEvent == SetEvent.OBJECT_REMOVED) {
            if (designObjectSet instanceof StructuredTypeSet && setEvent.getAffected() instanceof StructuredType) {
                StructuredType structuredType = (StructuredType)setEvent.getAffected();
                if (structuredType.isPredefined()) {
                    this.getPredefinedStCollection().remove(structuredType);
                } else {
                    this.getStructureTypeCollection().remove(structuredType);
                }
                structuredType.removeObjectListener(this);
            } else if (designObjectSet instanceof CollectionTypeSet) {
                CollectionType collectionType = (CollectionType)setEvent.getAffected();
                if (collectionType.isPredefined()) {
                    this.getPredefinedCtCollection().remove(collectionType);
                } else {
                    this.getCtCollection().remove(collectionType);
                }
                collectionType.removeObjectListener(this);
            }
            this.fireRemoved(setEvent.getAffected());
        }
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> arrayList = new ArrayList<DesignObjectSet>();
        arrayList.add(this.getDistinctTypeSet());
        arrayList.add(this.getStructuredTypeSet());
        arrayList.add(this.getNoteSet());
        arrayList.add(this.getCollectionTypeSet());
        return arrayList;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataTypesModelPropertiesDialog dataTypesModelPropertiesDialog = new DataTypesModelPropertiesDialog(this.getDesign().getAppView(), this, true);
            dataTypesModelPropertiesDialog.initProperties(this);
            dataTypesModelPropertiesDialog.show();
        }
    }

    public void updateInheritances() {
        Iterator iterator = this.getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            structuredType.updateInheritance();
        }
    }

    public void rearrangeTypes() {
        int n = 20;
        int n2 = 20;
        int n3 = 35;
        int n4 = 25;
        int n5 = 0;
        StructuredTypeSet structuredTypeSet = this.getDesign().getDataTypesDesign().getStructuredTypeSet();
        if (structuredTypeSet.size() > 0) {
            Iterator iterator = structuredTypeSet.iterator();
            float f = (float)Math.sqrt(structuredTypeSet.size());
            long l = (int)f;
            if (Math.sqrt(f * f) != (double)f) {
                ++l;
            }
            ++l;
            while (iterator.hasNext()) {
                StructuredType structuredType = (StructuredType)iterator.next();
                TopView topView = structuredType.getTopView();
                if (topView == null) continue;
                ++n5;
                Dimension dimension = this.getTypeSize(structuredType);
                n3 = dimension.width;
                n4 = Math.max(dimension.height, n4);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(n, n2), dimension));
                } else {
                    topView.setBounds(new Rectangle(new Point(n, n2), dimension));
                }
                n = n + n3 + 50;
                if ((long)n5 != l) continue;
                n5 = 0;
                n = 20;
                n2 = n2 + n4 + 50;
                n4 = 25;
            }
        }
    }

    public void rearrangeTypes(List list, Point point) {
        int n = point.x;
        int n2 = point.y;
        int n3 = 35;
        int n4 = 25;
        int n5 = 0;
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            float f = (float)Math.sqrt(list.size());
            long l = (int)f;
            if (Math.sqrt(f * f) != (double)f) {
                ++l;
            }
            ++l;
            while (iterator.hasNext()) {
                StructuredType structuredType = (StructuredType)iterator.next();
                TopView topView = structuredType.getTopView();
                if (topView == null) continue;
                ++n5;
                if (topView.getCellView() != null) {
                    Dimension dimension = this.getTypeSize(structuredType);
                    n3 = dimension.width;
                    n4 = Math.max(dimension.height, n4);
                    topView.getCellView().setNewBounds(new Rectangle(new Point(n, n2), dimension));
                }
                n = n + n3 + 50;
                if ((long)n5 != l) continue;
                n5 = 0;
                n = 20;
                n2 = n2 + n4 + 150;
                n4 = 25;
            }
        }
    }

    public Dimension getTypeSize(StructuredType structuredType) {
        int n = 35;
        int n2 = 25;
        int n3 = structuredType.getElements().length + structuredType.getMethods().length + 1;
        n2 += n3 * 14;
        int n4 = structuredType.getName().length() * 6;
        int n5 = 1;
        for (int i = 0; i < structuredType.getElements().length; ++i) {
            TypeElement typeElement = structuredType.getElements()[i];
            int n6 = typeElement.getName().length() * 7;
            int n7 = typeElement.getDataType().toString().length() * 7 + 10;
            n4 = Math.max(n6, n4);
            n5 = Math.max(n7, n5);
        }
        if (n4 == 1) {
            n4 = structuredType.getName().length() * 7;
        }
        return new Dimension(n + n4 + n5, n2);
    }

    public String getCollectionPrefix() {
        return this.collectionPrefix;
    }

    public void setCollectionPrefix(String string) {
        this.collectionPrefix = string;
    }

    public String getEmbeddedStructuredTypePrefix() {
        return this.embeddedStructuredTypePrefix;
    }

    public void setEmbeddedStructuredTypePrefix(String string) {
        this.embeddedStructuredTypePrefix = string;
    }

    public String getReferencePrefix() {
        return this.referencePrefix;
    }

    public void setReferencePrefix(String string) {
        this.referencePrefix = string;
    }

    public CollectionType getOrCreateCollectionFor(StructuredType structuredType, boolean bl) {
        TypeElement typeElement;
        CollectionType collectionType = null;
        Iterator iterator = this.getCollectionTypeSet().iterator();
        while (iterator.hasNext()) {
            collectionType = (CollectionType)iterator.next();
            typeElement = collectionType.getElementType();
            if (bl != typeElement.isReference() || typeElement.getType() != structuredType) continue;
            return collectionType;
        }
        collectionType = this.createCollectionType();
        typeElement = collectionType.getElementType();
        typeElement.setType(structuredType);
        typeElement.setReference(bl);
        typeElement.setSize("");
        typeElement.setPrecision(0);
        typeElement.setScale(0);
        collectionType.setName(structuredType.getName() + this.getDefaultCollectionType_Suffix());
        collectionType.setType(this.getDefaultCollectionType_Kind());
        if (CollectionType.TYPE_ARRAY.equals(this.getDefaultCollectionType_Kind())) {
            collectionType.setMaxElement(this.getDefaultArrayLimit());
        }
        return collectionType;
    }

    public String getCollectionOfRefsPrefix() {
        return this.collectionOfRefsPrefix;
    }

    public void setCollectionOfRefsPrefix(String string) {
        this.collectionOfRefsPrefix = string;
    }

    public int getDefaultArrayLimit() {
        return this.defaultArrayLimit;
    }

    public void setDefaultArrayLimit(int n) {
        this.defaultArrayLimit = n;
    }

    public String getDefaultCollectionType_Kind() {
        return this.defaultCollectionType_Kind;
    }

    public void setDefaultCollectionType_Kind(String string) {
        this.defaultCollectionType_Kind = string;
    }

    public String getDefaultCollectionType_Suffix() {
        return this.defaultCollectionType_Suffix;
    }

    public void setDefaultCollectionType_Suffix(String string) {
        this.defaultCollectionType_Suffix = string;
    }

    public boolean isUseRoleInAssociationEndAsName() {
        return this.useRoleInAssociationEndAsName;
    }

    public void setUseRoleInAssociationEndAsName(boolean bl) {
        this.useRoleInAssociationEndAsName = bl;
    }

    @Override
    public boolean canCreateDPSubview() {
        return true;
    }

    public DesignObjectCollection getStructureTypeCollection() {
        if (this.stCollection == null) {
            this.stCollection = new DesignObjectCollection();
            this.stCollection.setDesign(this.getDesign());
            this.stCollection.setParent(this);
            this.stCollection.setName(Messages.getString("DataTypesDesign.StructuredTypes"));
            this.stCollection.setElementDescriptor(StructuredType.class);
        }
        return this.stCollection;
    }

    public DesignObjectCollection getPredefinedStCollection() {
        if (this.predefinedStCollection == null) {
            this.predefinedStCollection = new DesignObjectCollection();
            this.predefinedStCollection.setDesign(this.getDesign());
            this.predefinedStCollection.setParent(this);
            this.predefinedStCollection.setName(Messages.getString("DataTypesDesign.PredefinedStructuredTypes"));
            this.predefinedStCollection.setElementDescriptor(StructuredType.class);
            this.addStructureType();
            this.setDirty(false);
            this.getMainView().setDirty(false);
        }
        return this.predefinedStCollection;
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.PREDEFINED_STATUS_CHANGED)) {
            AbstractDTObject abstractDTObject;
            if (designObject instanceof StructuredType) {
                abstractDTObject = (StructuredType)designObject;
                if (abstractDTObject.isPredefined()) {
                    if (!this.getPredefinedStCollection().contains(abstractDTObject)) {
                        abstractDTObject.setParent(this.getPredefinedStCollection());
                        this.getPredefinedStCollection().add(abstractDTObject);
                        this.getStructureTypeCollection().remove(abstractDTObject);
                    }
                } else if (!this.getStructureTypeCollection().contains(abstractDTObject)) {
                    abstractDTObject.setParent(this.getStructureTypeCollection());
                    this.getStructureTypeCollection().add(abstractDTObject);
                    this.getPredefinedStCollection().remove(abstractDTObject);
                }
            }
            if (designObject instanceof CollectionType) {
                abstractDTObject = (CollectionType)designObject;
                if (abstractDTObject.isPredefined()) {
                    if (!this.getPredefinedCtCollection().contains(abstractDTObject)) {
                        abstractDTObject.setParent(this.getPredefinedCtCollection());
                        this.getPredefinedCtCollection().add(abstractDTObject);
                        this.getCtCollection().remove(abstractDTObject);
                    }
                } else if (!this.getCtCollection().contains(abstractDTObject)) {
                    abstractDTObject.setParent(this.getCtCollection());
                    this.getCtCollection().add(abstractDTObject);
                    this.getPredefinedCtCollection().remove(abstractDTObject);
                }
            }
        }
    }

    public DesignObjectCollection getCtCollection() {
        if (this.ctCollection == null) {
            this.ctCollection = new DesignObjectCollection();
            this.ctCollection.setDesign(this.getDesign());
            this.ctCollection.setParent(this);
            this.ctCollection.setCanCreateElement(true);
            this.ctCollection.setName(Messages.getString("DataTypesDesign.CollectionTypes"));
            this.ctCollection.setElementDescriptor(CollectionType.class);
        }
        return this.ctCollection;
    }

    public DesignObjectCollection getPredefinedCtCollection() {
        if (this.predefinedCtCollection == null) {
            this.predefinedCtCollection = new DesignObjectCollection();
            this.predefinedCtCollection.setDesign(this.getDesign());
            this.predefinedCtCollection.setParent(this);
            this.predefinedCtCollection.setName(Messages.getString("DataTypesDesign.PredefinedCollectionTypes"));
            this.predefinedCtCollection.setElementDescriptor(CollectionType.class);
        }
        return this.predefinedCtCollection;
    }

    public void updateFontsAndColors(boolean bl) {
        Object object;
        Iterator iterator = this.getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getNoteSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getDTReferenceSet().iterator();
        while (iterator.hasNext()) {
            object = (DesignObject)iterator.next();
            if (bl) {
                ((DesignObject)object).setBackgroundColor(null);
            } else if (((DesignObject)object).getBackgroundColor() == null) {
                ((DesignObject)object).setBackgroundColor(((DesignObject)object).getTopView().getDefaultLineColor());
            }
            ((DesignObject)object).setUseDefaultColor(bl);
        }
        iterator = this.getDTInheritanceSet().iterator();
        while (iterator.hasNext()) {
            object = (DesignObject)iterator.next();
            if (bl) {
                ((DesignObject)object).setBackgroundColor(null);
            } else if (((DesignObject)object).getBackgroundColor() == null) {
                ((DesignObject)object).setBackgroundColor(((DesignObject)object).getTopView().getDefaultLineColor());
            }
            ((DesignObject)object).setUseDefaultColor(bl);
        }
        iterator = this.getLabelSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("DistinctType");
        arrayList.add("CollectionType");
        arrayList.add("StructuredType");
        arrayList.add("Note");
        arrayList.add("MainView");
        arrayList.add("SubView");
        return arrayList;
    }

    @Override
    public String getStoragePath() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "datatypes").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "datatypes/" + this.getName() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean setName(String string) {
        return true;
    }

    @Override
    public StorableObject createObject(String string, String string2, String string3) {
        DesignObject designObject = null;
        if ("DistinctType".equalsIgnoreCase(string)) {
            designObject = this.getDistinctTypeSet().createDistinctType(string2);
        } else if ("CollectionType".equalsIgnoreCase(string)) {
            designObject = this.getCollectionTypeSet().createCollectionType(string2);
        } else if ("StructuredType".equalsIgnoreCase(string)) {
            designObject = this.getStructuredTypeSet().createStructuredType(string2, false);
        } else if ("Note".equalsIgnoreCase(string)) {
            designObject = this.getNoteSet().createNote(string2);
        }
        if (designObject != null && string3 != null && string3.length() > 0) {
            designObject.setName(string3);
        }
        return designObject;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("distincttype", "DistinctType");
            this.f2tMap.put("collectiontype", "CollectionType");
            this.f2tMap.put("structuredtype", "StructuredType");
            this.f2tMap.put("note", "Note");
        }
        return this.f2tMap;
    }

    public static void initObjectDetails(Design design, File file, String string, StorableObjectStatusHelper storableObjectStatusHelper, String string2) {
        storableObjectStatusHelper.treePath.add(new TreePathHelper(OBJECT_NAME, new File(design.getDataTypesDesign().getStorageName()), DataTypesDesign.class));
        if ("distincttype".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = DistinctType.class;
            storableObjectStatusHelper.objectType = "DistinctType";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(DISTINCT_TYPE_SET_NAME, file.getParentFile(), DistinctTypeSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((DataTypesDesign)storableObjectStatusHelper.designPart).getDistinctTypeSet();
                storableObjectStatusHelper.storableObject = ((DataTypesDesign)storableObjectStatusHelper.designPart).getDistinctTypeSet().getObjectByID(string2);
            }
        } else if ("collectiontype".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = CollectionType.class;
            storableObjectStatusHelper.objectType = "CollectionType";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(COLLECTION_TYPE_SET_NAME, file.getParentFile(), CollectionTypeSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((DataTypesDesign)storableObjectStatusHelper.designPart).getCollectionTypeSet();
                storableObjectStatusHelper.storableObject = ((DataTypesDesign)storableObjectStatusHelper.designPart).getCollectionTypeSet().getObjectByID(string2);
            }
        } else if ("structuredtype".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = StructuredType.class;
            storableObjectStatusHelper.objectType = "StructuredType";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(STRUCTURED_TYPE_SET_NAME, file.getParentFile(), StructuredTypeSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((DataTypesDesign)storableObjectStatusHelper.designPart).getStructuredTypeSet();
                storableObjectStatusHelper.storableObject = ((DataTypesDesign)storableObjectStatusHelper.designPart).getStructuredTypeSet().getObjectByID(string2);
            }
        } else if ("note".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Note.class;
            storableObjectStatusHelper.objectType = "Note";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(NOTE_SET_NAME, file.getParentFile(), NoteSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((DataTypesDesign)storableObjectStatusHelper.designPart).getNoteSet();
                storableObjectStatusHelper.storableObject = ((DataTypesDesign)storableObjectStatusHelper.designPart).getNoteSet().getObjectByID(string2);
            }
        } else if ("subviews".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = DPVDataTypesSubView.class;
            storableObjectStatusHelper.treePath.add(new TreePathHelper(DIAGRAM_SET_NAME, file.getParentFile(), DPVDataTypesSubView.class));
            if (storableObjectStatusHelper.designPart != null) {
                DataTypesDesign dataTypesDesign = (DataTypesDesign)storableObjectStatusHelper.designPart;
                storableObjectStatusHelper.storableObject = dataTypesDesign.getMainView().getDPVId().equals(string2) ? dataTypesDesign.getMainView() : dataTypesDesign.getSubViewByID(string2);
            }
        }
    }

    public List<StorableObject> getNotMarkedGenerateObjects() {
        ArrayList<StorableObject> arrayList = new ArrayList<StorableObject>();
        this.addNotMarkedGenerateStructuredTypes(arrayList);
        this.addNotMarkedGenerateCollectionTypes(arrayList);
        return arrayList;
    }

    private void addNotMarkedGenerateStructuredTypes(List<StorableObject> list) {
        Iterator iterator = this.getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            if (structuredType.isMarkedGenerate()) continue;
            list.add(structuredType);
        }
    }

    private void addNotMarkedGenerateCollectionTypes(List<StorableObject> list) {
        Iterator iterator = this.getCollectionTypeSet().iterator();
        while (iterator.hasNext()) {
            CollectionType collectionType = (CollectionType)iterator.next();
            if (collectionType.isMarkedGenerate()) continue;
            list.add(collectionType);
        }
    }

    public List<StructuredType> getStructuredTypesOrderedByParent() {
        ArrayList<StructuredType> arrayList = new ArrayList<StructuredType>();
        Iterator iterator = this.getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            StructuredType structuredType = (StructuredType)iterator.next();
            this.addST(arrayList, structuredType);
        }
        return arrayList;
    }

    private void addST(List<StructuredType> list, StructuredType structuredType) {
        if (!list.contains(structuredType)) {
            StructuredType structuredType2 = structuredType.getParentType();
            if (structuredType2 != null) {
                this.addST(list, structuredType2);
                if (!list.contains(structuredType)) {
                    list.add(structuredType);
                }
            } else {
                list.add(structuredType);
            }
        }
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        if (this.getMainView() != null) {
            this.getMainView().getWorkSpace().updateSettings();
        }
        this.sortCollections();
    }

    @Override
    public List<Object> getObjectsWithMeasurements() {
        DesignObject designObject;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.getDistinctTypeSet().iterator();
        while (iterator.hasNext()) {
            designObject = (DistinctType)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getCollectionTypeSet().iterator();
        while (iterator.hasNext()) {
            designObject = (CollectionType)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            designObject = (StructuredType)iterator.next();
            if (designObject.getMeasurements().size() > 0) {
                arrayList.add(designObject);
            }
            for (TypeElement typeElement : Arrays.asList(((StructuredType)designObject).getElements())) {
                if (typeElement.getMeasurements().size() <= 0) continue;
                arrayList.add(typeElement);
            }
        }
        iterator = this.getMethodSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Method)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getNoteSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Note)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getDTInheritanceSet().iterator();
        while (iterator.hasNext()) {
            designObject = (DTInheritance)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getDTReferenceSet().iterator();
        while (iterator.hasNext()) {
            designObject = (DTReference)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        return arrayList;
    }
}

