/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.AbstractDTTV;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypes;
import oracle.dbtools.crest.swingui.datatypes.TVDTRelation;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class DTRelation
extends AbstractDTObject
implements ConnectionInterface {
    public static final Object[] CONNECTION_PROTO_ARRAY = new Connection[0];
    public static final int SOURCE = 0;
    public static final int DESTINATION = 1;
    private final AbstractDTObject[] DT_OBJECTS = new AbstractDTObject[2];
    private final Connection[] CONNECTIONS = new Connection[]{new SourceConnection(), new DestinationConnection()};
    private AbstractDTObject source;
    private AbstractDTObject destination;
    private Collection dpvCol = new ArrayList();

    public DTRelation(DesignPart designPart) {
        super(designPart);
    }

    public void setDTObject(int n, AbstractDTObject abstractDTObject) {
        if (this.DT_OBJECTS[n] == abstractDTObject) {
            return;
        }
        if (this.DT_OBJECTS[n] != null) {
            if (this.DT_OBJECTS[0] != this.DT_OBJECTS[1]) {
                // empty if block
            }
            this.DT_OBJECTS[n].remove(this.CONNECTIONS[n]);
        }
        if (abstractDTObject != null) {
            abstractDTObject.add(this.CONNECTIONS[n]);
        }
        this.DT_OBJECTS[n] = abstractDTObject;
        if (abstractDTObject != null) {
            // empty if block
        }
        this.fireChange(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED);
    }

    public AbstractDTObject getDTObject(int n) {
        return this.DT_OBJECTS[n];
    }

    public AbstractDTObject getTargetDTObject() {
        return this.getDTObject(1);
    }

    public void setTargetDTObject(AbstractDTObject abstractDTObject) {
        if (this.getTargetDTObject() != abstractDTObject) {
            AbstractDTObject abstractDTObject2 = this.getTargetDTObject();
            this.setDTObject(1, abstractDTObject);
            if (abstractDTObject2 != null && abstractDTObject2 != abstractDTObject) {
                this.clearTargetTV();
            }
            this.addToAllDPVs();
        }
    }

    public void addToAllDPVs() {
        DesignPartView designPartView;
        if (this.getTargetDTObject() == null || this.getSourceDTObject() == null) {
            return;
        }
        Collection collection = this.getTargetDTObject().getAffectedDPVs();
        Collection collection2 = this.getSourceDTObject().getAffectedDPVs();
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            designPartView = (DesignPartView)iterator.next();
            this.getTargetTV(designPartView);
        }
        while (iterator2.hasNext()) {
            designPartView = (DesignPartView)iterator2.next();
            this.getSourceTV(designPartView);
        }
    }

    public AbstractDTObject getSourceDTObject() {
        return this.getDTObject(0);
    }

    public AbstractDTObject getOtherDTObject(AbstractDTObject abstractDTObject) {
        if (abstractDTObject == this.getSourceDTObject()) {
            return this.getTargetDTObject();
        }
        return this.getSourceDTObject();
    }

    public void setSourceDTObject(AbstractDTObject abstractDTObject) {
        if (this.getSourceDTObject() != abstractDTObject) {
            AbstractDTObject abstractDTObject2 = this.getSourceDTObject();
            this.setDTObject(0, abstractDTObject);
            if (abstractDTObject2 != null && abstractDTObject2 != abstractDTObject) {
                this.clearSourceTV();
            }
            this.addToAllDPVs();
        }
    }

    public void clearSourceTV() {
        for (DpvInfo dpvInfo2 : this.dpvCol) {
            dpvInfo2.sourceTV = null;
            if (dpvInfo2.tv == null) continue;
            ((TVDTRelation)dpvInfo2.tv).removeConnection();
            if (dpvInfo2.dpv != null) {
                dpvInfo2.dpv.unregisterFromTreemodel(dpvInfo2.tv);
            }
            dpvInfo2.tv = null;
        }
    }

    public void clearTargetTV() {
        for (DpvInfo dpvInfo2 : this.dpvCol) {
            dpvInfo2.targetTV = null;
            if (dpvInfo2.tv == null) continue;
            ((TVDTRelation)dpvInfo2.tv).removeConnection();
            if (dpvInfo2.dpv != null) {
                dpvInfo2.dpv.unregisterFromTreemodel(dpvInfo2.tv);
            }
            dpvInfo2.tv = null;
        }
    }

    public DpvInfo getDPVInfoFor(DesignPartView designPartView) {
        DpvInfo dpvInfo22;
        for (DpvInfo dpvInfo22 : this.dpvCol) {
            if (dpvInfo22.dpv != designPartView) continue;
            return dpvInfo22;
        }
        dpvInfo22 = new DpvInfo();
        dpvInfo22.dpv = designPartView;
        this.dpvCol.add(dpvInfo22);
        return dpvInfo22;
    }

    @Override
    public TopView getViewFor(DesignPartView designPartView) {
        DpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        return dpvInfo2.tv;
    }

    public AbstractDTTV getSourceTV(DesignPartView designPartView) {
        Collection collection;
        DpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.sourceTV == null && this.getSourceDTObject() != null && !(collection = this.getSourceDTObject().getAllViews(designPartView)).isEmpty()) {
            Iterator iterator = collection.iterator();
            dpvInfo2.sourceTV = (AbstractDTTV)iterator.next();
            dpvInfo2.sourceTV.addTopViewListener(this);
            this.addTVDTRelation(dpvInfo2);
        }
        return dpvInfo2.sourceTV;
    }

    public AbstractDTTV getTargetTV(DesignPartView designPartView) {
        Collection collection;
        DpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.targetTV == null && this.getTargetDTObject() != null && !(collection = this.getTargetDTObject().getAllViews(designPartView)).isEmpty()) {
            Iterator iterator = collection.iterator();
            dpvInfo2.targetTV = (AbstractDTTV)iterator.next();
            dpvInfo2.targetTV.addTopViewListener(this);
            this.addTVDTRelation(dpvInfo2);
        }
        return dpvInfo2.targetTV;
    }

    public void addTVDTRelation(DpvInfo dpvInfo2) {
        if (dpvInfo2.tv == null && dpvInfo2.sourceTV != null && dpvInfo2.targetTV != null && dpvInfo2.dpv != null) {
            TopView topView = ((DPVDataTypes)dpvInfo2.dpv).createViewSynonim(this);
            topView.setSize(new Dimension(100, 100));
            this.addObjectListener(topView);
        } else if (dpvInfo2.tv != null && ((TVConnector)dpvInfo2.tv).getEdge() == null && dpvInfo2.dpv.isVisible() && dpvInfo2.sourceTV != null && dpvInfo2.targetTV != null && dpvInfo2.dpv != null) {
            DefaultEdge defaultEdge = ((TVDTRelation)dpvInfo2.tv).addConnection();
            dpvInfo2.tv.getDesignPartView().getWorkSpace().addPoints(defaultEdge, ((TVDTRelation)dpvInfo2.tv).getEdgePoints(), true);
            defaultEdge.getCellView().update();
        }
    }

    public void setSourceTV(AbstractDTTV abstractDTTV) {
        DesignPartView designPartView = abstractDTTV.getDesignPartView();
        DpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.sourceTV != abstractDTTV) {
            if (dpvInfo2.sourceTV != null) {
                if (dpvInfo2.tv != null) {
                    ((TVDTRelation)dpvInfo2.tv).removeConnection();
                    if (dpvInfo2.dpv != null) {
                        dpvInfo2.dpv.unregisterFromTreemodel(dpvInfo2.tv);
                    }
                    dpvInfo2.tv = null;
                }
                dpvInfo2.sourceTV.removeTopViewListener(this);
            }
            dpvInfo2.sourceTV = abstractDTTV;
            dpvInfo2.sourceTV.addTopViewListener(this);
            this.addTVDTRelation(dpvInfo2);
        }
    }

    public void setTargetTV(AbstractDTTV abstractDTTV) {
        DesignPartView designPartView = abstractDTTV.getDesignPartView();
        DpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.targetTV != abstractDTTV) {
            if (dpvInfo2.targetTV != null) {
                if (dpvInfo2.tv != null) {
                    ((TVDTRelation)dpvInfo2.tv).removeConnection();
                    if (dpvInfo2.dpv != null) {
                        dpvInfo2.dpv.unregisterFromTreemodel(dpvInfo2.tv);
                    }
                    dpvInfo2.tv = null;
                }
                dpvInfo2.targetTV.removeTopViewListener(this);
            }
            dpvInfo2.targetTV = abstractDTTV;
            dpvInfo2.targetTV.addTopViewListener(this);
            this.addTVDTRelation(dpvInfo2);
        }
    }

    public void callRemoveListeners() {
        ObjectChangeEvent objectChangeEvent = ObjectChangeEvent.OBJECT_REMOVED;
        objectChangeEvent.setAffected(this);
        this.fireChange(objectChangeEvent);
    }

    public boolean isValid() {
        return this.getDTObject(0) != null && this.getDTObject(1) != null;
    }

    public Connection getConnection(int n) {
        return this.CONNECTIONS[n];
    }

    public Connection getSourceConnection() {
        return this.getConnection(0);
    }

    public Connection getTargetConnection() {
        return this.getConnection(1);
    }

    @Override
    public void setTopView(TopView topView) {
        this.addTopView(topView);
    }

    @Override
    public TopView getTopView() {
        for (DpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.tv == null) continue;
            return dpvInfo2.tv;
        }
        return null;
    }

    @Override
    public void addTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        DpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.tv != null) {
            throw new RuntimeException(Messages.getString("DTRelation.AssociationAlreadyExists"));
        }
        dpvInfo2.tv = topView;
    }

    @Override
    public void removeTopView(TopView topView) {
        if (topView != null) {
            DesignPartView designPartView = topView.getDesignPartView();
            DpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            ((TVDTRelation)topView).removeConnection();
            if (dpvInfo2.dpv != null) {
                dpvInfo2.dpv.unregisterFromTreemodel(topView);
            }
            if (dpvInfo2.tv == null) {
                return;
            }
            this.dpvCol.remove(dpvInfo2);
            this.removeObjectListener(topView);
        }
    }

    public void removeViewFor(DesignPartView designPartView) {
        if (designPartView != null) {
            DpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            if (dpvInfo2.tv != null) {
                ((TVDTRelation)dpvInfo2.tv).removeConnection();
                if (dpvInfo2.dpv != null) {
                    dpvInfo2.dpv.unregisterFromTreemodel(dpvInfo2.tv);
                }
                this.dpvCol.remove(dpvInfo2);
            }
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public AbstractDTObject getSource() {
        return this.source;
    }

    public void setSource(AbstractDTObject abstractDTObject) {
        this.source = abstractDTObject;
    }

    public AbstractDTObject getDestination() {
        return this.destination;
    }

    public void setDestination(AbstractDTObject abstractDTObject) {
        this.destination = abstractDTObject;
    }

    @Override
    public String getObjectTypeName() {
        return "DTRelation";
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "DTRelation";
    }

    @Override
    public void changed(TopView topView, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView designPartView = topView.getDesignPartView();
            designPartView.removeViewFor(this);
            DpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            dpvInfo2.tv = null;
            if (dpvInfo2.sourceTV == topView) {
                dpvInfo2.sourceTV = null;
            }
            if (dpvInfo2.targetTV == topView) {
                dpvInfo2.targetTV = null;
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.setDTObject(1, null);
        this.setDTObject(0, null);
        int n = 0;
        ++n;
    }

    @Override
    public void setSourceTopView(TopView topView) {
        this.setSourceTV((AbstractDTTV)topView);
    }

    @Override
    public void setTargetTopView(TopView topView) {
        this.setTargetTV((AbstractDTTV)topView);
    }

    @Override
    public TopView getSourceTopView(DesignPartView designPartView) {
        return this.getSourceTV(designPartView);
    }

    @Override
    public TopView getTargetTopView(DesignPartView designPartView) {
        return this.getTargetTV(designPartView);
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView designPartView) {
        return this.getViewFor(designPartView);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getSourceDTObject();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getTargetDTObject();
    }

    @Override
    public List getAllViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (DpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.tv == null) continue;
            arrayList.add(dpvInfo2.tv);
        }
        return arrayList;
    }

    @Override
    public void restoreTopView(TopView topView, TopView topView2, TopView topView3) {
        topView.getDesignPartView().restoreTopview(topView, this);
        DpvInfo dpvInfo2 = this.getDPVInfoFor(topView.getDesignPartView());
        if (dpvInfo2.tv == topView) {
            this.addObjectListener(topView);
            dpvInfo2.targetTV = (AbstractDTTV)topView3;
            dpvInfo2.targetTV.addTopViewListener(this);
            dpvInfo2.sourceTV = (AbstractDTTV)topView2;
            dpvInfo2.sourceTV.addTopViewListener(this);
        }
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    public class DestinationConnection
    extends Connection {
        @Override
        public AbstractDTObject getDTObject() {
            return DTRelation.this.getDTObject(1);
        }

        @Override
        public String getDescriptor() {
            return "Destination";
        }

        @Override
        public boolean isSource() {
            return false;
        }
    }

    public class SourceConnection
    extends Connection {
        @Override
        public AbstractDTObject getDTObject() {
            return DTRelation.this.getDTObject(0);
        }

        @Override
        public String getDescriptor() {
            return "Source";
        }

        @Override
        public boolean isSource() {
            return true;
        }
    }

    public abstract class Connection {
        private Boolean optionality = Boolean.TRUE;
        private String nameOn = null;

        public DTRelation getDTRelation() {
            return DTRelation.this;
        }

        public abstract AbstractDTObject getDTObject();

        public abstract String getDescriptor();

        public abstract boolean isSource();

        public String toString() {
            return DTRelation.this.getName() + this.getDescriptor();
        }

        public boolean isOptional() {
            return this.optionality;
        }

        public void setOptional(boolean bl) {
            this.optionality = bl ? Boolean.TRUE : Boolean.FALSE;
        }

        public Boolean getOptionality() {
            return this.optionality;
        }

        public void setOptionality(Boolean bl) {
            this.optionality = bl == null ? Boolean.FALSE : bl;
        }

        public void setNameOn(String string) {
            this.nameOn = string;
        }

        public TopView getTopView() {
            return DTRelation.this.getTopView();
        }

        public String getNameOn() {
            return this.nameOn;
        }
    }

    public class DpvInfo {
        public AbstractDTTV sourceTV;
        public AbstractDTTV targetTV;
        public TopView tv;
        public DesignPartView dpv;

        DpvInfo() {
        }
    }
}

