/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;

public class DTReferenceSet
extends DesignObjectSet {
    private static final Object[] PROTO_TYPE = new DTReference[0];

    public DTReferenceSet(DesignPart designPart) {
        super(designPart);
    }

    public DTReference createReference(String string) {
        DTReference dTReference = new DTReference(this.getDesignPart());
        dTReference.setObjectID(string);
        dTReference.setDesign(this.getDesign());
        dTReference.setParent(this);
        this.getDesign().addDesignObject(dTReference);
        this.add(dTReference);
        return dTReference;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_TYPE;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return "DTReference";
    }

    public Collection getRelationsToSource(StructuredType structuredType) {
        ArrayList<DTReference> arrayList = new ArrayList<DTReference>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DTReference dTReference = (DTReference)iterator.next();
            if (dTReference.getSourceDTObject() != structuredType) continue;
            arrayList.add(dTReference);
        }
        return arrayList;
    }

    public Collection getRelationsToTarget(StructuredType structuredType) {
        ArrayList<DTReference> arrayList = new ArrayList<DTReference>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DTReference dTReference = (DTReference)iterator.next();
            if (dTReference.getTargetDTObject() != structuredType) continue;
            arrayList.add(dTReference);
        }
        return arrayList;
    }

    public Collection getRelationsTo(StructuredType structuredType) {
        ArrayList<DTReference> arrayList = new ArrayList<DTReference>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DTReference dTReference = (DTReference)iterator.next();
            if (dTReference.getSourceDTObject() != structuredType && dTReference.getTargetDTObject() != structuredType) continue;
            arrayList.add(dTReference);
        }
        return arrayList;
    }
}

