/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;

public class DTInheritanceSet
extends DesignObjectSet {
    private static final Object[] PROTO_TYPE = new DTInheritance[0];

    public DTInheritanceSet(DesignPart designPart) {
        super(designPart);
    }

    public DTInheritance createInheritance(String string) {
        DTInheritance dTInheritance = new DTInheritance(this.getDesignPart());
        dTInheritance.setObjectID(string);
        dTInheritance.setDesign(this.getDesign());
        dTInheritance.setParent(this);
        this.getDesign().addDesignObject(dTInheritance);
        this.add(dTInheritance);
        return dTInheritance;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_TYPE;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return "DTInheritance";
    }

    public Collection getInheritancesToSource(StructuredType structuredType) {
        ArrayList<DTInheritance> arrayList = new ArrayList<DTInheritance>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DTInheritance dTInheritance = (DTInheritance)iterator.next();
            if (dTInheritance.getSourceDTObject() != structuredType) continue;
            arrayList.add(dTInheritance);
        }
        return arrayList;
    }

    public Collection getInheritancesToTarget(StructuredType structuredType) {
        ArrayList<DTInheritance> arrayList = new ArrayList<DTInheritance>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DTInheritance dTInheritance = (DTInheritance)iterator.next();
            if (dTInheritance.getTargetDTObject() != structuredType) continue;
            arrayList.add(dTInheritance);
        }
        return arrayList;
    }

    public Collection getRelationsTo(StructuredType structuredType) {
        ArrayList<DTInheritance> arrayList = new ArrayList<DTInheritance>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DTInheritance dTInheritance = (DTInheritance)iterator.next();
            if (dTInheritance.getSourceDTObject() != structuredType && dTInheritance.getTargetDTObject() != structuredType) continue;
            arrayList.add(dTInheritance);
        }
        return arrayList;
    }
}

