/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.io.File;
import java.io.IOException;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionTypeSet;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.editor.datatypes.CollectionTypePropertiesDialogEx;

public class CollectionType
extends AbstractDTObject
implements Datatype,
SetListener {
    public static String TYPE_ARRAY = "ARRAY";
    public static String TYPE_COLLECTION = "COLLECTION";
    private String[] TYPES = new String[]{TYPE_ARRAY, TYPE_COLLECTION};
    private String type = this.TYPES[0];
    private TypeElement elementType = null;
    private int maxElement = 1;
    DataTypeWrapper dataTypeWrapper;
    public static final String TYPE_NAME = "CollectionType";

    public CollectionType(DesignPart designPart) {
        super(designPart);
        ((DataTypesDesign)designPart).getCollectionTypeSet().addSetListener(this);
    }

    @Override
    public int getByteSize() {
        return 0;
    }

    @Override
    public String getSize() {
        return "";
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public String getType() {
        return this.type;
    }

    public void setDataTypeID(String string) {
        this.getElementType().setTypeID(string);
    }

    public void setType(String string) {
        this.type = string;
    }

    public TypeElement getElementType() {
        if (this.elementType == null) {
            this.elementType = new TypeElement(this.getDesignPart(), null);
            this.elementType.setDesign(this.getDesign());
            this.elementType.setType(this.getDesign().getDomainSet().getDefaultDomain());
            this.elementType.setParent(this);
        }
        return this.elementType;
    }

    public DesignObject getDataType() {
        return this.getElementType().getType();
    }

    public void setElementType(TypeElement typeElement) {
        this.elementType = typeElement;
    }

    public void addElementType(DesignObject designObject) {
        this.getElementType().setType(designObject);
    }

    public int getMaxElement() {
        return this.maxElement;
    }

    public void setMaxElement(int n) {
        this.maxElement = n;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            CollectionTypePropertiesDialogEx collectionTypePropertiesDialogEx = new CollectionTypePropertiesDialogEx(this.getDesign().getAppView(), this);
            collectionTypePropertiesDialogEx.initProperties(this);
            collectionTypePropertiesDialogEx.show();
        }
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (designObjectSet instanceof CollectionTypeSet && setEvent.isRemoved()) {
            CollectionType collectionType = (CollectionType)setEvent.getAffected();
            if (this.getElementType().getType() == collectionType) {
                this.setElementType(null);
            }
        }
    }

    public boolean isArrayType() {
        return this.type.equalsIgnoreCase(this.TYPES[0]);
    }

    public void setArrayType() {
        this.setType(this.TYPES[0]);
    }

    public void setCollectionType() {
        this.setType(this.TYPES[1]);
    }

    @Override
    public void copy(DesignObject designObject) {
        CollectionType collectionType = (CollectionType)designObject;
        super.copy(collectionType);
        collectionType.setType(this.getType());
        collectionType.setMaxElement(this.getMaxElement());
        collectionType.setDataTypeID(this.getElementType().getObjectID());
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "collectiontype/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public DataTypeWrapper getDataTypeWrapper() {
        if (this.dataTypeWrapper == null) {
            this.dataTypeWrapper = new DataTypeWrapper(this.getElementType());
        }
        return this.dataTypeWrapper;
    }

    @Override
    public boolean hasProxyToDelete() {
        return true;
    }

    public class DataTypeWrapper {
        TypeElement te;

        private DataTypeWrapper(TypeElement typeElement) {
            this.te = typeElement;
        }

        public int getPrecision() {
            return this.te.getPrecision();
        }

        public void setPrecision(int n) {
            this.te.setPrecision(n);
        }

        public int getScale() {
            return this.te.getScale();
        }

        public void setScale(int n) {
            this.te.setScale(n);
        }

        public String getSize() {
            return this.te.getSize();
        }

        public void setSize(String string) {
            this.te.setSize(string);
        }

        public void setTypeID(String string) {
            this.te.setTypeID(string);
        }

        public String getTypeID() {
            return this.te.getTypeID();
        }

        public boolean isReference() {
            return this.te.isReference();
        }

        public void setReference(boolean bl) {
            this.te.setReference(bl);
        }
    }
}

