/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;

public class SnapshotComparator
extends StoragePropertiesComparator {
    private SnapshotOracle sourceSnapshot;
    private SnapshotOracle targetSnapshot;
    private Map objectsMap;

    public SnapshotComparator(StorageObject storageObject, StorageObject storageObject2, Map map) {
        super(storageObject, storageObject2);
        this.sourceSnapshot = (SnapshotOracle)storageObject;
        this.targetSnapshot = (SnapshotOracle)storageObject2;
        this.objectsMap = map;
        this.initPropertiesList();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder propertyHolder = new PropertyHolder(BODY);
        propertyHolder.setLeftValue(this.sourceSnapshot != null ? this.sourceSnapshot.getSubquery() : "");
        propertyHolder.setRightValue(this.targetSnapshot != null ? this.targetSnapshot.getSubquery() : "");
        if (!propertyHolder.getLeftValue().equals(propertyHolder.getRightValue())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(ON_PREBUILT_TABLE);
        propertyHolder.setLeftValue(this.sourceSnapshot != null ? String.valueOf(this.sourceSnapshot.getOnPrebuildTable()) : "");
        propertyHolder.setRightValue(this.targetSnapshot != null ? String.valueOf(this.targetSnapshot.getOnPrebuildTable()) : "");
        if (!propertyHolder.getLeftValue().equals(propertyHolder.getRightValue())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(IMPLEMENTS_TABLE);
        propertyHolder.setLeftValue(this.sourceSnapshot != null ? String.valueOf(this.sourceSnapshot.getImplementedTable()) : "");
        propertyHolder.setRightValue(this.targetSnapshot != null ? String.valueOf(this.targetSnapshot.getImplementedTable()) : "");
        if (!propertyHolder.getLeftValue().equals(propertyHolder.getRightValue())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromSnapshotToSnapshot();
    }

    private void copyPropertiesFromSnapshotToSnapshot() {
        if (this.sourceSnapshot != null && this.targetSnapshot != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                TableProxyOracle tableProxyOracle;
                ModelIDObject modelIDObject;
                TableProxyOracle tableProxyOracle2;
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(BODY)) {
                    this.targetSnapshot.setSubquery(this.sourceSnapshot.getSubquery());
                    continue;
                }
                if (engPropertyHolder.getName().equals(ON_PREBUILT_TABLE)) {
                    tableProxyOracle2 = this.sourceSnapshot.getOnPrebuildTable();
                    if (tableProxyOracle2 != null) {
                        modelIDObject = (ModelIDObject)this.objectsMap.get(tableProxyOracle2.getObjectID());
                        if (modelIDObject == null || (tableProxyOracle = (TableProxyOracle)this.targetSnapshot.getStorageDesign().getStorageObject(modelIDObject.getObjectID())) == null) continue;
                        this.targetSnapshot.setOnPrebuildTable(tableProxyOracle);
                        continue;
                    }
                    this.targetSnapshot.setOnPrebuildTable(null);
                    continue;
                }
                if (!engPropertyHolder.getName().equals(IMPLEMENTS_TABLE)) continue;
                tableProxyOracle2 = this.sourceSnapshot.getImplementedTable();
                if (tableProxyOracle2 != null) {
                    modelIDObject = (ModelIDObject)this.objectsMap.get(tableProxyOracle2.getObjectID());
                    if (modelIDObject == null || (tableProxyOracle = (TableProxyOracle)this.targetSnapshot.getStorageDesign().getStorageObject(modelIDObject.getObjectID())) == null) continue;
                    tableProxyOracle.setSnapshot(this.targetSnapshot);
                    continue;
                }
                modelIDObject = this.targetSnapshot.getImplementedTable();
                if (modelIDObject == null) continue;
                ((TableProxyOracle)modelIDObject).setSnapshot(null);
            }
        }
    }
}

