/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;

public class SequenceComparator
extends StoragePropertiesComparator {
    private SequenceOracle sourceSequence;
    private SequenceOracle targetSequence;

    public SequenceComparator(StorageObject storageObject, StorageObject storageObject2) {
        super(storageObject, storageObject2);
        this.sourceSequence = (SequenceOracle)storageObject;
        this.targetSequence = (SequenceOracle)storageObject2;
        this.initPropertiesList();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder propertyHolder = new PropertyHolder(USER_NAME);
        String string = "";
        String string2 = "";
        if (this.sourceSequence != null && this.sourceSequence.getUser() != null) {
            string = this.sourceSequence.getUser().getName();
        }
        if (this.targetSequence != null && this.targetSequence.getUser() != null) {
            string2 = this.targetSequence.getUser().getName();
        }
        propertyHolder.setLeftValue(string);
        propertyHolder.setRightValue(string2);
        if (this.sourceSequence != null && this.targetSequence != null && !string.equalsIgnoreCase(string2)) {
            propertyHolder.setModified(true);
            if (this.useSchema) {
                propertyHolder.setSelected(true);
            } else {
                propertyHolder.setFiltered(true);
            }
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(START_WITH);
        propertyHolder.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getStartWith() : "");
        propertyHolder.setRightValue(this.targetSequence != null ? this.targetSequence.getStartWith() : "");
        if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getStartWith().equals(this.targetSequence.getStartWith())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(INCREMENT_BY);
        propertyHolder.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getIncrementBy() : "");
        propertyHolder.setRightValue(this.targetSequence != null ? this.targetSequence.getIncrementBy() : "");
        if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getIncrementBy().equals(this.targetSequence.getIncrementBy())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(MAX_VALUE);
        propertyHolder.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getMaxValue() : "");
        propertyHolder.setRightValue(this.targetSequence != null ? this.targetSequence.getMaxValue() : "");
        if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getMaxValue().equals(this.targetSequence.getMaxValue())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(MIN_VALUE);
        propertyHolder.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getMinValue() : "");
        propertyHolder.setRightValue(this.targetSequence != null ? this.targetSequence.getMinValue() : "");
        if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getMinValue().equals(this.targetSequence.getMinValue())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(CYCLE);
        propertyHolder.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getCycle() : "");
        propertyHolder.setRightValue(this.targetSequence != null ? this.targetSequence.getCycle() : "");
        if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getCycle().equals(this.targetSequence.getCycle())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(CACHE);
        propertyHolder.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getCache() : "");
        propertyHolder.setRightValue(this.targetSequence != null ? this.targetSequence.getCache() : "");
        if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getCache().equals(this.targetSequence.getCache())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(ORDER);
        propertyHolder.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getOrder() : "");
        propertyHolder.setRightValue(this.targetSequence != null ? this.targetSequence.getOrder() : "");
        if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getOrder().equals(this.targetSequence.getOrder())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromSequenceToSequence();
    }

    private void copyPropertiesFromSequenceToSequence() {
        if (this.sourceSequence != null && this.targetSequence != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(USER_NAME)) {
                    this.targetSequence.setUser(this.sourceSequence.getUser());
                    continue;
                }
                if (engPropertyHolder.getName().equals(START_WITH)) {
                    this.targetSequence.setStartWith(this.sourceSequence.getStartWith());
                    continue;
                }
                if (engPropertyHolder.getName().equals(INCREMENT_BY)) {
                    this.targetSequence.setIncrementBy(this.sourceSequence.getIncrementBy());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MAX_VALUE)) {
                    this.targetSequence.setMaxValue(this.sourceSequence.getMaxValue());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MIN_VALUE)) {
                    this.targetSequence.setMinValue(this.sourceSequence.getMinValue());
                    continue;
                }
                if (engPropertyHolder.getName().equals(CYCLE)) {
                    this.targetSequence.setCycle(this.sourceSequence.getCycle());
                    continue;
                }
                if (engPropertyHolder.getName().equals(CACHE)) {
                    this.targetSequence.setCache(this.sourceSequence.getCache());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(ORDER)) continue;
                this.targetSequence.setOrder(this.sourceSequence.getOrder());
            }
        }
    }
}

