/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageObject;

public abstract class StoragePropertiesComparator
extends PropertiesComparator {
    private StorageObject left_so;
    private StorageObject right_so;

    public StoragePropertiesComparator(DesignObject designObject, DesignObject designObject2) {
        super(designObject, designObject2);
    }

    public StoragePropertiesComparator(StorageObject storageObject, StorageObject storageObject2) {
        super(null, null);
        this.left_so = storageObject;
        this.right_so = storageObject2;
    }

    @Override
    public abstract void copySelectedProperties();

    @Override
    public String getLeftName() {
        if (this.left_so != null) {
            return this.left_so.getName();
        }
        return "";
    }

    @Override
    public String getRightName() {
        if (this.right_so != null) {
            return this.right_so.getName();
        }
        return "";
    }

    @Override
    protected void initNameProperty() {
        PropertyHolder propertyHolder = new PropertyHolder(NAME);
        propertyHolder.setLeftValue(this.left_so != null ? this.left_so.getName() : "");
        propertyHolder.setRightValue(this.right_so != null ? this.right_so.getName() : "");
        if (this.left_so != null && this.right_so != null) {
            if (this.caseSensitive) {
                if (!this.left_so.getName().equals(this.right_so.getName())) {
                    propertyHolder.setModified(true);
                    propertyHolder.setSelected(true);
                }
            } else if (!this.left_so.getName().equalsIgnoreCase(this.right_so.getName())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
        }
        this.propertiesList.add(propertyHolder);
    }

    @Override
    protected void initCommentsAndNotes() {
        PropertyHolder propertyHolder = new PropertyHolder(COMMENT);
        propertyHolder.setLeftValue(this.left_so != null ? this.left_so.getComment() : "");
        propertyHolder.setRightValue(this.right_so != null ? this.right_so.getComment() : "");
        if (this.left_so != null && this.right_so != null && !this.left_so.getComment().equals(this.right_so.getComment())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(COMMENT_IN_RDBMS);
        propertyHolder.setLeftValue(this.left_so != null ? this.left_so.getCommentInRDBMS() : "");
        propertyHolder.setRightValue(this.right_so != null ? this.right_so.getCommentInRDBMS() : "");
        if (this.left_so != null && this.right_so != null && !this.left_so.getCommentInRDBMS().equals(this.right_so.getCommentInRDBMS())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(NOTES);
        propertyHolder.setLeftValue(this.left_so != null ? this.left_so.getNotes() : "");
        propertyHolder.setRightValue(this.right_so != null ? this.right_so.getNotes() : "");
        if (this.left_so != null && this.right_so != null && !this.left_so.getNotes().equals(this.right_so.getNotes())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.left_so != null && this.right_so != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(NAME)) {
                    this.right_so.setName(this.left_so.getName());
                    continue;
                }
                if (engPropertyHolder.getName().equals(COMMENT)) {
                    this.right_so.setComment(this.left_so.getComment());
                    continue;
                }
                if (engPropertyHolder.getName().equals(COMMENT_IN_RDBMS)) {
                    this.right_so.setCommentInRDBMS(this.left_so.getCommentInRDBMS());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(NOTES)) continue;
                this.right_so.setNotes(this.left_so.getNotes());
            }
            this.right_so.setDirty(this.isDirty());
        }
    }

    @Override
    public String getID() {
        if (this.left_so != null && this.right_so != null) {
            return this.left_so.getObjectID() + this.right_so.getObjectID();
        }
        if (this.left_so != null) {
            return this.left_so.getObjectID();
        }
        if (this.right_so != null) {
            return this.right_so.getObjectID();
        }
        return "null";
    }

    @Override
    protected boolean hasToBeRename() {
        return false;
    }

    @Override
    protected boolean hasToBeDrop() {
        return this.left_so == null && this.right_so != null;
    }

    public void setDroped(boolean bl) {
        this.isDroped = bl;
    }

    public boolean isDroped() {
        return this.isDroped;
    }
}

