/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TriggerOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBRenameTableOraclev10g
extends AbstractCSSBOracle {
    private StorageDesignOraclev10g storageDesign;
    private Map fkList = new TreeMap();
    private CSSBCreateRenameTableOraclev10g createTable = null;

    public CSSBRenameTableOraclev10g(Map map) {
        this.fkList = map;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Object object2;
        if (object == null) {
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        Table table = null;
        TableSelection tableSelection = (TableSelection)object;
        TableSelection tableSelection2 = (TableSelection)((CompareObjectSelection)object).getCorrespondentNode();
        TableProxyOraclev10g tableProxyOraclev10g = null;
        Table table2 = null;
        if (((CompareObjectSelection)object).getObject() instanceof Table) {
            table = (Table)((CompareObjectSelection)object).getCorrespondentNode().getObject();
            object2 = table.getDesign();
            RDBMSSite rDBMSSite = table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)((Design)object2).getStorageDesign(rDBMSSite, table);
            tableProxyOraclev10g = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            table2 = (Table)((CompareObjectSelection)object).getObject();
        } else if (((CompareObjectSelection)object).getObject() instanceof TableProxyOraclev10g) {
            tableProxyOraclev10g = (TableProxyOraclev10g)((CompareObjectSelection)object).getCorrespondentNode().getObject();
            table = (Table)tableProxyOraclev10g.getObject();
            object2 = table.getDesign();
            this.storageDesign = (StorageDesignOraclev10g)((Design)object2).getStorageDesign(table.getSelectedRDBMSSite(), table);
            table2 = (Table)((TableProxyOraclev10g)((CompareObjectSelection)object).getObject()).getObject();
        }
        if (((CompareObjectSelection)object).canBeRenameOnly()) {
            this.appendRenameTableOnly(table, table2, stringBuffer, bl);
            return;
        }
        if (tableSelection2.getScriptExecuteOption().equals(TableSelection.STOP_BEFORE_BACKUP) && (TableSelection.BACKUP_RENAME.equals(object2 = tableSelection2.getBackupOption()) || TableSelection.BACKUP_UNLOAD.equals(object2) || TableSelection.BACKUP_UNLOAD_PARTITION.equals(object2))) {
            this.appendScriptExecution(stringBuffer, this.storageDesign.getFormatedName(tableSelection2.getName()));
        }
        CSSBRenameTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendDropFK(tableProxyOraclev10g, (CompareObjectSelection)object, stringBuffer, bl);
        this.appendDropPK(tableProxyOraclev10g, stringBuffer, bl);
        this.appendDropUK(tableProxyOraclev10g, stringBuffer, bl);
        this.appendDropConstraint(tableProxyOraclev10g, stringBuffer, bl);
        this.appendDropCoilumnConstraints(tableProxyOraclev10g, stringBuffer, bl);
        this.appendDropIndex(tableProxyOraclev10g, stringBuffer, bl);
        this.appendDropTriggers(tableProxyOraclev10g, stringBuffer, bl);
        this.appendDropBitmapJoinIndexes(tableProxyOraclev10g, stringBuffer, bl);
        if (TableSelection.BACKUP_RENAME.equals(tableSelection2.getBackupOption())) {
            this.appendRenameTable(tableProxyOraclev10g, stringBuffer, bl);
            if (tableSelection2.getScriptExecuteOption().equals(TableSelection.STOP_AFTER_BACKUP)) {
                this.appendScriptExecution(stringBuffer, this.storageDesign.getFormatedName(tableSelection2.getName()));
            }
        } else if (TableSelection.BACKUP_UNLOAD.equals(tableSelection2.getBackupOption())) {
            object2 = tableSelection2.getUnloadDirectory();
            if ("".equals(object2)) {
                object2 = table.getDesign().getUnloadDirectory();
            }
            this.addUnloadExecution(stringBuffer, tableSelection, tableProxyOraclev10g, (String)object2);
            if (tableSelection2.getScriptExecuteOption().equals(TableSelection.STOP_AFTER_BACKUP)) {
                this.appendScriptExecution(stringBuffer, this.storageDesign.getFormatedName(tableSelection2.getName()));
            }
            this.appendDropTable(stringBuffer, tableProxyOraclev10g, bl);
        } else if (TableSelection.BACKUP_UNLOAD_PARTITION.equals(tableSelection2.getBackupOption())) {
            object2 = tableSelection2.getUnloadDirectory();
            if ("".equals(object2)) {
                object2 = table.getDesign().getUnloadDirectory();
            }
            this.addUnloadPerPartitionExecution(stringBuffer, tableSelection, tableProxyOraclev10g, (String)object2);
            if (tableSelection2.getScriptExecuteOption().equals(TableSelection.STOP_AFTER_BACKUP)) {
                this.appendScriptExecution(stringBuffer, this.storageDesign.getFormatedName(tableSelection2.getName()));
            }
            this.appendDropTable(stringBuffer, tableProxyOraclev10g, bl);
        } else if (TableSelection.NONE.equals(tableSelection2.getBackupOption())) {
            this.appendDropTable(stringBuffer, tableProxyOraclev10g, bl);
        }
        this.appendCreateTable(object, stringBuffer, bl);
    }

    protected void appendCreateTable(Object object, StringBuffer stringBuffer, boolean bl) {
        if (this.createTable == null) {
            this.createTable = new CSSBCreateRenameTableOraclev10g();
        }
        this.createTable.setRenamed(true);
        this.createTable.doAppend(stringBuffer, object, bl);
    }

    private void appendRenameTable(TableProxyOraclev10g tableProxyOraclev10g, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        this.appendBeforeAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOraclev10g.getObject());
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxyOraclev10g.getLongName()));
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "RENAME");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "TO");
        String string = "bcp_" + tableProxyOraclev10g.getName();
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string));
        String string2 = stringBuffer2.toString();
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        CSSBRenameTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        this.appendAfterAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOraclev10g.getObject());
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendRenameTableOnly(Table table, Table table2, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        this.appendBeforeAlterScript(stringBuffer, bl, table);
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(table.getLongName()));
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "RENAME");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "TO");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(table2.getName()));
        String string = stringBuffer2.toString();
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        CSSBRenameTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        this.appendAfterAlterScript(stringBuffer, bl, table);
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendDropConstraint(TableProxyOraclev10g tableProxyOraclev10g, StringBuffer stringBuffer, boolean bl) {
        Table table = (Table)tableProxyOraclev10g.getObject();
        for (TableLevelConstraint tableLevelConstraint : table.getCheckConstraints()) {
            this.appendDropObject(tableProxyOraclev10g, this.storageDesign.getFormatedName(tableLevelConstraint.getName()), stringBuffer, bl);
        }
    }

    private void appendDropIndex(TableProxyOraclev10g tableProxyOraclev10g, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = tableProxyOraclev10g.getIndexes().iterator();
        while (iterator.hasNext()) {
            IndexProxyOraclev10g indexProxyOraclev10g = (IndexProxyOraclev10g)iterator.next();
            CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "DROP");
            CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "INDEX");
            CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(indexProxyOraclev10g.getUserNameAndName()));
            String string = stringBuffer2.toString();
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            CSSBRenameTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            CDDLFileMaker.incrementDropIndex();
        }
    }

    private void appendDropUK(TableProxyOraclev10g tableProxyOraclev10g, StringBuffer stringBuffer, boolean bl) {
        Iterator iterator = tableProxyOraclev10g.getUniqueKeys().iterator();
        while (iterator.hasNext()) {
            UniqueOraclev10g uniqueOraclev10g = (UniqueOraclev10g)iterator.next();
            this.appendDropObject(tableProxyOraclev10g, this.storageDesign.getFormatedName(uniqueOraclev10g.getName()), stringBuffer, bl);
        }
    }

    private void appendDropPK(TableProxyOraclev10g tableProxyOraclev10g, StringBuffer stringBuffer, boolean bl) {
        if (!tableProxyOraclev10g.getPKName().equals("")) {
            this.appendDropObject(tableProxyOraclev10g, this.storageDesign.getFormatedName(tableProxyOraclev10g.getPKName()), stringBuffer, bl);
        }
    }

    private void appendDropObject(TableProxyOraclev10g tableProxyOraclev10g, String string, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBRenameTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendBeforeAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOraclev10g.getObject());
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxyOraclev10g.getLongName()));
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "DROP");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, string);
        String string2 = stringBuffer2.toString();
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "CASCADE");
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        this.appendAfterAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOraclev10g.getObject());
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendDropFK(TableProxyOraclev10g tableProxyOraclev10g, CompareObjectSelection compareObjectSelection, StringBuffer stringBuffer, boolean bl) {
        Iterator iterator = this.storageDesign.getFKProxySet().iterator();
        while (iterator.hasNext()) {
            FKProxyOraclev10g fKProxyOraclev10g = (FKProxyOraclev10g)iterator.next();
            FKIndexAssociation fKIndexAssociation = fKProxyOraclev10g.getIndex().getFKAssociation();
            if (this.fkList.get(fKIndexAssociation.getObjectID()) != null || this.fkList.get(fKProxyOraclev10g.getObjectID()) != null || fKProxyOraclev10g.getFKTable() != tableProxyOraclev10g.getObject() && fKProxyOraclev10g.getTable() != tableProxyOraclev10g.getObject()) continue;
            this.appendDropObject((TableProxyOraclev10g)fKProxyOraclev10g.getTableProxy(), this.storageDesign.getFormatedName(fKProxyOraclev10g.getName()), stringBuffer, bl);
            this.fkList.put(fKIndexAssociation.getObjectID(), tableProxyOraclev10g);
        }
    }

    private void appendDropTriggers(TableProxyOracle tableProxyOracle, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = tableProxyOracle.getTriggers().iterator();
        while (iterator.hasNext()) {
            TriggerOraclev10g triggerOraclev10g = (TriggerOraclev10g)iterator.next();
            CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "DROP");
            CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "TRIGGER");
            CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(triggerOraclev10g.getLongName()));
            String string = stringBuffer2.toString();
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            CSSBRenameTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
    }

    private void appendDropBitmapJoinIndexes(TableProxyOraclev10g tableProxyOraclev10g, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = tableProxyOraclev10g.getBjIndexes().iterator();
        while (iterator.hasNext()) {
            BitmapJoinIndexOraclev10g bitmapJoinIndexOraclev10g = (BitmapJoinIndexOraclev10g)iterator.next();
            CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "DROP");
            CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "INDEX");
            CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(bitmapJoinIndexOraclev10g.getLongName()));
            String string = stringBuffer2.toString();
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            CSSBRenameTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            CDDLFileMaker.incrementDropIndex();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof Table && (((CompareObjectSelection)object).canBeRename() || ((CompareObjectSelection)object).canBeRenameOnly());
    }

    private void appendDropTable(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBRenameTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "DROP");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxyOracle.getLongName()));
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        CSSBRenameTableOraclev10g.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        CDDLFileMaker.incrementDropTable();
    }

    public void addUnloadExecution(StringBuffer stringBuffer, TableSelection tableSelection, TableProxy tableProxy, String string) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = tableProxy.getName();
        this.appendUnloadHeader(stringBuffer, stringBuffer2, this.storageDesign.getFormatedName(string2), "");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("query:=   '");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  select ");
        this.addColumns(stringBuffer, tableProxy, tableSelection);
        stringBuffer.append(this.newline()).append(this.newTab());
        File file = new File(string, string2 + ".txt");
        stringBuffer.append("  from ").append(this.storageDesign.getFormatedName(tableProxy.getLongName()));
        stringBuffer.append(this.newline());
        stringBuffer.append("  ';");
        stringBuffer.append(this.newline());
        stringBuffer.append("    cwd_query_to_file( query ,'" + file.getAbsolutePath() + "'," + CDDLFileMaker.getReplaceOption() + ");");
        stringBuffer.append(this.newline());
        if (CDDLFileMaker.getddlAdvancedGenenerator() != null) {
            stringBuffer.append("   end if;");
            stringBuffer.append(this.newline());
        }
        stringBuffer.append("  end;");
        stringBuffer.append(this.newline());
        stringBuffer.append("/");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
    }

    private void addColumns(StringBuffer stringBuffer, TableProxy tableProxy, TableSelection tableSelection) {
        List list = tableSelection.getChildObjects(0);
        String string = "col";
        int n = 1;
        Design design = tableProxy.getDesign();
        if (list.size() > 0) {
            boolean bl = true;
            for (CompareObjectSelection compareObjectSelection : list) {
                CompareObjectSelection compareObjectSelection2;
                if (compareObjectSelection.canBeCreate() || compareObjectSelection.canBeDrop() && compareObjectSelection.isSelected() || this.isVirtualColumn(compareObjectSelection2 = compareObjectSelection.getCorrespondentNode())) continue;
                String string2 = this.storageDesign.getFormatedName(compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.NAME));
                String string3 = compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE);
                Column column = (Column)compareObjectSelection2.getObject();
                if (column != null) {
                    string3 = column.getDatatypeString(tableProxy.getStorageDesign().getRDBMSType().getName());
                }
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
                if (string3.startsWith("NUMBER") || string3.startsWith("DATE") || string3.startsWith("TIMESTAMP")) {
                    stringBuffer.append("to_char(" + CSSBRenameTableOraclev10g.getColumnPresentation(string2, string3, design) + ") ").append(string + n);
                } else {
                    stringBuffer.append(string2 + " ").append(string + n);
                }
                ++n;
            }
        }
    }

    public static String getColumnPresentation(String string, String string2, Design design) {
        String string3 = string2.toUpperCase();
        if (string3.indexOf("DATE") > -1) {
            return string + " , ''" + design.getEngDateFormat() + "''";
        }
        if (string3.indexOf("TIMESTAMP") > -1) {
            if (string3.indexOf("ZONE") == -1 || string3.indexOf("LOCAL") > -1) {
                return string + " , ''" + design.getEngTimestampFormat() + "''";
            }
            return string + " , ''" + design.getEngTimestampWTZFormat() + "''";
        }
        return string;
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public String newTab() {
        return "    ";
    }

    public void addUnloadPerPartitionExecution(StringBuffer stringBuffer, TableSelection tableSelection, TableProxy tableProxy, String string) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = tableProxy.getName();
        Iterator iterator = ((TableProxyOracle)tableProxy).getPartitions().iterator();
        while (iterator.hasNext()) {
            PartitionOracle partitionOracle = (PartitionOracle)iterator.next();
            this.appendUnloadHeader(stringBuffer, stringBuffer2, this.storageDesign.getFormatedName(string2), this.storageDesign.getFormatedName(partitionOracle.getName()));
            stringBuffer.append(this.newline()).append(this.newTab());
            stringBuffer.append("query:=   '");
            stringBuffer.append(this.newline()).append(this.newTab());
            stringBuffer.append("  select ");
            this.addColumns(stringBuffer, tableProxy, tableSelection);
            stringBuffer.append(this.newline()).append(this.newTab());
            File file = new File(string, string2 + "_" + partitionOracle.getName() + ".txt");
            stringBuffer.append("    from ").append(this.storageDesign.getFormatedName(tableProxy.getLongName())).append(' ');
            stringBuffer.append("PARTITION").append('(').append(this.storageDesign.getFormatedName(partitionOracle.getName())).append(')');
            stringBuffer.append(this.newline());
            stringBuffer.append("  ';");
            stringBuffer.append(this.newline());
            stringBuffer.append("    cwd_query_to_file( query  ,'" + file.getAbsolutePath() + "'," + CDDLFileMaker.getReplaceOption() + ");");
            stringBuffer.append(this.newline());
            if (CDDLFileMaker.getddlAdvancedGenenerator() != null) {
                stringBuffer.append("   end if;");
                stringBuffer.append(this.newline());
            }
            stringBuffer.append("  end;");
            stringBuffer.append(this.newline());
            stringBuffer.append("/");
            stringBuffer.append(this.newline());
            stringBuffer.append(this.newline());
        }
    }

    private void appendDropCoilumnConstraints(TableProxyOracle tableProxyOracle, StringBuffer stringBuffer, boolean bl) {
        ColumnProxy[] columnProxyArray = tableProxyOracle.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)columnProxyArray[i];
            Column column = columnProxyOracle.getColumn();
            String string = column.getConstraintName();
            if (string != null && !"".equals(string)) {
                this.appendDropConstraintsNoCascade(tableProxyOracle, string, stringBuffer, bl);
            }
            if (column.getNullsAllowed() || tableProxyOracle.getDesign().getAppView().getSettings().notNullShortFormGeneration()) continue;
            String string2 = string = columnProxyOracle.isNotNullConstraintNameChanged() ? columnProxyOracle.getNncName() : columnProxyOracle.getColumn().getNotNullConstraintName();
            if (string == null || "".equals(string)) continue;
            this.appendDropConstraintsNoCascade(tableProxyOracle, string, stringBuffer, bl);
        }
    }

    private void appendDropConstraintsNoCascade(TableProxyOracle tableProxyOracle, String string, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBRenameTableOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendBeforeAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOracle.getObject());
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxyOracle.getLongName()));
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "DROP");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
        CSSBRenameTableOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string));
        String string2 = stringBuffer2.toString();
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        this.appendAfterAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOracle.getObject());
        CDDLFileMaker.incrementAlterTable();
    }

    protected boolean isVirtualColumn(CompareObjectSelection compareObjectSelection) {
        return false;
    }
}

