/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBIndexOraclev10g
extends AbstractCSSBOracle {
    private DesignObject sType;
    protected StorageDesignOraclev10g storageDesign;
    private boolean isRenamed = false;
    private StringBuffer columnList = new StringBuffer();
    private String restoredExpression = null;
    private String tableName = "";

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index) {
            return true;
        }
        return object instanceof IndexProxy && !(object instanceof FKProxyOracle);
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Object object2;
        StringBuffer stringBuffer2 = new StringBuffer();
        Index index = null;
        IndexProxyOraclev10g indexProxyOraclev10g = null;
        if (object instanceof Index) {
            index = (Index)object;
            object2 = index.getDesign();
            RDBMSSite rDBMSSite = index.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)((Design)object2).getStorageDesign(rDBMSSite);
            indexProxyOraclev10g = (IndexProxyOraclev10g)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyOraclev10g) {
            indexProxyOraclev10g = (IndexProxyOraclev10g)object;
            index = (Index)indexProxyOraclev10g.getObject();
        }
        if (index != null && !index.isOidKey() && indexProxyOraclev10g != null && (index.shouldBeMerge() || this.isRenamed())) {
            if (indexProxyOraclev10g.isCommentChanged()) {
                this.appendComment(stringBuffer, indexProxyOraclev10g);
            } else {
                this.appendComment(stringBuffer, index);
            }
            this.storageDesign = (StorageDesignOraclev10g)indexProxyOraclev10g.getStorageDesign();
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, "CREATE");
            if (indexProxyOraclev10g.isUnique()) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, "UNIQUE");
            } else if (indexProxyOraclev10g.getBitmapIndex()) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, "BITMAP");
            }
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, "INDEX");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(indexProxyOraclev10g.getUserNameAndName()));
            object2 = stringBuffer2.toString();
            this.appendTable(stringBuffer2, indexProxyOraclev10g);
            if (this.restoredExpression != null || this.isNotEmpty(this.getRestoredColumns().toString())) {
                this.appendElementListRestored(stringBuffer2, index, indexProxyOraclev10g, true);
            } else {
                this.appendElementList(stringBuffer2, index, indexProxyOraclev10g, true);
            }
            if (!index.isSpatialIndex() && indexProxyOraclev10g.getIndexType().equals("")) {
                this.appendGlobalOrLocal(stringBuffer2, indexProxyOraclev10g, bl);
                this.appendIndexAttributes(stringBuffer2, indexProxyOraclev10g, bl);
            }
            this.appendToBuffer(stringBuffer, stringBuffer2, (String)object2);
            CSSBIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            CSSBIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, (String)object2);
            CDDLFileMaker.incrementCreateIndex();
        }
    }

    private void appendTable(StringBuffer stringBuffer, IndexProxyOraclev10g indexProxyOraclev10g) {
        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "ON");
        if (this.isNotEmpty(this.getTableName())) {
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.getTableName());
        } else {
            TableProxy tableProxy = indexProxyOraclev10g.getTableProxy();
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
        }
    }

    private void appendElementList(StringBuffer stringBuffer, Index index, IndexProxyOraclev10g indexProxyOraclev10g, boolean bl) {
        if (index.hasIndexExpression()) {
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBIndexOraclev10g.appendString(stringBuffer, index.getIndexExpression());
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        } else {
            ColumnProxy columnProxy = null;
            ColumnProxy[] columnProxyArray = indexProxyOraclev10g.getColumnProxies();
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            if (columnProxyArray.length < 1) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "-- No Columns");
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            }
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            for (int i = 0; i < columnProxyArray.length; ++i) {
                if (i != 0) {
                    CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
                }
                columnProxy = columnProxyArray[i];
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendString(stringBuffer, ' ');
                String string = this.storageDesign.getFormatedName(columnProxy.getName());
                if (index.isSpatialIndex()) {
                    Datatype datatype = columnProxy.getDataType();
                    if (this.sType == null) {
                        this.sType = columnProxy.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
                    }
                    if (datatype instanceof StructuredType) {
                        StructuredType structuredType = (StructuredType)datatype;
                        for (TypeElement typeElement : structuredType.getAllElements()) {
                            if (typeElement.getType() != this.sType) continue;
                            string = string.concat(".").concat(this.storageDesign.getFormatedName(typeElement.getName()));
                            break;
                        }
                    }
                }
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, string);
                if (index.isSpatialIndex() || !indexProxyOraclev10g.getIndexType().equals("")) continue;
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(columnProxy));
            }
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
        if (indexProxyOraclev10g != null) {
            if (index.isSpatialIndex()) {
                this.appendSpatialIndex(stringBuffer, index, indexProxyOraclev10g, bl);
            } else {
                this.appendDomainIndexProps(stringBuffer, index, indexProxyOraclev10g, bl);
            }
        }
    }

    private void appendDomainIndexProps(StringBuffer stringBuffer, Index index, IndexProxyOracle indexProxyOracle, boolean bl) {
        String string;
        if (!index.isSpatialIndex() && !(string = indexProxyOracle.getIndexType()).equals("")) {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "INDEXTYPE");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "IS");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            String string2 = indexProxyOracle.getIndexDomainParameters();
            if (!string2.equals("")) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARAMETERS");
                CSSBIndexOraclev10g.appendString(stringBuffer, '(');
                CSSBIndexOraclev10g.appendString(stringBuffer, '\'');
                CSSBIndexOraclev10g.appendString(stringBuffer, string2);
                CSSBIndexOraclev10g.appendString(stringBuffer, '\'');
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendSpatialIndex(StringBuffer stringBuffer, Index index, IndexProxyOraclev10g indexProxyOraclev10g, boolean bl) {
        if (index.isSpatialIndex()) {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "INDEXTYPE");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "IS");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "MDSYS.SPATIAL_INDEX");
            if (!index.getGeodetic().equals("YES") || index.getLayerType() != null && !index.getLayerType().equals("") || index.getDimensionsNumber() != 2 || indexProxyOraclev10g.getNonLeaf().equalsIgnoreCase("YES") || indexProxyOraclev10g.getTableSpace() != null || indexProxyOraclev10g.getBatchSize() != 1000 || indexProxyOraclev10g.getWorkTablespace() != null) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARAMETERS");
                CSSBIndexOraclev10g.appendString(stringBuffer, '(');
                CSSBIndexOraclev10g.appendString(stringBuffer, '\'');
                if (!index.getGeodetic().equals("YES")) {
                    CSSBIndexOraclev10g.appendString(stringBuffer, "geodetic");
                    CSSBIndexOraclev10g.appendString(stringBuffer, '=');
                    this.appendString(stringBuffer, Boolean.FALSE);
                }
                if (index.getLayerType() != null && !index.getLayerType().equals("")) {
                    CSSBIndexOraclev10g.appendSpace(stringBuffer);
                    CSSBIndexOraclev10g.appendString(stringBuffer, "layer_gtype");
                    CSSBIndexOraclev10g.appendString(stringBuffer, '=');
                    CSSBIndexOraclev10g.appendString(stringBuffer, index.getLayerType());
                }
                if (index.getDimensionsNumber() != 2) {
                    CSSBIndexOraclev10g.appendSpace(stringBuffer);
                    CSSBIndexOraclev10g.appendString(stringBuffer, "sdo_indx_dims");
                    CSSBIndexOraclev10g.appendString(stringBuffer, '=');
                    this.appendString(stringBuffer, index.getDimensionsNumber());
                }
                if (indexProxyOraclev10g.getBatchSize() != 1000) {
                    CSSBIndexOraclev10g.appendSpace(stringBuffer);
                    CSSBIndexOraclev10g.appendString(stringBuffer, "sdo_dml_batch_size=");
                    this.appendString(stringBuffer, indexProxyOraclev10g.getBatchSize());
                }
                if (indexProxyOraclev10g.getTableSpace() != null) {
                    CSSBIndexOraclev10g.appendSpace(stringBuffer);
                    CSSBIndexOraclev10g.appendString(stringBuffer, "tablespace=");
                    CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyOraclev10g.getTableSpace().getName()));
                }
                if (indexProxyOraclev10g.getWorkTablespace() != null) {
                    CSSBIndexOraclev10g.appendSpace(stringBuffer);
                    CSSBIndexOraclev10g.appendString(stringBuffer, "work_tablespace=");
                    CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyOraclev10g.getWorkTablespace().getName()));
                }
                if (indexProxyOraclev10g.getNonLeaf().equalsIgnoreCase("YES")) {
                    CSSBIndexOraclev10g.appendSpace(stringBuffer);
                    CSSBIndexOraclev10g.appendString(stringBuffer, "sdo_non_leaf_tbl=TRUE");
                }
                CSSBIndexOraclev10g.appendString(stringBuffer, '\'');
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
            this.appendSpatialIndexPartitions(stringBuffer, indexProxyOraclev10g, bl);
        }
    }

    private void appendSpatialIndexPartitions(StringBuffer stringBuffer, IndexProxyOraclev10g indexProxyOraclev10g, boolean bl) {
        if ("LOCAL".equalsIgnoreCase(indexProxyOraclev10g.getIndexPartitioned())) {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOCAL");
            TableProxyOraclev10g tableProxyOraclev10g = (TableProxyOraclev10g)indexProxyOraclev10g.getTableProxy();
            PartitionListOraclev10g partitionListOraclev10g = (PartitionListOraclev10g)tableProxyOraclev10g.getPartitionList();
            if (partitionListOraclev10g != null) {
                this.appendSpatialPartitions(stringBuffer, indexProxyOraclev10g, partitionListOraclev10g, bl);
            }
        }
    }

    private void appendSpatialPartitions(StringBuffer stringBuffer, IndexProxyOraclev10g indexProxyOraclev10g, PartitionListOraclev10g partitionListOraclev10g, boolean bl) {
        PartitionSetOraclev10g partitionSetOraclev10g = (PartitionSetOraclev10g)((StorageDesignOraclev10g)partitionListOraclev10g.getStorageDesign()).getPartitionSet();
        Object[] objectArray = partitionSetOraclev10g.toArray();
        Arrays.sort(objectArray, new PossitionComparator());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        Iterator iterator = arrayList.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            SegmentOraclev10g segmentOraclev10g;
            PartitionOraclev10g partitionOraclev10g = (PartitionOraclev10g)iterator.next();
            if (partitionOraclev10g.getPartitionList() == null || !partitionOraclev10g.getPartitionList().getObjectID().equalsIgnoreCase(partitionListOraclev10g.getObjectID())) continue;
            if (bl2) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                bl2 = false;
            } else {
                stringBuffer.append(',');
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex((IndexProxyOracle)indexProxyOraclev10g, partitionOraclev10g);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOraclev10g.getName()));
            }
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARAMETERS");
            CSSBIndexOraclev10g.appendString(stringBuffer, '(');
            CSSBIndexOraclev10g.appendString(stringBuffer, '\'');
            if (localIndexProperties.getTableSpace() != null) {
                CSSBIndexOraclev10g.appendString(stringBuffer, "tablespace=");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getTableSpace().getName()));
            }
            if ((segmentOraclev10g = (SegmentOraclev10g)localIndexProperties.getSegment()) != null) {
                CSSBIndexOraclev10g.appendSpace(stringBuffer);
                CSSBIndexOraclev10g.appendString(stringBuffer, "sdo_rdr_pctfree=");
                CSSBIndexOraclev10g.appendString(stringBuffer, String.valueOf(segmentOraclev10g.getPCTFree()).trim());
                if (segmentOraclev10g.getSCInitialExtent() > 0L) {
                    CSSBIndexOraclev10g.appendSpace(stringBuffer);
                    CSSBIndexOraclev10g.appendString(stringBuffer, "initial=");
                    CSSBIndexOraclev10g.appendString(stringBuffer, String.valueOf(segmentOraclev10g.getSCInitialExtent()).trim());
                }
                if (segmentOraclev10g.getSCNextExtent() > 0L) {
                    CSSBIndexOraclev10g.appendSpace(stringBuffer);
                    CSSBIndexOraclev10g.appendString(stringBuffer, "next=");
                    CSSBIndexOraclev10g.appendString(stringBuffer, String.valueOf(segmentOraclev10g.getSCNextExtent()).trim());
                }
                CSSBIndexOraclev10g.appendSpace(stringBuffer);
                CSSBIndexOraclev10g.appendString(stringBuffer, "pctincrease=");
                this.appendString(stringBuffer, segmentOraclev10g.getSCPctIncrease());
                CSSBIndexOraclev10g.appendSpace(stringBuffer);
                CSSBIndexOraclev10g.appendString(stringBuffer, "minextents=");
                this.appendString(stringBuffer, segmentOraclev10g.getSCMinExtents());
                CSSBIndexOraclev10g.appendSpace(stringBuffer);
                CSSBIndexOraclev10g.appendString(stringBuffer, "maxextents=");
                CSSBIndexOraclev10g.appendString(stringBuffer, segmentOraclev10g.getSCMaxExtents());
            }
            if (localIndexProperties.getWorkTablespace() != null) {
                CSSBIndexOraclev10g.appendSpace(stringBuffer);
                CSSBIndexOraclev10g.appendString(stringBuffer, "work_tablespace=");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getWorkTablespace().getName()));
            }
            if (localIndexProperties.getLayerType() != null && !localIndexProperties.getLayerType().equals("")) {
                CSSBIndexOraclev10g.appendSpace(stringBuffer);
                CSSBIndexOraclev10g.appendString(stringBuffer, "layer_gtype=");
                CSSBIndexOraclev10g.appendString(stringBuffer, localIndexProperties.getLayerType());
            }
            if (indexProxyOraclev10g.getNonLeaf().equalsIgnoreCase("YES")) {
                CSSBIndexOraclev10g.appendSpace(stringBuffer);
                CSSBIndexOraclev10g.appendString(stringBuffer, "sdo_non_leaf_tbl=TRUE");
            }
            CSSBIndexOraclev10g.appendString(stringBuffer, '\'');
            CSSBIndexOraclev10g.appendString(stringBuffer, ')');
        }
        if (!bl2) {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendString(stringBuffer, ')');
        }
    }

    private void appendGlobalOrLocal(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, boolean bl) {
        String string = indexProxyOracle.getIndexPartitioned();
        if ("LOCAL".equalsIgnoreCase(string)) {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOCAL");
            this.appendPartitionList(stringBuffer, indexProxyOracle, (TableProxyOraclev10g)indexProxyOracle.getTableProxy(), bl);
        } else {
            IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g = (IndexGlobalPartitionsListOraclev10g)indexProxyOracle.getIndexGlobalPartitionsList();
            if (indexGlobalPartitionsListOraclev10g != null) {
                String string2 = "";
                if ("GLOBAL BY RANGE".equalsIgnoreCase(string)) {
                    string2 = "RANGE";
                } else if ("GLOBAL HASH PARTITIONED BY QUANTITY".equalsIgnoreCase(string) || "GLOBAL HASH PARTITIONED BY LIST".equalsIgnoreCase(string)) {
                    string2 = "HASH";
                } else {
                    return;
                }
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, string2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllGlobalPartColumns()));
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
                if ("GLOBAL BY RANGE".equalsIgnoreCase(string)) {
                    this.appendGlobalRangePartitions(stringBuffer, indexProxyOracle, bl);
                } else if ("GLOBAL HASH PARTITIONED BY QUANTITY".equalsIgnoreCase(string)) {
                    CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                    CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITIONS");
                    this.appendStringWithSpace(stringBuffer, indexGlobalPartitionsListOraclev10g.getHashPQuantity());
                    if (!"".equals(indexGlobalPartitionsListOraclev10g.getHashPTableSpaces())) {
                        CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllHashPTS()));
                        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
                    }
                    if (!"".equals(indexGlobalPartitionsListOraclev10g.getIOTOverflowHashPTS())) {
                        CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllIOTOverflowHashPTS()));
                        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
                    }
                } else if ("GLOBAL HASH PARTITIONED BY LIST".equalsIgnoreCase(string)) {
                    this.appendGlobalHashPartitions(stringBuffer, indexProxyOracle, bl);
                }
            }
        }
    }

    protected void appendGlobalRangePartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, boolean bl) {
        Iterator iterator = indexProxyOracle.getGlobalPartitions().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            IndexGlobalPartitionOraclev10g indexGlobalPartitionOraclev10g = (IndexGlobalPartitionOraclev10g)iterator.next();
            if (bl2) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                stringBuffer.append(',');
            }
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev10g.getName()));
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, indexGlobalPartitionOraclev10g.getValueList());
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            if (indexGlobalPartitionOraclev10g.getTableSpace() != null) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev10g.getTableSpace().getName()));
            }
            this.appendSegment(stringBuffer, (SegmentOraclev10g)indexGlobalPartitionOraclev10g.getSegment(), bl, 2);
            if (!this.storageDesign.isOpen()) continue;
            if ("YES".equalsIgnoreCase(indexGlobalPartitionOraclev10g.getLogging())) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(indexGlobalPartitionOraclev10g.getLogging())) continue;
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
        }
        if (!bl2) {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendGlobalHashPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, boolean bl) {
        Iterator iterator = indexProxyOracle.getGlobalPartitions().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)iterator.next();
            if (bl2) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                stringBuffer.append(',');
            }
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexHashPartitionOraclev10g.getName()));
            if (indexHashPartitionOraclev10g.getTableSpace() != null) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexHashPartitionOraclev10g.getTableSpace().getName()));
            }
            if (indexHashPartitionOraclev10g.getOverflowTableSpace() != null) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexHashPartitionOraclev10g.getOverflowTableSpace().getName()));
            }
            this.appendHashPLobItems(stringBuffer, indexHashPartitionOraclev10g, bl);
        }
        if (!bl2) {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendHashPLobItems(StringBuffer stringBuffer, IndexHashPartitionOraclev10g indexHashPartitionOraclev10g, boolean bl) {
        IndexHashPartitionLobItemSetOraclev10g indexHashPartitionLobItemSetOraclev10g = (IndexHashPartitionLobItemSetOraclev10g)((StorageDesignOraclev10g)indexHashPartitionOraclev10g.getStorageDesign()).getIndexHashPartitionLobItemSet();
        Iterator iterator = indexHashPartitionLobItemSetOraclev10g.iterator();
        while (iterator.hasNext()) {
            IndexHashPartitionLobItemOraclev10g indexHashPartitionLobItemOraclev10g = (IndexHashPartitionLobItemOraclev10g)iterator.next();
            if (indexHashPartitionLobItemOraclev10g.getIndexHashPartition() == null || !indexHashPartitionLobItemOraclev10g.getIndexHashPartition().getObjectID().equalsIgnoreCase(indexHashPartitionOraclev10g.getObjectID())) continue;
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            this.appendLobPartitioningStorage(stringBuffer, indexHashPartitionLobItemOraclev10g.getName(), indexHashPartitionLobItemOraclev10g.getLobColumn(), "", indexHashPartitionLobItemOraclev10g.getTableSpace(), bl);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer stringBuffer, String string, Object object, String string2, TableSpaceOracle tableSpaceOracle, boolean bl) {
        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOB");
        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
        String string3 = "";
        if (object != null) {
            string3 = object.toString();
        }
        if (string3.length() > 0) {
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string3));
        } else {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("--  ERROR: Lob ");
            stringBuffer.append(string);
            stringBuffer.append(" has no Column specified");
            CDDLFileMaker.incrementErrors();
        }
        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE AS");
        if (!string2.equalsIgnoreCase("")) {
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
        } else if (tableSpaceOracle == null) {
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
        }
        if (tableSpaceOracle != null) {
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendSegment(StringBuffer stringBuffer, SegmentOraclev10g segmentOraclev10g, boolean bl, int n) {
        if (segmentOraclev10g != null) {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getPCTFree());
            if (segmentOraclev10g.getInitrans() > 2) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getInitrans());
            }
            if (segmentOraclev10g.getMaxTrans() > 2) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "MAXTRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getMaxTrans());
            }
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORAGE");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            if (segmentOraclev10g.getSCInitialExtent() > 0L) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCInitialExtent());
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            }
            if (segmentOraclev10g.getSCNextExtent() > 0L) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCNextExtent());
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            }
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCPctIncrease());
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCMinExtents());
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCMaxExtents());
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCFreeLists());
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "FREELIST");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCFreelistGroups());
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCBufferPool());
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendIndexAttributes(StringBuffer stringBuffer, IndexProxyOraclev10g indexProxyOraclev10g, boolean bl) {
        TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOraclev10g.getTableProxy();
        boolean bl2 = tableProxyOracle.getTemporary().equalsIgnoreCase("YES");
        if (!bl2) {
            if (indexProxyOraclev10g.getTableSpace() != null) {
                stringBuffer.append(NEWLINE).append("    ");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyOraclev10g.getTableSpace().getName()));
            }
            this.appendSegment(stringBuffer, (SegmentOraclev10g)indexProxyOraclev10g.getSegment(), bl, 1);
            if ("YES".equalsIgnoreCase(indexProxyOraclev10g.getLogging())) {
                stringBuffer.append(NEWLINE).append("    ");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(indexProxyOraclev10g.getLogging())) {
                stringBuffer.append(NEWLINE).append("    ");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
            }
        }
        if ("YES".equalsIgnoreCase(indexProxyOraclev10g.getOnline())) {
            stringBuffer.append(NEWLINE).append("    ");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "ONLINE");
        }
        if ("YES".equalsIgnoreCase(indexProxyOraclev10g.getComputeStatistics())) {
            stringBuffer.append(NEWLINE).append("    ");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
        }
        if (indexProxyOraclev10g.getCompress() > 0) {
            stringBuffer.append(NEWLINE).append("    ");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
            this.appendStringWithSpace(stringBuffer, indexProxyOraclev10g.getCompress());
        }
        if (!indexProxyOraclev10g.getBitmapIndex() && !indexProxyOraclev10g.isPartitioned()) {
            if ("NO".equalsIgnoreCase(indexProxyOraclev10g.getSortedRows())) {
                stringBuffer.append(NEWLINE).append("    ");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOSORT");
            } else if ("REVERSE".equalsIgnoreCase(indexProxyOraclev10g.getSortedRows())) {
                stringBuffer.append(NEWLINE).append("    ");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "REVERSE");
            }
        }
        if (!bl2 && "YES".equalsIgnoreCase(indexProxyOraclev10g.getParallel())) {
            stringBuffer.append(NEWLINE).append("    ");
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARALLEL");
            if (!"".equalsIgnoreCase(indexProxyOraclev10g.getDegree())) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, indexProxyOraclev10g.getDegree());
            }
        }
    }

    protected void appendPartitionList(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, TableProxyOracle tableProxyOracle, boolean bl) {
        PartitionListOraclev10g partitionListOraclev10g = (PartitionListOraclev10g)tableProxyOracle.getPartitionList();
        if (partitionListOraclev10g != null) {
            boolean bl2;
            String string;
            String string2 = partitionListOraclev10g.getPartitionType();
            String string3 = partitionListOraclev10g.getSubpartitionType();
            if (string3.equalsIgnoreCase("HASH") && !"".equals((string = indexProxyOracle.getAllHashSubPartitionsTableSpaces()).trim())) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(string));
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
            boolean bl3 = bl2 = !string3.equals("");
            if ("RANGE".equalsIgnoreCase(string2) || "COMPOSITE BY HASH".equalsIgnoreCase(string2) || "COMPOSITE BY LIST".equalsIgnoreCase(string2)) {
                this.appendPartitions(stringBuffer, indexProxyOracle, partitionListOraclev10g, bl2, bl);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(string2) || "HASH BY LIST OF PARTITIONS".equalsIgnoreCase(string2)) {
                this.appendHashPartitions(stringBuffer, partitionListOraclev10g, indexProxyOracle, bl);
            } else if ("LIST".equalsIgnoreCase(string2)) {
                this.appendListPartitions(stringBuffer, partitionListOraclev10g, indexProxyOracle, bl);
            }
        }
    }

    private void appendListPartitions(StringBuffer stringBuffer, PartitionListOraclev10g partitionListOraclev10g, IndexProxyOracle indexProxyOracle, boolean bl) {
        TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOracle.getTableProxy();
        StorageObjectCollection storageObjectCollection = tableProxyOracle.getPartitions();
        Iterator iterator = storageObjectCollection.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            ListPartitionOraclev10g listPartitionOraclev10g = (ListPartitionOraclev10g)iterator.next();
            if (bl2) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
            }
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex(indexProxyOracle, listPartitionOraclev10g);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev10g.getName()));
            }
            if (localIndexProperties == null) continue;
            TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)localIndexProperties.getTableSpace();
            String string = localIndexProperties.getLogging();
            SegmentOraclev10g segmentOraclev10g = (SegmentOraclev10g)localIndexProperties.getSegment();
            if (segmentOraclev10g != null) {
                this.appendSegment(stringBuffer, segmentOraclev10g, bl, 2);
            }
            if (tableSpaceOraclev10g != null) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOraclev10g.getName()));
            } else if (segmentOraclev10g != null && segmentOraclev10g.getTableSpace() != null) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(segmentOraclev10g.getTableSpace().getName()));
            }
            if ("YES".equalsIgnoreCase(string)) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(string)) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
            }
            if (localIndexProperties.getKeyCompression() > 0) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
                this.appendStringWithSpace(stringBuffer, localIndexProperties.getKeyCompression());
            }
            if (partitionListOraclev10g.getSubpartitionType().equals("")) continue;
            String string2 = this.recreateIndexHashPTSSet(localIndexProperties.getHashSubPartitionsTableSpaces());
            this.appendIndexSubPartitions(stringBuffer, indexProxyOracle, partitionListOraclev10g, listPartitionOraclev10g, string2, bl);
        }
        if (!bl2) {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendHashPartitions(StringBuffer stringBuffer, PartitionListOraclev10g partitionListOraclev10g, IndexProxyOracle indexProxyOracle, boolean bl) {
        if (partitionListOraclev10g.getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOracle.getTableProxy();
            StorageObjectCollection storageObjectCollection = tableProxyOracle.getPartitions();
            Iterator iterator = storageObjectCollection.iterator();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)iterator.next();
                if (bl2) {
                    CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    bl2 = false;
                } else {
                    CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
                }
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                LocalIndexProperties localIndexProperties = this.getPropsForIndex(indexProxyOracle, hashPartitionOraclev10g);
                if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                    CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
                } else {
                    CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev10g.getName()));
                }
                if (localIndexProperties == null) continue;
                TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)localIndexProperties.getTableSpace();
                if (tableSpaceOraclev10g != null) {
                    CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                    CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOraclev10g.getName()));
                }
                if (localIndexProperties.getKeyCompression() <= 0 || !(this.storageDesign instanceof StorageDesignOraclev11g)) continue;
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
                this.appendStringWithSpace(stringBuffer, localIndexProperties.getKeyCompression());
            }
            if (!bl2) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        } else {
            String string = indexProxyOracle.getAllHashSubPartitionsTableSpaces();
            if (!"".equals(string.trim())) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(string));
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, PartitionListOraclev10g partitionListOraclev10g, boolean bl, boolean bl2) {
        TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOracle.getTableProxy();
        StorageObjectCollection storageObjectCollection = tableProxyOracle.getPartitions();
        Iterator iterator = storageObjectCollection.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            PartitionOraclev10g partitionOraclev10g = (PartitionOraclev10g)iterator.next();
            if (bl3) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl3 = false;
            } else {
                stringBuffer.append(',');
            }
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex(indexProxyOracle, partitionOraclev10g);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOraclev10g.getName()));
            }
            if (localIndexProperties == null) continue;
            TableSpaceOracle tableSpaceOracle = localIndexProperties.getTableSpace();
            String string = localIndexProperties.getLogging();
            SegmentOraclev10g segmentOraclev10g = (SegmentOraclev10g)localIndexProperties.getSegment();
            if (segmentOraclev10g != null) {
                this.appendSegment(stringBuffer, segmentOraclev10g, bl2, 2);
            }
            if (tableSpaceOracle != null) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            } else if (segmentOraclev10g != null && segmentOraclev10g.getTableSpace() != null) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(segmentOraclev10g.getTableSpace().getName()));
            }
            if ("YES".equalsIgnoreCase(string)) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(string)) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
            }
            if (localIndexProperties.getKeyCompression() > 0) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
                this.appendStringWithSpace(stringBuffer, localIndexProperties.getKeyCompression());
            }
            if (!bl) continue;
            String string2 = this.recreateIndexHashPTSSet(localIndexProperties.getHashSubPartitionsTableSpaces());
            this.appendIndexSubPartitions(stringBuffer, indexProxyOracle, partitionListOraclev10g, partitionOraclev10g, string2, bl2);
        }
        if (!bl3) {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxyOracle, PartitionOracle partitionOracle) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partitionOracle, indexProxyOracle);
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxyOracle, HashPartitionOraclev10g hashPartitionOraclev10g) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(hashPartitionOraclev10g, indexProxyOracle);
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxyOracle, ListPartitionOraclev10g listPartitionOraclev10g) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(listPartitionOraclev10g, indexProxyOracle);
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxyOracle, ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(listStorageTemplatePartitionOraclev10g, indexProxyOracle);
    }

    public static String getFirstToken(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = " ";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
        }
        return string2.trim();
    }

    protected String recreateIndexHashPTSSet(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getById(string2);
            if (tableSpaceOracle == null) continue;
            if (!bl) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
            } else {
                bl = false;
            }
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
        return stringBuffer.toString();
    }

    protected void appendIndexSubPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, PartitionListOraclev10g partitionListOraclev10g, AbstractStorageObjectOracle abstractStorageObjectOracle, String string, boolean bl) {
        String string2 = partitionListOraclev10g.getSubpartitionType();
        if (string2.equalsIgnoreCase("HASH")) {
            PartitionOraclev10g partitionOraclev10g;
            if (abstractStorageObjectOracle instanceof PartitionOraclev10g && !this.appendHashSubPartitions(stringBuffer, indexProxyOracle, (partitionOraclev10g = (PartitionOraclev10g)abstractStorageObjectOracle).getPartitions(), bl) && !"".equalsIgnoreCase(string.trim())) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(string));
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        } else if (string2.equalsIgnoreCase("LIST") && abstractStorageObjectOracle instanceof PartitionOraclev10g) {
            this.appendListSubPartitions(stringBuffer, indexProxyOracle, ((PartitionOraclev10g)abstractStorageObjectOracle).getListPartitions(), bl);
        }
    }

    protected void appendListSubPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, StorageObjectCollection storageObjectCollection, boolean bl) {
        boolean bl2 = true;
        Iterator iterator = storageObjectCollection.iterator();
        while (iterator.hasNext()) {
            ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g = (ListStorageTemplatePartitionOraclev10g)iterator.next();
            if (bl2) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
            }
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex(indexProxyOracle, listStorageTemplatePartitionOraclev10g);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev10g.getName()));
            }
            if (localIndexProperties == null) continue;
            TableSpaceOracle tableSpaceOracle = localIndexProperties.getTableSpace();
            if (tableSpaceOracle != null) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 3);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            }
            if (localIndexProperties.getKeyCompression() <= 0 || !(this.storageDesign instanceof StorageDesignOraclev11g)) continue;
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 3);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
            this.appendStringWithSpace(stringBuffer, localIndexProperties.getKeyCompression());
        }
        if (!bl2) {
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected boolean appendHashSubPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, StorageObjectCollection storageObjectCollection, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = storageObjectCollection.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)iterator.next();
            if (bl3) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl3 = false;
                bl2 = true;
            } else {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
            }
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex(indexProxyOracle, hashPartitionOraclev10g);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev10g.getName()));
            }
            if (localIndexProperties == null) continue;
            TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)localIndexProperties.getTableSpace();
            if (tableSpaceOraclev10g != null) {
                CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 3);
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOraclev10g.getName()));
            }
            if (localIndexProperties.getKeyCompression() <= 0 || !(this.storageDesign instanceof StorageDesignOraclev11g)) continue;
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 3);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
            this.appendStringWithSpace(stringBuffer, localIndexProperties.getKeyCompression());
        }
        if (!bl3) {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            stringBuffer.append(')');
        }
        return bl2;
    }

    private void appendElementListRestored(StringBuffer stringBuffer, Index index, IndexProxyOraclev10g indexProxyOraclev10g, boolean bl) {
        if (this.restoredExpression != null && !this.restoredExpression.trim().equals("")) {
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBIndexOraclev10g.appendString(stringBuffer, this.restoredExpression);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        } else {
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendString(stringBuffer, ' ');
            this.appendString(stringBuffer, this.getRestoredColumns());
            CSSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            if (indexProxyOraclev10g != null) {
                if (index.isSpatialIndex()) {
                    this.appendSpatialIndex(stringBuffer, index, indexProxyOraclev10g, bl);
                } else {
                    this.appendDomainIndexProps(stringBuffer, index, indexProxyOraclev10g, bl);
                }
            }
        }
        this.getRestoredColumns().setLength(0);
        this.restoredExpression = null;
    }

    public void setRenamed(boolean bl) {
        this.isRenamed = bl;
    }

    public boolean isRenamed() {
        return this.isRenamed;
    }

    public void setRestoredExpression(String string) {
        this.restoredExpression = string;
    }

    public void setRestoredColumns(StringBuffer stringBuffer) {
        this.columnList = stringBuffer;
    }

    public StringBuffer getRestoredColumns() {
        return this.columnList;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setStorageDesign(StorageDesignOraclev10g storageDesignOraclev10g) {
        this.storageDesign = storageDesignOraclev10g;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof PartitionOraclev10g && object2 instanceof PartitionOraclev10g) {
                if (((PartitionOraclev10g)object).getPosition() > ((PartitionOraclev10g)object2).getPosition()) {
                    return 1;
                }
                if (((PartitionOraclev10g)object).getPosition() < ((PartitionOraclev10g)object2).getPosition()) {
                    return -1;
                }
            } else if (object instanceof ListPartitionOraclev10g && object2 instanceof ListPartitionOraclev10g) {
                if (((ListPartitionOraclev10g)object).getPosition() > ((ListPartitionOraclev10g)object2).getPosition()) {
                    return 1;
                }
                if (((ListPartitionOraclev10g)object).getPosition() < ((ListPartitionOraclev10g)object2).getPosition()) {
                    return -1;
                }
            } else {
                return 0;
            }
            return 0;
        }
    }
}

