/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBIndexOraclev10g;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBAlterIndexOraclev10g
extends AbstractCSSBOracle {
    CSSBDropIndex dropIndex;
    private CSSBIndexOraclev10g cssbIndex = null;
    Map fkMap;
    private PKProxyOraclev10g pk = null;
    protected StorageDesignOraclev10g storageDesign;
    private CompareObjectSelection tableObj;

    public CSSBAlterIndexOraclev10g(Map map) {
        this.fkMap = map;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        CompareObjectSelection compareObjectSelection = (CompareObjectSelection)object;
        this.tableObj = (CompareObjectSelection)((CompareObjectSelection)compareObjectSelection.getParent()).getParent();
        Table table = (Table)this.tableObj.getObject();
        Design design = table.getDesign();
        RDBMSSite rDBMSSite = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(rDBMSSite, table);
        if (!compareObjectSelection.canBeCreate()) {
            boolean bl2 = false;
            String string = null;
            String string2 = null;
            for (Object object2 : compareObjectSelection.getPropertiesComparator().getPropertiesList()) {
                if (!((EngPropertyHolder)object2).isSelected()) continue;
                String string3 = ((EngPropertyHolder)object2).getName();
                if (string3.equals(PropertiesComparator.NAME)) {
                    string = ((EngPropertyHolder)object2).getLeftValue();
                    string2 = ((EngPropertyHolder)object2).getRightValue();
                    continue;
                }
                if (!string3.equals(PropertiesComparator.COLUMNS) && !string3.equals(PropertiesComparator.INDEX_FUNCTION_EXPRESSION) && !string3.equals(PropertiesComparator.INDEX_STATUS)) continue;
                bl2 = true;
            }
            if (bl2) {
                this.dropIndex = new CSSBDropIndex(this.fkMap);
                this.dropIndex.doAppend(stringBuffer, object, bl);
            } else {
                if (string != null) {
                    Object object2;
                    object2 = (Index)compareObjectSelection.getCorrespondentNode().getObject();
                    if (((KeyObject)object2).isPK() || ((KeyObject)object2).isUnique()) {
                        this.renameConstraint(stringBuffer, string2, string, bl);
                    } else {
                        this.renameIndex(stringBuffer, (Index)object2, string, bl);
                    }
                }
                return;
            }
        }
        this.appendAddIndex(stringBuffer, compareObjectSelection, bl);
    }

    private void renameIndex(StringBuffer stringBuffer, Index index, String string, boolean bl) {
        RDBMSSite rDBMSSite;
        Table table = index.getTable();
        Design design = table.getDesign();
        StorageDesign storageDesign = design.getStorageDesign(rDBMSSite = table.getSelectedRDBMSSite(), table);
        IndexProxyOracle indexProxyOracle = (IndexProxyOracle)storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        if (indexProxyOracle != null) {
            StringBuffer stringBuffer2 = new StringBuffer();
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "INDEX");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(indexProxyOracle.getUserNameAndName()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "RENAME");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "TO");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string));
            String string2 = stringBuffer2.toString();
            this.appendToBuffer(stringBuffer, stringBuffer2, string2);
            this.appendLineFinisher(stringBuffer2, bl);
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string2);
            CDDLFileMaker.incrementAlterIndex();
        }
    }

    private void renameConstraint(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.getTableName(this.tableObj));
        String string3 = this.storageDesign.getFormatedName(string);
        String string4 = stringBuffer2.toString() + "RENAME" + ' ' + "CONSTRAINT" + ' ' + string3;
        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "RENAME");
        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, string3);
        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "TO");
        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string2));
        this.appendToBuffer(stringBuffer, stringBuffer2, string4);
        this.appendLineFinisher(stringBuffer2, bl);
        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, string4);
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendAddIndex(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, boolean bl) {
        Table table = (Table)this.tableObj.getObject();
        TableProxyOraclev10g tableProxyOraclev10g = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxyOraclev10g != null) {
            this.appendIndexDefinition(stringBuffer, compareObjectSelection, bl);
            this.appendPKDefinition(stringBuffer, tableProxyOraclev10g, compareObjectSelection, bl);
            this.appendUniqueDefinition(stringBuffer, tableProxyOraclev10g, compareObjectSelection, bl);
        }
    }

    private void appendIndexDefinition(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, boolean bl) {
        CSSBIndexOraclev10g cSSBIndexOraclev10g = this.getCSSBIndex();
        if (cSSBIndexOraclev10g.canHandle(compareObjectSelection.getObject())) {
            StringBuffer stringBuffer2 = this.getColumnsForRestore(compareObjectSelection, bl, true);
            cSSBIndexOraclev10g.setRestoredColumns(stringBuffer2);
            cSSBIndexOraclev10g.setRestoredExpression(compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.INDEX_FUNCTION_EXPRESSION));
            cSSBIndexOraclev10g.setTableName(this.getTableName(this.tableObj));
            cSSBIndexOraclev10g.doAppend(stringBuffer, compareObjectSelection.getObject(), bl);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Index;
    }

    private void appendPKDefinition(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, CompareObjectSelection compareObjectSelection, boolean bl) {
        if (tableProxyOraclev10g != null) {
            Index index = (Index)compareObjectSelection.getObject();
            this.pk = (PKProxyOraclev10g)this.storageDesign.getPKProxySet().getProxy(index.getObjectID());
            if (this.pk != null && index.shouldBeMerge()) {
                if (!"".equalsIgnoreCase(this.pk.getColumns())) {
                    StringBuffer stringBuffer2 = this.getColumnsForRestore(compareObjectSelection, bl, false);
                    if (this.isNotEmpty(stringBuffer2.toString())) {
                        StringBuffer stringBuffer3 = new StringBuffer();
                        String string = "";
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, "ALTER");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, "TABLE");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, this.getTableName(this.tableObj));
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, "ADD");
                        string = stringBuffer3.toString() + "CONSTRAINT" + ' ' + this.storageDesign.getFormatedName(this.pk.getName());
                        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer3, bl, 1);
                        if (this.pk.isCommentChanged() && !"".equalsIgnoreCase(this.pk.getComment())) {
                            this.appendComment(stringBuffer3, this.pk);
                        } else if (!"".equalsIgnoreCase(this.pk.getObject().getComment())) {
                            this.appendComment(stringBuffer3, this.pk.getObject());
                        }
                        CSSBAlterIndexOraclev10g.appendString(stringBuffer3, ' ');
                        String string2 = this.storageDesign.getFormatedName(this.pk.getName());
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, "CONSTRAINT");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, string2);
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, "PRIMARY KEY");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, '(');
                        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer3, bl, 1);
                        this.appendStringWithSpace(stringBuffer3, stringBuffer2);
                        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer3, bl, 1);
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, ')');
                        if (!"NO".equalsIgnoreCase(this.pk.getDeferrable())) {
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, "DEFERRABLE");
                            if ("DEFERRED".equalsIgnoreCase(this.pk.getInitially())) {
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, "INITIALLY");
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, "DEFERRED");
                            }
                        }
                        if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, "DISABLE");
                            if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, "VALIDATE");
                            }
                        }
                        if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer3, "NOVALIDATE");
                        }
                        if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                            this.appendUsingIndex(stringBuffer3, this.pk, tableProxyOraclev10g, bl);
                        }
                        this.appendToBuffer(stringBuffer, stringBuffer3, string);
                        this.appendLineFinisher(stringBuffer3, bl);
                        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer3, bl, 0);
                        this.appendToBuffer(stringBuffer, stringBuffer3, string);
                        CDDLFileMaker.incrementAlterTable();
                    }
                } else {
                    this.appendError(stringBuffer, bl, "Index " + this.pk.getLongName() + " without columns");
                }
            }
        }
    }

    private void appendUsingIndex(StringBuffer stringBuffer, PKProxyOraclev10g pKProxyOraclev10g, TableProxyOracle tableProxyOracle, boolean bl) {
        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(pKProxyOraclev10g.getUsingIndex()) && pKProxyOraclev10g.getExistingIndex() != null) {
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxyOraclev10g.getExistingIndex().getUserNameAndName()));
        } else {
            if ("LOCAL".equalsIgnoreCase(pKProxyOraclev10g.getUsingIndex())) {
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOCAL");
                this.getCSSBIndex().appendPartitionList(stringBuffer, pKProxyOraclev10g, tableProxyOracle, bl);
            } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pKProxyOraclev10g.getUsingIndex())) {
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, pKProxyOraclev10g.getCreateIndexStatement());
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            } else if (pKProxyOraclev10g.getUsingIndex().equalsIgnoreCase("GLOBAL BY RANGE")) {
                this.appendGlobalIndex(stringBuffer, pKProxyOraclev10g, bl);
            } else if (pKProxyOraclev10g.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                this.appendGlobalIndexByHashQuantity(stringBuffer, pKProxyOraclev10g, bl);
            } else if (pKProxyOraclev10g.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY LIST")) {
                this.appendGlobalIndexByHashList(stringBuffer, pKProxyOraclev10g, bl);
            }
            if (pKProxyOraclev10g.getIndexSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev10g)pKProxyOraclev10g.getIndexSegment(), false, bl, pKProxyOraclev10g.getTableSpace(), pKProxyOraclev10g.getLogging());
            } else {
                if (pKProxyOraclev10g.getTableSpace() != null) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxyOraclev10g.getTableSpace().getName()));
                    CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                }
                if (this.storageDesign.isOpen()) {
                    if ("YES".equalsIgnoreCase(pKProxyOraclev10g.getLogging())) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    } else if ("NO".equalsIgnoreCase(pKProxyOraclev10g.getLogging())) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (pKProxyOraclev10g.getIndexSort().equalsIgnoreCase("NO")) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOSORT");
                    CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                } else if (pKProxyOraclev10g.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    stringBuffer.append("REVERSE");
                    CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                }
                if (pKProxyOraclev10g.getComputeStatistics().equalsIgnoreCase("YES")) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
                }
            }
        }
    }

    private void appendGlobalIndex(StringBuffer stringBuffer, PKProxyOraclev10g pKProxyOraclev10g, boolean bl) {
        if (pKProxyOraclev10g.getIndexGlobalPL() != null) {
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "RANGE");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(pKProxyOraclev10g.getIndexGlobalPL().getAllGlobalPartColumns()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            this.appendGlobalPartitions(stringBuffer, pKProxyOraclev10g, bl);
        }
    }

    private void appendGlobalIndexByHashQuantity(StringBuffer stringBuffer, PKProxyOraclev10g pKProxyOraclev10g, boolean bl) {
        if (pKProxyOraclev10g.getIndexGlobalPL() != null) {
            IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g = (IndexGlobalPartitionsListOraclev10g)pKProxyOraclev10g.getIndexGlobalPL();
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllGlobalPartColumns()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITIONS");
            this.appendStringWithSpace(stringBuffer, indexGlobalPartitionsListOraclev10g.getHashPQuantity());
            if (!"".equals(indexGlobalPartitionsListOraclev10g.getHashPTableSpaces())) {
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllHashPTS()));
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
            if (!"".equals(indexGlobalPartitionsListOraclev10g.getIOTOverflowHashPTS())) {
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllIOTOverflowHashPTS()));
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendGlobalIndexByHashList(StringBuffer stringBuffer, PKProxyOraclev10g pKProxyOraclev10g, boolean bl) {
        if (pKProxyOraclev10g.getIndexGlobalPL() != null) {
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(pKProxyOraclev10g.getIndexGlobalPL().getAllGlobalPartColumns()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            this.appendHashPartitions(stringBuffer, pKProxyOraclev10g, bl);
        }
    }

    private void appendHashPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, boolean bl) {
        this.getCSSBIndex().appendGlobalHashPartitions(stringBuffer, indexProxyOracle, bl);
    }

    private void appendGlobalPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, boolean bl) {
        this.getCSSBIndex().appendGlobalRangePartitions(stringBuffer, indexProxyOracle, bl);
    }

    private void appendSegment(StringBuffer stringBuffer, SegmentOraclev10g segmentOraclev10g, boolean bl, boolean bl2, TableSpaceOracle tableSpaceOracle, String string) {
        if (segmentOraclev10g != null) {
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getPCTFree());
            if (bl) {
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PCTUSED");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getPCTUsed());
            }
            if (segmentOraclev10g.getInitrans() > 1) {
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getInitrans());
            }
            if (segmentOraclev10g.getMaxTrans() > 1) {
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "MAXTRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getMaxTrans());
            }
            if (tableSpaceOracle != null) {
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            } else if (segmentOraclev10g.getTableSpace() != null) {
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(segmentOraclev10g.getTableSpace().getName()));
            }
            if (!"".equals(string)) {
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                if (string.equalsIgnoreCase("NO")) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                } else {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                }
            }
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORAGE");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            if (segmentOraclev10g.getSCInitialExtent() > 0L) {
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCInitialExtent());
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            }
            if (segmentOraclev10g.getSCNextExtent() > 0L) {
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCNextExtent());
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            }
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCPctIncrease());
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCMinExtents());
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCMaxExtents());
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCFreeLists());
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "FREELIST");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCFreelistGroups());
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCBufferPool());
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl2, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendUniqueDefinition(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, CompareObjectSelection compareObjectSelection, boolean bl) {
        UniqueOraclev10g uniqueOraclev10g = (UniqueOraclev10g)this.storageDesign.getUniqueSet().getProxy(compareObjectSelection.getObject().getObjectID());
        if (uniqueOraclev10g != null && uniqueOraclev10g.shouldBeMerge()) {
            StringBuffer stringBuffer2 = new StringBuffer();
            String string = "";
            StringBuffer stringBuffer3 = this.getColumnsForRestore(compareObjectSelection, bl, false);
            if (this.isNotEmpty(stringBuffer3.toString())) {
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.getTableName(this.tableObj));
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "ADD");
                string = stringBuffer2.toString() + "CONSTRAINT" + ' ' + this.storageDesign.getFormatedName(uniqueOraclev10g.getName());
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                if (uniqueOraclev10g.isCommentChanged() && !"".equalsIgnoreCase(uniqueOraclev10g.getComment())) {
                    this.appendComment(stringBuffer2, uniqueOraclev10g);
                } else if (!"".equalsIgnoreCase(uniqueOraclev10g.getObject().getComment())) {
                    this.appendComment(stringBuffer2, uniqueOraclev10g.getObject());
                }
                String string2 = this.storageDesign.getFormatedName(uniqueOraclev10g.getName());
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, string2);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "UNIQUE");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                this.appendString(stringBuffer2, stringBuffer3);
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, ')');
                if (!"NO".equalsIgnoreCase(uniqueOraclev10g.getDeferrable())) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(uniqueOraclev10g.getInitially())) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "INITIALLY");
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "DEFERRED");
                    }
                }
                if (!"YES".equalsIgnoreCase(uniqueOraclev10g.getEnable())) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "DISABLE");
                    if ("YES".equalsIgnoreCase(uniqueOraclev10g.getValidate())) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(uniqueOraclev10g.getValidate())) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer2, "NOVALIDATE");
                }
                if (!"NO".equalsIgnoreCase(uniqueOraclev10g.getUsingIndex())) {
                    this.appendUniqueUsingIndex(stringBuffer2, uniqueOraclev10g, tableProxyOraclev10g, bl);
                }
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                this.appendLineFinisher(stringBuffer2, bl);
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CDDLFileMaker.incrementAlterTable();
            } else {
                this.appendError(stringBuffer, bl, "Index " + uniqueOraclev10g.getLongName() + " without columns");
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer stringBuffer, UniqueOraclev10g uniqueOraclev10g, TableProxyOracle tableProxyOracle, boolean bl) {
        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(uniqueOraclev10g.getUsingIndex()) && uniqueOraclev10g.getExistingIndex() != null) {
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueOraclev10g.getExistingIndex().getUserNameAndName()));
        } else {
            if ("LOCAL".equalsIgnoreCase(uniqueOraclev10g.getUsingIndex())) {
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOCAL");
                this.getCSSBIndex().appendPartitionList(stringBuffer, uniqueOraclev10g, tableProxyOracle, bl);
            } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(uniqueOraclev10g.getUsingIndex())) {
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, uniqueOraclev10g.getCreateIndexStatement());
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            } else if (uniqueOraclev10g.getUsingIndex().equalsIgnoreCase("GLOBAL BY RANGE")) {
                this.appendUniqueGlobalIndex(stringBuffer, uniqueOraclev10g, bl);
            } else if (uniqueOraclev10g.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY QUANTITY")) {
                this.appendGlobalIndexByHashQuantity(stringBuffer, uniqueOraclev10g, bl);
            } else if (uniqueOraclev10g.getUsingIndex().equalsIgnoreCase("GLOBAL HASH PARTITIONED BY LIST")) {
                this.appendGlobalIndexByHashList(stringBuffer, uniqueOraclev10g, bl);
            }
            if (uniqueOraclev10g.getIndexSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev10g)uniqueOraclev10g.getIndexSegment(), false, bl, uniqueOraclev10g.getTableSpace(), uniqueOraclev10g.getLogging());
            } else {
                if (uniqueOraclev10g.getTableSpace() != null) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueOraclev10g.getTableSpace().getName()));
                    CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                }
                if (this.storageDesign.isOpen()) {
                    if ("YES".equalsIgnoreCase(uniqueOraclev10g.getLogging())) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    } else if ("NO".equalsIgnoreCase(uniqueOraclev10g.getLogging())) {
                        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    }
                }
            }
            if (this.storageDesign.isOpen()) {
                if (uniqueOraclev10g.getIndexSort().equalsIgnoreCase("NO")) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOSORT");
                    CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                } else if (uniqueOraclev10g.getIndexSort().equalsIgnoreCase("REVERSE")) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "REVERSE");
                    CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                }
                if (uniqueOraclev10g.getComputeStatistics().equalsIgnoreCase("YES")) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
                }
            }
        }
    }

    private void appendUniqueGlobalIndex(StringBuffer stringBuffer, UniqueOraclev10g uniqueOraclev10g, boolean bl) {
        if (uniqueOraclev10g.getUsingIndexGlobalPL() != null) {
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "RANGE");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(uniqueOraclev10g.getUsingIndexGlobalPL().getAllGlobalPartColumns()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            this.appendGlobalPartitions(stringBuffer, uniqueOraclev10g, bl);
        }
    }

    private void appendGlobalIndexByHashQuantity(StringBuffer stringBuffer, UniqueOraclev10g uniqueOraclev10g, boolean bl) {
        if (uniqueOraclev10g.getUsingIndexGlobalPL() != null) {
            IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g = (IndexGlobalPartitionsListOraclev10g)uniqueOraclev10g.getUsingIndexGlobalPL();
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllGlobalPartColumns()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITIONS");
            this.appendStringWithSpace(stringBuffer, indexGlobalPartitionsListOraclev10g.getHashPQuantity());
            if (!"".equals(indexGlobalPartitionsListOraclev10g.getHashPTableSpaces())) {
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllHashPTS()));
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
            if (!"".equals(indexGlobalPartitionsListOraclev10g.getIOTOverflowHashPTS())) {
                CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllIOTOverflowHashPTS()));
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendGlobalIndexByHashList(StringBuffer stringBuffer, UniqueOraclev10g uniqueOraclev10g, boolean bl) {
        if (uniqueOraclev10g.getUsingIndexGlobalPL() != null) {
            CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "BY");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(uniqueOraclev10g.getUsingIndexGlobalPL().getAllGlobalPartColumns()));
            CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            this.appendHashPartitions(stringBuffer, uniqueOraclev10g, bl);
        }
    }

    public String getTableName(CompareObjectSelection compareObjectSelection) {
        String string = compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.SCHEMA);
        String string2 = this.storageDesign.getFormatedName(compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.NAME));
        if (!"".equals(string)) {
            string2 = this.storageDesign.getFormatedName(string) + '.' + string2;
        }
        return string2;
    }

    private StringBuffer getColumnsForRestore(CompareObjectSelection compareObjectSelection, boolean bl, boolean bl2) {
        Index index = (Index)compareObjectSelection.getObject();
        CompareObjectSelection compareObjectSelection2 = (CompareObjectSelection)((CompareObjectSelection)compareObjectSelection.getParent()).getParent();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = false;
        List list = compareObjectSelection2.getChildObjects(0);
        block0: for (Column column : index.getElementsCollection()) {
            for (CompareObjectSelection compareObjectSelection3 : list) {
                ModelIDObject modelIDObject = compareObjectSelection3.getObject();
                if (modelIDObject == null || !modelIDObject.equals(column)) continue;
                if (compareObjectSelection3.canBeCreate() && !compareObjectSelection3.isSelected() || compareObjectSelection3.canBeDrop() && compareObjectSelection3.getCorrespondentNode().isSelected()) continue block0;
                if (bl3) {
                    stringBuffer.append(',');
                    CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    stringBuffer.append(' ');
                }
                String string = compareObjectSelection3.isSelected() ? compareObjectSelection3.getChoosedPropertyValue(PropertiesComparator.NAME) : compareObjectSelection3.getCorrespondentNode().getObject().getName();
                CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
                if (bl2) {
                    CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(compareObjectSelection3.getObject()));
                }
                bl3 = true;
                continue block0;
            }
        }
        return stringBuffer;
    }

    private void appendError(StringBuffer stringBuffer, boolean bl, String string) {
        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
        CSSBAlterIndexOraclev10g.appendStringWithSpace(stringBuffer, "--  ERROR: ");
        CSSBAlterIndexOraclev10g.appendString(stringBuffer, string);
        CSSBAlterIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
        CDDLFileMaker.incrementErrors();
    }

    protected CSSBIndexOraclev10g getCSSBIndex() {
        if (this.cssbIndex == null) {
            this.cssbIndex = new CSSBIndexOraclev10g();
            this.cssbIndex.setStorageDesign(this.storageDesign);
        }
        return this.cssbIndex;
    }
}

