/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBCreateTable;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SnapshotOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBSnapshot
extends AbstractCSSBOracle {
    private StorageDesignOraclev9i storageDesign;
    private CSSBCreateTable cssbCreateTable;

    public CSSBSnapshot(CSSBCreateTable cSSBCreateTable) {
        this.cssbCreateTable = cSSBCreateTable;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        SnapshotOraclev9i snapshotOraclev9i = (SnapshotOraclev9i)((CompareObjectSelection)object).getObject();
        this.storageDesign = (StorageDesignOraclev9i)snapshotOraclev9i.getStorageDesign();
        this.appendComment(stringBuffer, snapshotOraclev9i);
        this.appendCreateSnapshot(stringBuffer2, snapshotOraclev9i);
        string = stringBuffer2.toString();
        if (snapshotOraclev9i.getImplementedTable() != null || snapshotOraclev9i.getOnPrebuildTable() == null) {
            if (snapshotOraclev9i.getCluster() != null) {
                this.appendCluster(stringBuffer2, snapshotOraclev9i, bl);
            } else {
                this.appendSegment(stringBuffer2, snapshotOraclev9i, bl);
            }
            TableProxyOracle tableProxyOracle = snapshotOraclev9i.getImplementedTable();
            if (tableProxyOracle != null && this.cssbCreateTable != null) {
                this.cssbCreateTable.appendPartitionList(stringBuffer2, (TableProxyOraclev9i)tableProxyOracle, bl);
            } else {
                this.appendPartitioning(stringBuffer2, snapshotOraclev9i, bl);
            }
            this.appendParallelClause(stringBuffer2, snapshotOraclev9i, bl);
            if (!snapshotOraclev9i.getBuild().equals("IMMEDIATE")) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer2, "BUILD");
                CSSBSnapshot.appendStringWithSpace(stringBuffer2, snapshotOraclev9i.getBuild());
            }
        } else {
            this.appendPrebuild(stringBuffer2, snapshotOraclev9i, bl);
        }
        this.appendUsingIndex(stringBuffer2, snapshotOraclev9i, bl);
        this.appendRefreshClause(stringBuffer2, snapshotOraclev9i, bl);
        this.appendForUpdate(stringBuffer2, snapshotOraclev9i, bl);
        this.appendQueryRewrite(stringBuffer2, snapshotOraclev9i, bl);
        this.appendSubquery(stringBuffer2, snapshotOraclev9i, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        CSSBSnapshot.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        CDDLFileMaker.incrementCreateSnapshot();
        CSSBSnapshot.appendNewLine(stringBuffer, bl, 0);
        if (snapshotOraclev9i.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(stringBuffer2, snapshotOraclev9i, bl);
        }
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        this.appendPermissions(stringBuffer, snapshotOraclev9i, bl);
    }

    private void appendCreateSnapshot(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i) {
        this.appendCreate(stringBuffer);
        CSSBSnapshot.appendStringWithSpace(stringBuffer, "MATERIALIZED");
        CSSBSnapshot.appendStringWithSpace(stringBuffer, "VIEW");
        CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(snapshotOraclev9i.getLongName()));
    }

    private void appendSegment(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        this.appendPhysicalAttributes(stringBuffer, snapshotOraclev9i.getSegment(), bl);
        this.appendTableSpace(stringBuffer, snapshotOraclev9i, bl);
        this.appendLobStorage(stringBuffer, snapshotOraclev9i.getLobStorage(), bl);
        this.appendAttributes(stringBuffer, snapshotOraclev9i, bl);
    }

    private void appendParallelClause(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if ("YES".equalsIgnoreCase(snapshotOraclev9i.getParalelClause())) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "PARALLEL");
        }
    }

    private void appendPrebuild(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if (snapshotOraclev9i.getImplementedTable() != null || snapshotOraclev9i.getOnPrebuildTable() == null) {
            if (!snapshotOraclev9i.getBuild().equals("IMMEDIATE")) {
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "BUILD");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getBuild());
            }
        } else {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "ON");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "PREBUILT");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "TABLE");
            if ("NO".equalsIgnoreCase(snapshotOraclev9i.getReducedPrecision())) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "WITHOUT REDUCED PRECISION");
            }
        }
    }

    private void appendUsingIndex(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if (snapshotOraclev9i.getUseIndex().equals("YES")) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "USING");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "INDEX");
            if (snapshotOraclev9i.getIndexTablespace() != null) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(snapshotOraclev9i.getIndexTablespace().getName()));
            } else if (snapshotOraclev9i.getIndexSegment() != null) {
                this.appendPhysicalAttributes(stringBuffer, snapshotOraclev9i.getIndexSegment(), bl);
            }
        } else if (snapshotOraclev9i.getUseIndex().equals("NO")) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "USING");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "NO");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "INDEX");
        }
    }

    private void appendRefreshClause(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if ("NEVER".equalsIgnoreCase(snapshotOraclev9i.getRefresh())) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "NEVER");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "REFRESH");
        } else if ("YES".equals(snapshotOraclev9i.getRefresh())) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "REFRESH");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getRefreshType());
            if (!"".equalsIgnoreCase(snapshotOraclev9i.getAction())) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getAction());
            } else {
                if (!"".equalsIgnoreCase(snapshotOraclev9i.getStartDate())) {
                    CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, "START DATE");
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getStartDate());
                }
                if (!"".equalsIgnoreCase(snapshotOraclev9i.getNextDate())) {
                    CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, "NEXT");
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getNextDate());
                }
            }
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "WITH");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getWith());
            if ("YES".equalsIgnoreCase(snapshotOraclev9i.getDefaultSegment())) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "USING");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "DEFAULT");
                if (!"LOCAL".equalsIgnoreCase(snapshotOraclev9i.getSegmentType())) {
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getSegmentType());
                }
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "ROLLBACK");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "SEGMENT");
            } else if (snapshotOraclev9i.getRollbackSegment() != null) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "USING");
                if (!"LOCAL".equalsIgnoreCase(snapshotOraclev9i.getSegmentType())) {
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getSegmentType());
                }
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "ROLLBACK");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "SEGMENT");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(snapshotOraclev9i.getRollbackSegment().getName()));
            }
        }
    }

    private void appendForUpdate(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if ("YES".equalsIgnoreCase(snapshotOraclev9i.getForUpdate())) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "FOR");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "UPDATE");
        }
    }

    private void appendQueryRewrite(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if ("ENABLE".equalsIgnoreCase(snapshotOraclev9i.getQueryRewrite())) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "ENABLE");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "QUERY REWRITE");
        }
    }

    private void appendSubquery(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
        CSSBSnapshot.appendStringWithSpace(stringBuffer, "AS");
        CSSBSnapshot.appendStringWithSpace(stringBuffer, snapshotOraclev9i.getSubquery());
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof SnapshotOraclev9i;
    }

    private void appendLobStorage(StringBuffer stringBuffer, LobStorageOracle lobStorageOracle, boolean bl) {
        if (lobStorageOracle != null) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "LOB");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOracle.getColumn()));
            CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "STORE AS");
            if (!lobStorageOracle.getLobSegmentName().equalsIgnoreCase("")) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOracle.getLobSegmentName()));
            }
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOracle.getTableSpace() != null) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOracle.getTableSpace().getName()));
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            }
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "STORAGE");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
            if (lobStorageOracle.getSCInitialExtent() > 0L) {
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 3);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCInitialExtent());
            }
            if (lobStorageOracle.getSCNextExtent() > 0L) {
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 3);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCNextExtent());
            }
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 3);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCPctIncrease());
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 3);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCMinExtents());
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 3);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCMaxExtents());
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 3);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCFreeLists());
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 3);
            if (lobStorageOracle.getSCFreelistGroups() > 1) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "FREELIST");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "GROUPS");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCFreelistGroups());
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 3);
            }
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCBufferPool());
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOracle.getChunk() > 0) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "CHUNK");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getChunk());
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            }
            if (lobStorageOracle.getOldVersions().equalsIgnoreCase("RETENTION")) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "RETENTION");
            } else {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "PCTVERSION");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getPCTVersion());
            }
            if (lobStorageOracle.getFreepools() > 0 && lobStorageOracle.getSCFreelistGroups() <= 1) {
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getFreepools());
            }
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            if ("ENABLE".equalsIgnoreCase(lobStorageOracle.getStorageInRow())) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "STORAGE IN ROW");
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, lobStorageOracle.getCache());
            if (!"CACHE".equalsIgnoreCase(lobStorageOracle.getCache())) {
                if ("YES".equalsIgnoreCase(lobStorageOracle.getLogging())) {
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(lobStorageOracle.getLogging())) {
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, "NOLOGGING");
                }
            }
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendTableSpace(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        TableSpaceOracle tableSpaceOracle = snapshotOraclev9i.getTablespace();
        if (tableSpaceOracle != null && !"[NONE]".equalsIgnoreCase(tableSpaceOracle.getName())) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
    }

    private void appendAttributes(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        if ("YES".equalsIgnoreCase(snapshotOraclev9i.getLogging())) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "LOGGING");
        } else if ("NO".equalsIgnoreCase(snapshotOraclev9i.getLogging())) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "NOLOGGING");
        }
        if ("YES".equalsIgnoreCase(snapshotOraclev9i.getCache())) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "CACHE");
        } else if ("NO".equalsIgnoreCase(snapshotOraclev9i.getCache())) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "NOCACHE");
        }
    }

    private void appendCluster(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        ClusterOracle clusterOracle = snapshotOraclev9i.getCluster();
        if (clusterOracle != null) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "CLUSTER");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(clusterOracle.getLongName()));
            if (!"".equalsIgnoreCase(snapshotOraclev9i.getClusterColumns())) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getClusterColumns()));
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendPhysicalAttributes(StringBuffer stringBuffer, SegmentOracle segmentOracle, boolean bl) {
        if (segmentOracle != null) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getPCTFree());
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "PCTUSED");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getPCTUsed());
            if (segmentOracle.getInitrans() > 1) {
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getInitrans());
            }
            if (segmentOracle.getMaxTrans() > 1) {
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "MAXTRANS");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getMaxTrans());
            }
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "STORAGE");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            if (segmentOracle.getSCInitialExtent() > 0L) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getSCInitialExtent());
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            }
            if (segmentOracle.getSCNextExtent() > 0L) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getSCNextExtent());
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            }
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCPctIncrease());
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCMinExtents());
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, segmentOracle.getSCMaxExtents());
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCFreeLists());
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "FREELIST");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCFreelistGroups());
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, segmentOracle.getSCBufferPool());
            CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendPartitioning(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        PartitionListOraclev9i partitionListOraclev9i = (PartitionListOraclev9i)snapshotOraclev9i.getPartitionList();
        if (partitionListOraclev9i != null) {
            String string = partitionListOraclev9i.getPartitionType();
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            if ("RANGE".equalsIgnoreCase(string)) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "PARTITION BY RANGE");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getColumns()));
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                this.appendPartitions(stringBuffer, partitionListOraclev9i, false, bl);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(string)) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "PARTITION BY RANGE");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getColumns()));
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "BY");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "HASH");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getSubPartColumns()));
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                if ("NO".equals(partitionListOraclev9i.getUseSubpartStorageTemplate()) && (partitionListOraclev9i.getSubPartitionsQuantity() > 1 || !"".equals(partitionListOraclev9i.getSubPartitionsTableSpaces()))) {
                    CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                    this.appendStringWithSpace(stringBuffer, partitionListOraclev9i.getSubPartitionsQuantity());
                    if (!"".equals(partitionListOraclev9i.getSubPartitionsTableSpaces())) {
                        CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                        CSSBSnapshot.appendStringWithSpace(stringBuffer, "STORE IN");
                        CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                        CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllSubPartitionsTableSpaces()));
                        CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                    }
                }
                this.appendPartitions(stringBuffer, partitionListOraclev9i, true, bl);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(string)) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "PARTITION BY RANGE");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getColumns()));
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "BY");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "LIST");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getSubPartColumns()));
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                this.appendPartitions(stringBuffer, partitionListOraclev9i, true, bl);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(string)) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "BY");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "HASH");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getColumns()));
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "PARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionListOraclev9i.getHashPQuantity());
                if (!"".equals(partitionListOraclev9i.getHashPTableSpaces())) {
                    CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, "STORE IN");
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllHashPTableSpaces()));
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                }
                if (!"".equals(partitionListOraclev9i.getIOTOverflowHashPTS())) {
                    CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, "OVERFLOW");
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, "STORE IN");
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllIOTOverflowHashPTS()));
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(string)) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "BY");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "HASH");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getColumns()));
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                this.appendHashPartitions(stringBuffer, partitionListOraclev9i, bl);
            } else if ("LIST".equalsIgnoreCase(string)) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "BY");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "LIST");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev9i.getColumns()));
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                this.appendListPartitions(stringBuffer, snapshotOraclev9i, bl);
            }
        }
    }

    private void appendListPartitions(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        Iterator iterator = snapshotOraclev9i.getPartitions().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            ListPartitionOraclev9i listPartitionOraclev9i = (ListPartitionOraclev9i)iterator.next();
            if (bl2) {
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                bl2 = false;
            } else {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ',');
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            }
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev9i.getName()));
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "VALUES");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
            if (!"".equalsIgnoreCase(listPartitionOraclev9i.getColumns())) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, listPartitionOraclev9i.getColumns());
            } else {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "DEFAULT");
            }
            CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
            if (listPartitionOraclev9i.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "NOCOMPRESS");
            } else if (listPartitionOraclev9i.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "COMPRESS");
            }
            if (listPartitionOraclev9i.getSegment() == null) {
                if (listPartitionOraclev9i.getTablespace() != null) {
                    CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev9i.getTablespace().getName()));
                }
                if (this.storageDesign.isOpen()) {
                    if (listPartitionOraclev9i.getLogging().equalsIgnoreCase("YES")) {
                        CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                        CSSBSnapshot.appendStringWithSpace(stringBuffer, "LOGGING");
                    } else if (listPartitionOraclev9i.getLogging().equalsIgnoreCase("NO")) {
                        CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                        CSSBSnapshot.appendStringWithSpace(stringBuffer, "NOLOGGING");
                    }
                }
            }
            Iterator iterator2 = listPartitionOraclev9i.getLobStorages().iterator();
            while (iterator2.hasNext()) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)iterator2.next();
                this.appendLobStorage(stringBuffer, lobStorageOracle, bl);
            }
        }
        if (!bl2) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendPartitions(StringBuffer stringBuffer, PartitionListOracle partitionListOracle, boolean bl, boolean bl2) {
        StorageObjectCollection storageObjectCollection = partitionListOracle.getSnapshot().getPartitionsCollection();
        if (storageObjectCollection.size() > 0) {
            Object[] objectArray = storageObjectCollection.toArray();
            Arrays.sort(objectArray, new PossitionComparator());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
            Iterator iterator = arrayList.iterator();
            boolean bl3 = true;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof PartitionOracle)) continue;
                PartitionOracle partitionOracle = (PartitionOracle)e;
                if (bl3) {
                    CSSBSnapshot.appendNewLine(stringBuffer, bl2, 1);
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                    bl3 = false;
                } else {
                    CSSBSnapshot.appendStringWithSpace(stringBuffer, ',');
                }
                CSSBSnapshot.appendNewLine(stringBuffer, bl2, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOracle.getName()));
                CSSBSnapshot.appendNewLine(stringBuffer, bl2, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendStringWithSpace(stringBuffer, partitionOracle.getValueList());
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                this.appendPhysicalAttributes(stringBuffer, partitionOracle.getSegment(), bl2);
                Iterator iterator2 = partitionOracle.getLobs().iterator();
                while (iterator2.hasNext()) {
                    LobStorageOracle lobStorageOracle = (LobStorageOracle)iterator2.next();
                    this.appendLobStorage(stringBuffer, lobStorageOracle, bl2);
                }
                if (!bl || this.appendHashSubPartitions(stringBuffer, partitionOracle, bl2) || partitionOracle.getSubPartitionsQuantity() <= 0) continue;
                CSSBSnapshot.appendNewLine(stringBuffer, bl2, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionOracle.getSubPartitionsQuantity());
                if ("".equalsIgnoreCase(partitionOracle.getSubPartitionsTableSpaces())) continue;
                CSSBSnapshot.appendNewLine(stringBuffer, bl2, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "STORE IN");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionOracle.getAllSubPartitionsTableSpaces()));
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
            }
            if (!bl3) {
                CSSBSnapshot.appendNewLine(stringBuffer, bl2, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private boolean appendHashSubPartitions(StringBuffer stringBuffer, PartitionOracle partitionOracle, boolean bl) {
        boolean bl2 = false;
        HashPartitionSetOracle hashPartitionSetOracle = ((StorageDesignOracle)partitionOracle.getStorageDesign()).getHashPartitionSet();
        Iterator iterator = hashPartitionSetOracle.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)iterator.next();
            if (hashPartitionOracle.getSubPartitionOf() != partitionOracle) continue;
            if (bl3) {
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                bl3 = false;
                bl2 = true;
            } else {
                this.appendComma(stringBuffer);
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            }
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOracle.getName()));
            if (hashPartitionOracle.getTableSpace() == null) continue;
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOracle.getTableSpace().getName()));
            Iterator iterator2 = hashPartitionOracle.getLobItems().iterator();
            while (iterator2.hasNext()) {
                HashPartitionLobItemOracle hashPartitionLobItemOracle = (HashPartitionLobItemOracle)iterator2.next();
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "LOB");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                this.appendStringWithSpace(stringBuffer, hashPartitionLobItemOracle);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
                if (hashPartitionLobItemOracle.getTableSpace() == null) continue;
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "STORE AS");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionLobItemOracle.getTableSpace().getName()));
                CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
            }
        }
        if (!bl3) {
            CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
        }
        return bl2;
    }

    private boolean appendHashPartitions(StringBuffer stringBuffer, PartitionListOracle partitionListOracle, boolean bl) {
        boolean bl2 = false;
        SnapshotOracle snapshotOracle = partitionListOracle.getSnapshot();
        Iterator iterator = snapshotOracle.getPartitions().iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)iterator.next();
            if (bl3) {
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
                bl3 = false;
                bl2 = true;
            } else {
                this.appendComma(stringBuffer);
                CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            }
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOracle.getName()));
            if (hashPartitionOracle.getTableSpace() != null) {
                CSSBSnapshot.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOracle.getTableSpace().getName()));
            }
            this.appendHashPLobItems(stringBuffer, hashPartitionOracle, bl);
        }
        if (!bl3) {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 1);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
        }
        return bl2;
    }

    private void appendHashPLobItems(StringBuffer stringBuffer, HashPartitionOracle hashPartitionOracle, boolean bl) {
        HashPartitionLobItemSetOracle hashPartitionLobItemSetOracle = ((StorageDesignOracle)hashPartitionOracle.getStorageDesign()).getHashPartitionLobItemSet();
        Iterator iterator = hashPartitionLobItemSetOracle.iterator();
        while (iterator.hasNext()) {
            HashPartitionLobItemOracle hashPartitionLobItemOracle = (HashPartitionLobItemOracle)iterator.next();
            if (hashPartitionLobItemOracle.getHashPartition() == null || !hashPartitionLobItemOracle.getHashPartition().toString().equalsIgnoreCase(hashPartitionOracle.toString())) continue;
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 2);
            this.appendLobPartitioningStorage(stringBuffer, hashPartitionLobItemOracle.getName(), hashPartitionLobItemOracle.getLobColumn(), "", hashPartitionLobItemOracle.getTableSpace(), bl);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer stringBuffer, String string, Object object, String string2, TableSpaceOracle tableSpaceOracle, boolean bl) {
        CSSBSnapshot.appendStringWithSpace(stringBuffer, "LOB");
        CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
        String string3 = "";
        if (object != null) {
            string3 = object.toString();
        }
        if (string3.length() > 0) {
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string3));
        } else {
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("--  ERROR: Lob ");
            stringBuffer.append(string);
            stringBuffer.append(" has no Column specified");
            CDDLFileMaker.incrementErrors();
        }
        CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
        CSSBSnapshot.appendStringWithSpace(stringBuffer, "STORE AS");
        if (!string2.equalsIgnoreCase("")) {
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
        } else if (tableSpaceOracle == null) {
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
        }
        if (tableSpaceOracle != null) {
            CSSBSnapshot.appendStringWithSpace(stringBuffer, '(');
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            CSSBSnapshot.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendPermissions(StringBuffer stringBuffer, SnapshotOraclev9i snapshotOraclev9i, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        PermissionsSetOracle permissionsSetOracle = ((StorageDesignOracle)snapshotOraclev9i.getStorageDesign()).getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            AbstractStorageObjectOracle abstractStorageObjectOracle;
            PermissionsOraclev9i permissionsOraclev9i = (PermissionsOraclev9i)iterator.next();
            if (permissionsOraclev9i.getSnapshot() != null && permissionsOraclev9i.getSnapshot().equals(snapshotOraclev9i) && !permissionsOraclev9i.getPrivileges().equalsIgnoreCase("")) {
                if (snapshotOraclev9i.getUser() != null) {
                    abstractStorageObjectOracle = null;
                    abstractStorageObjectOracle = permissionsOraclev9i.getUser() != null ? permissionsOraclev9i.getUser() : permissionsOraclev9i.getRole();
                    this.appendExecutePackage(stringBuffer, permissionsOraclev9i.getPrivileges(), permissionsOraclev9i.getSnapshot(), abstractStorageObjectOracle, bl2, false);
                    bl2 = false;
                } else {
                    CSSBSnapshot.appendNewLine(stringBuffer, bl, 0);
                    CSSBSnapshot.appendNewLine(stringBuffer, bl, 0);
                    this.appendComment(stringBuffer, permissionsOraclev9i);
                    CSSBSnapshot.appendStringWithSpace(stringBuffer2, "GRANT");
                    CSSBSnapshot.appendStringWithSpace(stringBuffer2, permissionsOraclev9i.getPrivileges());
                    string = stringBuffer2.toString();
                    this.appendObject(stringBuffer2, permissionsOraclev9i);
                    this.appendTo(stringBuffer2, permissionsOraclev9i);
                    this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    CSSBSnapshot.appendNewLine(stringBuffer2, bl, 0);
                    stringBuffer2.append(';');
                    CSSBSnapshot.appendNewLine(stringBuffer2, bl, 0);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                }
            }
            if (permissionsOraclev9i.getSnapshot() == null || !permissionsOraclev9i.getSnapshot().equals(snapshotOraclev9i) || permissionsOraclev9i.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            if (snapshotOraclev9i.getUser() != null) {
                abstractStorageObjectOracle = null;
                abstractStorageObjectOracle = permissionsOraclev9i.getUser() != null ? permissionsOraclev9i.getUser() : permissionsOraclev9i.getRole();
                this.appendExecutePackage(stringBuffer, permissionsOraclev9i.getPrivilegesWithGrantOption(), permissionsOraclev9i.getSnapshot(), abstractStorageObjectOracle, bl2, true);
                bl2 = false;
                continue;
            }
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 0);
            CSSBSnapshot.appendNewLine(stringBuffer, bl, 0);
            this.appendComment(stringBuffer, permissionsOraclev9i);
            CSSBSnapshot.appendStringWithSpace(stringBuffer2, "GRANT");
            CSSBSnapshot.appendStringWithSpace(stringBuffer2, permissionsOraclev9i.getPrivilegesWithGrantOption());
            string = stringBuffer2.toString();
            this.appendObject(stringBuffer2, permissionsOraclev9i);
            this.appendTo(stringBuffer2, permissionsOraclev9i);
            this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i);
            this.appendGrantOption(stringBuffer2, permissionsOraclev9i);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            CSSBSnapshot.appendNewLine(stringBuffer2, bl, 0);
            stringBuffer2.append(';');
            CSSBSnapshot.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
        if (!bl2) {
            this.appendDropPackage(stringBuffer2, this.storageDesign.getFormatedName(snapshotOraclev9i.getUser().getName()));
        }
    }

    private void appendObject(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        stringBuffer.append(NEWLINE);
        stringBuffer.append("ON ");
        if (permissionsOraclev9i.getSnapshot() != null) {
            stringBuffer.append(this.storageDesign.getFormatedName(permissionsOraclev9i.getSnapshot().getLongName()));
        }
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        stringBuffer.append(" TO ");
        if ("YES".equalsIgnoreCase(permissionsOraclev9i.getPublic())) {
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else if (permissionsOraclev9i.getUser() != null) {
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev9i.getUser().getName()));
        } else if (permissionsOraclev9i.getRole() != null) {
            CSSBSnapshot.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev9i.getRole().getName()));
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        if (permissionsOraclev9i.getRole() == null) {
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        if ("YES".equalsIgnoreCase(permissionsOraclev9i.getHierarchyOption())) {
            stringBuffer.append(NEWLINE);
            CSSBSnapshot.appendStringWithSpace(stringBuffer, "WITH HIERARCHY OPTION");
        }
    }

    private void createPackage(StringBuffer stringBuffer, String string) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = "";
        stringBuffer.append(NEWLINE);
        stringBuffer.append(NEWLINE);
        stringBuffer2.append("CREATE OR REPLACE PACKAGE ").append(string).append(".perm_manager IS");
        string2 = stringBuffer2.toString();
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("v_option VARCHAR(20) DEFAULT NULL;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("v_statement VARCHAR(2000) DEFAULT NULL;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("procedure perm_grant(p_privilege IN VARCHAR2,");
        stringBuffer2.append(NEWLINE).append("    ").append("    ");
        stringBuffer2.append("p_object IN VARCHAR2,");
        stringBuffer2.append(NEWLINE).append("    ").append("    ");
        stringBuffer2.append("p_grantee IN VARCHAR2,");
        stringBuffer2.append(NEWLINE).append("    ").append("    ");
        stringBuffer2.append("p_option IN BOOLEAN DEFAULT FALSE);");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("END perm_manager;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("/");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("CREATE OR REPLACE PACKAGE BODY ").append(string).append(".perm_manager IS");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("procedure perm_grant(p_privilege IN VARCHAR2,");
        stringBuffer2.append(NEWLINE).append("    ").append("    ");
        stringBuffer2.append("p_object IN VARCHAR2,");
        stringBuffer2.append(NEWLINE).append("    ").append("    ");
        stringBuffer2.append("p_grantee IN VARCHAR2,");
        stringBuffer2.append(NEWLINE).append("    ").append("    ");
        stringBuffer2.append("p_option IN BOOLEAN DEFAULT FALSE) IS");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("BEGIN");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("IF (NOT p_option)");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append(" THEN v_option := '';");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("ELSE v_option := 'WITH GRANT OPTION';");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("END IF;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("v_statement := 'GRANT '||p_privilege||");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("    ").append("' ON ' ||p_object||");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("    ").append("' TO ' ||p_grantee||");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("    ").append("' ' ||v_option;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("EXECUTE IMMEDIATE v_statement;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("END perm_grant;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("END perm_manager;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("/");
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
    }

    private void appendExecutePackage(StringBuffer stringBuffer, String string, SnapshotOracle snapshotOracle, StorageObject storageObject, boolean bl, boolean bl2) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = this.storageDesign.getFormatedName(snapshotOracle.getUser().getName());
        if (bl) {
            this.createPackage(stringBuffer, string2);
        }
        stringBuffer.append(NEWLINE);
        stringBuffer.append(NEWLINE);
        CSSBSnapshot.appendStringWithSpace(stringBuffer2, "BEGIN");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append(string2).append(".perm_manager.perm_grant('").append(string).append("', '");
        if (snapshotOracle != null) {
            stringBuffer2.append(this.storageDesign.getFormatedName(snapshotOracle.getLongName()));
        }
        stringBuffer2.append("', '");
        if (storageObject != null) {
            stringBuffer2.append(storageObject);
        }
        stringBuffer2.append("', ");
        if (bl2) {
            if (storageObject instanceof RoleOracle && storageObject == null) {
                stringBuffer2.append("true");
            } else {
                stringBuffer2.append("false");
            }
        } else {
            stringBuffer2.append("false");
        }
        stringBuffer2.append(");");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("END;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("/");
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
    }

    private void appendDropPackage(StringBuffer stringBuffer, String string) {
        stringBuffer.append(NEWLINE);
        stringBuffer.append(NEWLINE);
        stringBuffer.append("DROP PACKAGE ").append(string).append(".perm_manager;");
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((PartitionOracle)object).getPosition() > ((PartitionOracle)object2).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)object).getPosition() < ((PartitionOracle)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

