/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBIndex
extends AbstractCSSBOracle {
    private DesignObject sType;
    private StorageDesignOraclev9i storageDesign;
    private boolean isRenamed = false;
    private StringBuffer columnList = new StringBuffer();
    private String restoredExpression = null;
    private String tableName = "";

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index) {
            return true;
        }
        return object instanceof IndexProxy && !(object instanceof FKProxyOracle);
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Object object2;
        StringBuffer stringBuffer2 = new StringBuffer();
        Index index = null;
        IndexProxyOraclev9i indexProxyOraclev9i = null;
        if (object instanceof CompareObjectSelection) {
            index = (Index)((CompareObjectSelection)object).getObject();
            object2 = index.getDesign();
            RDBMSSite rDBMSSite = index.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev9i)((Design)object2).getStorageDesign(rDBMSSite);
            indexProxyOraclev9i = (IndexProxyOraclev9i)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof Index) {
            index = (Index)object;
            object2 = index.getDesign();
            RDBMSSite rDBMSSite = index.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev9i)((Design)object2).getStorageDesign(rDBMSSite);
            indexProxyOraclev9i = (IndexProxyOraclev9i)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyOraclev9i) {
            indexProxyOraclev9i = (IndexProxyOraclev9i)object;
            index = (Index)indexProxyOraclev9i.getObject();
        }
        if (index != null && !index.isOidKey() && indexProxyOraclev9i != null && (index.shouldBeMerge() || this.isRenamed())) {
            if (indexProxyOraclev9i.isCommentChanged()) {
                this.appendComment(stringBuffer, indexProxyOraclev9i);
            } else {
                this.appendComment(stringBuffer, index);
            }
            this.storageDesign = (StorageDesignOraclev9i)indexProxyOraclev9i.getStorageDesign();
            CSSBIndex.appendStringWithSpace(stringBuffer2, "CREATE");
            if (indexProxyOraclev9i.isUnique()) {
                CSSBIndex.appendStringWithSpace(stringBuffer2, "UNIQUE");
            } else if (indexProxyOraclev9i.getBitmapIndex()) {
                CSSBIndex.appendStringWithSpace(stringBuffer2, "BITMAP");
            }
            CSSBIndex.appendStringWithSpace(stringBuffer2, "INDEX");
            CSSBIndex.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(indexProxyOraclev9i.getUserNameAndName()));
            object2 = stringBuffer2.toString();
            this.appendTable(stringBuffer2, indexProxyOraclev9i);
            if (this.restoredExpression != null || this.isNotEmpty(this.getRestoredColumns().toString())) {
                this.appendElementListRestored(stringBuffer2, index, indexProxyOraclev9i, true);
            } else {
                this.appendElementList(stringBuffer2, index, indexProxyOraclev9i, true);
            }
            if (!index.isSpatialIndex() && indexProxyOraclev9i.getIndexType().equals("")) {
                this.appendGlobalOrLocal(stringBuffer2, indexProxyOraclev9i, bl);
                this.appendIndexAttributes(stringBuffer2, indexProxyOraclev9i, bl);
            }
            this.appendToBuffer(stringBuffer, stringBuffer2, (String)object2);
            CSSBIndex.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            CSSBIndex.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, (String)object2);
            CDDLFileMaker.incrementCreateIndex();
        }
    }

    private void appendTable(StringBuffer stringBuffer, IndexProxyOraclev9i indexProxyOraclev9i) {
        CSSBIndex.appendStringWithSpace(stringBuffer, "ON");
        if (this.isNotEmpty(this.getTableName())) {
            CSSBIndex.appendStringWithSpace(stringBuffer, this.getTableName());
        } else {
            TableProxy tableProxy = indexProxyOraclev9i.getTableProxy();
            CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
        }
    }

    private void appendElementList(StringBuffer stringBuffer, Index index, IndexProxyOraclev9i indexProxyOraclev9i, boolean bl) {
        if (index.hasIndexExpression()) {
            CSSBIndex.appendStringWithSpace(stringBuffer, '(');
            CSSBIndex.appendString(stringBuffer, index.getIndexExpression());
            CSSBIndex.appendStringWithSpace(stringBuffer, ')');
        } else {
            ColumnProxy columnProxy = null;
            ColumnProxy[] columnProxyArray = indexProxyOraclev9i.getColumnProxies();
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            if (columnProxyArray.length < 1) {
                CSSBIndex.appendStringWithSpace(stringBuffer, "-- No Columns");
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            }
            CSSBIndex.appendStringWithSpace(stringBuffer, '(');
            for (int i = 0; i < columnProxyArray.length; ++i) {
                if (i != 0) {
                    CSSBIndex.appendStringWithSpace(stringBuffer, ',');
                }
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                columnProxy = columnProxyArray[i];
                CSSBIndex.appendString(stringBuffer, ' ');
                String string = this.storageDesign.getFormatedName(columnProxy.getName());
                if (index.isSpatialIndex()) {
                    Datatype datatype = columnProxy.getDataType();
                    if (this.sType == null) {
                        this.sType = columnProxy.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
                    }
                    if (datatype instanceof StructuredType) {
                        StructuredType structuredType = (StructuredType)datatype;
                        for (TypeElement typeElement : structuredType.getAllElements()) {
                            if (typeElement.getType() != this.sType) continue;
                            string = string.concat(".").concat(this.storageDesign.getFormatedName(typeElement.getName()));
                            break;
                        }
                    }
                }
                CSSBIndex.appendStringWithSpace(stringBuffer, string);
                if (index.isSpatialIndex() || !indexProxyOraclev9i.getIndexType().equals("")) continue;
                CSSBIndex.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(columnProxy));
            }
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, ')');
        }
        if (indexProxyOraclev9i != null) {
            if (index.isSpatialIndex()) {
                this.appendSpatialIndex(stringBuffer, index, indexProxyOraclev9i, bl);
            } else {
                this.appendDomainIndexProps(stringBuffer, index, indexProxyOraclev9i, bl);
            }
        }
    }

    private void appendDomainIndexProps(StringBuffer stringBuffer, Index index, IndexProxyOracle indexProxyOracle, boolean bl) {
        String string;
        if (!index.isSpatialIndex() && !(string = indexProxyOracle.getIndexType()).equals("")) {
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, "INDEXTYPE");
            CSSBIndex.appendStringWithSpace(stringBuffer, "IS");
            CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            String string2 = indexProxyOracle.getIndexDomainParameters();
            if (!string2.equals("")) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "PARAMETERS");
                CSSBIndex.appendString(stringBuffer, '(');
                CSSBIndex.appendString(stringBuffer, '\'');
                CSSBIndex.appendString(stringBuffer, string2);
                CSSBIndex.appendString(stringBuffer, '\'');
                CSSBIndex.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendSpatialIndex(StringBuffer stringBuffer, Index index, IndexProxyOraclev9i indexProxyOraclev9i, boolean bl) {
        if (index.isSpatialIndex()) {
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, "INDEXTYPE");
            CSSBIndex.appendStringWithSpace(stringBuffer, "IS");
            CSSBIndex.appendStringWithSpace(stringBuffer, "MDSYS.SPATIAL_INDEX");
            if (!index.getGeodetic().equals("YES") || indexProxyOraclev9i.getTableSpace() != null || index.getLayerType() != null && !index.getLayerType().equals("") || index.getDimensionsNumber() != 2) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "PARAMETERS");
                CSSBIndex.appendString(stringBuffer, '(');
                CSSBIndex.appendString(stringBuffer, '\'');
                if (!index.getGeodetic().equals("YES")) {
                    CSSBIndex.appendString(stringBuffer, "geodetic");
                    CSSBIndex.appendString(stringBuffer, '=');
                    this.appendString(stringBuffer, Boolean.FALSE);
                }
                if (index.getLayerType() != null && !index.getLayerType().equals("")) {
                    CSSBIndex.appendSpace(stringBuffer);
                    CSSBIndex.appendString(stringBuffer, "layer_gtype");
                    CSSBIndex.appendString(stringBuffer, '=');
                    CSSBIndex.appendString(stringBuffer, index.getLayerType());
                }
                if (index.getDimensionsNumber() != 2) {
                    CSSBIndex.appendSpace(stringBuffer);
                    CSSBIndex.appendString(stringBuffer, "sdo_indx_dims");
                    CSSBIndex.appendString(stringBuffer, '=');
                    this.appendString(stringBuffer, index.getDimensionsNumber());
                }
                if (indexProxyOraclev9i.getTableSpace() != null) {
                    CSSBIndex.appendSpace(stringBuffer);
                    CSSBIndex.appendString(stringBuffer, "tablespace=");
                    CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyOraclev9i.getTableSpace().getName()));
                }
                CSSBIndex.appendString(stringBuffer, '\'');
                CSSBIndex.appendStringWithSpace(stringBuffer, ')');
            }
            this.appendSpatialIndexPartitions(stringBuffer, indexProxyOraclev9i, bl);
        }
    }

    private void appendSpatialIndexPartitions(StringBuffer stringBuffer, IndexProxyOraclev9i indexProxyOraclev9i, boolean bl) {
        if ("LOCAL".equalsIgnoreCase(indexProxyOraclev9i.getIndexPartitioned())) {
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, "LOCAL");
            TableProxyOraclev9i tableProxyOraclev9i = (TableProxyOraclev9i)indexProxyOraclev9i.getTableProxy();
            PartitionListOraclev9i partitionListOraclev9i = (PartitionListOraclev9i)tableProxyOraclev9i.getPartitionList();
            if (partitionListOraclev9i != null) {
                this.appendSpatialPartitions(stringBuffer, indexProxyOraclev9i, partitionListOraclev9i, bl);
            }
        }
    }

    private void appendSpatialPartitions(StringBuffer stringBuffer, IndexProxyOraclev9i indexProxyOraclev9i, PartitionListOraclev9i partitionListOraclev9i, boolean bl) {
        PartitionSetOraclev9i partitionSetOraclev9i = (PartitionSetOraclev9i)((StorageDesignOraclev9i)partitionListOraclev9i.getStorageDesign()).getPartitionSet();
        Object[] objectArray = partitionSetOraclev9i.toArray();
        Arrays.sort(objectArray, new PossitionComparator());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        Iterator iterator = arrayList.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            SegmentOraclev9i segmentOraclev9i;
            PartitionOraclev9i partitionOraclev9i = (PartitionOraclev9i)iterator.next();
            if (partitionOraclev9i.getPartitionList() == null || !partitionOraclev9i.getPartitionList().getObjectID().equalsIgnoreCase(partitionListOraclev9i.getObjectID())) continue;
            if (bl2) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, '(');
                CSSBIndex.appendNewLine(stringBuffer, bl, 2);
                bl2 = false;
            } else {
                stringBuffer.append(',');
                CSSBIndex.appendNewLine(stringBuffer, bl, 2);
            }
            CSSBIndex.appendStringWithSpace(stringBuffer, "PARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex((IndexProxyOracle)indexProxyOraclev9i, partitionOraclev9i);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOraclev9i.getName()));
            }
            CSSBIndex.appendNewLine(stringBuffer, bl, 2);
            CSSBIndex.appendStringWithSpace(stringBuffer, "PARAMETERS");
            CSSBIndex.appendString(stringBuffer, '(');
            CSSBIndex.appendString(stringBuffer, '\'');
            if (localIndexProperties.getTableSpace() != null) {
                CSSBIndex.appendString(stringBuffer, "tablespace = ");
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getTableSpace().getName()));
            }
            if ((segmentOraclev9i = (SegmentOraclev9i)localIndexProperties.getSegment()) != null) {
                CSSBIndex.appendSpace(stringBuffer);
                CSSBIndex.appendString(stringBuffer, "sdo_rdr_pctfree=");
                this.appendString(stringBuffer, segmentOraclev9i.getPCTFree());
                if (segmentOraclev9i.getSCInitialExtent() > 0L) {
                    CSSBIndex.appendSpace(stringBuffer);
                    CSSBIndex.appendString(stringBuffer, "initial=");
                    this.appendString(stringBuffer, segmentOraclev9i.getSCInitialExtent());
                }
                if (segmentOraclev9i.getSCNextExtent() > 0L) {
                    CSSBIndex.appendSpace(stringBuffer);
                    CSSBIndex.appendString(stringBuffer, "next=");
                    this.appendString(stringBuffer, segmentOraclev9i.getSCNextExtent());
                }
                CSSBIndex.appendSpace(stringBuffer);
                CSSBIndex.appendString(stringBuffer, "pctincrease=");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCPctIncrease());
                CSSBIndex.appendSpace(stringBuffer);
                CSSBIndex.appendString(stringBuffer, "minextents=");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCMinExtents());
                CSSBIndex.appendSpace(stringBuffer);
                CSSBIndex.appendString(stringBuffer, "maxextents=");
                CSSBIndex.appendString(stringBuffer, segmentOraclev9i.getSCMaxExtents());
            }
            if (localIndexProperties.getLayerType() != null && !localIndexProperties.getLayerType().equals("")) {
                CSSBIndex.appendSpace(stringBuffer);
                CSSBIndex.appendString(stringBuffer, "layer_gtype=");
                CSSBIndex.appendString(stringBuffer, localIndexProperties.getLayerType());
            }
            CSSBIndex.appendString(stringBuffer, '\'');
            CSSBIndex.appendString(stringBuffer, ')');
        }
        if (!bl2) {
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendString(stringBuffer, ')');
        }
    }

    private void appendElementListRestored(StringBuffer stringBuffer, Index index, IndexProxyOraclev9i indexProxyOraclev9i, boolean bl) {
        if (this.restoredExpression != null && !this.restoredExpression.trim().equals("")) {
            CSSBIndex.appendStringWithSpace(stringBuffer, '(');
            CSSBIndex.appendString(stringBuffer, this.restoredExpression);
            CSSBIndex.appendStringWithSpace(stringBuffer, ')');
        } else {
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, '(');
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendString(stringBuffer, ' ');
            this.appendString(stringBuffer, this.getRestoredColumns());
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, ')');
            if (indexProxyOraclev9i != null) {
                if (index.isSpatialIndex()) {
                    this.appendSpatialIndex(stringBuffer, index, indexProxyOraclev9i, bl);
                } else {
                    this.appendDomainIndexProps(stringBuffer, index, indexProxyOraclev9i, bl);
                }
            }
        }
        this.getRestoredColumns().setLength(0);
        this.restoredExpression = null;
    }

    private void appendGlobalOrLocal(StringBuffer stringBuffer, IndexProxyOraclev9i indexProxyOraclev9i, boolean bl) {
        if ("GLOBAL".equalsIgnoreCase(indexProxyOraclev9i.getIndexPartitioned())) {
            IndexGlobalPartitionsListOraclev9i indexGlobalPartitionsListOraclev9i = (IndexGlobalPartitionsListOraclev9i)indexProxyOraclev9i.getIndexGlobalPartitionsList();
            if (indexGlobalPartitionsListOraclev9i != null) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "GLOBAL");
                CSSBIndex.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBIndex.appendStringWithSpace(stringBuffer, "BY");
                CSSBIndex.appendStringWithSpace(stringBuffer, "RANGE");
                CSSBIndex.appendStringWithSpace(stringBuffer, '(');
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev9i.getAllGlobalPartColumns()));
                CSSBIndex.appendStringWithSpace(stringBuffer, ')');
                this.appendGlobalPartitions(stringBuffer, indexProxyOraclev9i, bl);
            }
        } else if ("LOCAL".equalsIgnoreCase(indexProxyOraclev9i.getIndexPartitioned())) {
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, "LOCAL");
            this.appendPartitionList(stringBuffer, indexProxyOraclev9i, (TableProxyOraclev9i)indexProxyOraclev9i.getTableProxy(), bl);
        }
    }

    protected void appendGlobalPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, boolean bl) {
        Iterator iterator = indexProxyOracle.getGlobalPartitions().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            IndexGlobalPartitionOraclev9i indexGlobalPartitionOraclev9i = (IndexGlobalPartitionOraclev9i)iterator.next();
            if (bl2) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                stringBuffer.append(',');
            }
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev9i.getName()));
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
            CSSBIndex.appendStringWithSpace(stringBuffer, '(');
            CSSBIndex.appendStringWithSpace(stringBuffer, indexGlobalPartitionOraclev9i.getValueList());
            CSSBIndex.appendStringWithSpace(stringBuffer, ')');
            if (indexGlobalPartitionOraclev9i.getTableSpace() != null) {
                CSSBIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev9i.getTableSpace().getName()));
            }
            this.appendSegment(stringBuffer, (SegmentOraclev9i)indexGlobalPartitionOraclev9i.getSegment(), bl);
            if ("YES".equalsIgnoreCase(indexGlobalPartitionOraclev9i.getLogging())) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 2);
                CSSBIndex.appendStringWithSpace(stringBuffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(indexGlobalPartitionOraclev9i.getLogging())) continue;
            CSSBIndex.appendNewLine(stringBuffer, bl, 2);
            CSSBIndex.appendStringWithSpace(stringBuffer, "NOLOGGING");
        }
        if (!bl2) {
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendSegment(StringBuffer stringBuffer, SegmentOraclev9i segmentOraclev9i, boolean bl) {
        if (segmentOraclev9i != null) {
            CSSBIndex.appendNewLine(stringBuffer, bl, 2);
            CSSBIndex.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getPCTFree());
            if (segmentOraclev9i.getInitrans() > 2) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 2);
                CSSBIndex.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getInitrans());
            }
            if (segmentOraclev9i.getMaxTrans() > 2) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 2);
                CSSBIndex.appendStringWithSpace(stringBuffer, "MAXTRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getMaxTrans());
            }
            CSSBIndex.appendNewLine(stringBuffer, bl, 2);
            CSSBIndex.appendStringWithSpace(stringBuffer, "STORAGE");
            CSSBIndex.appendStringWithSpace(stringBuffer, '(');
            CSSBIndex.appendNewLine(stringBuffer, bl, 3);
            if (segmentOraclev9i.getSCInitialExtent() > 0L) {
                CSSBIndex.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCInitialExtent());
                CSSBIndex.appendNewLine(stringBuffer, bl, 3);
            }
            if (segmentOraclev9i.getSCNextExtent() > 0L) {
                CSSBIndex.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCNextExtent());
                CSSBIndex.appendNewLine(stringBuffer, bl, 3);
            }
            CSSBIndex.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCPctIncrease());
            CSSBIndex.appendNewLine(stringBuffer, bl, 3);
            CSSBIndex.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCMinExtents());
            CSSBIndex.appendNewLine(stringBuffer, bl, 3);
            CSSBIndex.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            CSSBIndex.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCMaxExtents());
            CSSBIndex.appendNewLine(stringBuffer, bl, 3);
            CSSBIndex.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCFreeLists());
            CSSBIndex.appendNewLine(stringBuffer, bl, 3);
            CSSBIndex.appendStringWithSpace(stringBuffer, "FREELIST");
            CSSBIndex.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCFreelistGroups());
            CSSBIndex.appendNewLine(stringBuffer, bl, 3);
            CSSBIndex.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            CSSBIndex.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCBufferPool());
            CSSBIndex.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendIndexAttributes(StringBuffer stringBuffer, IndexProxyOraclev9i indexProxyOraclev9i, boolean bl) {
        TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOraclev9i.getTableProxy();
        boolean bl2 = tableProxyOracle.getTemporary().equalsIgnoreCase("YES");
        if (!bl2) {
            if (indexProxyOraclev9i.getTableSpace() != null) {
                stringBuffer.append(NEWLINE).append("    ");
                CSSBIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyOraclev9i.getTableSpace().getName()));
            }
            this.appendSegment(stringBuffer, (SegmentOraclev9i)indexProxyOraclev9i.getSegment(), bl);
            if ("YES".equalsIgnoreCase(indexProxyOraclev9i.getLogging())) {
                stringBuffer.append(NEWLINE).append("    ");
                CSSBIndex.appendStringWithSpace(stringBuffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(indexProxyOraclev9i.getLogging())) {
                stringBuffer.append(NEWLINE).append("    ");
                CSSBIndex.appendStringWithSpace(stringBuffer, "NOLOGGING");
            }
        }
        if ("YES".equalsIgnoreCase(indexProxyOraclev9i.getOnline())) {
            stringBuffer.append(NEWLINE).append("    ");
            CSSBIndex.appendStringWithSpace(stringBuffer, "ONLINE");
        }
        if ("YES".equalsIgnoreCase(indexProxyOraclev9i.getComputeStatistics())) {
            stringBuffer.append(NEWLINE).append("    ");
            CSSBIndex.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
        }
        if (indexProxyOraclev9i.getCompress() > 0) {
            stringBuffer.append(NEWLINE).append("    ");
            CSSBIndex.appendStringWithSpace(stringBuffer, "COMPRESS");
            this.appendStringWithSpace(stringBuffer, indexProxyOraclev9i.getCompress());
        }
        if (!indexProxyOraclev9i.getBitmapIndex() && !indexProxyOraclev9i.isPartitioned()) {
            if ("NO".equalsIgnoreCase(indexProxyOraclev9i.getSortedRows())) {
                stringBuffer.append(NEWLINE).append("    ");
                CSSBIndex.appendStringWithSpace(stringBuffer, "NOSORT");
            } else if ("REVERSE".equalsIgnoreCase(indexProxyOraclev9i.getSortedRows())) {
                stringBuffer.append(NEWLINE).append("    ");
                CSSBIndex.appendStringWithSpace(stringBuffer, "REVERSE");
            }
        }
        if (!bl2 && "YES".equalsIgnoreCase(indexProxyOraclev9i.getParallel())) {
            stringBuffer.append(NEWLINE).append("    ");
            CSSBIndex.appendStringWithSpace(stringBuffer, "PARALLEL");
            if (!"".equalsIgnoreCase(indexProxyOraclev9i.getDegree())) {
                CSSBIndex.appendStringWithSpace(stringBuffer, indexProxyOraclev9i.getDegree());
            }
        }
    }

    private void appendPartitionList(StringBuffer stringBuffer, IndexProxyOraclev9i indexProxyOraclev9i, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        PartitionListOraclev9i partitionListOraclev9i = (PartitionListOraclev9i)tableProxyOraclev9i.getPartitionList();
        if (partitionListOraclev9i != null) {
            String string = partitionListOraclev9i.getPartitionType();
            if ("RANGE".equalsIgnoreCase(string)) {
                this.appendPartitions(stringBuffer, indexProxyOraclev9i, partitionListOraclev9i, false, bl);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(string)) {
                String string2 = indexProxyOraclev9i.getAllHashSubPartitionsTableSpaces();
                if (!"".equals(string2.trim())) {
                    CSSBIndex.appendStringWithSpace(stringBuffer, "STORE IN");
                    CSSBIndex.appendStringWithSpace(stringBuffer, '(');
                    CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(string2));
                    CSSBIndex.appendStringWithSpace(stringBuffer, ')');
                }
                this.appendPartitions(stringBuffer, indexProxyOraclev9i, partitionListOraclev9i, true, bl);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(string)) {
                this.appendPartitions(stringBuffer, indexProxyOraclev9i, partitionListOraclev9i, true, bl);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(string) || "HASH BY LIST OF PARTITIONS".equalsIgnoreCase(string)) {
                this.appendHashPartitions(stringBuffer, partitionListOraclev9i, indexProxyOraclev9i, bl);
            } else if ("LIST".equalsIgnoreCase(string)) {
                this.appendListPartitions(stringBuffer, partitionListOraclev9i, indexProxyOraclev9i, bl);
            }
        }
    }

    private void appendListPartitions(StringBuffer stringBuffer, PartitionListOraclev9i partitionListOraclev9i, IndexProxyOraclev9i indexProxyOraclev9i, boolean bl) {
        TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOraclev9i.getTableProxy();
        StorageObjectCollection storageObjectCollection = tableProxyOracle.getPartitions();
        Iterator iterator = storageObjectCollection.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            ListPartitionOraclev9i listPartitionOraclev9i = (ListPartitionOraclev9i)iterator.next();
            if (bl2) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                CSSBIndex.appendStringWithSpace(stringBuffer, ',');
            }
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, "PARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex((IndexProxyOracle)indexProxyOraclev9i, listPartitionOraclev9i);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev9i.getName()));
            }
            if (localIndexProperties == null) continue;
            TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)localIndexProperties.getTableSpace();
            String string = localIndexProperties.getLogging();
            SegmentOraclev9i segmentOraclev9i = (SegmentOraclev9i)localIndexProperties.getSegment();
            if (segmentOraclev9i != null) {
                this.appendSegment(stringBuffer, segmentOraclev9i, bl);
            }
            if (tableSpaceOraclev9i != null) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOraclev9i.getName()));
            } else if (segmentOraclev9i != null && segmentOraclev9i.getTableSpace() != null) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(segmentOraclev9i.getTableSpace().getName()));
            }
            if ("YES".equalsIgnoreCase(string)) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(string)) continue;
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, "NOLOGGING");
        }
        if (!bl2) {
            stringBuffer.append(NEWLINE).append("    ");
            CSSBIndex.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendHashPartitions(StringBuffer stringBuffer, PartitionListOraclev9i partitionListOraclev9i, IndexProxyOraclev9i indexProxyOraclev9i, boolean bl) {
        if (partitionListOraclev9i.getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOraclev9i.getTableProxy();
            StorageObjectCollection storageObjectCollection = tableProxyOracle.getPartitions();
            Iterator iterator = storageObjectCollection.iterator();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                TableSpaceOraclev9i tableSpaceOraclev9i;
                HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
                if (bl2) {
                    CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                    CSSBIndex.appendStringWithSpace(stringBuffer, '(');
                    bl2 = false;
                } else {
                    CSSBIndex.appendStringWithSpace(stringBuffer, ',');
                }
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "PARTITION");
                LocalIndexProperties localIndexProperties = this.getPropsForIndex((IndexProxyOracle)indexProxyOraclev9i, hashPartitionOraclev9i);
                if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                    CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
                } else {
                    CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getName()));
                }
                if (localIndexProperties == null || (tableSpaceOraclev9i = (TableSpaceOraclev9i)localIndexProperties.getTableSpace()) == null) continue;
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOraclev9i.getName()));
            }
            if (!bl2) {
                stringBuffer.append(NEWLINE).append("    ");
                CSSBIndex.appendStringWithSpace(stringBuffer, ')');
            }
        } else {
            String string = indexProxyOraclev9i.getAllHashSubPartitionsTableSpaces();
            if (!"".equals(string.trim())) {
                CSSBIndex.appendStringWithSpace(stringBuffer, "STORE IN");
                CSSBIndex.appendStringWithSpace(stringBuffer, '(');
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(string));
                CSSBIndex.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendPartitions(StringBuffer stringBuffer, IndexProxyOraclev9i indexProxyOraclev9i, PartitionListOraclev9i partitionListOraclev9i, boolean bl, boolean bl2) {
        TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOraclev9i.getTableProxy();
        StorageObjectCollection storageObjectCollection = tableProxyOracle.getPartitions();
        Iterator iterator = storageObjectCollection.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            PartitionOraclev9i partitionOraclev9i = (PartitionOraclev9i)iterator.next();
            if (bl3) {
                CSSBIndex.appendNewLine(stringBuffer, bl2, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, '(');
                bl3 = false;
            } else {
                stringBuffer.append(',');
            }
            CSSBIndex.appendNewLine(stringBuffer, bl2, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, "PARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex((IndexProxyOracle)indexProxyOraclev9i, partitionOraclev9i);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOraclev9i.getName()));
            }
            if (localIndexProperties == null) continue;
            TableSpaceOracle tableSpaceOracle = localIndexProperties.getTableSpace();
            String string = localIndexProperties.getLogging();
            SegmentOraclev9i segmentOraclev9i = (SegmentOraclev9i)localIndexProperties.getSegment();
            if (segmentOraclev9i != null) {
                this.appendSegment(stringBuffer, segmentOraclev9i, bl2);
            }
            if (tableSpaceOracle != null) {
                CSSBIndex.appendNewLine(stringBuffer, bl2, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            } else if (segmentOraclev9i != null && segmentOraclev9i.getTableSpace() != null) {
                CSSBIndex.appendNewLine(stringBuffer, bl2, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(segmentOraclev9i.getTableSpace().getName()));
            }
            if ("YES".equalsIgnoreCase(string)) {
                CSSBIndex.appendNewLine(stringBuffer, bl2, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(string)) {
                CSSBIndex.appendNewLine(stringBuffer, bl2, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "NOLOGGING");
            }
            if (localIndexProperties.getKeyCompression() > 0) {
                CSSBIndex.appendNewLine(stringBuffer, bl2, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "COMPRESS");
                this.appendStringWithSpace(stringBuffer, localIndexProperties.getKeyCompression());
            }
            if (!bl) continue;
            String string2 = this.recreateIndexHashPTSSet(localIndexProperties.getHashSubPartitionsTableSpaces());
            this.appendIndexSubPartitions(stringBuffer, indexProxyOraclev9i, partitionListOraclev9i.getPartitionType(), partitionOraclev9i, string2, bl2);
        }
        if (!bl3) {
            stringBuffer.append("    ").append(')');
        }
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxyOracle, PartitionOracle partitionOracle) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partitionOracle, indexProxyOracle);
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxyOracle, HashPartitionOraclev9i hashPartitionOraclev9i) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(hashPartitionOraclev9i, indexProxyOracle);
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxyOracle, ListPartitionOraclev9i listPartitionOraclev9i) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(listPartitionOraclev9i, indexProxyOracle);
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxyOracle, ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(listStorageTemplatePartitionOraclev9i, indexProxyOracle);
    }

    public static String getFirstToken(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = " ";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
        }
        return string2.trim();
    }

    private String recreateIndexHashPTSSet(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getById(string2);
            if (tableSpaceOracle == null) continue;
            if (!bl) {
                CSSBIndex.appendStringWithSpace(stringBuffer, ',');
            } else {
                bl = false;
            }
            CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
        return stringBuffer.toString();
    }

    private void appendIndexSubPartitions(StringBuffer stringBuffer, IndexProxyOraclev9i indexProxyOraclev9i, String string, PartitionOraclev9i partitionOraclev9i, String string2, boolean bl) {
        if (string.equalsIgnoreCase("COMPOSITE BY HASH")) {
            if (!this.appendHashSubPartitions(stringBuffer, indexProxyOraclev9i, partitionOraclev9i, bl) && !"".equalsIgnoreCase(string2.trim())) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, "STORE IN");
                CSSBIndex.appendStringWithSpace(stringBuffer, '(');
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(string2));
                CSSBIndex.appendStringWithSpace(stringBuffer, ')');
            }
        } else if (string.equalsIgnoreCase("COMPOSITE BY LIST")) {
            this.appendListSubPartitions(stringBuffer, indexProxyOraclev9i, partitionOraclev9i, bl);
        }
    }

    private void appendListSubPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, PartitionOraclev9i partitionOraclev9i, boolean bl) {
        boolean bl2 = true;
        Iterator iterator = partitionOraclev9i.getListPartitions().iterator();
        while (iterator.hasNext()) {
            TableSpaceOracle tableSpaceOracle;
            ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)iterator.next();
            if (bl2) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                CSSBIndex.appendStringWithSpace(stringBuffer, ',');
            }
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex(indexProxyOracle, listStorageTemplatePartitionOraclev9i);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev9i.getName()));
            }
            if (localIndexProperties == null || (tableSpaceOracle = localIndexProperties.getTableSpace()) == null) continue;
            CSSBIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
        if (!bl2) {
            CSSBIndex.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private boolean appendHashSubPartitions(StringBuffer stringBuffer, IndexProxyOraclev9i indexProxyOraclev9i, PartitionOraclev9i partitionOraclev9i, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = partitionOraclev9i.getPartitions().iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            TableSpaceOraclev9i tableSpaceOraclev9i;
            HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
            if (bl3) {
                CSSBIndex.appendNewLine(stringBuffer, bl, 1);
                CSSBIndex.appendStringWithSpace(stringBuffer, '(');
                bl3 = false;
                bl2 = true;
            } else {
                CSSBIndex.appendStringWithSpace(stringBuffer, ',');
            }
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex((IndexProxyOracle)indexProxyOraclev9i, hashPartitionOraclev9i);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getName()));
            }
            if (localIndexProperties == null || (tableSpaceOraclev9i = (TableSpaceOraclev9i)localIndexProperties.getTableSpace()) == null) continue;
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOraclev9i.getName()));
        }
        if (!bl3) {
            CSSBIndex.appendNewLine(stringBuffer, bl, 1);
            stringBuffer.append(')');
        }
        return bl2;
    }

    public void setRenamed(boolean bl) {
        this.isRenamed = bl;
    }

    public boolean isRenamed() {
        return this.isRenamed;
    }

    public void setRestoredExpression(String string) {
        this.restoredExpression = string;
    }

    public void setRestoredColumns(StringBuffer stringBuffer) {
        this.columnList = stringBuffer;
    }

    public StringBuffer getRestoredColumns() {
        return this.columnList;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof PartitionOraclev9i && object2 instanceof PartitionOraclev9i) {
                if (((PartitionOraclev9i)object).getPosition() > ((PartitionOraclev9i)object2).getPosition()) {
                    return 1;
                }
                if (((PartitionOraclev9i)object).getPosition() < ((PartitionOraclev9i)object2).getPosition()) {
                    return -1;
                }
            } else if (object instanceof ListPartitionOraclev9i && object2 instanceof ListPartitionOraclev9i) {
                if (((ListPartitionOraclev9i)object).getPosition() > ((ListPartitionOraclev9i)object2).getPosition()) {
                    return 1;
                }
                if (((ListPartitionOraclev9i)object).getPosition() < ((ListPartitionOraclev9i)object2).getPosition()) {
                    return -1;
                }
            } else {
                return 0;
            }
            return 0;
        }
    }
}

