/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTableConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBAlterTableConstraint
extends AbstractCSSBOracle {
    private CSSBDropTableConstraint dropConstraint;
    protected StorageDesignOracle storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        CompareObjectSelection compareObjectSelection = (CompareObjectSelection)object;
        CompareObjectSelection compareObjectSelection2 = compareObjectSelection.getCorrespondentNode();
        TableLevelConstraint tableLevelConstraint = (TableLevelConstraint)compareObjectSelection.getObject();
        Table table = tableLevelConstraint.getTable();
        if (table != null) {
            Design design = table.getDesign();
            RDBMSSite rDBMSSite = table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)design.getStorageDesign(rDBMSSite, table);
            if (compareObjectSelection.canBeCreate()) {
                this.appendAddConstraint(stringBuffer, compareObjectSelection, table, bl);
            } else {
                this.appendModifyConstraint(stringBuffer, compareObjectSelection, compareObjectSelection2, table, bl);
            }
        }
    }

    private void appendModifyConstraint(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, CompareObjectSelection compareObjectSelection2, Table table, boolean bl) {
        TableProxyOracle tableProxyOracle = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        Map map = this.getPropertiesMap(compareObjectSelection);
        if (tableProxyOracle != null && !map.isEmpty()) {
            TableLevelConstraint tableLevelConstraint = (TableLevelConstraint)compareObjectSelection.getObject();
            TableCheckConstraintOracle tableCheckConstraintOracle = tableProxyOracle.getTableConstraint(tableLevelConstraint);
            this.dropConstraint = new CSSBDropTableConstraint();
            if (this.dropConstraint == null) {
                this.dropConstraint = new CSSBDropTableConstraint();
            }
            this.dropConstraint.doAppend(stringBuffer, compareObjectSelection2, bl);
            String string = compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.NAME);
            String string2 = compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.RULE);
            StringBuffer stringBuffer2 = new StringBuffer();
            this.appendBeforeAlterScript(stringBuffer, bl, table);
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, "ALTER");
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, "TABLE");
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, this.getTableName(compareObjectSelection2));
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, "ADD");
            if (!"".equals(string) && !string.toUpperCase().startsWith("SYS_")) {
                CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string));
            }
            String string3 = stringBuffer2.toString();
            CSSBAlterTableConstraint.appendNewLine(stringBuffer2, bl, 1);
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, "CHECK");
            CSSBAlterTableConstraint.appendString(stringBuffer2, '(');
            CSSBAlterTableConstraint.appendString(stringBuffer2, string2);
            CSSBAlterTableConstraint.appendString(stringBuffer2, ')');
            this.appendTableConstraintState(stringBuffer2, tableCheckConstraintOracle, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string3);
            CSSBAlterTableConstraint.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            CSSBAlterTableConstraint.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string3);
            CDDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(stringBuffer, bl, table);
        }
    }

    private Map getPropertiesMap(CompareObjectSelection compareObjectSelection) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (EngPropertyHolder engPropertyHolder : compareObjectSelection.getPropertiesComparator().getPropertiesList()) {
            if (!engPropertyHolder.isSelected()) continue;
            if (engPropertyHolder.getName().equals(PropertiesComparator.NAME)) {
                treeMap.put(PropertiesComparator.NAME, engPropertyHolder.getLeftValue());
                continue;
            }
            if (!engPropertyHolder.getName().equals(PropertiesComparator.RULE)) continue;
            treeMap.put(PropertiesComparator.RULE, engPropertyHolder.getLeftValue());
        }
        return treeMap;
    }

    private void appendAddConstraint(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, Table table, boolean bl) {
        TableProxyOracle tableProxyOracle;
        TableLevelConstraint tableLevelConstraint = (TableLevelConstraint)compareObjectSelection.getObject();
        String string = tableLevelConstraint.getRule();
        if (!"".equals(string) && (tableProxyOracle = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID())) != null) {
            TableCheckConstraintOracle tableCheckConstraintOracle = tableProxyOracle.getTableConstraint(tableLevelConstraint);
            String string2 = tableCheckConstraintOracle.getName();
            StringBuffer stringBuffer2 = new StringBuffer();
            this.appendBeforeAlterScript(stringBuffer, bl, table);
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, "ALTER");
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, "TABLE");
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(this.getTableName(compareObjectSelection)));
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, "ADD");
            if (!"".equals(string2) && !string2.toUpperCase().startsWith("SYS_")) {
                CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string2));
            }
            String string3 = stringBuffer2.toString();
            CSSBAlterTableConstraint.appendNewLine(stringBuffer2, bl, 1);
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer2, "CHECK");
            CSSBAlterTableConstraint.appendString(stringBuffer2, '(');
            CSSBAlterTableConstraint.appendString(stringBuffer2, string);
            CSSBAlterTableConstraint.appendString(stringBuffer2, ')');
            this.appendTableConstraintState(stringBuffer2, tableCheckConstraintOracle, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string3);
            CSSBAlterTableConstraint.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            CSSBAlterTableConstraint.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string3);
            CDDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(stringBuffer, bl, table);
        }
    }

    private void appendTableConstraintState(StringBuffer stringBuffer, TableCheckConstraintOracle tableCheckConstraintOracle, boolean bl) {
        if (!"NO".equalsIgnoreCase(tableCheckConstraintOracle.getDeferrable())) {
            CSSBAlterTableConstraint.appendNewLine(stringBuffer, bl, 2);
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(tableCheckConstraintOracle.getInitially())) {
                CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer, "INITIALLY");
                CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer, "DEFERRED");
            }
        }
        if ("NO".equalsIgnoreCase(tableCheckConstraintOracle.getEnable())) {
            CSSBAlterTableConstraint.appendNewLine(stringBuffer, bl, 2);
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer, "DISABLE");
            if ("YES".equalsIgnoreCase(tableCheckConstraintOracle.getValidate())) {
                CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer, "VALIDATE");
            }
        }
        if ("NO".equalsIgnoreCase(tableCheckConstraintOracle.getValidate())) {
            CSSBAlterTableConstraint.appendNewLine(stringBuffer, bl, 2);
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer, "NOVALIDATE");
        }
        if (tableCheckConstraintOracle.getExceptionsTable() != null) {
            CSSBAlterTableConstraint.appendNewLine(stringBuffer, bl, 2);
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer, "EXCEPTIONS");
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer, "INTO");
            CSSBAlterTableConstraint.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableCheckConstraintOracle.getExceptionsTable().getName()));
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof TableLevelConstraint;
    }

    protected String getTableName(CompareObjectSelection compareObjectSelection) {
        CompareObjectSelection compareObjectSelection2 = compareObjectSelection.getTableNode();
        if (compareObjectSelection2 != null) {
            String string = compareObjectSelection2.getMergedProperty(PropertiesComparator.SCHEMA);
            String string2 = this.storageDesign.getFormatedName(compareObjectSelection2.getMergedProperty(PropertiesComparator.NAME));
            if (!"".equals(string)) {
                string2 = this.storageDesign.getFormatedName(string) + '.' + string2;
            }
            return string2;
        }
        return "";
    }
}

