/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.AbstractCSSBOraclev9i;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;

public class CSSBAlterTable
extends AbstractCSSBOraclev9i {
    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        CompareObjectSelection compareObjectSelection = (CompareObjectSelection)object;
        Table table = (Table)compareObjectSelection.getObject();
        Design design = table.getDesign();
        RDBMSSite rDBMSSite = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev9i)design.getStorageDesign(rDBMSSite, table);
        TableProxyOraclev9i tableProxyOraclev9i = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (compareObjectSelection.isModified()) {
            for (EngPropertyHolder engPropertyHolder : compareObjectSelection.getPropertiesComparator().getPropertiesList()) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(PropertiesComparator.COMMENT_IN_RDBMS) && table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    this.appendCommentOn(stringBuffer2, tableProxyOraclev9i, bl);
                    this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(PropertiesComparator.SPATIAL_TABLE) || !Boolean.parseBoolean(engPropertyHolder.getLeftValue())) continue;
                for (SpatialColumnDefObject spatialColumnDefObject : table.getSpatialDefinitions()) {
                    if (spatialColumnDefObject.getSpatialColumn() == null && !spatialColumnDefObject.isFunction()) continue;
                    this.appendRegisterSpatialTable(stringBuffer, table, spatialColumnDefObject, bl);
                }
            }
        } else if (!compareObjectSelection.hasChildsWithChangeStatus()) {
            CSSBAlterTable.appendStringWithSpace(stringBuffer, MessageFormat.format(Messages.getString("CSSBAlterTable.TableNotModified"), this.storageDesign.getFormatedName(table.getName())));
            CSSBAlterTable.appendNewLine(stringBuffer, bl, 0);
            CSSBAlterTable.appendNewLine(stringBuffer, bl, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Table;
    }
}

