/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBIndex;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBAlterIndex
extends AbstractCSSBOracle {
    CSSBDropIndex dropIndex;
    private CSSBIndex cssbIndex = new CSSBIndex();
    Map fkMap;
    private PKProxyOraclev9i pk = null;
    private StorageDesignOraclev9i storageDesign;
    private CompareObjectSelection tableObj;

    public CSSBAlterIndex(Map map) {
        this.fkMap = map;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        CompareObjectSelection compareObjectSelection = (CompareObjectSelection)object;
        this.tableObj = (CompareObjectSelection)((CompareObjectSelection)compareObjectSelection.getParent()).getParent();
        Table table = (Table)this.tableObj.getObject();
        Design design = table.getDesign();
        RDBMSSite rDBMSSite = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev9i)design.getStorageDesign(rDBMSSite, table);
        if (!compareObjectSelection.canBeCreate()) {
            boolean bl2 = false;
            String string = null;
            String string2 = null;
            for (Object object2 : compareObjectSelection.getPropertiesComparator().getPropertiesList()) {
                if (!((EngPropertyHolder)object2).isSelected()) continue;
                String string3 = ((EngPropertyHolder)object2).getName();
                if (string3.equals(PropertiesComparator.NAME)) {
                    string = ((EngPropertyHolder)object2).getLeftValue();
                    string2 = ((EngPropertyHolder)object2).getRightValue();
                    continue;
                }
                if (!string3.equals(PropertiesComparator.COLUMNS) && !string3.equals(PropertiesComparator.INDEX_FUNCTION_EXPRESSION) && !string3.equals(PropertiesComparator.INDEX_STATUS)) continue;
                bl2 = true;
            }
            if (bl2) {
                this.dropIndex = new CSSBDropIndex(this.fkMap);
                this.dropIndex.doAppend(stringBuffer, object, bl);
            } else {
                if (string != null) {
                    Object object2;
                    object2 = (Index)compareObjectSelection.getCorrespondentNode().getObject();
                    if (((KeyObject)object2).isPK() || ((KeyObject)object2).isUnique()) {
                        this.renameConstraint(stringBuffer, string2, string, bl);
                    } else {
                        this.renameIndex(stringBuffer, (Index)object2, string, bl);
                    }
                }
                return;
            }
        }
        this.appendAddIndex(stringBuffer, compareObjectSelection, bl);
    }

    private void renameIndex(StringBuffer stringBuffer, Index index, String string, boolean bl) {
        RDBMSSite rDBMSSite;
        Table table = index.getTable();
        Design design = table.getDesign();
        StorageDesign storageDesign = design.getStorageDesign(rDBMSSite = table.getSelectedRDBMSSite(), table);
        IndexProxyOracle indexProxyOracle = (IndexProxyOracle)storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        if (indexProxyOracle != null) {
            StringBuffer stringBuffer2 = new StringBuffer();
            CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "ALTER");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "INDEX");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(indexProxyOracle.getUserNameAndName()));
            CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "RENAME");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "TO");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string));
            String string2 = stringBuffer2.toString();
            this.appendToBuffer(stringBuffer, stringBuffer2, string2);
            this.appendLineFinisher(stringBuffer2, bl);
            CSSBAlterIndex.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string2);
            CDDLFileMaker.incrementAlterIndex();
        }
    }

    private void renameConstraint(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBAlterIndex.appendStringWithSpace(stringBuffer2, this.getTableName(this.tableObj));
        String string3 = this.storageDesign.getFormatedName(string);
        String string4 = stringBuffer2.toString() + "RENAME" + ' ' + "CONSTRAINT" + ' ' + string3;
        CSSBAlterIndex.appendNewLine(stringBuffer2, bl, 1);
        CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "RENAME");
        CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
        CSSBAlterIndex.appendStringWithSpace(stringBuffer2, string3);
        CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "TO");
        CSSBAlterIndex.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string2));
        this.appendToBuffer(stringBuffer, stringBuffer2, string4);
        this.appendLineFinisher(stringBuffer2, bl);
        CSSBAlterIndex.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, string4);
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendAddIndex(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, boolean bl) {
        Table table = (Table)this.tableObj.getObject();
        TableProxyOraclev9i tableProxyOraclev9i = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxyOraclev9i != null) {
            this.appendIndexDefinition(stringBuffer, compareObjectSelection, bl);
            this.appendPKDefinition(stringBuffer, tableProxyOraclev9i, compareObjectSelection, bl);
            this.appendUniqueDefinition(stringBuffer, tableProxyOraclev9i, compareObjectSelection, bl);
        }
    }

    private void appendIndexDefinition(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, boolean bl) {
        if (this.cssbIndex.canHandle(compareObjectSelection.getObject())) {
            StringBuffer stringBuffer2 = this.getColumnsForRestore(compareObjectSelection, bl, true);
            this.cssbIndex.setRestoredColumns(stringBuffer2);
            this.cssbIndex.setRestoredExpression(compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.INDEX_FUNCTION_EXPRESSION));
            this.cssbIndex.setTableName(this.getTableName(this.tableObj));
            this.cssbIndex.doAppend(stringBuffer, compareObjectSelection.getObject(), bl);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Index;
    }

    private void appendPKDefinition(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, CompareObjectSelection compareObjectSelection, boolean bl) {
        if (tableProxyOraclev9i != null) {
            Index index = (Index)compareObjectSelection.getObject();
            this.pk = (PKProxyOraclev9i)this.storageDesign.getPKProxySet().getProxy(index.getObjectID());
            if (this.pk != null && index.shouldBeMerge()) {
                if (!"".equalsIgnoreCase(this.pk.getColumns())) {
                    StringBuffer stringBuffer2 = this.getColumnsForRestore(compareObjectSelection, bl, false);
                    if (this.isNotEmpty(stringBuffer2.toString())) {
                        StringBuffer stringBuffer3 = new StringBuffer();
                        String string = "";
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer3, "ALTER");
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer3, "TABLE");
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer3, this.getTableName(this.tableObj));
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer3, "ADD");
                        string = stringBuffer3.toString() + "CONSTRAINT" + ' ' + this.storageDesign.getFormatedName(this.pk.getName());
                        CSSBAlterIndex.appendNewLine(stringBuffer3, bl, 1);
                        if (this.pk.isCommentChanged() && !"".equalsIgnoreCase(this.pk.getComment())) {
                            this.appendComment(stringBuffer3, this.pk);
                        } else if (!"".equalsIgnoreCase(this.pk.getObject().getComment())) {
                            this.appendComment(stringBuffer3, this.pk.getObject());
                        }
                        CSSBAlterIndex.appendString(stringBuffer3, ' ');
                        String string2 = this.storageDesign.getFormatedName(this.pk.getName());
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer3, "CONSTRAINT");
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer3, string2);
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer3, "PRIMARY KEY");
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer3, '(');
                        CSSBAlterIndex.appendNewLine(stringBuffer3, bl, 1);
                        this.appendStringWithSpace(stringBuffer3, stringBuffer2);
                        CSSBAlterIndex.appendNewLine(stringBuffer3, bl, 1);
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer3, ')');
                        if (!"NO".equalsIgnoreCase(this.pk.getDeferrable())) {
                            CSSBAlterIndex.appendStringWithSpace(stringBuffer3, "DEFERRABLE");
                            if ("DEFERRED".equalsIgnoreCase(this.pk.getInitially())) {
                                CSSBAlterIndex.appendStringWithSpace(stringBuffer3, "INITIALLY");
                                CSSBAlterIndex.appendStringWithSpace(stringBuffer3, "DEFERRED");
                            }
                        }
                        if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                            CSSBAlterIndex.appendStringWithSpace(stringBuffer3, "DISABLE");
                            if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                                CSSBAlterIndex.appendStringWithSpace(stringBuffer3, "VALIDATE");
                            }
                        }
                        if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                            CSSBAlterIndex.appendStringWithSpace(stringBuffer3, "NOVALIDATE");
                        }
                        if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                            this.appendUsingIndex(stringBuffer3, this.pk, bl);
                        }
                        this.appendToBuffer(stringBuffer, stringBuffer3, string);
                        this.appendLineFinisher(stringBuffer3, bl);
                        CSSBAlterIndex.appendNewLine(stringBuffer3, bl, 0);
                        this.appendToBuffer(stringBuffer, stringBuffer3, string);
                        CDDLFileMaker.incrementAlterTable();
                    }
                } else {
                    this.appendError(stringBuffer, bl, "Index " + this.pk.getLongName() + " without columns");
                }
            }
        }
    }

    private void appendUsingIndex(StringBuffer stringBuffer, PKProxyOraclev9i pKProxyOraclev9i, boolean bl) {
        CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
        CSSBAlterIndex.appendStringWithSpace(stringBuffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex()) && pKProxyOraclev9i.getExistingIndex() != null) {
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxyOraclev9i.getExistingIndex().getUserNameAndName()));
        } else {
            if ("LOCAL PARTITIONED".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex())) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "LOCAL");
            } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex())) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, '(');
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, pKProxyOraclev9i.getCreateIndexStatement());
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, ')');
            } else if ("GLOBAL PARTITIONED".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex())) {
                this.appendGlobalIndex(stringBuffer, pKProxyOraclev9i, bl);
            }
            if (pKProxyOraclev9i.getIndexSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)pKProxyOraclev9i.getIndexSegment(), false, bl, pKProxyOraclev9i.getTableSpace(), pKProxyOraclev9i.getLogging());
            } else {
                if (pKProxyOraclev9i.getTableSpace() != null) {
                    CSSBAlterIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBAlterIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxyOraclev9i.getTableSpace().getName()));
                    CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
                }
                if (this.storageDesign.isOpen()) {
                    if ("YES".equalsIgnoreCase(pKProxyOraclev9i.getLogging())) {
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer, "LOGGING");
                        CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
                    } else if ("NO".equalsIgnoreCase(pKProxyOraclev9i.getLogging())) {
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer, "NOLOGGING");
                        CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
                    }
                }
            }
            if (pKProxyOraclev9i.getIndexSort().equalsIgnoreCase("NO")) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "NOSORT");
                CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
            } else if (pKProxyOraclev9i.getIndexSort().equalsIgnoreCase("REVERSE")) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "REVERSE");
                CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
            }
            if (pKProxyOraclev9i.getComputeStatistics().equalsIgnoreCase("YES")) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendGlobalIndex(StringBuffer stringBuffer, PKProxyOraclev9i pKProxyOraclev9i, boolean bl) {
        if (pKProxyOraclev9i.getIndexGlobalPL() != null) {
            CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "GLOBAL");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "BY");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "RANGE");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, '(');
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(pKProxyOraclev9i.getIndexGlobalPL().getAllGlobalPartColumns()));
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, ')');
            this.appendGlobalPartitions(stringBuffer, pKProxyOraclev9i, bl);
        }
    }

    private void appendGlobalPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, boolean bl) {
        this.cssbIndex.appendGlobalPartitions(stringBuffer, indexProxyOracle, bl);
    }

    private void appendSegment(StringBuffer stringBuffer, SegmentOraclev9i segmentOraclev9i, boolean bl, boolean bl2, TableSpaceOracle tableSpaceOracle, String string) {
        if (segmentOraclev9i != null) {
            CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getPCTFree());
            if (bl) {
                CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "PCTUSED");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getPCTUsed());
            }
            if (segmentOraclev9i.getInitrans() > 1) {
                CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getInitrans());
            }
            if (segmentOraclev9i.getMaxTrans() > 1) {
                CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "MAXTRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getMaxTrans());
            }
            if (tableSpaceOracle != null) {
                CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            } else if (segmentOraclev9i.getTableSpace() != null) {
                CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(segmentOraclev9i.getTableSpace().getName()));
            }
            if (!"".equals(string)) {
                CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
                if (string.equalsIgnoreCase("NO")) {
                    CSSBAlterIndex.appendStringWithSpace(stringBuffer, "NOLOGGING");
                } else {
                    CSSBAlterIndex.appendStringWithSpace(stringBuffer, "LOGGING");
                }
            }
            CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "STORAGE");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, '(');
            CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
            if (segmentOraclev9i.getSCInitialExtent() > 0L) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCInitialExtent());
                CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
            }
            if (segmentOraclev9i.getSCNextExtent() > 0L) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCNextExtent());
                CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
            }
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCPctIncrease());
            CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCMinExtents());
            CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCMaxExtents());
            CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCFreeLists());
            CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "FREELIST");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCFreelistGroups());
            CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 2);
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCBufferPool());
            CSSBAlterIndex.appendNewLine(stringBuffer, bl2, 1);
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendUniqueDefinition(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, CompareObjectSelection compareObjectSelection, boolean bl) {
        UniqueOraclev9i uniqueOraclev9i = (UniqueOraclev9i)this.storageDesign.getUniqueSet().getProxy(compareObjectSelection.getObject().getObjectID());
        if (uniqueOraclev9i != null && uniqueOraclev9i.shouldBeMerge()) {
            StringBuffer stringBuffer2 = new StringBuffer();
            String string = "";
            StringBuffer stringBuffer3 = this.getColumnsForRestore(compareObjectSelection, bl, false);
            if (this.isNotEmpty(stringBuffer3.toString())) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "ALTER");
                CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "TABLE");
                CSSBAlterIndex.appendStringWithSpace(stringBuffer2, this.getTableName(this.tableObj));
                CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "ADD");
                string = stringBuffer2.toString() + "CONSTRAINT" + ' ' + this.storageDesign.getFormatedName(uniqueOraclev9i.getName());
                CSSBAlterIndex.appendNewLine(stringBuffer2, bl, 1);
                if (uniqueOraclev9i.isCommentChanged() && !"".equalsIgnoreCase(uniqueOraclev9i.getComment())) {
                    this.appendComment(stringBuffer2, uniqueOraclev9i);
                } else if (!"".equalsIgnoreCase(uniqueOraclev9i.getObject().getComment())) {
                    this.appendComment(stringBuffer2, uniqueOraclev9i.getObject());
                }
                String string2 = this.storageDesign.getFormatedName(uniqueOraclev9i.getName());
                CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                CSSBAlterIndex.appendStringWithSpace(stringBuffer2, string2);
                CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "UNIQUE");
                CSSBAlterIndex.appendStringWithSpace(stringBuffer2, '(');
                CSSBAlterIndex.appendNewLine(stringBuffer2, bl, 1);
                this.appendString(stringBuffer2, stringBuffer3);
                CSSBAlterIndex.appendNewLine(stringBuffer2, bl, 1);
                CSSBAlterIndex.appendStringWithSpace(stringBuffer2, ')');
                if (!"NO".equalsIgnoreCase(uniqueOraclev9i.getDeferrable())) {
                    CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(uniqueOraclev9i.getInitially())) {
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "INITIALLY");
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "DEFERRED");
                    }
                }
                if (!"YES".equalsIgnoreCase(uniqueOraclev9i.getEnable())) {
                    CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "DISABLE");
                    if ("YES".equalsIgnoreCase(uniqueOraclev9i.getValidate())) {
                        CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(uniqueOraclev9i.getValidate())) {
                    CSSBAlterIndex.appendStringWithSpace(stringBuffer2, "NOVALIDATE");
                }
                if (!"NO".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex())) {
                    this.appendUniqueUsingIndex(stringBuffer2, uniqueOraclev9i, bl);
                }
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                this.appendLineFinisher(stringBuffer2, bl);
                CSSBAlterIndex.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CDDLFileMaker.incrementAlterTable();
            } else {
                this.appendError(stringBuffer, bl, "Index " + uniqueOraclev9i.getLongName() + " without columns");
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer stringBuffer, UniqueOraclev9i uniqueOraclev9i, boolean bl) {
        CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
        CSSBAlterIndex.appendStringWithSpace(stringBuffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex()) && uniqueOraclev9i.getExistingIndex() != null) {
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueOraclev9i.getExistingIndex().getUserNameAndName()));
        } else {
            if ("LOCAL PARTITIONED".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex())) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "LOCAL");
            } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex())) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, '(');
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, uniqueOraclev9i.getCreateIndexStatement());
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, ')');
            } else if (uniqueOraclev9i.getUsingIndex().equalsIgnoreCase("GLOBAL PARTITIONED")) {
                this.appendUniqueGlobalIndex(stringBuffer, uniqueOraclev9i, bl);
            }
            if (uniqueOraclev9i.getIndexSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)uniqueOraclev9i.getIndexSegment(), false, bl, uniqueOraclev9i.getTableSpace(), uniqueOraclev9i.getLogging());
            } else {
                if (uniqueOraclev9i.getTableSpace() != null) {
                    CSSBAlterIndex.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBAlterIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueOraclev9i.getTableSpace().getName()));
                    CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
                }
                if ("YES".equalsIgnoreCase(uniqueOraclev9i.getLogging())) {
                    CSSBAlterIndex.appendStringWithSpace(stringBuffer, "LOGGING");
                    CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
                } else if ("NO".equalsIgnoreCase(uniqueOraclev9i.getLogging())) {
                    CSSBAlterIndex.appendStringWithSpace(stringBuffer, "NOLOGGING");
                    CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
                }
            }
            if (uniqueOraclev9i.getIndexSort().equalsIgnoreCase("NO")) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "NOSORT");
                CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
            } else if (uniqueOraclev9i.getIndexSort().equalsIgnoreCase("REVERSE")) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "REVERSE");
                CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
            }
            if (uniqueOraclev9i.getComputeStatistics().equalsIgnoreCase("YES")) {
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendUniqueGlobalIndex(StringBuffer stringBuffer, UniqueOraclev9i uniqueOraclev9i, boolean bl) {
        if (uniqueOraclev9i.getUsingIndexGlobalPL() != null) {
            CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "GLOBAL");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "BY");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, "RANGE");
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, '(');
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(uniqueOraclev9i.getUsingIndexGlobalPL().getAllGlobalPartColumns()));
            CSSBAlterIndex.appendStringWithSpace(stringBuffer, ')');
            this.appendGlobalPartitions(stringBuffer, uniqueOraclev9i, bl);
        }
    }

    private StringBuffer getColumnsForRestore(CompareObjectSelection compareObjectSelection, boolean bl, boolean bl2) {
        Index index = (Index)compareObjectSelection.getObject();
        CompareObjectSelection compareObjectSelection2 = (CompareObjectSelection)((CompareObjectSelection)compareObjectSelection.getParent()).getParent();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = false;
        List list = compareObjectSelection2.getChildObjects(0);
        block0: for (Column column : index.getElementsCollection()) {
            for (CompareObjectSelection compareObjectSelection3 : list) {
                ModelIDObject modelIDObject = compareObjectSelection3.getObject();
                if (modelIDObject == null || !modelIDObject.equals(column)) continue;
                if (compareObjectSelection3.canBeCreate() && !compareObjectSelection3.isSelected() || compareObjectSelection3.canBeDrop() && compareObjectSelection3.getCorrespondentNode().isSelected()) continue block0;
                if (bl3) {
                    stringBuffer.append(',');
                    CSSBAlterIndex.appendNewLine(stringBuffer, bl, 1);
                    stringBuffer.append(' ');
                }
                String string = compareObjectSelection3.isSelected() ? compareObjectSelection3.getChoosedPropertyValue(PropertiesComparator.NAME) : compareObjectSelection3.getCorrespondentNode().getObject().getName();
                CSSBAlterIndex.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
                if (bl2) {
                    CSSBAlterIndex.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(compareObjectSelection3.getObject()));
                }
                bl3 = true;
                continue block0;
            }
        }
        return stringBuffer;
    }

    private void appendError(StringBuffer stringBuffer, boolean bl, String string) {
        CSSBAlterIndex.appendNewLine(stringBuffer, bl, 0);
        CSSBAlterIndex.appendStringWithSpace(stringBuffer, "--  ERROR: ");
        CSSBAlterIndex.appendString(stringBuffer, string);
        CSSBAlterIndex.appendNewLine(stringBuffer, bl, 0);
        CDDLFileMaker.incrementErrors();
    }

    public String getTableName(CompareObjectSelection compareObjectSelection) {
        String string = compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.SCHEMA);
        String string2 = this.storageDesign.getFormatedName(compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.NAME));
        if (!"".equals(string)) {
            string2 = this.storageDesign.getFormatedName(string) + '.' + string2;
        }
        return string2;
    }
}

