/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.ddl.CompareRelationalModels;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;

public class DDLTableComparator
extends PropertiesComparator {
    private final Table sourceTable;
    private final Table targetTable;
    private TableProxy sourceTableProxy;
    private TableProxy targetTableProxy;
    private CompareRelationalModels selectionObject;
    private StorageDesign storageDesign;

    public DDLTableComparator(Table table, Table table2) {
        super(table, table2);
        this.sourceTable = table;
        this.targetTable = table2;
        Design design = table.getDesign();
        this.storageDesign = design.getStorageDesign(table.getSelectedRDBMSSite());
        this.initPropertiesList();
    }

    public DDLTableComparator(Table table, Table table2, TableProxy tableProxy, TableProxy tableProxy2) {
        super(table, table2);
        this.sourceTable = table;
        this.targetTable = table2;
        this.sourceTableProxy = tableProxy;
        this.targetTableProxy = tableProxy2;
        this.initPropertiesList();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromTableToTable();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        if (this.sourceTableProxy != null || this.targetTableProxy != null) {
            this.initSchemaProperty();
        }
        this.initCommentsAndNotes();
        PropertyHolder propertyHolder = new PropertyHolder(TEMP_TABLE_SCOPE);
        propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getScope() : "");
        propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getScope() : "");
        if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getScope().equals(this.targetTable.getScope())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(TABLE_TYPE);
        propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getDesign().getDLSettings().getClassificationTypeNameByID(this.sourceTable.getTypeID()) : "");
        propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getDesign().getDLSettings().getClassificationTypeNameByID(this.targetTable.getTypeID()) : "");
        if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getTypeID().equals(this.targetTable.getTypeID())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(STRUCTURED_TYPE);
        if (this.sourceTable != null && this.sourceTable.getBasedOnStructuredType() != null) {
            propertyHolder.setLeftValue(this.sourceTable.getBasedOnStructuredType().getName());
        } else {
            propertyHolder.setLeftValue("");
        }
        if (this.targetTable != null && this.targetTable.getBasedOnStructuredType() != null) {
            propertyHolder.setRightValue(this.targetTable.getBasedOnStructuredType().getName());
        } else {
            propertyHolder.setRightValue("");
        }
        if (this.sourceTable != null && this.targetTable != null && this.sourceTable.getBasedOnStructuredType() != this.targetTable.getBasedOnStructuredType()) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(MIN_VOLUMES);
        propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getMinVolumes() : "");
        propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getMinVolumes() : "");
        if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getMinVolumes().equals(this.targetTable.getMinVolumes())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(EXPECTED_VOLUMES);
        propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getExpectedVolumes() : "");
        propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getExpectedVolumes() : "");
        if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getExpectedVolumes().equals(this.targetTable.getExpectedVolumes())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(MAX_VOLUMES);
        propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getMaxVolumes() : "");
        propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getMaxVolumes() : "");
        if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getMaxVolumes().equals(this.targetTable.getMaxVolumes())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(GROWTH_PERCENT);
        propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getGrowthPercent() : "");
        propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getGrowthPercent() : "");
        if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getGrowthPercent().equals(this.targetTable.getGrowthPercent())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(GROWTH_TYPE);
        propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getGrowthType() : "");
        propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getGrowthType() : "");
        if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getGrowthType().equals(this.targetTable.getGrowthType())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(NORMAL_FORM);
        propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getNormalForm() : "");
        propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getNormalForm() : "");
        if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getNormalForm().equals(this.targetTable.getNormalForm())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(ADEQUATELY_NORMALIZED);
        propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getAdequatelyNormalized() : "");
        propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getAdequatelyNormalized() : "");
        if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getAdequatelyNormalized().equals(this.targetTable.getAdequatelyNormalized())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(COLUMNS_ORDER);
        propertyHolder.setLeftValue(this.sourceTable != null ? this.getElementsToString(this.sourceTable) : "");
        propertyHolder.setRightValue(this.targetTable != null ? this.getElementsToString(this.targetTable) : "");
        if (!this.equalColumnsOrderNew(this.sourceTable, this.targetTable)) {
            propertyHolder.setSelected(true);
            propertyHolder.setModified(true);
        }
        if (!this.useColumnsOrder) {
            propertyHolder.setSelected(false);
        }
        this.propertiesList.add(propertyHolder);
    }

    private void copyPropertiesFromTableToTable() {
        if (this.sourceTable != null && this.targetTable != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(TEMP_TABLE_SCOPE)) {
                    this.targetTable.setScope(this.sourceTable.getScope());
                    continue;
                }
                if (engPropertyHolder.getName().equals(TABLE_TYPE)) {
                    this.targetTable.setTypeID(this.sourceTable.getTypeID());
                    continue;
                }
                if (engPropertyHolder.getName().equals(STRUCTURED_TYPE)) {
                    this.targetTable.setBasedOnStructuredType(this.sourceTable.getBasedOnStructuredType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MIN_VOLUMES)) {
                    this.targetTable.setMinVolumes(this.sourceTable.getMinVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(EXPECTED_VOLUMES)) {
                    this.targetTable.setExpectedVolumes(this.sourceTable.getExpectedVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MAX_VOLUMES)) {
                    this.targetTable.setMaxVolumes(this.sourceTable.getMaxVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(GROWTH_PERCENT)) {
                    this.targetTable.setGrowthPercent(this.sourceTable.getGrowthPercent());
                    continue;
                }
                if (engPropertyHolder.getName().equals(GROWTH_TYPE)) {
                    this.targetTable.setGrowthType(this.sourceTable.getGrowthType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(NORMAL_FORM)) {
                    this.targetTable.setNormalForm(this.sourceTable.getNormalForm());
                    continue;
                }
                if (engPropertyHolder.getName().equals(ADEQUATELY_NORMALIZED)) {
                    this.targetTable.setAdequatelyNormalized(this.sourceTable.getAdequatelyNormalized());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(SCHEMA) || this.sourceTableProxy == null || this.targetTableProxy == null || this.sourceTableProxy.getUserSchema() == null) continue;
                this.targetTableProxy.setUserSchema(this.sourceTableProxy.getUserSchema().getName());
            }
        }
    }

    public CompareRelationalModels getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareRelationalModels compareRelationalModels) {
        this.selectionObject = compareRelationalModels;
    }

    @Override
    public String getLeftName() {
        return this.sourceTable != null ? MessageFormat.format(Messages.getString("DDLTableComparator.sourceTable"), this.sourceTable.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.targetTable != null ? MessageFormat.format(Messages.getString("DDLTableComparator.targetTable"), this.targetTable.getName()) : "";
    }

    private String getElementsToString(Table table) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<ContainedObject> iterator = Arrays.asList(table.getElements()).iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ContainedObject containedObject = iterator.next();
            if (bl) {
                stringBuffer.append(this.storageDesign.getFormatedName(containedObject.getName()));
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(this.storageDesign.getFormatedName(containedObject.getName()));
        }
        return stringBuffer.toString();
    }

    private boolean equalColumnOrder(Table table, Table table2) {
        if (this.sourceTable == null || table2 == null) {
            return true;
        }
        ContainedObject[] containedObjectArray = table.getElements();
        ContainedObject[] containedObjectArray2 = table2.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            if (i > containedObjectArray2.length - 1) {
                return true;
            }
            Column column = (Column)containedObjectArray[i];
            Column column2 = (Column)containedObjectArray2[i];
            if (column2.getImportedId() != null && column.getObjectID().equals(column2.getImportedId()) || column2.getName().equals(column.getName()) || column2.getDataType().toString().equals(column.getDataType().toString()) && column.getContainer().getElementByName(column2.getName()) == null) continue;
            return false;
        }
        return true;
    }

    private boolean equalColumnsOrderNew(Table table, Table table2) {
        if (this.getLeftSelectionObject() != null) {
            CompareRelationalModels[] compareRelationalModelsArray = this.getColumnNodes(this.getSelectionObject());
            for (int i = 0; i < compareRelationalModelsArray.length; ++i) {
                Column column;
                CompareRelationalModels compareRelationalModels = compareRelationalModelsArray[i];
                if (compareRelationalModels.getStatus() == ModelIdObjectSelection.STATE_NEW && this.isBeforeUnchangedColumn(i, compareRelationalModelsArray)) {
                    return false;
                }
                if (compareRelationalModels.getStatus() != ModelIdObjectSelection.STATE_UNCHANGED && compareRelationalModels.getStatus() != ModelIdObjectSelection.STATE_MODIFIED || (column = (Column)compareRelationalModels.getCorrespondentNode().getObject()) == null || i == column.getIndex()) continue;
                return false;
            }
            return true;
        }
        return this.equalColumnOrder(table, table2);
    }

    private CompareRelationalModels[] getColumnNodes(CompareRelationalModels compareRelationalModels) {
        ArrayList<CompareRelationalModels> arrayList = new ArrayList<CompareRelationalModels>();
        CompareRelationalModels compareRelationalModels2 = (CompareRelationalModels)compareRelationalModels.getChild(0);
        int n = compareRelationalModels2.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            CompareRelationalModels compareRelationalModels3 = (CompareRelationalModels)compareRelationalModels2.getChild(i);
            if (compareRelationalModels3.getStatus() == ModelIdObjectSelection.STATE_DELETED || (!compareRelationalModels3.isSelected() || compareRelationalModels3.getStatus() != ModelIdObjectSelection.STATE_NEW) && compareRelationalModels3.getStatus() == ModelIdObjectSelection.STATE_NEW) continue;
            arrayList.add(compareRelationalModels3);
        }
        return arrayList.toArray(new CompareRelationalModels[0]);
    }

    private boolean isBeforeUnchangedColumn(int n, CompareRelationalModels[] compareRelationalModelsArray) {
        for (int i = n + 1; i < compareRelationalModelsArray.length; ++i) {
            if (compareRelationalModelsArray[i].getStatus() != ModelIdObjectSelection.STATE_UNCHANGED) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceTable != null && this.targetTable != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected() || !engPropertyHolder.getName().equals(TABLE_TYPE) && this.equalColumnsOrderNew(this.sourceTable, this.targetTable) && !engPropertyHolder.getName().equals(SCHEMA)) continue;
                return true;
            }
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceTable == null && this.targetTable != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    protected void initSchemaProperty() {
        PropertyHolder propertyHolder = new PropertyHolder(SCHEMA);
        propertyHolder.setLeftValue(this.sourceTableProxy != null && this.sourceTableProxy.getUserSchema() != null ? this.sourceTableProxy.getUserSchema().getName() : "");
        propertyHolder.setRightValue(this.targetTableProxy != null && this.targetTableProxy.getUserSchema() != null ? this.targetTableProxy.getUserSchema().getName() : "");
        if (this.caseSensitive) {
            if (!propertyHolder.getLeftValue().equals(propertyHolder.getRightValue())) {
                propertyHolder.setModified(true);
                if (this.useSchema) {
                    propertyHolder.setSelected(true);
                } else {
                    propertyHolder.setFiltered(true);
                }
            }
        } else if (!propertyHolder.getLeftValue().equalsIgnoreCase(propertyHolder.getRightValue())) {
            propertyHolder.setModified(true);
            if (this.useSchema) {
                propertyHolder.setSelected(true);
            } else {
                propertyHolder.setFiltered(true);
            }
        }
        this.propertiesList.add(propertyHolder);
    }

    public Table getSourceTable() {
        return this.sourceTable;
    }

    public TableProxy getSourceTableProxy() {
        return this.sourceTableProxy;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public TableProxy getTargetTableProxy() {
        return this.targetTableProxy;
    }

    public void presetColumnsOrder() {
        EngPropertyHolder engPropertyHolder = this.getPropertyHolderByName(COLUMNS_ORDER);
        if (engPropertyHolder != null) {
            if (this.getLeftSelectionObject() != null) {
                engPropertyHolder.setRightValue(this.targetTable != null ? this.getElementsToString(this.targetTable) : "");
                CompareRelationalModels[] compareRelationalModelsArray = this.getColumnNodes(this.getSelectionObject());
                engPropertyHolder.setLeftValue(this.sourceTable != null ? this.getElementsToString(compareRelationalModelsArray) : "");
                if (!this.equalColumnsOrderNew(this.sourceTable, this.targetTable)) {
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setModified(true);
                } else {
                    engPropertyHolder.setSelected(false);
                    engPropertyHolder.setModified(false);
                }
            } else {
                engPropertyHolder.setLeftValue(this.sourceTable != null ? this.getElementsToString(this.sourceTable) : "");
                engPropertyHolder.setRightValue(this.targetTable != null ? this.getElementsToString(this.targetTable) : "");
                if (!this.equalColumnsOrderNew(this.sourceTable, this.targetTable)) {
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setModified(true);
                }
            }
            if (!this.useColumnsOrder) {
                engPropertyHolder.setSelected(false);
            }
        }
    }

    private String getElementsToString(CompareRelationalModels[] compareRelationalModelsArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < compareRelationalModelsArray.length; ++i) {
            ContainedObject containedObject = (ContainedObject)compareRelationalModelsArray[i].getObject();
            if (bl) {
                stringBuffer.append(this.storageDesign.getFormatedName(containedObject.getName()));
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(this.storageDesign.getFormatedName(containedObject.getName()));
        }
        return stringBuffer.toString();
    }
}

