/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.CompareRelationalModels;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;

public class DDLStructuredTypeComparator
extends PropertiesComparator {
    private StructuredType sourceType;
    private StructuredType targetType;
    private CompareRelationalModels selectionObject;
    private StorageDesign storageDesign;

    public DDLStructuredTypeComparator(StructuredType structuredType, StructuredType structuredType2) {
        super(structuredType, structuredType2);
        this.sourceType = structuredType;
        this.targetType = structuredType2;
        Design design = structuredType.getDesign();
        this.storageDesign = design.getStorageDesign(structuredType.getSelectedRDBMSSite());
        this.initPropertiesList();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromStrTypeToStrType();
    }

    private void copyPropertiesFromStrTypeToStrType() {
        if (this.sourceType != null && this.targetType != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
            }
        }
    }

    public void presetTypeElemsOrder() {
        EngPropertyHolder engPropertyHolder = this.getPropertyHolderByName(STRUCTURED_TYPE);
        if (engPropertyHolder != null) {
            if (this.getLeftSelectionObject() != null) {
                engPropertyHolder.setRightValue(this.targetType != null ? this.getElementsToString(this.targetType) : "");
                CompareRelationalModels[] compareRelationalModelsArray = this.getTypeElemNodes(this.getSelectionObject());
                engPropertyHolder.setLeftValue(this.sourceType != null ? this.getElementsToString(compareRelationalModelsArray) : "");
                if (!this.equalElementsOrderNew(this.sourceType, this.targetType)) {
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setModified(true);
                } else {
                    engPropertyHolder.setSelected(false);
                    engPropertyHolder.setModified(false);
                }
            } else {
                engPropertyHolder.setLeftValue(this.sourceType != null ? this.getElementsToString(this.sourceType) : "");
                engPropertyHolder.setRightValue(this.targetType != null ? this.getElementsToString(this.targetType) : "");
                if (!this.equalElementsOrderNew(this.sourceType, this.targetType)) {
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setModified(true);
                }
            }
        }
    }

    private boolean isBeforeUnchangedElement(int n, CompareRelationalModels[] compareRelationalModelsArray) {
        for (int i = n + 1; i < compareRelationalModelsArray.length; ++i) {
            if (compareRelationalModelsArray[i].getStatus() != ModelIdObjectSelection.STATE_UNCHANGED) continue;
            return true;
        }
        return false;
    }

    private boolean equalElementsOrderNew(StructuredType structuredType, StructuredType structuredType2) {
        if (this.getLeftSelectionObject() != null) {
            CompareRelationalModels[] compareRelationalModelsArray = this.getTypeElemNodes(this.getSelectionObject());
            for (int i = 0; i < compareRelationalModelsArray.length; ++i) {
                CompareRelationalModels compareRelationalModels = compareRelationalModelsArray[i];
                if (compareRelationalModels.getStatus() == ModelIdObjectSelection.STATE_NEW && this.isBeforeUnchangedElement(i, compareRelationalModelsArray)) {
                    return false;
                }
                if (compareRelationalModels.getStatus() != ModelIdObjectSelection.STATE_UNCHANGED && compareRelationalModels.getStatus() != ModelIdObjectSelection.STATE_MODIFIED) continue;
            }
            return true;
        }
        return this.equalElementsOrder(structuredType, structuredType2);
    }

    private boolean equalElementsOrder(StructuredType structuredType, StructuredType structuredType2) {
        if (structuredType == null || structuredType2 == null) {
            return true;
        }
        TypeElement[] typeElementArray = structuredType.getElements();
        TypeElement[] typeElementArray2 = structuredType2.getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            if (i > typeElementArray2.length - 1) {
                return true;
            }
            TypeElement typeElement = typeElementArray[i];
            TypeElement typeElement2 = typeElementArray2[i];
            if (typeElement2.getImportedId() != null && typeElement.getObjectID().equals(typeElement2.getImportedId()) || typeElement2.getName().equals(typeElement.getName()) || typeElement2.getDataType().toString().equals(typeElement.getDataType().toString())) continue;
            return false;
        }
        return true;
    }

    private CompareRelationalModels[] getTypeElemNodes(CompareRelationalModels compareRelationalModels) {
        ArrayList<CompareRelationalModels> arrayList = new ArrayList<CompareRelationalModels>();
        CompareRelationalModels compareRelationalModels2 = (CompareRelationalModels)compareRelationalModels.getChild(0);
        int n = compareRelationalModels2.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            CompareRelationalModels compareRelationalModels3 = (CompareRelationalModels)compareRelationalModels2.getChild(i);
            if (compareRelationalModels3.getStatus() == ModelIdObjectSelection.STATE_DELETED || (!compareRelationalModels3.isSelected() || compareRelationalModels3.getStatus() != ModelIdObjectSelection.STATE_NEW) && compareRelationalModels3.getStatus() == ModelIdObjectSelection.STATE_NEW) continue;
            arrayList.add(compareRelationalModels3);
        }
        return arrayList.toArray(new CompareRelationalModels[0]);
    }

    private String getElementsToString(StructuredType structuredType) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<TypeElement> iterator = Arrays.asList(structuredType.getElements()).iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            TypeElement typeElement = iterator.next();
            if (bl) {
                stringBuffer.append(this.storageDesign.getFormatedName(typeElement.getName()));
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(this.storageDesign.getFormatedName(typeElement.getName()));
        }
        return stringBuffer.toString();
    }

    private String getElementsToString(CompareRelationalModels[] compareRelationalModelsArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < compareRelationalModelsArray.length; ++i) {
            TypeElement typeElement = (TypeElement)compareRelationalModelsArray[i].getObject();
            if (bl) {
                stringBuffer.append(this.storageDesign.getFormatedName(typeElement.getName()));
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(this.storageDesign.getFormatedName(typeElement.getName()));
        }
        return stringBuffer.toString();
    }

    public CompareRelationalModels getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareRelationalModels compareRelationalModels) {
        this.selectionObject = compareRelationalModels;
    }

    @Override
    public String getLeftName() {
        if (this.sourceType != null && !this.sourceType.getName().equalsIgnoreCase("SDO_GEOMETRY") && !this.sourceType.getName().equalsIgnoreCase("XMLTYPE")) {
            return MessageFormat.format(Messages.getString("DDLStructuredTypeComparator.SourceStructureType"), this.sourceType.getName());
        }
        return "";
    }

    @Override
    public String getRightName() {
        return this.targetType != null ? MessageFormat.format(Messages.getString("DDLStructuredTypeComparator.TargetStructureType"), this.targetType.getName()) : "";
    }
}

