/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.ddl.CompareRelationalModels;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;

public class DDLIndexComparator
extends PropertiesComparator {
    private Index sourceIndex;
    private Index targetIndex;
    private Map objectsMap;
    private CompareRelationalModels selectionObject;
    private StorageDesign storageDesign;

    public DDLIndexComparator(Index index, Index index2, Map map) {
        super(index, index2);
        this.sourceIndex = index;
        this.targetIndex = index2;
        this.objectsMap = map;
        this.initPropertiesList();
        Design design = index.getDesign();
        this.storageDesign = design.getStorageDesign(index.getSelectedRDBMSSite());
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        PropertyHolder propertyHolder = new PropertyHolder(INDEX_STATUS);
        propertyHolder.setLeftValue(this.sourceIndex != null ? this.sourceIndex.getIndexState() : "");
        propertyHolder.setRightValue(this.targetIndex != null ? this.targetIndex.getIndexState() : "");
        if (this.targetIndex != null && this.sourceIndex != null && !this.targetIndex.getIndexState().equals(this.sourceIndex.getIndexState())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(COLUMNS);
        propertyHolder.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
        propertyHolder.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
        if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap)) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
            propertyHolder.setEditable(false);
        }
        this.propertiesList.add(propertyHolder);
    }

    private String getElementsToString(Index index) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = index.getElementsCollection().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (index.isPK() || index.isUnique()) {
                if (bl) {
                    stringBuffer.append(this.storageDesign.getFormatedName(column.getName()));
                    bl = false;
                    continue;
                }
                stringBuffer.append("; ").append(this.storageDesign.getFormatedName(column.getName()));
                continue;
            }
            if (bl) {
                stringBuffer.append(this.storageDesign.getFormatedName(column.getName())).append(" ").append(index.getColumnSortOrder(column));
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(this.storageDesign.getFormatedName(column.getName())).append(" ").append(index.getColumnSortOrder(column));
        }
        return stringBuffer.toString();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromIndexToKey();
    }

    private void copyPropertiesFromIndexToKey() {
        if (this.targetIndex != null && this.sourceIndex != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(INDEX_STATUS)) {
                    this.targetIndex.setIndexState(this.sourceIndex.getIndexState());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(COLUMNS)) continue;
                MergingModels.synchronizeColumnsFromIndexToKey(this.sourceIndex, this.targetIndex);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceIndex != null ? this.sourceIndex.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetIndex != null ? this.targetIndex.getLongName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceIndex == null) {
            return true;
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceIndex == null && this.targetIndex != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    @Override
    public String getChoosedPropertyValue(String string) {
        return super.getChoosedPropertyValue(string);
    }

    public void presetColumnsOrder() {
        EngPropertyHolder engPropertyHolder = this.getPropertyHolderByName(COLUMNS);
        if (engPropertyHolder != null) {
            if (this.getLeftSelectionObject() != null) {
                engPropertyHolder.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.sourceIndex != null) {
                    CompareRelationalModels[] compareRelationalModelsArray = this.getColumnNodes(this.sourceIndex, this.getTableNode());
                    engPropertyHolder.setLeftValue(this.getElementsToString(this.sourceIndex, compareRelationalModelsArray));
                } else {
                    engPropertyHolder.setLeftValue("");
                }
                if (this.targetIndex != null && this.sourceIndex != null) {
                    if (!MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap)) {
                        engPropertyHolder.setModified(true);
                        engPropertyHolder.setSelected(true);
                    } else {
                        engPropertyHolder.setModified(false);
                        engPropertyHolder.setSelected(false);
                    }
                    engPropertyHolder.setEditable(false);
                }
            } else {
                engPropertyHolder.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
                engPropertyHolder.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap)) {
                    engPropertyHolder.setModified(true);
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setEditable(false);
                }
            }
        }
    }

    private CompareRelationalModels[] getColumnNodes(Index index, CompareRelationalModels compareRelationalModels) {
        ContainedObject[] containedObjectArray;
        ArrayList<ContainedObject[]> arrayList = new ArrayList<ContainedObject[]>();
        CompareRelationalModels compareRelationalModels2 = (CompareRelationalModels)compareRelationalModels.getChild(0);
        int n = compareRelationalModels2.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            containedObjectArray = (ContainedObject[])compareRelationalModels2.getChild(i);
            if (containedObjectArray.getStatus() == ModelIdObjectSelection.STATE_DELETED || (!containedObjectArray.isSelected() || containedObjectArray.getStatus() != ModelIdObjectSelection.STATE_NEW) && containedObjectArray.getStatus() == ModelIdObjectSelection.STATE_NEW) continue;
            arrayList.add(containedObjectArray);
        }
        ArrayList<CompareRelationalModels> arrayList2 = new ArrayList<CompareRelationalModels>();
        containedObjectArray = index.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            CompareRelationalModels compareRelationalModels3 = this.getNode(arrayList, containedObjectArray[i]);
            if (compareRelationalModels3 == null) continue;
            arrayList2.add(compareRelationalModels3);
        }
        return arrayList2.toArray(new CompareRelationalModels[0]);
    }

    private CompareRelationalModels getNode(List list, ModelIDObject modelIDObject) {
        for (CompareRelationalModels compareRelationalModels : list) {
            if (compareRelationalModels.getObject() != modelIDObject) continue;
            return compareRelationalModels;
        }
        return null;
    }

    private String getElementsToString(Index index, CompareRelationalModels[] compareRelationalModelsArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < compareRelationalModelsArray.length; ++i) {
            ContainedObject containedObject = (ContainedObject)compareRelationalModelsArray[i].getObject();
            if (index.isPK() || index.isUnique()) {
                if (bl) {
                    stringBuffer.append(this.storageDesign.getFormatedName(containedObject.getName()));
                    bl = false;
                    continue;
                }
                stringBuffer.append("; ").append(this.storageDesign.getFormatedName(containedObject.getName()));
                continue;
            }
            if (bl) {
                stringBuffer.append(this.storageDesign.getFormatedName(containedObject.getName())).append(" ").append(index.getColumnSortOrder(containedObject));
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(this.storageDesign.getFormatedName(containedObject.getName())).append(" ").append(index.getColumnSortOrder(containedObject));
        }
        return stringBuffer.toString();
    }

    private CompareRelationalModels getTableNode() {
        if (this.getLeftSelectionObject() != null) {
            return (CompareRelationalModels)((CompareRelationalModels)this.getLeftSelectionObject().getParent()).getParent();
        }
        return null;
    }

    public CompareRelationalModels getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareRelationalModels compareRelationalModels) {
        this.selectionObject = compareRelationalModels;
    }
}

