/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.swingui.compare.CompareModelsDialog;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public abstract class AbstractCSSBOracle
extends SQLStatementBuilder {
    public static final String PREFIX = "bcp_";
    public static final String EXT_PREFIX = "EXT_";

    @Override
    protected void appendComment(StringBuffer stringBuffer, ModelIDObject modelIDObject) {
        if (CompareModelsDialog.isIncludeComments()) {
            StringTokenizer stringTokenizer = new StringTokenizer(modelIDObject.getComment(), "\n");
            stringBuffer.append(NEWLINE);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                while (string.length() > 76) {
                    int n = 76;
                    if (string.indexOf(76) != 32 && string.indexOf(76) != 9 && string.indexOf(76) != 10) {
                        n = string.substring(0, 76).lastIndexOf(32);
                        int n2 = string.substring(0, 76).lastIndexOf(9);
                        int n3 = string.substring(0, 76).lastIndexOf(10);
                        if (n2 > n) {
                            n = n2;
                        }
                        if (n3 > n) {
                            n = n3;
                        }
                        if (n == -1) {
                            n = 76;
                        }
                    }
                    stringBuffer.append("--  ").append(string.substring(0, n)).append(NEWLINE);
                    string = string.substring(n + 1);
                }
                stringBuffer.append("--  ").append(string).append(NEWLINE);
            }
        }
    }

    @Override
    protected void appendCommentOn(StringBuffer stringBuffer, StorageObject storageObject, boolean bl) {
        String string = "";
        if (storageObject instanceof TableProxy) {
            TableProxy tableProxy = (TableProxy)storageObject;
            if (tableProxy.isCommentInRDBMSChanged()) {
                string = tableProxy.getCommentInRDBMS();
            } else {
                Table table = (Table)tableProxy.getObject();
                string = table.getCommentInRDBMS();
            }
        } else if (storageObject instanceof TableViewProxy) {
            TableViewProxy tableViewProxy = (TableViewProxy)storageObject;
            if (tableViewProxy.isCommentInRDBMSChanged()) {
                string = tableViewProxy.getCommentInRDBMS();
            } else {
                TableView tableView = (TableView)tableViewProxy.getObject();
                string = tableView.getCommentInRDBMS();
            }
        } else if (storageObject instanceof SnapshotOracle) {
            string = storageObject.getCommentInRDBMS();
        }
        if (this.isNotEmpty(string)) {
            if (bl) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append(NEWLINE);
            }
            stringBuffer.append("COMMENT ON TABLE ").append(storageObject.getStorageDesign().getFormatedName(storageObject.getLongName())).append(" IS '").append(this.replaceSingleQuote(string)).append('\'').append(NEWLINE).append(';');
        }
        stringBuffer.append(NEWLINE);
    }

    @Override
    protected String addQuotesToDefault(String string, String string2) {
        String string3 = string2.trim();
        if (("TRUE".equalsIgnoreCase(string3) || "FALSE".equalsIgnoreCase(string3)) && "DECIMAL".equalsIgnoreCase(string)) {
            return "TRUE".equalsIgnoreCase(string3) ? "1" : "0";
        }
        if ("NULL".equalsIgnoreCase(string3) || "ROWID".equalsIgnoreCase(string3) || "CURRENT_DATE".equalsIgnoreCase(string3) || "CURRENT_TIMESTAMP".equalsIgnoreCase(string3) || "DBTIMEZONE".equalsIgnoreCase(string3) || "LOCALTIMESTAMP".equalsIgnoreCase(string3) || "SESSIONTIMEZONE".equalsIgnoreCase(string3) || "SYSDATE".equalsIgnoreCase(string3) || "SYSTIMESTAMP".equalsIgnoreCase(string3) || "USER".equalsIgnoreCase(string3)) {
            return string3;
        }
        return super.addQuotesToDefault(string, string2);
    }

    @Override
    protected void appendToBuffer(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string) {
        if (this.canAppendBuffer(stringBuffer2)) {
            if (CDDLFileMaker.getddlAdvancedGenenerator() != null) {
                if (this.isNotLineFinisher(stringBuffer2.toString())) {
                    stringBuffer.append("-- Step").append(CDDLFileMaker.getAdvancedStep());
                    this.appendFormatedBuffer(stringBuffer, stringBuffer2, string, CDDLFileMaker.getAdvancedStep(), true);
                    CDDLFileMaker.incrementAdvancedStep();
                }
            } else {
                stringBuffer.append(stringBuffer2);
            }
            stringBuffer2.setLength(0);
        }
    }

    @Override
    protected boolean hasToBeBackup() {
        return CompareModelsDialog.isBackup();
    }

    protected void appendScriptExecution(StringBuffer stringBuffer, String string) {
        if (CDDLFileMaker.getddlAdvancedGenenerator() != null) {
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 0);
            stringBuffer.append("-- stop_script execution");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 0);
            stringBuffer.append("-- Step").append(CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 0);
            AbstractCSSBOracle.appendString(stringBuffer, "declare");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 1);
            AbstractCSSBOracle.appendString(stringBuffer, "start_step NUMBER;");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 1);
            AbstractCSSBOracle.appendString(stringBuffer, "stop_step NUMBER;");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 0);
            AbstractCSSBOracle.appendString(stringBuffer, "begin");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 1);
            AbstractCSSBOracle.appendString(stringBuffer, "start_step := adv_scripting.GET_START_STEP();");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 1);
            AbstractCSSBOracle.appendString(stringBuffer, "stop_step := adv_scripting.GET_STOP_STEP();");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 1);
            AbstractCSSBOracle.appendString(stringBuffer, "if ");
            this.appendString(stringBuffer, CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendString(stringBuffer, "  > start_step and (stop_step = 0 OR ");
            this.appendString(stringBuffer, CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendString(stringBuffer, " <= stop_step) then");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 1);
            AbstractCSSBOracle.appendString(stringBuffer, "  DBMS_OUTPUT.PUT_LINE('Step ");
            this.appendString(stringBuffer, CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendString(stringBuffer, " USER BREAK');");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 1);
            AbstractCSSBOracle.appendString(stringBuffer, "  adv_scripting.STOP_EXECUTION('");
            AbstractCSSBOracle.appendString(stringBuffer, string);
            AbstractCSSBOracle.appendString(stringBuffer, "');");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 1);
            AbstractCSSBOracle.appendString(stringBuffer, "end if;");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 0);
            AbstractCSSBOracle.appendString(stringBuffer, "end;");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 0);
            AbstractCSSBOracle.appendString(stringBuffer, "/");
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 0);
            stringBuffer.append("-- end Step").append(CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 0);
            AbstractCSSBOracle.appendNewLine(stringBuffer, true, 0);
            CDDLFileMaker.incrementAdvancedStep();
        }
    }

    protected void appendUnloadHeader(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string, String string2) {
        if (CDDLFileMaker.getddlAdvancedGenenerator() != null) {
            AbstractCSSBOracle.appendNewLine(stringBuffer2, true, 0);
            AbstractCSSBOracle.appendNewLine(stringBuffer2, true, 0);
            stringBuffer2.append("-- Step").append(CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendNewLine(stringBuffer2, true, 0);
            stringBuffer2.append("declare");
            AbstractCSSBOracle.appendNewLine(stringBuffer2, true, 0);
            stringBuffer2.append("    start_step NUMBER;");
            AbstractCSSBOracle.appendNewLine(stringBuffer2, true, 0);
            stringBuffer2.append("    stop_step NUMBER;");
            AbstractCSSBOracle.appendNewLine(stringBuffer2, true, 0);
            stringBuffer2.append("    query varchar2(4000);");
            AbstractCSSBOracle.appendNewLine(stringBuffer2, true, 0);
            stringBuffer2.append("    begin");
            AbstractCSSBOracle.appendNewLine(stringBuffer2, true, 0);
            stringBuffer2.append("    start_step := adv_scripting.GET_START_STEP(); ");
            AbstractCSSBOracle.appendNewLine(stringBuffer2, true, 0);
            stringBuffer2.append("    stop_step := adv_scripting.GET_STOP_STEP(); ");
            AbstractCSSBOracle.appendNewLine(stringBuffer2, true, 0);
            AbstractCSSBOracle.appendString(stringBuffer2, "    if ");
            this.appendString(stringBuffer2, CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendString(stringBuffer2, "  > start_step and (stop_step = 0 OR ");
            this.appendString(stringBuffer2, CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendString(stringBuffer2, " <= stop_step) then");
            AbstractCSSBOracle.appendNewLine(stringBuffer2, true, 0);
            AbstractCSSBOracle.appendString(stringBuffer2, "    DBMS_OUTPUT.PUT_LINE('Step ");
            this.appendString(stringBuffer2, CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendString(stringBuffer2, " unload for table ");
            AbstractCSSBOracle.appendString(stringBuffer2, string);
            if (this.isNotEmpty(string2)) {
                AbstractCSSBOracle.appendString(stringBuffer2, "  partition ");
                AbstractCSSBOracle.appendString(stringBuffer2, string2);
            }
            AbstractCSSBOracle.appendString(stringBuffer2, "');");
            stringBuffer.append(stringBuffer2);
            CDDLFileMaker.incrementAdvancedStep();
        }
        stringBuffer2.setLength(0);
    }
}

