/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;

public class EntityComparator
extends PropertiesComparator {
    private final Entity entity;
    private final Entity table;
    private CompareCWDDesigns selectionObject;

    public EntityComparator(Entity entity, Entity entity2) {
        super(entity, entity2);
        this.entity = entity;
        this.table = entity2;
        this.initPropertiesList();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        PropertyHolder propertyHolder = new PropertyHolder(TEMP_TABLE_SCOPE);
        propertyHolder.setLeftValue(this.entity != null ? this.entity.getScope() : "");
        propertyHolder.setRightValue(this.table != null ? this.table.getScope() : "");
        if (this.entity != null && this.table != null && !this.entity.getScope().equals(this.table.getScope())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(TABLE_TYPE);
        propertyHolder.setLeftValue(this.entity != null ? this.entity.getDesign().getDLSettings().getClassificationTypeNameByID(this.entity.getTypeID()) : "");
        propertyHolder.setRightValue(this.table != null ? this.table.getDesign().getDLSettings().getClassificationTypeNameByID(this.table.getTypeID()) : "");
        if (this.entity != null && this.table != null && !this.entity.getTypeID().equals(this.table.getTypeID())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(MIN_VOLUMES);
        propertyHolder.setLeftValue(this.entity != null ? this.entity.getMinVolumes() : "");
        propertyHolder.setRightValue(this.table != null ? this.table.getMinVolumes() : "");
        if (this.entity != null && this.table != null && !this.entity.getMinVolumes().equals(this.table.getMinVolumes())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(EXPECTED_VOLUMES);
        propertyHolder.setLeftValue(this.entity != null ? this.entity.getExpectedVolumes() : "");
        propertyHolder.setRightValue(this.table != null ? this.table.getExpectedVolumes() : "");
        if (this.entity != null && this.table != null && !this.entity.getExpectedVolumes().equals(this.table.getExpectedVolumes())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(MAX_VOLUMES);
        propertyHolder.setLeftValue(this.entity != null ? this.entity.getMaxVolumes() : "");
        propertyHolder.setRightValue(this.table != null ? this.table.getMaxVolumes() : "");
        if (this.entity != null && this.table != null && !this.entity.getMaxVolumes().equals(this.table.getMaxVolumes())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(GROWTH_PERCENT);
        propertyHolder.setLeftValue(this.entity != null ? this.entity.getGrowthPercent() : "");
        propertyHolder.setRightValue(this.table != null ? this.table.getGrowthPercent() : "");
        if (this.entity != null && this.table != null && !this.entity.getGrowthPercent().equals(this.table.getGrowthPercent())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(GROWTH_TYPE);
        propertyHolder.setLeftValue(this.entity != null ? this.entity.getGrowthType() : "");
        propertyHolder.setRightValue(this.table != null ? this.table.getGrowthType() : "");
        if (this.entity != null && this.table != null && !this.entity.getGrowthType().equals(this.table.getGrowthType())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(NORMAL_FORM);
        propertyHolder.setLeftValue(this.entity != null ? this.entity.getNormalForm() : "");
        propertyHolder.setRightValue(this.table != null ? this.table.getNormalForm() : "");
        if (this.entity != null && this.table != null && !this.entity.getNormalForm().equals(this.table.getNormalForm())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(ADEQUATELY_NORMALIZED);
        propertyHolder.setLeftValue(this.entity != null ? this.entity.getAdequatelyNormalized() : "");
        propertyHolder.setRightValue(this.table != null ? this.table.getAdequatelyNormalized() : "");
        if (this.entity != null && this.table != null && !this.entity.getAdequatelyNormalized().equals(this.table.getAdequatelyNormalized())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromEntityToEntity();
    }

    private void copyPropertiesFromEntityToEntity() {
        if (this.entity != null && this.table != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(TEMP_TABLE_SCOPE)) {
                    this.table.setScope(this.entity.getScope());
                    continue;
                }
                if (engPropertyHolder.getName().equals(TABLE_TYPE)) {
                    this.table.setTypeID(this.entity.getTypeID());
                    continue;
                }
                if (engPropertyHolder.getName().equals(STRUCTURED_TYPE)) {
                    this.table.setBasedOnStructuredType(this.entity.getBasedOnStructuredType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MIN_VOLUMES)) {
                    this.table.setMinVolumes(this.entity.getMinVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(EXPECTED_VOLUMES)) {
                    this.table.setExpectedVolumes(this.entity.getExpectedVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MAX_VOLUMES)) {
                    this.table.setMaxVolumes(this.entity.getMaxVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(GROWTH_PERCENT)) {
                    this.table.setGrowthPercent(this.entity.getGrowthPercent());
                    continue;
                }
                if (engPropertyHolder.getName().equals(GROWTH_TYPE)) {
                    this.table.setGrowthType(this.entity.getGrowthType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(NORMAL_FORM)) {
                    this.table.setNormalForm(this.entity.getNormalForm());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(ADEQUATELY_NORMALIZED)) continue;
                this.table.setAdequatelyNormalized(this.entity.getAdequatelyNormalized());
            }
        }
    }

    public void presetAttributesOrder() {
        EngPropertyHolder engPropertyHolder = this.getPropertyHolderByName(COLUMNS_ORDER);
        if (engPropertyHolder != null) {
            if (this.getLeftSelectionObject() != null) {
                engPropertyHolder.setRightValue(this.table != null ? this.getElementsToString(this.table) : "");
                CompareCWDDesigns[] compareCWDDesignsArray = this.getAttributeNodes(this.getSelectionObject());
                engPropertyHolder.setLeftValue(this.entity != null ? this.getElementsToString(compareCWDDesignsArray) : "");
                if (!this.equalAttributesOrderNew(this.entity, this.table)) {
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setModified(true);
                } else {
                    engPropertyHolder.setSelected(false);
                    engPropertyHolder.setModified(false);
                }
            } else {
                engPropertyHolder.setLeftValue(this.entity != null ? this.getElementsToString(this.entity) : "");
                engPropertyHolder.setRightValue(this.table != null ? this.getElementsToString(this.table) : "");
                if (!this.equalAttributesOrderNew(this.entity, this.table)) {
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setModified(true);
                }
            }
            if (!this.useColumnsOrder) {
                engPropertyHolder.setSelected(false);
            }
        }
    }

    private boolean isBeforeUnchangedAttribute(int n, CompareCWDDesigns[] compareCWDDesignsArray) {
        for (int i = n + 1; i < compareCWDDesignsArray.length; ++i) {
            if (compareCWDDesignsArray[i].getStatus() != ModelIdObjectSelection.STATE_UNCHANGED) continue;
            return true;
        }
        return false;
    }

    private boolean equalAttributesOrderNew(Entity entity, Entity entity2) {
        if (this.getLeftSelectionObject() != null) {
            CompareCWDDesigns[] compareCWDDesignsArray = this.getAttributeNodes(this.getSelectionObject());
            for (int i = 0; i < compareCWDDesignsArray.length; ++i) {
                Attribute attribute;
                CompareCWDDesigns compareCWDDesigns = compareCWDDesignsArray[i];
                if (compareCWDDesigns.getStatus() == ModelIdObjectSelection.STATE_NEW && this.isBeforeUnchangedAttribute(i, compareCWDDesignsArray)) {
                    return false;
                }
                if (compareCWDDesigns.getStatus() != ModelIdObjectSelection.STATE_UNCHANGED && compareCWDDesigns.getStatus() != ModelIdObjectSelection.STATE_MODIFIED || (attribute = (Attribute)compareCWDDesigns.getCorrespondentNode().getObject()) == null || i == attribute.getIndex()) continue;
                return false;
            }
            return true;
        }
        return this.equalAttributesOrder(entity, entity2);
    }

    private boolean equalAttributesOrder(Entity entity, Entity entity2) {
        if (entity == null || entity2 == null) {
            return true;
        }
        ContainedObject[] containedObjectArray = entity.getElements();
        ContainedObject[] containedObjectArray2 = entity2.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            if (i > containedObjectArray2.length - 1) {
                return true;
            }
            Attribute attribute = (Attribute)containedObjectArray[i];
            Attribute attribute2 = (Attribute)containedObjectArray2[i];
            if (attribute2.getImportedId() != null && attribute.getObjectID().equals(attribute2.getImportedId()) || attribute2.getName().equals(attribute.getName()) || attribute2.getDataType().toString().equals(attribute.getDataType().toString()) && attribute.getContainer().getElementByName(attribute2.getName()) == null) continue;
            return false;
        }
        return true;
    }

    private CompareCWDDesigns[] getAttributeNodes(CompareCWDDesigns compareCWDDesigns) {
        ArrayList<CompareCWDDesigns> arrayList = new ArrayList<CompareCWDDesigns>();
        CompareCWDDesigns compareCWDDesigns2 = (CompareCWDDesigns)compareCWDDesigns.getChild(0);
        int n = compareCWDDesigns2.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            CompareCWDDesigns compareCWDDesigns3 = (CompareCWDDesigns)compareCWDDesigns2.getChild(i);
            if (compareCWDDesigns3.getStatus() == ModelIdObjectSelection.STATE_DELETED || (!compareCWDDesigns3.isSelected() || compareCWDDesigns3.getStatus() != ModelIdObjectSelection.STATE_NEW) && compareCWDDesigns3.getStatus() == ModelIdObjectSelection.STATE_NEW) continue;
            arrayList.add(compareCWDDesigns3);
        }
        return arrayList.toArray(new CompareCWDDesigns[0]);
    }

    private String getElementsToString(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<ContainedObject> iterator = Arrays.asList(entity.getElements()).iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ContainedObject containedObject = iterator.next();
            if (bl) {
                stringBuffer.append(containedObject.getName());
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(containedObject.getName());
        }
        return stringBuffer.toString();
    }

    private String getElementsToString(CompareCWDDesigns[] compareCWDDesignsArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < compareCWDDesignsArray.length; ++i) {
            ContainedObject containedObject = (ContainedObject)compareCWDDesignsArray[i].getObject();
            if (bl) {
                stringBuffer.append(containedObject.getName());
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(containedObject.getName());
        }
        return stringBuffer.toString();
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns compareCWDDesigns) {
        this.selectionObject = compareCWDDesigns;
    }

    @Override
    public String getLeftName() {
        return this.entity != null ? MessageFormat.format(Messages.getString("EntityComparator.SourceEntity"), this.entity.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.table != null ? MessageFormat.format(Messages.getString("EntityComparator.TargetEntity"), this.table.getName()) : "";
    }
}

