/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;

public class CWDIndexComparator
extends PropertiesComparator {
    private Index sourceIndex;
    private Index targetIndex;
    private Map objectsMap;
    private CompareCWDDesigns selectionObject;

    public CWDIndexComparator(Index index, Index index2, Map map) {
        super(index, index2);
        this.sourceIndex = index;
        this.targetIndex = index2;
        this.objectsMap = map;
        this.initPropertiesList();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        PropertyHolder propertyHolder = new PropertyHolder(INDEX_STATUS);
        propertyHolder.setLeftValue(this.sourceIndex != null ? this.sourceIndex.getIndexState() : "");
        propertyHolder.setRightValue(this.targetIndex != null ? this.targetIndex.getIndexState() : "");
        if (this.targetIndex != null && this.sourceIndex != null && !this.targetIndex.getIndexState().equals(this.sourceIndex.getIndexState())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(COLUMNS);
        propertyHolder.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
        propertyHolder.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
        if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap)) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
            propertyHolder.setEditable(false);
        }
        this.propertiesList.add(propertyHolder);
    }

    private String getElementsToString(Index index) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = index.getElementsCollection().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (index.isPK() || index.isUnique()) {
                if (bl) {
                    stringBuffer.append(column.getName());
                    bl = false;
                    continue;
                }
                stringBuffer.append("; ").append(column.getName());
                continue;
            }
            if (bl) {
                stringBuffer.append(column.getName()).append(" ").append(index.getColumnSortOrder(column));
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(column.getName()).append(" ").append(index.getColumnSortOrder(column));
        }
        return stringBuffer.toString();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromIndexToKey();
    }

    private void copyPropertiesFromIndexToKey() {
        if (this.targetIndex != null && this.sourceIndex != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(INDEX_STATUS)) {
                    this.targetIndex.setIndexState(this.sourceIndex.getIndexState());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(COLUMNS)) continue;
                MergingModels.synchronizeColumnsFromIndexToKey(this.sourceIndex, this.targetIndex);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceIndex != null ? this.sourceIndex.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetIndex != null ? this.targetIndex.getLongName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceIndex == null) {
            return true;
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceIndex == null && this.targetIndex != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    @Override
    public String getChoosedPropertyValue(String string) {
        return super.getChoosedPropertyValue(string);
    }

    public void presetColumnsOrder() {
        EngPropertyHolder engPropertyHolder = this.getPropertyHolderByName(COLUMNS);
        if (engPropertyHolder != null) {
            if (this.getLeftSelectionObject() != null) {
                engPropertyHolder.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.sourceIndex != null) {
                    CompareCWDDesigns[] compareCWDDesignsArray = this.getColumnNodes(this.sourceIndex, this.getTableNode());
                    engPropertyHolder.setLeftValue(this.getElementsToString(this.sourceIndex, compareCWDDesignsArray));
                } else {
                    engPropertyHolder.setLeftValue("");
                }
                if (this.targetIndex != null && this.sourceIndex != null) {
                    if (!MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap)) {
                        engPropertyHolder.setModified(true);
                        engPropertyHolder.setSelected(true);
                    } else {
                        engPropertyHolder.setModified(false);
                        engPropertyHolder.setSelected(false);
                    }
                    engPropertyHolder.setEditable(false);
                }
            } else {
                engPropertyHolder.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
                engPropertyHolder.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap)) {
                    engPropertyHolder.setModified(true);
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setEditable(false);
                }
            }
        }
    }

    private CompareCWDDesigns[] getColumnNodes(Index index, CompareCWDDesigns compareCWDDesigns) {
        ContainedObject[] containedObjectArray;
        ArrayList<ContainedObject[]> arrayList = new ArrayList<ContainedObject[]>();
        CompareCWDDesigns compareCWDDesigns2 = (CompareCWDDesigns)compareCWDDesigns.getChild(0);
        int n = compareCWDDesigns2.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            containedObjectArray = (ContainedObject[])compareCWDDesigns2.getChild(i);
            if (containedObjectArray.getStatus() == ModelIdObjectSelection.STATE_DELETED || (!containedObjectArray.isSelected() || containedObjectArray.getStatus() != ModelIdObjectSelection.STATE_NEW) && containedObjectArray.getStatus() == ModelIdObjectSelection.STATE_NEW) continue;
            arrayList.add(containedObjectArray);
        }
        ArrayList<CompareCWDDesigns> arrayList2 = new ArrayList<CompareCWDDesigns>();
        containedObjectArray = index.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            CompareCWDDesigns compareCWDDesigns3 = this.getNode(arrayList, containedObjectArray[i]);
            if (compareCWDDesigns3 == null) continue;
            arrayList2.add(compareCWDDesigns3);
        }
        return arrayList2.toArray(new CompareCWDDesigns[0]);
    }

    private CompareCWDDesigns getNode(List list, ModelIDObject modelIDObject) {
        for (CompareCWDDesigns compareCWDDesigns : list) {
            if (compareCWDDesigns.getObject() != modelIDObject) continue;
            return compareCWDDesigns;
        }
        return null;
    }

    private String getElementsToString(Index index, CompareCWDDesigns[] compareCWDDesignsArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < compareCWDDesignsArray.length; ++i) {
            ContainedObject containedObject = (ContainedObject)compareCWDDesignsArray[i].getObject();
            if (index.isPK() || index.isUnique()) {
                if (bl) {
                    stringBuffer.append(containedObject.getName());
                    bl = false;
                    continue;
                }
                stringBuffer.append("; ").append(containedObject.getName());
                continue;
            }
            if (bl) {
                stringBuffer.append(containedObject.getName()).append(" ").append(index.getColumnSortOrder(containedObject));
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(containedObject.getName()).append(" ").append(index.getColumnSortOrder(containedObject));
        }
        return stringBuffer.toString();
    }

    private CompareCWDDesigns getTableNode() {
        if (this.getLeftSelectionObject() != null) {
            return (CompareCWDDesigns)((CompareCWDDesigns)this.getLeftSelectionObject().getParent()).getParent();
        }
        return null;
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns compareCWDDesigns) {
        this.selectionObject = compareCWDDesigns;
    }
}

